// services/content/public/mojom/navigable_contents_factory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_FACTORY_MOJOM_H_
#define SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_FACTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/content/public/mojom/navigable_contents_factory.mojom-shared.h"
#include "services/content/public/mojom/navigable_contents_factory.mojom-forward.h"
#include "services/content/public/mojom/navigable_contents.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "base/component_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class NavigableContentsFactoryProxy;

template <typename ImplRefTraits>
class NavigableContentsFactoryStub;

class NavigableContentsFactoryRequestValidator;


class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsFactory
    : public NavigableContentsFactoryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NavigableContentsFactoryInterfaceBase;
  using Proxy_ = NavigableContentsFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = NavigableContentsFactoryStub<ImplRefTraits>;

  using RequestValidator_ = NavigableContentsFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateContentsMinVersion = 0,
  };
  virtual ~NavigableContentsFactory() {}

  
  virtual void CreateContents(NavigableContentsParamsPtr params, ::mojo::PendingReceiver<::content::mojom::NavigableContents> receiver, ::mojo::PendingRemote<::content::mojom::NavigableContentsClient> client) = 0;
};



class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsFactoryProxy
    : public NavigableContentsFactory {
 public:
  using InterfaceType = NavigableContentsFactory;

  explicit NavigableContentsFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateContents(NavigableContentsParamsPtr params, ::mojo::PendingReceiver<::content::mojom::NavigableContents> receiver, ::mojo::PendingRemote<::content::mojom::NavigableContentsClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsFactoryStubDispatch {
 public:
  static bool Accept(NavigableContentsFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NavigableContentsFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NavigableContentsFactory>>
class NavigableContentsFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NavigableContentsFactoryStub() {}
  ~NavigableContentsFactoryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigableContentsFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigableContentsFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) NavigableContentsParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigableContentsParams, T>::value>;
  using DataView = NavigableContentsParamsDataView;
  using Data_ = internal::NavigableContentsParams_Data;

  template <typename... Args>
  static NavigableContentsParamsPtr New(Args&&... args) {
    return NavigableContentsParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigableContentsParamsPtr From(const U& u) {
    return mojo::TypeConverter<NavigableContentsParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigableContentsParams>::Convert(*this);
  }


  NavigableContentsParams();

  NavigableContentsParams(
      bool enable_view_auto_resize,
      const base::Optional<::gfx::Size>& auto_resize_min_size,
      const base::Optional<::gfx::Size>& auto_resize_max_size,
      bool suppress_navigations,
      bool override_background_color,
      uint32_t background_color);

  ~NavigableContentsParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigableContentsParamsPtr>
  NavigableContentsParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigableContentsParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigableContentsParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigableContentsParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigableContentsParams_UnserializedMessageContext<
            UserType, NavigableContentsParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NavigableContentsParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return NavigableContentsParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigableContentsParams_UnserializedMessageContext<
            UserType, NavigableContentsParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigableContentsParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool enable_view_auto_resize;
  
  base::Optional<::gfx::Size> auto_resize_min_size;
  
  base::Optional<::gfx::Size> auto_resize_max_size;
  
  bool suppress_navigations;
  
  bool override_background_color;
  
  uint32_t background_color;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigableContentsParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigableContentsParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigableContentsParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigableContentsParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
NavigableContentsParamsPtr NavigableContentsParams::Clone() const {
  return New(
      mojo::Clone(enable_view_auto_resize),
      mojo::Clone(auto_resize_min_size),
      mojo::Clone(auto_resize_max_size),
      mojo::Clone(suppress_navigations),
      mojo::Clone(override_background_color),
      mojo::Clone(background_color)
  );
}

template <typename T, NavigableContentsParams::EnableIfSame<T>*>
bool NavigableContentsParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->enable_view_auto_resize, other_struct.enable_view_auto_resize))
    return false;
  if (!mojo::Equals(this->auto_resize_min_size, other_struct.auto_resize_min_size))
    return false;
  if (!mojo::Equals(this->auto_resize_max_size, other_struct.auto_resize_max_size))
    return false;
  if (!mojo::Equals(this->suppress_navigations, other_struct.suppress_navigations))
    return false;
  if (!mojo::Equals(this->override_background_color, other_struct.override_background_color))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  return true;
}

template <typename T, NavigableContentsParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.enable_view_auto_resize, rhs.enable_view_auto_resize))
    return true;
  if (std::less<>{}(rhs.enable_view_auto_resize, lhs.enable_view_auto_resize))
    return false;
  if (std::less<>{}(lhs.auto_resize_min_size, rhs.auto_resize_min_size))
    return true;
  if (std::less<>{}(rhs.auto_resize_min_size, lhs.auto_resize_min_size))
    return false;
  if (std::less<>{}(lhs.auto_resize_max_size, rhs.auto_resize_max_size))
    return true;
  if (std::less<>{}(rhs.auto_resize_max_size, lhs.auto_resize_max_size))
    return false;
  if (std::less<>{}(lhs.suppress_navigations, rhs.suppress_navigations))
    return true;
  if (std::less<>{}(rhs.suppress_navigations, lhs.suppress_navigations))
    return false;
  if (std::less<>{}(lhs.override_background_color, rhs.override_background_color))
    return true;
  if (std::less<>{}(rhs.override_background_color, lhs.override_background_color))
    return false;
  if (std::less<>{}(lhs.background_color, rhs.background_color))
    return true;
  if (std::less<>{}(rhs.background_color, lhs.background_color))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace content

namespace mojo {


template <>
struct COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM) StructTraits<::content::mojom::NavigableContentsParams::DataView,
                                         ::content::mojom::NavigableContentsParamsPtr> {
  static bool IsNull(const ::content::mojom::NavigableContentsParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::NavigableContentsParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::NavigableContentsParams::enable_view_auto_resize) enable_view_auto_resize(
      const ::content::mojom::NavigableContentsParamsPtr& input) {
    return input->enable_view_auto_resize;
  }

  static const decltype(::content::mojom::NavigableContentsParams::auto_resize_min_size)& auto_resize_min_size(
      const ::content::mojom::NavigableContentsParamsPtr& input) {
    return input->auto_resize_min_size;
  }

  static const decltype(::content::mojom::NavigableContentsParams::auto_resize_max_size)& auto_resize_max_size(
      const ::content::mojom::NavigableContentsParamsPtr& input) {
    return input->auto_resize_max_size;
  }

  static decltype(::content::mojom::NavigableContentsParams::suppress_navigations) suppress_navigations(
      const ::content::mojom::NavigableContentsParamsPtr& input) {
    return input->suppress_navigations;
  }

  static decltype(::content::mojom::NavigableContentsParams::override_background_color) override_background_color(
      const ::content::mojom::NavigableContentsParamsPtr& input) {
    return input->override_background_color;
  }

  static decltype(::content::mojom::NavigableContentsParams::background_color) background_color(
      const ::content::mojom::NavigableContentsParamsPtr& input) {
    return input->background_color;
  }

  static bool Read(::content::mojom::NavigableContentsParams::DataView input, ::content::mojom::NavigableContentsParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_FACTORY_MOJOM_H_