// services/network/public/mojom/host_resolver.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/address_list.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/network_isolation_key.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "services/network/public/cpp/host_resolver_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {

class ResolveHostHandleProxy;

template <typename ImplRefTraits>
class ResolveHostHandleStub;

class ResolveHostHandleRequestValidator;


class  ResolveHostHandle
    : public ResolveHostHandleInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ResolveHostHandleInterfaceBase;
  using Proxy_ = ResolveHostHandleProxy;

  template <typename ImplRefTraits>
  using Stub_ = ResolveHostHandleStub<ImplRefTraits>;

  using RequestValidator_ = ResolveHostHandleRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCancelMinVersion = 0,
  };
  virtual ~ResolveHostHandle() {}

  
  virtual void Cancel(int32_t result) = 0;
};

class ResolveHostClientProxy;

template <typename ImplRefTraits>
class ResolveHostClientStub;

class ResolveHostClientRequestValidator;


class  ResolveHostClient
    : public ResolveHostClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ResolveHostClientInterfaceBase;
  using Proxy_ = ResolveHostClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ResolveHostClientStub<ImplRefTraits>;

  using RequestValidator_ = ResolveHostClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCompleteMinVersion = 0,
    kOnTextResultsMinVersion = 0,
    kOnHostnameResultsMinVersion = 0,
  };
  virtual ~ResolveHostClient() {}

  
  virtual void OnComplete(int32_t result, const ::net::ResolveErrorInfo& resolve_error_info, const base::Optional<::net::AddressList>& resolved_addresses) = 0;

  
  virtual void OnTextResults(const std::vector<std::string>& text_results) = 0;

  
  virtual void OnHostnameResults(const std::vector<::net::HostPortPair>& hosts) = 0;
};

class MdnsListenClientProxy;

template <typename ImplRefTraits>
class MdnsListenClientStub;

class MdnsListenClientRequestValidator;


class  MdnsListenClient
    : public MdnsListenClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MdnsListenClientInterfaceBase;
  using Proxy_ = MdnsListenClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = MdnsListenClientStub<ImplRefTraits>;

  using RequestValidator_ = MdnsListenClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnAddressResultMinVersion = 0,
    kOnTextResultMinVersion = 0,
    kOnHostnameResultMinVersion = 0,
    kOnUnhandledResultMinVersion = 0,
  };
  
  using UpdateType = MdnsListenClient_UpdateType;
  virtual ~MdnsListenClient() {}

  
  virtual void OnAddressResult(::net::HostResolver::MdnsListener::Delegate::UpdateType update_type, ::net::DnsQueryType query_type, const ::net::IPEndPoint& endpoint) = 0;

  
  virtual void OnTextResult(::net::HostResolver::MdnsListener::Delegate::UpdateType update_type, ::net::DnsQueryType query_type, const std::vector<std::string>& text_records) = 0;

  
  virtual void OnHostnameResult(::net::HostResolver::MdnsListener::Delegate::UpdateType update_type, ::net::DnsQueryType query_type, const ::net::HostPortPair& host) = 0;

  
  virtual void OnUnhandledResult(::net::HostResolver::MdnsListener::Delegate::UpdateType update_type, ::net::DnsQueryType query_type) = 0;
};

class HostResolverProxy;

template <typename ImplRefTraits>
class HostResolverStub;

class HostResolverRequestValidator;
class HostResolverResponseValidator;


class  HostResolver
    : public HostResolverInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = HostResolverInterfaceBase;
  using Proxy_ = HostResolverProxy;

  template <typename ImplRefTraits>
  using Stub_ = HostResolverStub<ImplRefTraits>;

  using RequestValidator_ = HostResolverRequestValidator;
  using ResponseValidator_ = HostResolverResponseValidator;
  enum MethodMinVersions : uint32_t {
    kResolveHostMinVersion = 0,
    kMdnsListenMinVersion = 0,
  };
  virtual ~HostResolver() {}

  
  virtual void ResolveHost(const ::net::HostPortPair& host, const ::net::NetworkIsolationKey& network_isolation_key, ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<ResolveHostClient> response_client) = 0;


  using MdnsListenCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void MdnsListen(const ::net::HostPortPair& host, ::net::DnsQueryType query_type, ::mojo::PendingRemote<MdnsListenClient> response_client, MdnsListenCallback callback) = 0;
};

class DnsConfigChangeManagerClientProxy;

template <typename ImplRefTraits>
class DnsConfigChangeManagerClientStub;

class DnsConfigChangeManagerClientRequestValidator;


class  DnsConfigChangeManagerClient
    : public DnsConfigChangeManagerClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DnsConfigChangeManagerClientInterfaceBase;
  using Proxy_ = DnsConfigChangeManagerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DnsConfigChangeManagerClientStub<ImplRefTraits>;

  using RequestValidator_ = DnsConfigChangeManagerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDnsConfigChangedMinVersion = 0,
  };
  virtual ~DnsConfigChangeManagerClient() {}

  
  virtual void OnDnsConfigChanged() = 0;
};

class DnsConfigChangeManagerProxy;

template <typename ImplRefTraits>
class DnsConfigChangeManagerStub;

class DnsConfigChangeManagerRequestValidator;


class  DnsConfigChangeManager
    : public DnsConfigChangeManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DnsConfigChangeManagerInterfaceBase;
  using Proxy_ = DnsConfigChangeManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = DnsConfigChangeManagerStub<ImplRefTraits>;

  using RequestValidator_ = DnsConfigChangeManagerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRequestNotificationsMinVersion = 0,
  };
  virtual ~DnsConfigChangeManager() {}

  
  virtual void RequestNotifications(::mojo::PendingRemote<DnsConfigChangeManagerClient> client) = 0;
};



class  ResolveHostHandleProxy
    : public ResolveHostHandle {
 public:
  using InterfaceType = ResolveHostHandle;

  explicit ResolveHostHandleProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Cancel(int32_t result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ResolveHostClientProxy
    : public ResolveHostClient {
 public:
  using InterfaceType = ResolveHostClient;

  explicit ResolveHostClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnComplete(int32_t result, const ::net::ResolveErrorInfo& resolve_error_info, const base::Optional<::net::AddressList>& resolved_addresses) final;
  
  void OnTextResults(const std::vector<std::string>& text_results) final;
  
  void OnHostnameResults(const std::vector<::net::HostPortPair>& hosts) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MdnsListenClientProxy
    : public MdnsListenClient {
 public:
  using InterfaceType = MdnsListenClient;

  explicit MdnsListenClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnAddressResult(::net::HostResolver::MdnsListener::Delegate::UpdateType update_type, ::net::DnsQueryType query_type, const ::net::IPEndPoint& endpoint) final;
  
  void OnTextResult(::net::HostResolver::MdnsListener::Delegate::UpdateType update_type, ::net::DnsQueryType query_type, const std::vector<std::string>& text_records) final;
  
  void OnHostnameResult(::net::HostResolver::MdnsListener::Delegate::UpdateType update_type, ::net::DnsQueryType query_type, const ::net::HostPortPair& host) final;
  
  void OnUnhandledResult(::net::HostResolver::MdnsListener::Delegate::UpdateType update_type, ::net::DnsQueryType query_type) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  HostResolverProxy
    : public HostResolver {
 public:
  using InterfaceType = HostResolver;

  explicit HostResolverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ResolveHost(const ::net::HostPortPair& host, const ::net::NetworkIsolationKey& network_isolation_key, ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<ResolveHostClient> response_client) final;
  
  void MdnsListen(const ::net::HostPortPair& host, ::net::DnsQueryType query_type, ::mojo::PendingRemote<MdnsListenClient> response_client, MdnsListenCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DnsConfigChangeManagerClientProxy
    : public DnsConfigChangeManagerClient {
 public:
  using InterfaceType = DnsConfigChangeManagerClient;

  explicit DnsConfigChangeManagerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDnsConfigChanged() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DnsConfigChangeManagerProxy
    : public DnsConfigChangeManager {
 public:
  using InterfaceType = DnsConfigChangeManager;

  explicit DnsConfigChangeManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestNotifications(::mojo::PendingRemote<DnsConfigChangeManagerClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ResolveHostHandleStubDispatch {
 public:
  static bool Accept(ResolveHostHandle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ResolveHostHandle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ResolveHostHandle>>
class ResolveHostHandleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ResolveHostHandleStub() {}
  ~ResolveHostHandleStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResolveHostHandleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResolveHostHandleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ResolveHostClientStubDispatch {
 public:
  static bool Accept(ResolveHostClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ResolveHostClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ResolveHostClient>>
class ResolveHostClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ResolveHostClientStub() {}
  ~ResolveHostClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResolveHostClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResolveHostClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MdnsListenClientStubDispatch {
 public:
  static bool Accept(MdnsListenClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MdnsListenClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MdnsListenClient>>
class MdnsListenClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MdnsListenClientStub() {}
  ~MdnsListenClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MdnsListenClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MdnsListenClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  HostResolverStubDispatch {
 public:
  static bool Accept(HostResolver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HostResolver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HostResolver>>
class HostResolverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HostResolverStub() {}
  ~HostResolverStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HostResolverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HostResolverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DnsConfigChangeManagerClientStubDispatch {
 public:
  static bool Accept(DnsConfigChangeManagerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DnsConfigChangeManagerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DnsConfigChangeManagerClient>>
class DnsConfigChangeManagerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DnsConfigChangeManagerClientStub() {}
  ~DnsConfigChangeManagerClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DnsConfigChangeManagerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DnsConfigChangeManagerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DnsConfigChangeManagerStubDispatch {
 public:
  static bool Accept(DnsConfigChangeManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DnsConfigChangeManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DnsConfigChangeManager>>
class DnsConfigChangeManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DnsConfigChangeManagerStub() {}
  ~DnsConfigChangeManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DnsConfigChangeManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DnsConfigChangeManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ResolveHostHandleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ResolveHostClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MdnsListenClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HostResolverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DnsConfigChangeManagerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DnsConfigChangeManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  HostResolverResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  DnsOverHttpsServer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DnsOverHttpsServer, T>::value>;
  using DataView = DnsOverHttpsServerDataView;
  using Data_ = internal::DnsOverHttpsServer_Data;

  template <typename... Args>
  static DnsOverHttpsServerPtr New(Args&&... args) {
    return DnsOverHttpsServerPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DnsOverHttpsServerPtr From(const U& u) {
    return mojo::TypeConverter<DnsOverHttpsServerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DnsOverHttpsServer>::Convert(*this);
  }


  DnsOverHttpsServer();

  DnsOverHttpsServer(
      const std::string& server_template,
      bool use_post);

  ~DnsOverHttpsServer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DnsOverHttpsServerPtr>
  DnsOverHttpsServerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DnsOverHttpsServer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DnsOverHttpsServer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DnsOverHttpsServer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DnsOverHttpsServer_UnserializedMessageContext<
            UserType, DnsOverHttpsServer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DnsOverHttpsServer::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DnsOverHttpsServer::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DnsOverHttpsServer_UnserializedMessageContext<
            UserType, DnsOverHttpsServer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DnsOverHttpsServer::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string server_template;
  
  bool use_post;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DnsOverHttpsServer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DnsOverHttpsServer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DnsOverHttpsServer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DnsOverHttpsServer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ResolveErrorInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResolveErrorInfo, T>::value>;
  using DataView = ResolveErrorInfoDataView;
  using Data_ = internal::ResolveErrorInfo_Data;

  template <typename... Args>
  static ResolveErrorInfoPtr New(Args&&... args) {
    return ResolveErrorInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResolveErrorInfoPtr From(const U& u) {
    return mojo::TypeConverter<ResolveErrorInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResolveErrorInfo>::Convert(*this);
  }


  ResolveErrorInfo();

  ResolveErrorInfo(
      int32_t error,
      bool is_secure_network_error);

  ~ResolveErrorInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResolveErrorInfoPtr>
  ResolveErrorInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResolveErrorInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResolveErrorInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResolveErrorInfo_UnserializedMessageContext<
            UserType, ResolveErrorInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ResolveErrorInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ResolveErrorInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResolveErrorInfo_UnserializedMessageContext<
            UserType, ResolveErrorInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResolveErrorInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t error;
  
  bool is_secure_network_error;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  DnsConfigOverrides {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DnsConfigOverrides, T>::value>;
  using DataView = DnsConfigOverridesDataView;
  using Data_ = internal::DnsConfigOverrides_Data;
  using Tristate = DnsConfigOverrides_Tristate;

  template <typename... Args>
  static DnsConfigOverridesPtr New(Args&&... args) {
    return DnsConfigOverridesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DnsConfigOverridesPtr From(const U& u) {
    return mojo::TypeConverter<DnsConfigOverridesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DnsConfigOverrides>::Convert(*this);
  }


  DnsConfigOverrides();

  DnsConfigOverrides(
      base::Optional<std::vector<::net::IPEndPoint>> nameservers,
      base::Optional<std::vector<std::string>> search,
      DnsConfigOverrides::Tristate append_to_multi_label_name,
      int8_t ndots,
      base::Optional<::base::TimeDelta> timeout,
      int32_t attempts,
      DnsConfigOverrides::Tristate rotate,
      DnsConfigOverrides::Tristate use_local_ipv6,
      base::Optional<std::vector<DnsOverHttpsServerPtr>> dns_over_https_servers,
      OptionalSecureDnsMode secure_dns_mode,
      DnsConfigOverrides::Tristate allow_dns_over_https_upgrade,
      base::Optional<std::vector<std::string>> disabled_upgrade_providers,
      bool clear_hosts);

  ~DnsConfigOverrides();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DnsConfigOverridesPtr>
  DnsConfigOverridesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DnsConfigOverrides::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DnsConfigOverrides::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DnsConfigOverrides_UnserializedMessageContext<
            UserType, DnsConfigOverrides::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DnsConfigOverrides::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DnsConfigOverrides::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DnsConfigOverrides_UnserializedMessageContext<
            UserType, DnsConfigOverrides::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DnsConfigOverrides::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<std::vector<::net::IPEndPoint>> nameservers;
  
  base::Optional<std::vector<std::string>> search;
  
  DnsConfigOverrides::Tristate append_to_multi_label_name;
  
  int8_t ndots;
  
  base::Optional<::base::TimeDelta> timeout;
  
  int32_t attempts;
  
  DnsConfigOverrides::Tristate rotate;
  
  DnsConfigOverrides::Tristate use_local_ipv6;
  
  base::Optional<std::vector<DnsOverHttpsServerPtr>> dns_over_https_servers;
  
  OptionalSecureDnsMode secure_dns_mode;
  
  DnsConfigOverrides::Tristate allow_dns_over_https_upgrade;
  
  base::Optional<std::vector<std::string>> disabled_upgrade_providers;
  
  bool clear_hosts;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DnsConfigOverrides);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DnsConfigOverrides::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ResolveHostParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResolveHostParameters, T>::value>;
  using DataView = ResolveHostParametersDataView;
  using Data_ = internal::ResolveHostParameters_Data;
  using Source = ResolveHostParameters_Source;
  using CacheUsage = ResolveHostParameters_CacheUsage;

  template <typename... Args>
  static ResolveHostParametersPtr New(Args&&... args) {
    return ResolveHostParametersPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResolveHostParametersPtr From(const U& u) {
    return mojo::TypeConverter<ResolveHostParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResolveHostParameters>::Convert(*this);
  }


  ResolveHostParameters();

  ResolveHostParameters(
      ::net::DnsQueryType dns_query_type,
      ::net::RequestPriority initial_priority,
      ::net::HostResolverSource source,
      ResolveHostParameters::CacheUsage cache_usage,
      ::mojo::PendingReceiver<ResolveHostHandle> control_handle,
      bool include_canonical_name,
      bool loopback_only,
      bool is_speculative,
      OptionalSecureDnsMode secure_dns_mode_override);

  ~ResolveHostParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResolveHostParametersPtr>
  ResolveHostParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResolveHostParameters::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResolveHostParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResolveHostParameters_UnserializedMessageContext<
            UserType, ResolveHostParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ResolveHostParameters::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ResolveHostParameters::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResolveHostParameters_UnserializedMessageContext<
            UserType, ResolveHostParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResolveHostParameters::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::net::DnsQueryType dns_query_type;
  
  ::net::RequestPriority initial_priority;
  
  ::net::HostResolverSource source;
  
  ResolveHostParameters::CacheUsage cache_usage;
  
  ::mojo::PendingReceiver<ResolveHostHandle> control_handle;
  
  bool include_canonical_name;
  
  bool loopback_only;
  
  bool is_speculative;
  
  OptionalSecureDnsMode secure_dns_mode_override;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ResolveHostParameters);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResolveHostParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DnsOverHttpsServerPtr DnsOverHttpsServer::Clone() const {
  return New(
      mojo::Clone(server_template),
      mojo::Clone(use_post)
  );
}

template <typename T, DnsOverHttpsServer::EnableIfSame<T>*>
bool DnsOverHttpsServer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->server_template, other_struct.server_template))
    return false;
  if (!mojo::Equals(this->use_post, other_struct.use_post))
    return false;
  return true;
}

template <typename T, DnsOverHttpsServer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.server_template, rhs.server_template))
    return true;
  if (std::less<>{}(rhs.server_template, lhs.server_template))
    return false;
  if (std::less<>{}(lhs.use_post, rhs.use_post))
    return true;
  if (std::less<>{}(rhs.use_post, lhs.use_post))
    return false;
  return false;
}
template <typename StructPtrType>
DnsConfigOverridesPtr DnsConfigOverrides::Clone() const {
  return New(
      mojo::Clone(nameservers),
      mojo::Clone(search),
      mojo::Clone(append_to_multi_label_name),
      mojo::Clone(ndots),
      mojo::Clone(timeout),
      mojo::Clone(attempts),
      mojo::Clone(rotate),
      mojo::Clone(use_local_ipv6),
      mojo::Clone(dns_over_https_servers),
      mojo::Clone(secure_dns_mode),
      mojo::Clone(allow_dns_over_https_upgrade),
      mojo::Clone(disabled_upgrade_providers),
      mojo::Clone(clear_hosts)
  );
}

template <typename T, DnsConfigOverrides::EnableIfSame<T>*>
bool DnsConfigOverrides::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->nameservers, other_struct.nameservers))
    return false;
  if (!mojo::Equals(this->search, other_struct.search))
    return false;
  if (!mojo::Equals(this->append_to_multi_label_name, other_struct.append_to_multi_label_name))
    return false;
  if (!mojo::Equals(this->ndots, other_struct.ndots))
    return false;
  if (!mojo::Equals(this->timeout, other_struct.timeout))
    return false;
  if (!mojo::Equals(this->attempts, other_struct.attempts))
    return false;
  if (!mojo::Equals(this->rotate, other_struct.rotate))
    return false;
  if (!mojo::Equals(this->use_local_ipv6, other_struct.use_local_ipv6))
    return false;
  if (!mojo::Equals(this->dns_over_https_servers, other_struct.dns_over_https_servers))
    return false;
  if (!mojo::Equals(this->secure_dns_mode, other_struct.secure_dns_mode))
    return false;
  if (!mojo::Equals(this->allow_dns_over_https_upgrade, other_struct.allow_dns_over_https_upgrade))
    return false;
  if (!mojo::Equals(this->disabled_upgrade_providers, other_struct.disabled_upgrade_providers))
    return false;
  if (!mojo::Equals(this->clear_hosts, other_struct.clear_hosts))
    return false;
  return true;
}

template <typename T, DnsConfigOverrides::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.nameservers, rhs.nameservers))
    return true;
  if (std::less<>{}(rhs.nameservers, lhs.nameservers))
    return false;
  if (std::less<>{}(lhs.search, rhs.search))
    return true;
  if (std::less<>{}(rhs.search, lhs.search))
    return false;
  if (std::less<>{}(lhs.append_to_multi_label_name, rhs.append_to_multi_label_name))
    return true;
  if (std::less<>{}(rhs.append_to_multi_label_name, lhs.append_to_multi_label_name))
    return false;
  if (std::less<>{}(lhs.ndots, rhs.ndots))
    return true;
  if (std::less<>{}(rhs.ndots, lhs.ndots))
    return false;
  if (std::less<>{}(lhs.timeout, rhs.timeout))
    return true;
  if (std::less<>{}(rhs.timeout, lhs.timeout))
    return false;
  if (std::less<>{}(lhs.attempts, rhs.attempts))
    return true;
  if (std::less<>{}(rhs.attempts, lhs.attempts))
    return false;
  if (std::less<>{}(lhs.rotate, rhs.rotate))
    return true;
  if (std::less<>{}(rhs.rotate, lhs.rotate))
    return false;
  if (std::less<>{}(lhs.use_local_ipv6, rhs.use_local_ipv6))
    return true;
  if (std::less<>{}(rhs.use_local_ipv6, lhs.use_local_ipv6))
    return false;
  if (std::less<>{}(lhs.dns_over_https_servers, rhs.dns_over_https_servers))
    return true;
  if (std::less<>{}(rhs.dns_over_https_servers, lhs.dns_over_https_servers))
    return false;
  if (std::less<>{}(lhs.secure_dns_mode, rhs.secure_dns_mode))
    return true;
  if (std::less<>{}(rhs.secure_dns_mode, lhs.secure_dns_mode))
    return false;
  if (std::less<>{}(lhs.allow_dns_over_https_upgrade, rhs.allow_dns_over_https_upgrade))
    return true;
  if (std::less<>{}(rhs.allow_dns_over_https_upgrade, lhs.allow_dns_over_https_upgrade))
    return false;
  if (std::less<>{}(lhs.disabled_upgrade_providers, rhs.disabled_upgrade_providers))
    return true;
  if (std::less<>{}(rhs.disabled_upgrade_providers, lhs.disabled_upgrade_providers))
    return false;
  if (std::less<>{}(lhs.clear_hosts, rhs.clear_hosts))
    return true;
  if (std::less<>{}(rhs.clear_hosts, lhs.clear_hosts))
    return false;
  return false;
}
template <typename StructPtrType>
ResolveErrorInfoPtr ResolveErrorInfo::Clone() const {
  return New(
      mojo::Clone(error),
      mojo::Clone(is_secure_network_error)
  );
}

template <typename T, ResolveErrorInfo::EnableIfSame<T>*>
bool ResolveErrorInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error, other_struct.error))
    return false;
  if (!mojo::Equals(this->is_secure_network_error, other_struct.is_secure_network_error))
    return false;
  return true;
}

template <typename T, ResolveErrorInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.error, rhs.error))
    return true;
  if (std::less<>{}(rhs.error, lhs.error))
    return false;
  if (std::less<>{}(lhs.is_secure_network_error, rhs.is_secure_network_error))
    return true;
  if (std::less<>{}(rhs.is_secure_network_error, lhs.is_secure_network_error))
    return false;
  return false;
}
template <typename StructPtrType>
ResolveHostParametersPtr ResolveHostParameters::Clone() const {
  return New(
      mojo::Clone(dns_query_type),
      mojo::Clone(initial_priority),
      mojo::Clone(source),
      mojo::Clone(cache_usage),
      mojo::Clone(control_handle),
      mojo::Clone(include_canonical_name),
      mojo::Clone(loopback_only),
      mojo::Clone(is_speculative),
      mojo::Clone(secure_dns_mode_override)
  );
}

template <typename T, ResolveHostParameters::EnableIfSame<T>*>
bool ResolveHostParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dns_query_type, other_struct.dns_query_type))
    return false;
  if (!mojo::Equals(this->initial_priority, other_struct.initial_priority))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  if (!mojo::Equals(this->cache_usage, other_struct.cache_usage))
    return false;
  if (!mojo::Equals(this->control_handle, other_struct.control_handle))
    return false;
  if (!mojo::Equals(this->include_canonical_name, other_struct.include_canonical_name))
    return false;
  if (!mojo::Equals(this->loopback_only, other_struct.loopback_only))
    return false;
  if (!mojo::Equals(this->is_speculative, other_struct.is_speculative))
    return false;
  if (!mojo::Equals(this->secure_dns_mode_override, other_struct.secure_dns_mode_override))
    return false;
  return true;
}

template <typename T, ResolveHostParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.dns_query_type, rhs.dns_query_type))
    return true;
  if (std::less<>{}(rhs.dns_query_type, lhs.dns_query_type))
    return false;
  if (std::less<>{}(lhs.initial_priority, rhs.initial_priority))
    return true;
  if (std::less<>{}(rhs.initial_priority, lhs.initial_priority))
    return false;
  if (std::less<>{}(lhs.source, rhs.source))
    return true;
  if (std::less<>{}(rhs.source, lhs.source))
    return false;
  if (std::less<>{}(lhs.cache_usage, rhs.cache_usage))
    return true;
  if (std::less<>{}(rhs.cache_usage, lhs.cache_usage))
    return false;
  if (std::less<>{}(lhs.control_handle, rhs.control_handle))
    return true;
  if (std::less<>{}(rhs.control_handle, lhs.control_handle))
    return false;
  if (std::less<>{}(lhs.include_canonical_name, rhs.include_canonical_name))
    return true;
  if (std::less<>{}(rhs.include_canonical_name, lhs.include_canonical_name))
    return false;
  if (std::less<>{}(lhs.loopback_only, rhs.loopback_only))
    return true;
  if (std::less<>{}(rhs.loopback_only, lhs.loopback_only))
    return false;
  if (std::less<>{}(lhs.is_speculative, rhs.is_speculative))
    return true;
  if (std::less<>{}(rhs.is_speculative, lhs.is_speculative))
    return false;
  if (std::less<>{}(lhs.secure_dns_mode_override, rhs.secure_dns_mode_override))
    return true;
  if (std::less<>{}(rhs.secure_dns_mode_override, lhs.secure_dns_mode_override))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::DnsOverHttpsServer::DataView,
                                         ::network::mojom::DnsOverHttpsServerPtr> {
  static bool IsNull(const ::network::mojom::DnsOverHttpsServerPtr& input) { return !input; }
  static void SetToNull(::network::mojom::DnsOverHttpsServerPtr* output) { output->reset(); }

  static const decltype(::network::mojom::DnsOverHttpsServer::server_template)& server_template(
      const ::network::mojom::DnsOverHttpsServerPtr& input) {
    return input->server_template;
  }

  static decltype(::network::mojom::DnsOverHttpsServer::use_post) use_post(
      const ::network::mojom::DnsOverHttpsServerPtr& input) {
    return input->use_post;
  }

  static bool Read(::network::mojom::DnsOverHttpsServer::DataView input, ::network::mojom::DnsOverHttpsServerPtr* output);
};


template <>
struct  StructTraits<::network::mojom::DnsConfigOverrides::DataView,
                                         ::network::mojom::DnsConfigOverridesPtr> {
  static bool IsNull(const ::network::mojom::DnsConfigOverridesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::DnsConfigOverridesPtr* output) { output->reset(); }

  static const decltype(::network::mojom::DnsConfigOverrides::nameservers)& nameservers(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->nameservers;
  }

  static const decltype(::network::mojom::DnsConfigOverrides::search)& search(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->search;
  }

  static decltype(::network::mojom::DnsConfigOverrides::append_to_multi_label_name) append_to_multi_label_name(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->append_to_multi_label_name;
  }

  static decltype(::network::mojom::DnsConfigOverrides::ndots) ndots(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->ndots;
  }

  static const decltype(::network::mojom::DnsConfigOverrides::timeout)& timeout(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->timeout;
  }

  static decltype(::network::mojom::DnsConfigOverrides::attempts) attempts(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->attempts;
  }

  static decltype(::network::mojom::DnsConfigOverrides::rotate) rotate(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->rotate;
  }

  static decltype(::network::mojom::DnsConfigOverrides::use_local_ipv6) use_local_ipv6(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->use_local_ipv6;
  }

  static const decltype(::network::mojom::DnsConfigOverrides::dns_over_https_servers)& dns_over_https_servers(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->dns_over_https_servers;
  }

  static decltype(::network::mojom::DnsConfigOverrides::secure_dns_mode) secure_dns_mode(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->secure_dns_mode;
  }

  static decltype(::network::mojom::DnsConfigOverrides::allow_dns_over_https_upgrade) allow_dns_over_https_upgrade(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->allow_dns_over_https_upgrade;
  }

  static const decltype(::network::mojom::DnsConfigOverrides::disabled_upgrade_providers)& disabled_upgrade_providers(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->disabled_upgrade_providers;
  }

  static decltype(::network::mojom::DnsConfigOverrides::clear_hosts) clear_hosts(
      const ::network::mojom::DnsConfigOverridesPtr& input) {
    return input->clear_hosts;
  }

  static bool Read(::network::mojom::DnsConfigOverrides::DataView input, ::network::mojom::DnsConfigOverridesPtr* output);
};


template <>
struct  StructTraits<::network::mojom::ResolveErrorInfo::DataView,
                                         ::network::mojom::ResolveErrorInfoPtr> {
  static bool IsNull(const ::network::mojom::ResolveErrorInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ResolveErrorInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::ResolveErrorInfo::error) error(
      const ::network::mojom::ResolveErrorInfoPtr& input) {
    return input->error;
  }

  static decltype(::network::mojom::ResolveErrorInfo::is_secure_network_error) is_secure_network_error(
      const ::network::mojom::ResolveErrorInfoPtr& input) {
    return input->is_secure_network_error;
  }

  static bool Read(::network::mojom::ResolveErrorInfo::DataView input, ::network::mojom::ResolveErrorInfoPtr* output);
};


template <>
struct  StructTraits<::network::mojom::ResolveHostParameters::DataView,
                                         ::network::mojom::ResolveHostParametersPtr> {
  static bool IsNull(const ::network::mojom::ResolveHostParametersPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ResolveHostParametersPtr* output) { output->reset(); }

  static decltype(::network::mojom::ResolveHostParameters::dns_query_type) dns_query_type(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->dns_query_type;
  }

  static decltype(::network::mojom::ResolveHostParameters::initial_priority) initial_priority(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->initial_priority;
  }

  static decltype(::network::mojom::ResolveHostParameters::source) source(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->source;
  }

  static decltype(::network::mojom::ResolveHostParameters::cache_usage) cache_usage(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->cache_usage;
  }

  static  decltype(::network::mojom::ResolveHostParameters::control_handle)& control_handle(
       ::network::mojom::ResolveHostParametersPtr& input) {
    return input->control_handle;
  }

  static decltype(::network::mojom::ResolveHostParameters::include_canonical_name) include_canonical_name(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->include_canonical_name;
  }

  static decltype(::network::mojom::ResolveHostParameters::loopback_only) loopback_only(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->loopback_only;
  }

  static decltype(::network::mojom::ResolveHostParameters::is_speculative) is_speculative(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->is_speculative;
  }

  static decltype(::network::mojom::ResolveHostParameters::secure_dns_mode_override) secure_dns_mode_override(
      const ::network::mojom::ResolveHostParametersPtr& input) {
    return input->secure_dns_mode_override;
  }

  static bool Read(::network::mojom::ResolveHostParameters::DataView input, ::network::mojom::ResolveHostParametersPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_H_