// components/ip_protection/mojom/data_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_SHARED_H_
#define COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/ip_protection/mojom/data_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"







namespace ip_protection::mojom {
class GeoHintDataView;

class BlindSignedAuthTokenDataView;



}  // ip_protection::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ip_protection::mojom::GeoHintDataView> {
  using Data = ::ip_protection::mojom::internal::GeoHint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ip_protection::mojom::BlindSignedAuthTokenDataView> {
  using Data = ::ip_protection::mojom::internal::BlindSignedAuthToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ip_protection::mojom {


enum class ProxyLayer : int32_t {
  
  kProxyA = 0,
  
  kProxyB = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ProxyLayer value);
inline bool IsKnownEnumValue(ProxyLayer value) {
  return internal::ProxyLayer_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GeoHintDataView {
 public:
  GeoHintDataView() = default;

  GeoHintDataView(
      internal::GeoHint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCountryCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCountryCode(UserType* output) {
    
    auto* pointer = data_->country_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIsoRegionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsoRegion(UserType* output) {
    
    auto* pointer = data_->iso_region.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCityNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCityName(UserType* output) {
    
    auto* pointer = data_->city_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GeoHint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BlindSignedAuthTokenDataView {
 public:
  BlindSignedAuthTokenDataView() = default;

  BlindSignedAuthTokenDataView(
      internal::BlindSignedAuthToken_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExpirationDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiration(UserType* output) {
    
    auto* pointer = data_->expiration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetGeoHintDataView(
      GeoHintDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeoHint(UserType* output) {
    
    auto* pointer = data_->geo_hint.Get();
    return mojo::internal::Deserialize<::ip_protection::mojom::GeoHintDataView>(
        pointer, output, message_);
  }
 private:
  internal::BlindSignedAuthToken_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ip_protection::mojom

namespace std {

template <>
struct hash<::ip_protection::mojom::ProxyLayer>
    : public mojo::internal::EnumHashImpl<::ip_protection::mojom::ProxyLayer> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ip_protection::mojom::ProxyLayer, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ip_protection::mojom::ProxyLayer, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ip_protection::mojom::ProxyLayer>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ip_protection::mojom::GeoHintDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ip_protection::mojom::GeoHintDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ip_protection::mojom::internal::GeoHint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::country_code(input)) in_country_code = Traits::country_code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->country_code)::BaseType> country_code_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_country_code, country_code_fragment);
    fragment->country_code.Set(
        country_code_fragment.is_null() ? nullptr : country_code_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->country_code.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null country_code in GeoHint struct");
    decltype(Traits::iso_region(input)) in_iso_region = Traits::iso_region(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->iso_region)::BaseType> iso_region_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_iso_region, iso_region_fragment);
    fragment->iso_region.Set(
        iso_region_fragment.is_null() ? nullptr : iso_region_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->iso_region.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null iso_region in GeoHint struct");
    decltype(Traits::city_name(input)) in_city_name = Traits::city_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->city_name)::BaseType> city_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_city_name, city_name_fragment);
    fragment->city_name.Set(
        city_name_fragment.is_null() ? nullptr : city_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->city_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null city_name in GeoHint struct");
  }

  static bool Deserialize(::ip_protection::mojom::internal::GeoHint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ip_protection::mojom::GeoHintDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ip_protection::mojom::BlindSignedAuthTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ip_protection::mojom::BlindSignedAuthTokenDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ip_protection::mojom::internal::BlindSignedAuthToken_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_token, token_fragment);
    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in BlindSignedAuthToken struct");
    decltype(Traits::expiration(input)) in_expiration = Traits::expiration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiration)::BaseType> expiration_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_expiration, expiration_fragment);
    fragment->expiration.Set(
        expiration_fragment.is_null() ? nullptr : expiration_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->expiration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiration in BlindSignedAuthToken struct");
    decltype(Traits::geo_hint(input)) in_geo_hint = Traits::geo_hint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->geo_hint)::BaseType> geo_hint_fragment(
            fragment.message());
    mojo::internal::Serialize<::ip_protection::mojom::GeoHintDataView>(
        in_geo_hint, geo_hint_fragment);
    fragment->geo_hint.Set(
        geo_hint_fragment.is_null() ? nullptr : geo_hint_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->geo_hint.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null geo_hint in BlindSignedAuthToken struct");
  }

  static bool Deserialize(::ip_protection::mojom::internal::BlindSignedAuthToken_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ip_protection::mojom::BlindSignedAuthTokenDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ip_protection::mojom {

inline void GeoHintDataView::GetCountryCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->country_code.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GeoHintDataView::GetIsoRegionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->iso_region.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GeoHintDataView::GetCityNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->city_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BlindSignedAuthTokenDataView::GetTokenDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->token.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BlindSignedAuthTokenDataView::GetExpirationDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expiration.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void BlindSignedAuthTokenDataView::GetGeoHintDataView(
    GeoHintDataView* output) {
  auto pointer = data_->geo_hint.Get();
  *output = GeoHintDataView(pointer, message_);
}



}  // ip_protection::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::ip_protection::mojom::ProxyLayer> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ip_protection::mojom::ProxyLayer value);
};

} // namespace perfetto

#endif  // COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_SHARED_H_