// services/network/public/mojom/service_worker_router_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SERVICE_WORKER_ROUTER_INFO_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SERVICE_WORKER_ROUTER_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/service_worker_router_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"







namespace network::mojom {
class ServiceWorkerRouterInfoDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ServiceWorkerRouterInfoDataView> {
  using Data = ::network::mojom::internal::ServiceWorkerRouterInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class ServiceWorkerRouterSourceType : int32_t {
  
  kNetwork = 0,
  
  kRace = 1,
  
  kFetchEvent = 2,
  
  kCache = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ServiceWorkerRouterSourceType value);
inline bool IsKnownEnumValue(ServiceWorkerRouterSourceType value) {
  return internal::ServiceWorkerRouterSourceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ServiceWorkerStatus : int32_t {
  
  kRunning = 0,
  
  kStarting = 1,
  
  kStopping = 2,
  
  kStopped = 3,
  
  kWarmingUp = 4,
  
  kWarmedUp = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, ServiceWorkerStatus value);
inline bool IsKnownEnumValue(ServiceWorkerStatus value) {
  return internal::ServiceWorkerStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ServiceWorkerRouterInfoDataView {
 public:
  ServiceWorkerRouterInfoDataView() = default;

  ServiceWorkerRouterInfoDataView(
      internal::ServiceWorkerRouterInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  std::optional<uint32_t> rule_id_matched() const {

    return data_->rule_id_matched_$flag
        ? std::make_optional(data_->rule_id_matched_$value)
        : std::nullopt;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMatchedSourceType(UserType* output) const {
    if (!data_->matched_source_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::ServiceWorkerRouterSourceType>(
        data_->matched_source_type_$value, &output->emplace());
  }
  std::optional<ServiceWorkerRouterSourceType> matched_source_type() const {
    if (!data_->matched_source_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ServiceWorkerRouterSourceType>(data_->matched_source_type_$value));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadActualSourceType(UserType* output) const {
    if (!data_->actual_source_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::ServiceWorkerRouterSourceType>(
        data_->actual_source_type_$value, &output->emplace());
  }
  std::optional<ServiceWorkerRouterSourceType> actual_source_type() const {
    if (!data_->actual_source_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ServiceWorkerRouterSourceType>(data_->actual_source_type_$value));
  }
  uint64_t route_rule_num() const {
    return data_->route_rule_num;
  }
  inline void GetRouterEvaluationTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouterEvaluationTime(UserType* output) {
    
    auto* pointer = data_->router_evaluation_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetCacheLookupTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheLookupTime(UserType* output) {
    
    auto* pointer = data_->cache_lookup_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEvaluationWorkerStatus(UserType* output) const {
    if (!data_->evaluation_worker_status_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::ServiceWorkerStatus>(
        data_->evaluation_worker_status_$value, &output->emplace());
  }
  std::optional<ServiceWorkerStatus> evaluation_worker_status() const {
    if (!data_->evaluation_worker_status_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ServiceWorkerStatus>(data_->evaluation_worker_status_$value));
  }
 private:
  internal::ServiceWorkerRouterInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::ServiceWorkerRouterSourceType>
    : public mojo::internal::EnumHashImpl<::network::mojom::ServiceWorkerRouterSourceType> {};

template <>
struct hash<::network::mojom::ServiceWorkerStatus>
    : public mojo::internal::EnumHashImpl<::network::mojom::ServiceWorkerStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ServiceWorkerRouterSourceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ServiceWorkerRouterSourceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ServiceWorkerRouterSourceType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ServiceWorkerStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ServiceWorkerStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ServiceWorkerStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ServiceWorkerRouterInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ServiceWorkerRouterInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ServiceWorkerRouterInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->rule_id_matched_$flag = Traits::rule_id_matched(input).has_value();
    if (Traits::rule_id_matched(input).has_value()) {
      fragment->rule_id_matched_$value = Traits::rule_id_matched(input).value();
    }
    fragment->matched_source_type_$flag = Traits::matched_source_type(input).has_value();
    if (Traits::matched_source_type(input).has_value()) {
      mojo::internal::Serialize<::network::mojom::ServiceWorkerRouterSourceType>(
          Traits::matched_source_type(input).value(), &fragment->matched_source_type_$value);
    } else {
      fragment->matched_source_type_$value =
          static_cast<int32_t>(::network::mojom::ServiceWorkerRouterSourceType::kMinValue);
    }
    fragment->actual_source_type_$flag = Traits::actual_source_type(input).has_value();
    if (Traits::actual_source_type(input).has_value()) {
      mojo::internal::Serialize<::network::mojom::ServiceWorkerRouterSourceType>(
          Traits::actual_source_type(input).value(), &fragment->actual_source_type_$value);
    } else {
      fragment->actual_source_type_$value =
          static_cast<int32_t>(::network::mojom::ServiceWorkerRouterSourceType::kMinValue);
    }
    fragment->route_rule_num = Traits::route_rule_num(input);
    decltype(Traits::router_evaluation_time(input)) in_router_evaluation_time = Traits::router_evaluation_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->router_evaluation_time)::BaseType> router_evaluation_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_router_evaluation_time, router_evaluation_time_fragment);
    fragment->router_evaluation_time.Set(
        router_evaluation_time_fragment.is_null() ? nullptr : router_evaluation_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->router_evaluation_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null router_evaluation_time in ServiceWorkerRouterInfo struct");
    decltype(Traits::cache_lookup_time(input)) in_cache_lookup_time = Traits::cache_lookup_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cache_lookup_time)::BaseType> cache_lookup_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_cache_lookup_time, cache_lookup_time_fragment);
    fragment->cache_lookup_time.Set(
        cache_lookup_time_fragment.is_null() ? nullptr : cache_lookup_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cache_lookup_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cache_lookup_time in ServiceWorkerRouterInfo struct");
    fragment->evaluation_worker_status_$flag = Traits::evaluation_worker_status(input).has_value();
    if (Traits::evaluation_worker_status(input).has_value()) {
      mojo::internal::Serialize<::network::mojom::ServiceWorkerStatus>(
          Traits::evaluation_worker_status(input).value(), &fragment->evaluation_worker_status_$value);
    } else {
      fragment->evaluation_worker_status_$value =
          static_cast<int32_t>(::network::mojom::ServiceWorkerStatus::kMinValue);
    }
  }

  static bool Deserialize(::network::mojom::internal::ServiceWorkerRouterInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ServiceWorkerRouterInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ServiceWorkerRouterInfoDataView::GetRouterEvaluationTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->router_evaluation_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void ServiceWorkerRouterInfoDataView::GetCacheLookupTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->cache_lookup_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ServiceWorkerRouterSourceType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ServiceWorkerRouterSourceType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ServiceWorkerStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ServiceWorkerStatus value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SERVICE_WORKER_ROUTER_INFO_MOJOM_SHARED_H_