// services/video_capture/public/mojom/device.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace video_capture::mojom {
namespace internal {
class  Device_Start_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::VideoCaptureParams_Data> requested_settings;
  mojo::internal::Interface_Data handler;

 private:
  friend class mojo::internal::MessageFragment<Device_Start_Params_Data>;

  Device_Start_Params_Data();
  ~Device_Start_Params_Data() = delete;
};
static_assert(sizeof(Device_Start_Params_Data) == 24,
              "Bad sizeof(Device_Start_Params_Data)");
class  Device_MaybeSuspend_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Device_MaybeSuspend_Params_Data>;

  Device_MaybeSuspend_Params_Data();
  ~Device_MaybeSuspend_Params_Data() = delete;
};
static_assert(sizeof(Device_MaybeSuspend_Params_Data) == 8,
              "Bad sizeof(Device_MaybeSuspend_Params_Data)");
class  Device_Resume_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Device_Resume_Params_Data>;

  Device_Resume_Params_Data();
  ~Device_Resume_Params_Data() = delete;
};
static_assert(sizeof(Device_Resume_Params_Data) == 8,
              "Bad sizeof(Device_Resume_Params_Data)");
class  Device_GetPhotoState_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Device_GetPhotoState_Params_Data>;

  Device_GetPhotoState_Params_Data();
  ~Device_GetPhotoState_Params_Data() = delete;
};
static_assert(sizeof(Device_GetPhotoState_Params_Data) == 8,
              "Bad sizeof(Device_GetPhotoState_Params_Data)");
class  Device_GetPhotoState_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::PhotoState_Data> capabilities;

 private:
  friend class mojo::internal::MessageFragment<Device_GetPhotoState_ResponseParams_Data>;

  Device_GetPhotoState_ResponseParams_Data();
  ~Device_GetPhotoState_ResponseParams_Data() = delete;
};
static_assert(sizeof(Device_GetPhotoState_ResponseParams_Data) == 16,
              "Bad sizeof(Device_GetPhotoState_ResponseParams_Data)");
class  Device_SetPhotoOptions_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::PhotoSettings_Data> settings;

 private:
  friend class mojo::internal::MessageFragment<Device_SetPhotoOptions_Params_Data>;

  Device_SetPhotoOptions_Params_Data();
  ~Device_SetPhotoOptions_Params_Data() = delete;
};
static_assert(sizeof(Device_SetPhotoOptions_Params_Data) == 16,
              "Bad sizeof(Device_SetPhotoOptions_Params_Data)");
class  Device_SetPhotoOptions_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Device_SetPhotoOptions_ResponseParams_Data>;

  Device_SetPhotoOptions_ResponseParams_Data();
  ~Device_SetPhotoOptions_ResponseParams_Data() = delete;
};
static_assert(sizeof(Device_SetPhotoOptions_ResponseParams_Data) == 16,
              "Bad sizeof(Device_SetPhotoOptions_ResponseParams_Data)");
class  Device_TakePhoto_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Device_TakePhoto_Params_Data>;

  Device_TakePhoto_Params_Data();
  ~Device_TakePhoto_Params_Data() = delete;
};
static_assert(sizeof(Device_TakePhoto_Params_Data) == 8,
              "Bad sizeof(Device_TakePhoto_Params_Data)");
class  Device_TakePhoto_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::Blob_Data> blob;

 private:
  friend class mojo::internal::MessageFragment<Device_TakePhoto_ResponseParams_Data>;

  Device_TakePhoto_ResponseParams_Data();
  ~Device_TakePhoto_ResponseParams_Data() = delete;
};
static_assert(sizeof(Device_TakePhoto_ResponseParams_Data) == 16,
              "Bad sizeof(Device_TakePhoto_ResponseParams_Data)");
class  Device_ProcessFeedback_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::VideoCaptureFeedback_Data> feedback;

 private:
  friend class mojo::internal::MessageFragment<Device_ProcessFeedback_Params_Data>;

  Device_ProcessFeedback_Params_Data();
  ~Device_ProcessFeedback_Params_Data() = delete;
};
static_assert(sizeof(Device_ProcessFeedback_Params_Data) == 16,
              "Bad sizeof(Device_ProcessFeedback_Params_Data)");
class  Device_RequestRefreshFrame_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Device_RequestRefreshFrame_Params_Data>;

  Device_RequestRefreshFrame_Params_Data();
  ~Device_RequestRefreshFrame_Params_Data() = delete;
};
static_assert(sizeof(Device_RequestRefreshFrame_Params_Data) == 8,
              "Bad sizeof(Device_RequestRefreshFrame_Params_Data)");

}  // namespace internal


class Device_Start_ParamsDataView {
 public:
  Device_Start_ParamsDataView() = default;

  Device_Start_ParamsDataView(
      internal::Device_Start_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestedSettingsDataView(
      ::media::mojom::VideoCaptureParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestedSettings(UserType* output) {
    
    auto* pointer = data_->requested_settings.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureParamsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameHandlerInterfaceBase>>(
            &data_->handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Device_Start_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Device_MaybeSuspend_ParamsDataView {
 public:
  Device_MaybeSuspend_ParamsDataView() = default;

  Device_MaybeSuspend_ParamsDataView(
      internal::Device_MaybeSuspend_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Device_MaybeSuspend_Params_Data* data_ = nullptr;
};


class Device_Resume_ParamsDataView {
 public:
  Device_Resume_ParamsDataView() = default;

  Device_Resume_ParamsDataView(
      internal::Device_Resume_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Device_Resume_Params_Data* data_ = nullptr;
};


class Device_GetPhotoState_ParamsDataView {
 public:
  Device_GetPhotoState_ParamsDataView() = default;

  Device_GetPhotoState_ParamsDataView(
      internal::Device_GetPhotoState_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Device_GetPhotoState_Params_Data* data_ = nullptr;
};


class Device_GetPhotoState_ResponseParamsDataView {
 public:
  Device_GetPhotoState_ResponseParamsDataView() = default;

  Device_GetPhotoState_ResponseParamsDataView(
      internal::Device_GetPhotoState_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCapabilitiesDataView(
      ::media::mojom::PhotoStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCapabilities(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::PhotoStateDataView, UserType>(),
    "Attempting to read the optional `capabilities` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCapabilities` instead "
    "of `ReadCapabilities if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->capabilities.Get();
    return mojo::internal::Deserialize<::media::mojom::PhotoStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::Device_GetPhotoState_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Device_SetPhotoOptions_ParamsDataView {
 public:
  Device_SetPhotoOptions_ParamsDataView() = default;

  Device_SetPhotoOptions_ParamsDataView(
      internal::Device_SetPhotoOptions_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSettingsDataView(
      ::media::mojom::PhotoSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSettings(UserType* output) {
    
    auto* pointer = data_->settings.Get();
    return mojo::internal::Deserialize<::media::mojom::PhotoSettingsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Device_SetPhotoOptions_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Device_SetPhotoOptions_ResponseParamsDataView {
 public:
  Device_SetPhotoOptions_ResponseParamsDataView() = default;

  Device_SetPhotoOptions_ResponseParamsDataView(
      internal::Device_SetPhotoOptions_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Device_SetPhotoOptions_ResponseParams_Data* data_ = nullptr;
};


class Device_TakePhoto_ParamsDataView {
 public:
  Device_TakePhoto_ParamsDataView() = default;

  Device_TakePhoto_ParamsDataView(
      internal::Device_TakePhoto_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Device_TakePhoto_Params_Data* data_ = nullptr;
};


class Device_TakePhoto_ResponseParamsDataView {
 public:
  Device_TakePhoto_ResponseParamsDataView() = default;

  Device_TakePhoto_ResponseParamsDataView(
      internal::Device_TakePhoto_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBlobDataView(
      ::media::mojom::BlobDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::BlobDataView, UserType>(),
    "Attempting to read the optional `blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlob` instead "
    "of `ReadBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blob.Get();
    return mojo::internal::Deserialize<::media::mojom::BlobDataView>(
        pointer, output, message_);
  }
 private:
  internal::Device_TakePhoto_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Device_ProcessFeedback_ParamsDataView {
 public:
  Device_ProcessFeedback_ParamsDataView() = default;

  Device_ProcessFeedback_ParamsDataView(
      internal::Device_ProcessFeedback_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFeedbackDataView(
      ::media::mojom::VideoCaptureFeedbackDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeedback(UserType* output) {
    
    auto* pointer = data_->feedback.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureFeedbackDataView>(
        pointer, output, message_);
  }
 private:
  internal::Device_ProcessFeedback_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Device_RequestRefreshFrame_ParamsDataView {
 public:
  Device_RequestRefreshFrame_ParamsDataView() = default;

  Device_RequestRefreshFrame_ParamsDataView(
      internal::Device_RequestRefreshFrame_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Device_RequestRefreshFrame_Params_Data* data_ = nullptr;
};

inline void Device_Start_ParamsDataView::GetRequestedSettingsDataView(
    ::media::mojom::VideoCaptureParamsDataView* output) {
  auto pointer = data_->requested_settings.Get();
  *output = ::media::mojom::VideoCaptureParamsDataView(pointer, message_);
}








inline void Device_GetPhotoState_ResponseParamsDataView::GetCapabilitiesDataView(
    ::media::mojom::PhotoStateDataView* output) {
  auto pointer = data_->capabilities.Get();
  *output = ::media::mojom::PhotoStateDataView(pointer, message_);
}


inline void Device_SetPhotoOptions_ParamsDataView::GetSettingsDataView(
    ::media::mojom::PhotoSettingsDataView* output) {
  auto pointer = data_->settings.Get();
  *output = ::media::mojom::PhotoSettingsDataView(pointer, message_);
}






inline void Device_TakePhoto_ResponseParamsDataView::GetBlobDataView(
    ::media::mojom::BlobDataView* output) {
  auto pointer = data_->blob.Get();
  *output = ::media::mojom::BlobDataView(pointer, message_);
}


inline void Device_ProcessFeedback_ParamsDataView::GetFeedbackDataView(
    ::media::mojom::VideoCaptureFeedbackDataView* output) {
  auto pointer = data_->feedback.Get();
  *output = ::media::mojom::VideoCaptureFeedbackDataView(pointer, message_);
}





}  // video_capture::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_PARAMS_DATA_H_