// third_party/blink/public/mojom/idle/idle_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/idle/idle_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/idle/idle_manager.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* IdleManagerErrorToStringHelper(IdleManagerError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IdleManagerError::kSuccess:
      return "kSuccess";
    case IdleManagerError::kPermissionDisabled:
      return "kPermissionDisabled";
    default:
      return nullptr;
  }
}

std::string IdleManagerErrorToString(IdleManagerError value) {
  const char *str = IdleManagerErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IdleManagerError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IdleManagerError value) {
  return os << IdleManagerErrorToString(value);
}

namespace internal {


// static
bool IdleState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdleState_Data* object =
      static_cast<const IdleState_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->idle_time, validation_context))
    return false;

  return true;
}

IdleState_Data::IdleState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdleMonitor_Update_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdleMonitor_Update_Params_Data* object =
      static_cast<const IdleMonitor_Update_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

IdleMonitor_Update_Params_Data::IdleMonitor_Update_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdleManager_AddMonitor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdleManager_AddMonitor_Params_Data* object =
      static_cast<const IdleManager_AddMonitor_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->monitor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->monitor,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IdleManager_AddMonitor_Params_Data::IdleManager_AddMonitor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdleManager_AddMonitor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdleManager_AddMonitor_ResponseParams_Data* object =
      static_cast<const IdleManager_AddMonitor_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::IdleManagerError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

IdleManager_AddMonitor_ResponseParams_Data::IdleManager_AddMonitor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IdleManagerError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IdleManagerError value) {
  return std::move(context).WriteString(::blink::mojom::IdleManagerErrorToString(value));
}

} // namespace perfetto