// ui/base/ime/mojom/text_input_state.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_SHARED_H_
#define UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/base/ime/mojom/text_input_state.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"
#include "ui/base/ime/mojom/virtual_keyboard_types.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace ui::mojom {
class ImeTextSpanInfoDataView;

class TextInputStateDataView;



}  // ui::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::mojom::ImeTextSpanInfoDataView> {
  using Data = ::ui::mojom::internal::ImeTextSpanInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::TextInputStateDataView> {
  using Data = ::ui::mojom::internal::TextInputState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ui::mojom {


class ImeTextSpanInfoDataView {
 public:
  ImeTextSpanInfoDataView() = default;

  ImeTextSpanInfoDataView(
      internal::ImeTextSpanInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSpanDataView(
      ::ui::mojom::ImeTextSpanDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSpan(UserType* output) {
    
    auto* pointer = data_->span.Get();
    return mojo::internal::Deserialize<::ui::mojom::ImeTextSpanDataView>(
        pointer, output, message_);
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
 private:
  internal::ImeTextSpanInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextInputStateDataView {
 public:
  TextInputStateDataView() = default;

  TextInputStateDataView(
      internal::TextInputState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t node_id() const {
    return data_->node_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::ui::mojom::TextInputType>(
        data_value, output);
  }
  ::ui::mojom::TextInputType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::TextInputType>(data_->type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::ui::mojom::TextInputMode>(
        data_value, output);
  }
  ::ui::mojom::TextInputMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::TextInputMode>(data_->mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) const {
    auto data_value = data_->action;
    return mojo::internal::Deserialize<::ui::mojom::TextInputAction>(
        data_value, output);
  }
  ::ui::mojom::TextInputAction action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::TextInputAction>(data_->action));
  }
  uint32_t flags() const {
    return data_->flags;
  }
  inline void GetValueDataView(
      ::mojo_base::mojom::BigString16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::BigString16DataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::BigString16DataView>(
        pointer, output, message_);
  }
  inline void GetSelectionDataView(
      ::gfx::mojom::RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelection(UserType* output) {
    
    auto* pointer = data_->selection.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetCompositionDataView(
      ::gfx::mojom::RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadComposition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RangeDataView, UserType>(),
    "Attempting to read the optional `composition` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadComposition` instead "
    "of `ReadComposition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->composition.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RangeDataView>(
        pointer, output, message_);
  }
  bool can_compose_inline() const {
    return data_->can_compose_inline;
  }
  bool show_ime_if_needed() const {
    return data_->show_ime_if_needed;
  }
  bool always_hide_ime() const {
    return data_->always_hide_ime;
  }
  bool reply_to_request() const {
    return data_->reply_to_request;
  }
  inline void GetEditContextControlBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEditContextControlBounds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `edit_context_control_bounds` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEditContextControlBounds` instead "
    "of `ReadEditContextControlBounds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->edit_context_control_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetEditContextSelectionBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEditContextSelectionBounds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `edit_context_selection_bounds` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEditContextSelectionBounds` instead "
    "of `ReadEditContextSelectionBounds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->edit_context_selection_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVkPolicy(UserType* output) const {
    auto data_value = data_->vk_policy;
    return mojo::internal::Deserialize<::ui::mojom::VirtualKeyboardPolicy>(
        data_value, output);
  }
  ::ui::mojom::VirtualKeyboardPolicy vk_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::VirtualKeyboardPolicy>(data_->vk_policy));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLastVkVisibilityRequest(UserType* output) const {
    auto data_value = data_->last_vk_visibility_request;
    return mojo::internal::Deserialize<::ui::mojom::VirtualKeyboardVisibilityRequest>(
        data_value, output);
  }
  ::ui::mojom::VirtualKeyboardVisibilityRequest last_vk_visibility_request() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::VirtualKeyboardVisibilityRequest>(data_->last_vk_visibility_request));
  }
  inline void GetImeTextSpansInfoDataView(
      mojo::ArrayDataView<ImeTextSpanInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImeTextSpansInfo(UserType* output) {
    
    auto* pointer = data_->ime_text_spans_info.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TextInputState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ui::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::ImeTextSpanInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::ImeTextSpanInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::ImeTextSpanInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::span(input)) in_span = Traits::span(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->span)::BaseType> span_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::ImeTextSpanDataView>(
        in_span, span_fragment);
    fragment->span.Set(
        span_fragment.is_null() ? nullptr : span_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->span.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null span in ImeTextSpanInfo struct");
    decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounds)::BaseType> bounds_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_bounds, bounds_fragment);
    fragment->bounds.Set(
        bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bounds.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in ImeTextSpanInfo struct");
  }

  static bool Deserialize(::ui::mojom::internal::ImeTextSpanInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::ImeTextSpanInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::TextInputStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::TextInputStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::TextInputState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->node_id = Traits::node_id(input);
    mojo::internal::Serialize<::ui::mojom::TextInputType>(
        Traits::type(input), &fragment->type);
    mojo::internal::Serialize<::ui::mojom::TextInputMode>(
        Traits::mode(input), &fragment->mode);
    mojo::internal::Serialize<::ui::mojom::TextInputAction>(
        Traits::action(input), &fragment->action);
    fragment->flags = Traits::flags(input);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    decltype(Traits::selection(input)) in_selection = Traits::selection(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selection)::BaseType> selection_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
        in_selection, selection_fragment);
    fragment->selection.Set(
        selection_fragment.is_null() ? nullptr : selection_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->selection.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selection in TextInputState struct");
    decltype(Traits::composition(input)) in_composition = Traits::composition(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->composition)::BaseType> composition_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
        in_composition, composition_fragment);
    fragment->composition.Set(
        composition_fragment.is_null() ? nullptr : composition_fragment.data());
    fragment->can_compose_inline = Traits::can_compose_inline(input);
    fragment->show_ime_if_needed = Traits::show_ime_if_needed(input);
    fragment->always_hide_ime = Traits::always_hide_ime(input);
    fragment->reply_to_request = Traits::reply_to_request(input);
    decltype(Traits::edit_context_control_bounds(input)) in_edit_context_control_bounds = Traits::edit_context_control_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->edit_context_control_bounds)::BaseType> edit_context_control_bounds_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_edit_context_control_bounds, edit_context_control_bounds_fragment);
    fragment->edit_context_control_bounds.Set(
        edit_context_control_bounds_fragment.is_null() ? nullptr : edit_context_control_bounds_fragment.data());
    decltype(Traits::edit_context_selection_bounds(input)) in_edit_context_selection_bounds = Traits::edit_context_selection_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->edit_context_selection_bounds)::BaseType> edit_context_selection_bounds_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_edit_context_selection_bounds, edit_context_selection_bounds_fragment);
    fragment->edit_context_selection_bounds.Set(
        edit_context_selection_bounds_fragment.is_null() ? nullptr : edit_context_selection_bounds_fragment.data());
    mojo::internal::Serialize<::ui::mojom::VirtualKeyboardPolicy>(
        Traits::vk_policy(input), &fragment->vk_policy);
    mojo::internal::Serialize<::ui::mojom::VirtualKeyboardVisibilityRequest>(
        Traits::last_vk_visibility_request(input), &fragment->last_vk_visibility_request);
    decltype(Traits::ime_text_spans_info(input)) in_ime_text_spans_info = Traits::ime_text_spans_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ime_text_spans_info)::BaseType>
        ime_text_spans_info_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_info_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanInfoDataView>>(
        in_ime_text_spans_info, ime_text_spans_info_fragment, &ime_text_spans_info_validate_params);
    fragment->ime_text_spans_info.Set(
        ime_text_spans_info_fragment.is_null() ? nullptr : ime_text_spans_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->ime_text_spans_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ime_text_spans_info in TextInputState struct");
  }

  static bool Deserialize(::ui::mojom::internal::TextInputState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::TextInputStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ui::mojom {

inline void ImeTextSpanInfoDataView::GetSpanDataView(
    ::ui::mojom::ImeTextSpanDataView* output) {
  auto pointer = data_->span.Get();
  *output = ::ui::mojom::ImeTextSpanDataView(pointer, message_);
}
inline void ImeTextSpanInfoDataView::GetBoundsDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->bounds.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}


inline void TextInputStateDataView::GetValueDataView(
    ::mojo_base::mojom::BigString16DataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::BigString16DataView(pointer, message_);
}
inline void TextInputStateDataView::GetSelectionDataView(
    ::gfx::mojom::RangeDataView* output) {
  auto pointer = data_->selection.Get();
  *output = ::gfx::mojom::RangeDataView(pointer, message_);
}
inline void TextInputStateDataView::GetCompositionDataView(
    ::gfx::mojom::RangeDataView* output) {
  auto pointer = data_->composition.Get();
  *output = ::gfx::mojom::RangeDataView(pointer, message_);
}
inline void TextInputStateDataView::GetEditContextControlBoundsDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->edit_context_control_bounds.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void TextInputStateDataView::GetEditContextSelectionBoundsDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->edit_context_selection_bounds.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void TextInputStateDataView::GetImeTextSpansInfoDataView(
    mojo::ArrayDataView<ImeTextSpanInfoDataView>* output) {
  auto pointer = data_->ime_text_spans_info.Get();
  *output = mojo::ArrayDataView<ImeTextSpanInfoDataView>(pointer, message_);
}



}  // ui::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_SHARED_H_