use core::fmt::{self, Debug, Display, Formatter};
use core::str::FromStr;

use crate::timezone_impl::{TimeSpans, FixedTimespanSet, FixedTimespan};

/// TimeZones built at compile time from the tz database
///
/// This implements [`chrono::TimeZone`] so that it may be used in and to
/// construct chrono's DateTime type. See the root module documentation
/// for details.
#[derive(Clone, Copy, PartialEq, Eq, Hash)]
#[cfg_attr(feature = "arbitrary", derive(arbitrary::Arbitrary))]
pub enum Tz {
    /// Africa/Abidjan
    Africa__Abidjan,
    /// Africa/Accra
    Africa__Accra,
    /// Africa/Addis_Ababa
    Africa__Addis_Ababa,
    /// Africa/Algiers
    Africa__Algiers,
    /// Africa/Asmara
    Africa__Asmara,
    /// Africa/Asmera
    Africa__Asmera,
    /// Africa/Bamako
    Africa__Bamako,
    /// Africa/Bangui
    Africa__Bangui,
    /// Africa/Banjul
    Africa__Banjul,
    /// Africa/Bissau
    Africa__Bissau,
    /// Africa/Blantyre
    Africa__Blantyre,
    /// Africa/Brazzaville
    Africa__Brazzaville,
    /// Africa/Bujumbura
    Africa__Bujumbura,
    /// Africa/Cairo
    Africa__Cairo,
    /// Africa/Casablanca
    Africa__Casablanca,
    /// Africa/Ceuta
    Africa__Ceuta,
    /// Africa/Conakry
    Africa__Conakry,
    /// Africa/Dakar
    Africa__Dakar,
    /// Africa/Dar_es_Salaam
    Africa__Dar_es_Salaam,
    /// Africa/Djibouti
    Africa__Djibouti,
    /// Africa/Douala
    Africa__Douala,
    /// Africa/El_Aaiun
    Africa__El_Aaiun,
    /// Africa/Freetown
    Africa__Freetown,
    /// Africa/Gaborone
    Africa__Gaborone,
    /// Africa/Harare
    Africa__Harare,
    /// Africa/Johannesburg
    Africa__Johannesburg,
    /// Africa/Juba
    Africa__Juba,
    /// Africa/Kampala
    Africa__Kampala,
    /// Africa/Khartoum
    Africa__Khartoum,
    /// Africa/Kigali
    Africa__Kigali,
    /// Africa/Kinshasa
    Africa__Kinshasa,
    /// Africa/Lagos
    Africa__Lagos,
    /// Africa/Libreville
    Africa__Libreville,
    /// Africa/Lome
    Africa__Lome,
    /// Africa/Luanda
    Africa__Luanda,
    /// Africa/Lubumbashi
    Africa__Lubumbashi,
    /// Africa/Lusaka
    Africa__Lusaka,
    /// Africa/Malabo
    Africa__Malabo,
    /// Africa/Maputo
    Africa__Maputo,
    /// Africa/Maseru
    Africa__Maseru,
    /// Africa/Mbabane
    Africa__Mbabane,
    /// Africa/Mogadishu
    Africa__Mogadishu,
    /// Africa/Monrovia
    Africa__Monrovia,
    /// Africa/Nairobi
    Africa__Nairobi,
    /// Africa/Ndjamena
    Africa__Ndjamena,
    /// Africa/Niamey
    Africa__Niamey,
    /// Africa/Nouakchott
    Africa__Nouakchott,
    /// Africa/Ouagadougou
    Africa__Ouagadougou,
    /// Africa/Porto-Novo
    Africa__PortoNovo,
    /// Africa/Sao_Tome
    Africa__Sao_Tome,
    /// Africa/Timbuktu
    Africa__Timbuktu,
    /// Africa/Tripoli
    Africa__Tripoli,
    /// Africa/Tunis
    Africa__Tunis,
    /// Africa/Windhoek
    Africa__Windhoek,
    /// America/Adak
    America__Adak,
    /// America/Anchorage
    America__Anchorage,
    /// America/Anguilla
    America__Anguilla,
    /// America/Antigua
    America__Antigua,
    /// America/Araguaina
    America__Araguaina,
    /// America/Argentina/Buenos_Aires
    America__Argentina__Buenos_Aires,
    /// America/Argentina/Catamarca
    America__Argentina__Catamarca,
    /// America/Argentina/ComodRivadavia
    America__Argentina__ComodRivadavia,
    /// America/Argentina/Cordoba
    America__Argentina__Cordoba,
    /// America/Argentina/Jujuy
    America__Argentina__Jujuy,
    /// America/Argentina/La_Rioja
    America__Argentina__La_Rioja,
    /// America/Argentina/Mendoza
    America__Argentina__Mendoza,
    /// America/Argentina/Rio_Gallegos
    America__Argentina__Rio_Gallegos,
    /// America/Argentina/Salta
    America__Argentina__Salta,
    /// America/Argentina/San_Juan
    America__Argentina__San_Juan,
    /// America/Argentina/San_Luis
    America__Argentina__San_Luis,
    /// America/Argentina/Tucuman
    America__Argentina__Tucuman,
    /// America/Argentina/Ushuaia
    America__Argentina__Ushuaia,
    /// America/Aruba
    America__Aruba,
    /// America/Asuncion
    America__Asuncion,
    /// America/Atikokan
    America__Atikokan,
    /// America/Atka
    America__Atka,
    /// America/Bahia
    America__Bahia,
    /// America/Bahia_Banderas
    America__Bahia_Banderas,
    /// America/Barbados
    America__Barbados,
    /// America/Belem
    America__Belem,
    /// America/Belize
    America__Belize,
    /// America/Blanc-Sablon
    America__BlancSablon,
    /// America/Boa_Vista
    America__Boa_Vista,
    /// America/Bogota
    America__Bogota,
    /// America/Boise
    America__Boise,
    /// America/Buenos_Aires
    America__Buenos_Aires,
    /// America/Cambridge_Bay
    America__Cambridge_Bay,
    /// America/Campo_Grande
    America__Campo_Grande,
    /// America/Cancun
    America__Cancun,
    /// America/Caracas
    America__Caracas,
    /// America/Catamarca
    America__Catamarca,
    /// America/Cayenne
    America__Cayenne,
    /// America/Cayman
    America__Cayman,
    /// America/Chicago
    America__Chicago,
    /// America/Chihuahua
    America__Chihuahua,
    /// America/Ciudad_Juarez
    America__Ciudad_Juarez,
    /// America/Coral_Harbour
    America__Coral_Harbour,
    /// America/Cordoba
    America__Cordoba,
    /// America/Costa_Rica
    America__Costa_Rica,
    /// America/Creston
    America__Creston,
    /// America/Cuiaba
    America__Cuiaba,
    /// America/Curacao
    America__Curacao,
    /// America/Danmarkshavn
    America__Danmarkshavn,
    /// America/Dawson
    America__Dawson,
    /// America/Dawson_Creek
    America__Dawson_Creek,
    /// America/Denver
    America__Denver,
    /// America/Detroit
    America__Detroit,
    /// America/Dominica
    America__Dominica,
    /// America/Edmonton
    America__Edmonton,
    /// America/Eirunepe
    America__Eirunepe,
    /// America/El_Salvador
    America__El_Salvador,
    /// America/Ensenada
    America__Ensenada,
    /// America/Fort_Nelson
    America__Fort_Nelson,
    /// America/Fort_Wayne
    America__Fort_Wayne,
    /// America/Fortaleza
    America__Fortaleza,
    /// America/Glace_Bay
    America__Glace_Bay,
    /// America/Godthab
    America__Godthab,
    /// America/Goose_Bay
    America__Goose_Bay,
    /// America/Grand_Turk
    America__Grand_Turk,
    /// America/Grenada
    America__Grenada,
    /// America/Guadeloupe
    America__Guadeloupe,
    /// America/Guatemala
    America__Guatemala,
    /// America/Guayaquil
    America__Guayaquil,
    /// America/Guyana
    America__Guyana,
    /// America/Halifax
    America__Halifax,
    /// America/Havana
    America__Havana,
    /// America/Hermosillo
    America__Hermosillo,
    /// America/Indiana/Indianapolis
    America__Indiana__Indianapolis,
    /// America/Indiana/Knox
    America__Indiana__Knox,
    /// America/Indiana/Marengo
    America__Indiana__Marengo,
    /// America/Indiana/Petersburg
    America__Indiana__Petersburg,
    /// America/Indiana/Tell_City
    America__Indiana__Tell_City,
    /// America/Indiana/Vevay
    America__Indiana__Vevay,
    /// America/Indiana/Vincennes
    America__Indiana__Vincennes,
    /// America/Indiana/Winamac
    America__Indiana__Winamac,
    /// America/Indianapolis
    America__Indianapolis,
    /// America/Inuvik
    America__Inuvik,
    /// America/Iqaluit
    America__Iqaluit,
    /// America/Jamaica
    America__Jamaica,
    /// America/Jujuy
    America__Jujuy,
    /// America/Juneau
    America__Juneau,
    /// America/Kentucky/Louisville
    America__Kentucky__Louisville,
    /// America/Kentucky/Monticello
    America__Kentucky__Monticello,
    /// America/Knox_IN
    America__Knox_IN,
    /// America/Kralendijk
    America__Kralendijk,
    /// America/La_Paz
    America__La_Paz,
    /// America/Lima
    America__Lima,
    /// America/Los_Angeles
    America__Los_Angeles,
    /// America/Louisville
    America__Louisville,
    /// America/Lower_Princes
    America__Lower_Princes,
    /// America/Maceio
    America__Maceio,
    /// America/Managua
    America__Managua,
    /// America/Manaus
    America__Manaus,
    /// America/Marigot
    America__Marigot,
    /// America/Martinique
    America__Martinique,
    /// America/Matamoros
    America__Matamoros,
    /// America/Mazatlan
    America__Mazatlan,
    /// America/Mendoza
    America__Mendoza,
    /// America/Menominee
    America__Menominee,
    /// America/Merida
    America__Merida,
    /// America/Metlakatla
    America__Metlakatla,
    /// America/Mexico_City
    America__Mexico_City,
    /// America/Miquelon
    America__Miquelon,
    /// America/Moncton
    America__Moncton,
    /// America/Monterrey
    America__Monterrey,
    /// America/Montevideo
    America__Montevideo,
    /// America/Montreal
    America__Montreal,
    /// America/Montserrat
    America__Montserrat,
    /// America/Nassau
    America__Nassau,
    /// America/New_York
    America__New_York,
    /// America/Nipigon
    America__Nipigon,
    /// America/Nome
    America__Nome,
    /// America/Noronha
    America__Noronha,
    /// America/North_Dakota/Beulah
    America__North_Dakota__Beulah,
    /// America/North_Dakota/Center
    America__North_Dakota__Center,
    /// America/North_Dakota/New_Salem
    America__North_Dakota__New_Salem,
    /// America/Nuuk
    America__Nuuk,
    /// America/Ojinaga
    America__Ojinaga,
    /// America/Panama
    America__Panama,
    /// America/Pangnirtung
    America__Pangnirtung,
    /// America/Paramaribo
    America__Paramaribo,
    /// America/Phoenix
    America__Phoenix,
    /// America/Port-au-Prince
    America__PortauPrince,
    /// America/Port_of_Spain
    America__Port_of_Spain,
    /// America/Porto_Acre
    America__Porto_Acre,
    /// America/Porto_Velho
    America__Porto_Velho,
    /// America/Puerto_Rico
    America__Puerto_Rico,
    /// America/Punta_Arenas
    America__Punta_Arenas,
    /// America/Rainy_River
    America__Rainy_River,
    /// America/Rankin_Inlet
    America__Rankin_Inlet,
    /// America/Recife
    America__Recife,
    /// America/Regina
    America__Regina,
    /// America/Resolute
    America__Resolute,
    /// America/Rio_Branco
    America__Rio_Branco,
    /// America/Rosario
    America__Rosario,
    /// America/Santa_Isabel
    America__Santa_Isabel,
    /// America/Santarem
    America__Santarem,
    /// America/Santiago
    America__Santiago,
    /// America/Santo_Domingo
    America__Santo_Domingo,
    /// America/Sao_Paulo
    America__Sao_Paulo,
    /// America/Scoresbysund
    America__Scoresbysund,
    /// America/Shiprock
    America__Shiprock,
    /// America/Sitka
    America__Sitka,
    /// America/St_Barthelemy
    America__St_Barthelemy,
    /// America/St_Johns
    America__St_Johns,
    /// America/St_Kitts
    America__St_Kitts,
    /// America/St_Lucia
    America__St_Lucia,
    /// America/St_Thomas
    America__St_Thomas,
    /// America/St_Vincent
    America__St_Vincent,
    /// America/Swift_Current
    America__Swift_Current,
    /// America/Tegucigalpa
    America__Tegucigalpa,
    /// America/Thule
    America__Thule,
    /// America/Thunder_Bay
    America__Thunder_Bay,
    /// America/Tijuana
    America__Tijuana,
    /// America/Toronto
    America__Toronto,
    /// America/Tortola
    America__Tortola,
    /// America/Vancouver
    America__Vancouver,
    /// America/Virgin
    America__Virgin,
    /// America/Whitehorse
    America__Whitehorse,
    /// America/Winnipeg
    America__Winnipeg,
    /// America/Yakutat
    America__Yakutat,
    /// America/Yellowknife
    America__Yellowknife,
    /// Antarctica/Casey
    Antarctica__Casey,
    /// Antarctica/Davis
    Antarctica__Davis,
    /// Antarctica/DumontDUrville
    Antarctica__DumontDUrville,
    /// Antarctica/Macquarie
    Antarctica__Macquarie,
    /// Antarctica/Mawson
    Antarctica__Mawson,
    /// Antarctica/McMurdo
    Antarctica__McMurdo,
    /// Antarctica/Palmer
    Antarctica__Palmer,
    /// Antarctica/Rothera
    Antarctica__Rothera,
    /// Antarctica/South_Pole
    Antarctica__South_Pole,
    /// Antarctica/Syowa
    Antarctica__Syowa,
    /// Antarctica/Troll
    Antarctica__Troll,
    /// Antarctica/Vostok
    Antarctica__Vostok,
    /// Arctic/Longyearbyen
    Arctic__Longyearbyen,
    /// Asia/Aden
    Asia__Aden,
    /// Asia/Almaty
    Asia__Almaty,
    /// Asia/Amman
    Asia__Amman,
    /// Asia/Anadyr
    Asia__Anadyr,
    /// Asia/Aqtau
    Asia__Aqtau,
    /// Asia/Aqtobe
    Asia__Aqtobe,
    /// Asia/Ashgabat
    Asia__Ashgabat,
    /// Asia/Ashkhabad
    Asia__Ashkhabad,
    /// Asia/Atyrau
    Asia__Atyrau,
    /// Asia/Baghdad
    Asia__Baghdad,
    /// Asia/Bahrain
    Asia__Bahrain,
    /// Asia/Baku
    Asia__Baku,
    /// Asia/Bangkok
    Asia__Bangkok,
    /// Asia/Barnaul
    Asia__Barnaul,
    /// Asia/Beirut
    Asia__Beirut,
    /// Asia/Bishkek
    Asia__Bishkek,
    /// Asia/Brunei
    Asia__Brunei,
    /// Asia/Calcutta
    Asia__Calcutta,
    /// Asia/Chita
    Asia__Chita,
    /// Asia/Choibalsan
    Asia__Choibalsan,
    /// Asia/Chongqing
    Asia__Chongqing,
    /// Asia/Chungking
    Asia__Chungking,
    /// Asia/Colombo
    Asia__Colombo,
    /// Asia/Dacca
    Asia__Dacca,
    /// Asia/Damascus
    Asia__Damascus,
    /// Asia/Dhaka
    Asia__Dhaka,
    /// Asia/Dili
    Asia__Dili,
    /// Asia/Dubai
    Asia__Dubai,
    /// Asia/Dushanbe
    Asia__Dushanbe,
    /// Asia/Famagusta
    Asia__Famagusta,
    /// Asia/Gaza
    Asia__Gaza,
    /// Asia/Harbin
    Asia__Harbin,
    /// Asia/Hebron
    Asia__Hebron,
    /// Asia/Ho_Chi_Minh
    Asia__Ho_Chi_Minh,
    /// Asia/Hong_Kong
    Asia__Hong_Kong,
    /// Asia/Hovd
    Asia__Hovd,
    /// Asia/Irkutsk
    Asia__Irkutsk,
    /// Asia/Istanbul
    Asia__Istanbul,
    /// Asia/Jakarta
    Asia__Jakarta,
    /// Asia/Jayapura
    Asia__Jayapura,
    /// Asia/Jerusalem
    Asia__Jerusalem,
    /// Asia/Kabul
    Asia__Kabul,
    /// Asia/Kamchatka
    Asia__Kamchatka,
    /// Asia/Karachi
    Asia__Karachi,
    /// Asia/Kashgar
    Asia__Kashgar,
    /// Asia/Kathmandu
    Asia__Kathmandu,
    /// Asia/Katmandu
    Asia__Katmandu,
    /// Asia/Khandyga
    Asia__Khandyga,
    /// Asia/Kolkata
    Asia__Kolkata,
    /// Asia/Krasnoyarsk
    Asia__Krasnoyarsk,
    /// Asia/Kuala_Lumpur
    Asia__Kuala_Lumpur,
    /// Asia/Kuching
    Asia__Kuching,
    /// Asia/Kuwait
    Asia__Kuwait,
    /// Asia/Macao
    Asia__Macao,
    /// Asia/Macau
    Asia__Macau,
    /// Asia/Magadan
    Asia__Magadan,
    /// Asia/Makassar
    Asia__Makassar,
    /// Asia/Manila
    Asia__Manila,
    /// Asia/Muscat
    Asia__Muscat,
    /// Asia/Nicosia
    Asia__Nicosia,
    /// Asia/Novokuznetsk
    Asia__Novokuznetsk,
    /// Asia/Novosibirsk
    Asia__Novosibirsk,
    /// Asia/Omsk
    Asia__Omsk,
    /// Asia/Oral
    Asia__Oral,
    /// Asia/Phnom_Penh
    Asia__Phnom_Penh,
    /// Asia/Pontianak
    Asia__Pontianak,
    /// Asia/Pyongyang
    Asia__Pyongyang,
    /// Asia/Qatar
    Asia__Qatar,
    /// Asia/Qostanay
    Asia__Qostanay,
    /// Asia/Qyzylorda
    Asia__Qyzylorda,
    /// Asia/Rangoon
    Asia__Rangoon,
    /// Asia/Riyadh
    Asia__Riyadh,
    /// Asia/Saigon
    Asia__Saigon,
    /// Asia/Sakhalin
    Asia__Sakhalin,
    /// Asia/Samarkand
    Asia__Samarkand,
    /// Asia/Seoul
    Asia__Seoul,
    /// Asia/Shanghai
    Asia__Shanghai,
    /// Asia/Singapore
    Asia__Singapore,
    /// Asia/Srednekolymsk
    Asia__Srednekolymsk,
    /// Asia/Taipei
    Asia__Taipei,
    /// Asia/Tashkent
    Asia__Tashkent,
    /// Asia/Tbilisi
    Asia__Tbilisi,
    /// Asia/Tehran
    Asia__Tehran,
    /// Asia/Tel_Aviv
    Asia__Tel_Aviv,
    /// Asia/Thimbu
    Asia__Thimbu,
    /// Asia/Thimphu
    Asia__Thimphu,
    /// Asia/Tokyo
    Asia__Tokyo,
    /// Asia/Tomsk
    Asia__Tomsk,
    /// Asia/Ujung_Pandang
    Asia__Ujung_Pandang,
    /// Asia/Ulaanbaatar
    Asia__Ulaanbaatar,
    /// Asia/Ulan_Bator
    Asia__Ulan_Bator,
    /// Asia/Urumqi
    Asia__Urumqi,
    /// Asia/Ust-Nera
    Asia__UstNera,
    /// Asia/Vientiane
    Asia__Vientiane,
    /// Asia/Vladivostok
    Asia__Vladivostok,
    /// Asia/Yakutsk
    Asia__Yakutsk,
    /// Asia/Yangon
    Asia__Yangon,
    /// Asia/Yekaterinburg
    Asia__Yekaterinburg,
    /// Asia/Yerevan
    Asia__Yerevan,
    /// Atlantic/Azores
    Atlantic__Azores,
    /// Atlantic/Bermuda
    Atlantic__Bermuda,
    /// Atlantic/Canary
    Atlantic__Canary,
    /// Atlantic/Cape_Verde
    Atlantic__Cape_Verde,
    /// Atlantic/Faeroe
    Atlantic__Faeroe,
    /// Atlantic/Faroe
    Atlantic__Faroe,
    /// Atlantic/Jan_Mayen
    Atlantic__Jan_Mayen,
    /// Atlantic/Madeira
    Atlantic__Madeira,
    /// Atlantic/Reykjavik
    Atlantic__Reykjavik,
    /// Atlantic/South_Georgia
    Atlantic__South_Georgia,
    /// Atlantic/St_Helena
    Atlantic__St_Helena,
    /// Atlantic/Stanley
    Atlantic__Stanley,
    /// Australia/ACT
    Australia__ACT,
    /// Australia/Adelaide
    Australia__Adelaide,
    /// Australia/Brisbane
    Australia__Brisbane,
    /// Australia/Broken_Hill
    Australia__Broken_Hill,
    /// Australia/Canberra
    Australia__Canberra,
    /// Australia/Currie
    Australia__Currie,
    /// Australia/Darwin
    Australia__Darwin,
    /// Australia/Eucla
    Australia__Eucla,
    /// Australia/Hobart
    Australia__Hobart,
    /// Australia/LHI
    Australia__LHI,
    /// Australia/Lindeman
    Australia__Lindeman,
    /// Australia/Lord_Howe
    Australia__Lord_Howe,
    /// Australia/Melbourne
    Australia__Melbourne,
    /// Australia/NSW
    Australia__NSW,
    /// Australia/North
    Australia__North,
    /// Australia/Perth
    Australia__Perth,
    /// Australia/Queensland
    Australia__Queensland,
    /// Australia/South
    Australia__South,
    /// Australia/Sydney
    Australia__Sydney,
    /// Australia/Tasmania
    Australia__Tasmania,
    /// Australia/Victoria
    Australia__Victoria,
    /// Australia/West
    Australia__West,
    /// Australia/Yancowinna
    Australia__Yancowinna,
    /// Brazil/Acre
    Brazil__Acre,
    /// Brazil/DeNoronha
    Brazil__DeNoronha,
    /// Brazil/East
    Brazil__East,
    /// Brazil/West
    Brazil__West,
    /// CET
    CET,
    /// CST6CDT
    CST6CDT,
    /// Canada/Atlantic
    Canada__Atlantic,
    /// Canada/Central
    Canada__Central,
    /// Canada/Eastern
    Canada__Eastern,
    /// Canada/Mountain
    Canada__Mountain,
    /// Canada/Newfoundland
    Canada__Newfoundland,
    /// Canada/Pacific
    Canada__Pacific,
    /// Canada/Saskatchewan
    Canada__Saskatchewan,
    /// Canada/Yukon
    Canada__Yukon,
    /// Chile/Continental
    Chile__Continental,
    /// Chile/EasterIsland
    Chile__EasterIsland,
    /// Cuba
    Cuba,
    /// EET
    EET,
    /// EST
    EST,
    /// EST5EDT
    EST5EDT,
    /// Egypt
    Egypt,
    /// Eire
    Eire,
    /// Etc/GMT
    Etc__GMT,
    /// Etc/GMT+0
    Etc__GMTPlus0,
    /// Etc/GMT+1
    Etc__GMTPlus1,
    /// Etc/GMT+10
    Etc__GMTPlus10,
    /// Etc/GMT+11
    Etc__GMTPlus11,
    /// Etc/GMT+12
    Etc__GMTPlus12,
    /// Etc/GMT+2
    Etc__GMTPlus2,
    /// Etc/GMT+3
    Etc__GMTPlus3,
    /// Etc/GMT+4
    Etc__GMTPlus4,
    /// Etc/GMT+5
    Etc__GMTPlus5,
    /// Etc/GMT+6
    Etc__GMTPlus6,
    /// Etc/GMT+7
    Etc__GMTPlus7,
    /// Etc/GMT+8
    Etc__GMTPlus8,
    /// Etc/GMT+9
    Etc__GMTPlus9,
    /// Etc/GMT-0
    Etc__GMTMinus0,
    /// Etc/GMT-1
    Etc__GMTMinus1,
    /// Etc/GMT-10
    Etc__GMTMinus10,
    /// Etc/GMT-11
    Etc__GMTMinus11,
    /// Etc/GMT-12
    Etc__GMTMinus12,
    /// Etc/GMT-13
    Etc__GMTMinus13,
    /// Etc/GMT-14
    Etc__GMTMinus14,
    /// Etc/GMT-2
    Etc__GMTMinus2,
    /// Etc/GMT-3
    Etc__GMTMinus3,
    /// Etc/GMT-4
    Etc__GMTMinus4,
    /// Etc/GMT-5
    Etc__GMTMinus5,
    /// Etc/GMT-6
    Etc__GMTMinus6,
    /// Etc/GMT-7
    Etc__GMTMinus7,
    /// Etc/GMT-8
    Etc__GMTMinus8,
    /// Etc/GMT-9
    Etc__GMTMinus9,
    /// Etc/GMT0
    Etc__GMT0,
    /// Etc/Greenwich
    Etc__Greenwich,
    /// Etc/UCT
    Etc__UCT,
    /// Etc/UTC
    Etc__UTC,
    /// Etc/Universal
    Etc__Universal,
    /// Etc/Zulu
    Etc__Zulu,
    /// Europe/Amsterdam
    Europe__Amsterdam,
    /// Europe/Andorra
    Europe__Andorra,
    /// Europe/Astrakhan
    Europe__Astrakhan,
    /// Europe/Athens
    Europe__Athens,
    /// Europe/Belfast
    Europe__Belfast,
    /// Europe/Belgrade
    Europe__Belgrade,
    /// Europe/Berlin
    Europe__Berlin,
    /// Europe/Bratislava
    Europe__Bratislava,
    /// Europe/Brussels
    Europe__Brussels,
    /// Europe/Bucharest
    Europe__Bucharest,
    /// Europe/Budapest
    Europe__Budapest,
    /// Europe/Busingen
    Europe__Busingen,
    /// Europe/Chisinau
    Europe__Chisinau,
    /// Europe/Copenhagen
    Europe__Copenhagen,
    /// Europe/Dublin
    Europe__Dublin,
    /// Europe/Gibraltar
    Europe__Gibraltar,
    /// Europe/Guernsey
    Europe__Guernsey,
    /// Europe/Helsinki
    Europe__Helsinki,
    /// Europe/Isle_of_Man
    Europe__Isle_of_Man,
    /// Europe/Istanbul
    Europe__Istanbul,
    /// Europe/Jersey
    Europe__Jersey,
    /// Europe/Kaliningrad
    Europe__Kaliningrad,
    /// Europe/Kiev
    Europe__Kiev,
    /// Europe/Kirov
    Europe__Kirov,
    /// Europe/Kyiv
    Europe__Kyiv,
    /// Europe/Lisbon
    Europe__Lisbon,
    /// Europe/Ljubljana
    Europe__Ljubljana,
    /// Europe/London
    Europe__London,
    /// Europe/Luxembourg
    Europe__Luxembourg,
    /// Europe/Madrid
    Europe__Madrid,
    /// Europe/Malta
    Europe__Malta,
    /// Europe/Mariehamn
    Europe__Mariehamn,
    /// Europe/Minsk
    Europe__Minsk,
    /// Europe/Monaco
    Europe__Monaco,
    /// Europe/Moscow
    Europe__Moscow,
    /// Europe/Nicosia
    Europe__Nicosia,
    /// Europe/Oslo
    Europe__Oslo,
    /// Europe/Paris
    Europe__Paris,
    /// Europe/Podgorica
    Europe__Podgorica,
    /// Europe/Prague
    Europe__Prague,
    /// Europe/Riga
    Europe__Riga,
    /// Europe/Rome
    Europe__Rome,
    /// Europe/Samara
    Europe__Samara,
    /// Europe/San_Marino
    Europe__San_Marino,
    /// Europe/Sarajevo
    Europe__Sarajevo,
    /// Europe/Saratov
    Europe__Saratov,
    /// Europe/Simferopol
    Europe__Simferopol,
    /// Europe/Skopje
    Europe__Skopje,
    /// Europe/Sofia
    Europe__Sofia,
    /// Europe/Stockholm
    Europe__Stockholm,
    /// Europe/Tallinn
    Europe__Tallinn,
    /// Europe/Tirane
    Europe__Tirane,
    /// Europe/Tiraspol
    Europe__Tiraspol,
    /// Europe/Ulyanovsk
    Europe__Ulyanovsk,
    /// Europe/Uzhgorod
    Europe__Uzhgorod,
    /// Europe/Vaduz
    Europe__Vaduz,
    /// Europe/Vatican
    Europe__Vatican,
    /// Europe/Vienna
    Europe__Vienna,
    /// Europe/Vilnius
    Europe__Vilnius,
    /// Europe/Volgograd
    Europe__Volgograd,
    /// Europe/Warsaw
    Europe__Warsaw,
    /// Europe/Zagreb
    Europe__Zagreb,
    /// Europe/Zaporozhye
    Europe__Zaporozhye,
    /// Europe/Zurich
    Europe__Zurich,
    /// GB
    GB,
    /// GB-Eire
    GBEire,
    /// GMT
    GMT,
    /// GMT+0
    GMTPlus0,
    /// GMT-0
    GMTMinus0,
    /// GMT0
    GMT0,
    /// Greenwich
    Greenwich,
    /// HST
    HST,
    /// Hongkong
    Hongkong,
    /// Iceland
    Iceland,
    /// Indian/Antananarivo
    Indian__Antananarivo,
    /// Indian/Chagos
    Indian__Chagos,
    /// Indian/Christmas
    Indian__Christmas,
    /// Indian/Cocos
    Indian__Cocos,
    /// Indian/Comoro
    Indian__Comoro,
    /// Indian/Kerguelen
    Indian__Kerguelen,
    /// Indian/Mahe
    Indian__Mahe,
    /// Indian/Maldives
    Indian__Maldives,
    /// Indian/Mauritius
    Indian__Mauritius,
    /// Indian/Mayotte
    Indian__Mayotte,
    /// Indian/Reunion
    Indian__Reunion,
    /// Iran
    Iran,
    /// Israel
    Israel,
    /// Jamaica
    Jamaica,
    /// Japan
    Japan,
    /// Kwajalein
    Kwajalein,
    /// Libya
    Libya,
    /// MET
    MET,
    /// MST
    MST,
    /// MST7MDT
    MST7MDT,
    /// Mexico/BajaNorte
    Mexico__BajaNorte,
    /// Mexico/BajaSur
    Mexico__BajaSur,
    /// Mexico/General
    Mexico__General,
    /// NZ
    NZ,
    /// NZ-CHAT
    NZCHAT,
    /// Navajo
    Navajo,
    /// PRC
    PRC,
    /// PST8PDT
    PST8PDT,
    /// Pacific/Apia
    Pacific__Apia,
    /// Pacific/Auckland
    Pacific__Auckland,
    /// Pacific/Bougainville
    Pacific__Bougainville,
    /// Pacific/Chatham
    Pacific__Chatham,
    /// Pacific/Chuuk
    Pacific__Chuuk,
    /// Pacific/Easter
    Pacific__Easter,
    /// Pacific/Efate
    Pacific__Efate,
    /// Pacific/Enderbury
    Pacific__Enderbury,
    /// Pacific/Fakaofo
    Pacific__Fakaofo,
    /// Pacific/Fiji
    Pacific__Fiji,
    /// Pacific/Funafuti
    Pacific__Funafuti,
    /// Pacific/Galapagos
    Pacific__Galapagos,
    /// Pacific/Gambier
    Pacific__Gambier,
    /// Pacific/Guadalcanal
    Pacific__Guadalcanal,
    /// Pacific/Guam
    Pacific__Guam,
    /// Pacific/Honolulu
    Pacific__Honolulu,
    /// Pacific/Johnston
    Pacific__Johnston,
    /// Pacific/Kanton
    Pacific__Kanton,
    /// Pacific/Kiritimati
    Pacific__Kiritimati,
    /// Pacific/Kosrae
    Pacific__Kosrae,
    /// Pacific/Kwajalein
    Pacific__Kwajalein,
    /// Pacific/Majuro
    Pacific__Majuro,
    /// Pacific/Marquesas
    Pacific__Marquesas,
    /// Pacific/Midway
    Pacific__Midway,
    /// Pacific/Nauru
    Pacific__Nauru,
    /// Pacific/Niue
    Pacific__Niue,
    /// Pacific/Norfolk
    Pacific__Norfolk,
    /// Pacific/Noumea
    Pacific__Noumea,
    /// Pacific/Pago_Pago
    Pacific__Pago_Pago,
    /// Pacific/Palau
    Pacific__Palau,
    /// Pacific/Pitcairn
    Pacific__Pitcairn,
    /// Pacific/Pohnpei
    Pacific__Pohnpei,
    /// Pacific/Ponape
    Pacific__Ponape,
    /// Pacific/Port_Moresby
    Pacific__Port_Moresby,
    /// Pacific/Rarotonga
    Pacific__Rarotonga,
    /// Pacific/Saipan
    Pacific__Saipan,
    /// Pacific/Samoa
    Pacific__Samoa,
    /// Pacific/Tahiti
    Pacific__Tahiti,
    /// Pacific/Tarawa
    Pacific__Tarawa,
    /// Pacific/Tongatapu
    Pacific__Tongatapu,
    /// Pacific/Truk
    Pacific__Truk,
    /// Pacific/Wake
    Pacific__Wake,
    /// Pacific/Wallis
    Pacific__Wallis,
    /// Pacific/Yap
    Pacific__Yap,
    /// Poland
    Poland,
    /// Portugal
    Portugal,
    /// ROC
    ROC,
    /// ROK
    ROK,
    /// Singapore
    Singapore,
    /// Turkey
    Turkey,
    /// UCT
    UCT,
    /// US/Alaska
    US__Alaska,
    /// US/Aleutian
    US__Aleutian,
    /// US/Arizona
    US__Arizona,
    /// US/Central
    US__Central,
    /// US/East-Indiana
    US__EastIndiana,
    /// US/Eastern
    US__Eastern,
    /// US/Hawaii
    US__Hawaii,
    /// US/Indiana-Starke
    US__IndianaStarke,
    /// US/Michigan
    US__Michigan,
    /// US/Mountain
    US__Mountain,
    /// US/Pacific
    US__Pacific,
    /// US/Samoa
    US__Samoa,
    /// UTC
    UTC,
    /// Universal
    Universal,
    /// W-SU
    WSU,
    /// WET
    WET,
    /// Zulu
    Zulu,
}
static TIMEZONES: ::phf::Map<&'static str, Tz> = 
::phf::Map {
    key: 12913932095322966823,
    disps: &[
        (0, 42),
        (0, 6),
        (0, 0),
        (0, 53),
        (1, 24),
        (0, 0),
        (0, 451),
        (0, 16),
        (0, 0),
        (0, 28),
        (0, 576),
        (0, 13),
        (0, 41),
        (0, 269),
        (0, 0),
        (0, 15),
        (0, 545),
        (0, 1),
        (0, 99),
        (0, 5),
        (0, 93),
        (0, 32),
        (0, 14),
        (0, 0),
        (0, 260),
        (0, 10),
        (0, 7),
        (0, 156),
        (0, 1),
        (5, 192),
        (1, 183),
        (0, 23),
        (0, 53),
        (0, 95),
        (0, 236),
        (0, 27),
        (0, 60),
        (0, 383),
        (0, 2),
        (0, 0),
        (0, 111),
        (0, 4),
        (0, 215),
        (0, 54),
        (0, 2),
        (0, 1),
        (0, 22),
        (1, 438),
        (0, 248),
        (1, 187),
        (0, 9),
        (0, 3),
        (0, 32),
        (0, 50),
        (2, 123),
        (0, 42),
        (1, 20),
        (0, 1),
        (6, 551),
        (0, 128),
        (1, 111),
        (0, 553),
        (0, 0),
        (0, 0),
        (0, 231),
        (0, 25),
        (0, 127),
        (0, 95),
        (0, 512),
        (8, 167),
        (4, 54),
        (0, 20),
        (0, 191),
        (13, 23),
        (1, 32),
        (0, 478),
        (0, 256),
        (0, 12),
        (0, 40),
        (0, 432),
        (0, 499),
        (0, 2),
        (0, 100),
        (0, 25),
        (5, 124),
        (0, 258),
        (0, 255),
        (0, 467),
        (0, 154),
        (0, 450),
        (0, 528),
        (0, 105),
        (0, 8),
        (1, 439),
        (0, 12),
        (19, 343),
        (0, 0),
        (2, 411),
        (0, 95),
        (36, 54),
        (0, 115),
        (0, 184),
        (1, 406),
        (1, 417),
        (0, 0),
        (0, 337),
        (7, 360),
        (1, 518),
        (6, 41),
        (1, 1),
        (0, 494),
        (0, 33),
        (0, 0),
        (10, 249),
        (6, 381),
        (0, 458),
        (2, 235),
        (12, 336),
        (19, 503),
        (0, 180),
    ],
    entries: &[
        ("America/Guyana", Tz::America__Guyana),
        ("Asia/Krasnoyarsk", Tz::Asia__Krasnoyarsk),
        ("America/Merida", Tz::America__Merida),
        ("Asia/Tel_Aviv", Tz::Asia__Tel_Aviv),
        ("America/Tortola", Tz::America__Tortola),
        ("America/Santarem", Tz::America__Santarem),
        ("Australia/Brisbane", Tz::Australia__Brisbane),
        ("America/Caracas", Tz::America__Caracas),
        ("America/Nassau", Tz::America__Nassau),
        ("America/Chicago", Tz::America__Chicago),
        ("America/Hermosillo", Tz::America__Hermosillo),
        ("Africa/Asmara", Tz::Africa__Asmara),
        ("America/Godthab", Tz::America__Godthab),
        ("Europe/Vatican", Tz::Europe__Vatican),
        ("NZ-CHAT", Tz::NZCHAT),
        ("Pacific/Kosrae", Tz::Pacific__Kosrae),
        ("America/Montreal", Tz::America__Montreal),
        ("America/Dominica", Tz::America__Dominica),
        ("Australia/Sydney", Tz::Australia__Sydney),
        ("US/East-Indiana", Tz::US__EastIndiana),
        ("America/Catamarca", Tz::America__Catamarca),
        ("Pacific/Wallis", Tz::Pacific__Wallis),
        ("NZ", Tz::NZ),
        ("Asia/Damascus", Tz::Asia__Damascus),
        ("Asia/Manila", Tz::Asia__Manila),
        ("America/Noronha", Tz::America__Noronha),
        ("Europe/Zagreb", Tz::Europe__Zagreb),
        ("Europe/Mariehamn", Tz::Europe__Mariehamn),
        ("UCT", Tz::UCT),
        ("Europe/Busingen", Tz::Europe__Busingen),
        ("Canada/Mountain", Tz::Canada__Mountain),
        ("Arctic/Longyearbyen", Tz::Arctic__Longyearbyen),
        ("America/Bogota", Tz::America__Bogota),
        ("Europe/Belgrade", Tz::Europe__Belgrade),
        ("US/Alaska", Tz::US__Alaska),
        ("Asia/Pyongyang", Tz::Asia__Pyongyang),
        ("America/Campo_Grande", Tz::America__Campo_Grande),
        ("MET", Tz::MET),
        ("Asia/Sakhalin", Tz::Asia__Sakhalin),
        ("Etc/GMT-3", Tz::Etc__GMTMinus3),
        ("Pacific/Ponape", Tz::Pacific__Ponape),
        ("Cuba", Tz::Cuba),
        ("America/Ojinaga", Tz::America__Ojinaga),
        ("Asia/Tehran", Tz::Asia__Tehran),
        ("America/Tegucigalpa", Tz::America__Tegucigalpa),
        ("Pacific/Honolulu", Tz::Pacific__Honolulu),
        ("America/Aruba", Tz::America__Aruba),
        ("America/Rio_Branco", Tz::America__Rio_Branco),
        ("America/Guayaquil", Tz::America__Guayaquil),
        ("Etc/Zulu", Tz::Etc__Zulu),
        ("Europe/Monaco", Tz::Europe__Monaco),
        ("Africa/Kinshasa", Tz::Africa__Kinshasa),
        ("America/St_Kitts", Tz::America__St_Kitts),
        ("Asia/Yekaterinburg", Tz::Asia__Yekaterinburg),
        ("Africa/Freetown", Tz::Africa__Freetown),
        ("Africa/El_Aaiun", Tz::Africa__El_Aaiun),
        ("America/Anguilla", Tz::America__Anguilla),
        ("Africa/Abidjan", Tz::Africa__Abidjan),
        ("Singapore", Tz::Singapore),
        ("GMT-0", Tz::GMTMinus0),
        ("America/Blanc-Sablon", Tz::America__BlancSablon),
        ("PST8PDT", Tz::PST8PDT),
        ("Pacific/Efate", Tz::Pacific__Efate),
        ("America/Indiana/Vincennes", Tz::America__Indiana__Vincennes),
        ("Europe/Jersey", Tz::Europe__Jersey),
        ("America/Lower_Princes", Tz::America__Lower_Princes),
        ("Africa/Sao_Tome", Tz::Africa__Sao_Tome),
        ("Asia/Irkutsk", Tz::Asia__Irkutsk),
        ("Europe/Chisinau", Tz::Europe__Chisinau),
        ("Asia/Taipei", Tz::Asia__Taipei),
        ("America/Indiana/Winamac", Tz::America__Indiana__Winamac),
        ("Africa/Blantyre", Tz::Africa__Blantyre),
        ("America/Swift_Current", Tz::America__Swift_Current),
        ("America/Boa_Vista", Tz::America__Boa_Vista),
        ("Africa/Brazzaville", Tz::Africa__Brazzaville),
        ("Antarctica/Rothera", Tz::Antarctica__Rothera),
        ("Asia/Macau", Tz::Asia__Macau),
        ("Etc/GMT-14", Tz::Etc__GMTMinus14),
        ("Australia/Tasmania", Tz::Australia__Tasmania),
        ("Pacific/Wake", Tz::Pacific__Wake),
        ("Asia/Seoul", Tz::Asia__Seoul),
        ("Turkey", Tz::Turkey),
        ("Asia/Tokyo", Tz::Asia__Tokyo),
        ("America/Recife", Tz::America__Recife),
        ("Atlantic/Madeira", Tz::Atlantic__Madeira),
        ("America/Paramaribo", Tz::America__Paramaribo),
        ("Etc/GMT0", Tz::Etc__GMT0),
        ("Asia/Srednekolymsk", Tz::Asia__Srednekolymsk),
        ("America/Mendoza", Tz::America__Mendoza),
        ("America/St_Johns", Tz::America__St_Johns),
        ("Europe/Podgorica", Tz::Europe__Podgorica),
        ("America/La_Paz", Tz::America__La_Paz),
        ("Asia/Ujung_Pandang", Tz::Asia__Ujung_Pandang),
        ("Indian/Cocos", Tz::Indian__Cocos),
        ("Asia/Brunei", Tz::Asia__Brunei),
        ("Asia/Oral", Tz::Asia__Oral),
        ("Europe/Vaduz", Tz::Europe__Vaduz),
        ("America/Argentina/San_Juan", Tz::America__Argentina__San_Juan),
        ("America/Lima", Tz::America__Lima),
        ("America/Porto_Velho", Tz::America__Porto_Velho),
        ("Etc/GMT-6", Tz::Etc__GMTMinus6),
        ("America/Belize", Tz::America__Belize),
        ("Australia/Victoria", Tz::Australia__Victoria),
        ("Pacific/Enderbury", Tz::Pacific__Enderbury),
        ("Europe/Minsk", Tz::Europe__Minsk),
        ("Asia/Aden", Tz::Asia__Aden),
        ("Asia/Yakutsk", Tz::Asia__Yakutsk),
        ("Europe/Sofia", Tz::Europe__Sofia),
        ("Africa/Nouakchott", Tz::Africa__Nouakchott),
        ("America/Detroit", Tz::America__Detroit),
        ("Europe/Paris", Tz::Europe__Paris),
        ("Etc/GMT+2", Tz::Etc__GMTPlus2),
        ("America/Manaus", Tz::America__Manaus),
        ("Europe/Isle_of_Man", Tz::Europe__Isle_of_Man),
        ("Australia/ACT", Tz::Australia__ACT),
        ("Atlantic/South_Georgia", Tz::Atlantic__South_Georgia),
        ("Etc/GMT+8", Tz::Etc__GMTPlus8),
        ("America/Havana", Tz::America__Havana),
        ("Asia/Istanbul", Tz::Asia__Istanbul),
        ("Etc/GMT+3", Tz::Etc__GMTPlus3),
        ("Pacific/Pohnpei", Tz::Pacific__Pohnpei),
        ("America/Argentina/Salta", Tz::America__Argentina__Salta),
        ("Pacific/Bougainville", Tz::Pacific__Bougainville),
        ("America/Coral_Harbour", Tz::America__Coral_Harbour),
        ("America/Bahia", Tz::America__Bahia),
        ("Pacific/Fakaofo", Tz::Pacific__Fakaofo),
        ("Africa/Asmera", Tz::Africa__Asmera),
        ("Asia/Baghdad", Tz::Asia__Baghdad),
        ("America/Boise", Tz::America__Boise),
        ("Antarctica/McMurdo", Tz::Antarctica__McMurdo),
        ("Pacific/Kiritimati", Tz::Pacific__Kiritimati),
        ("Africa/Accra", Tz::Africa__Accra),
        ("Europe/Malta", Tz::Europe__Malta),
        ("Etc/GMT-12", Tz::Etc__GMTMinus12),
        ("Mexico/BajaSur", Tz::Mexico__BajaSur),
        ("Asia/Bangkok", Tz::Asia__Bangkok),
        ("Indian/Chagos", Tz::Indian__Chagos),
        ("Etc/Greenwich", Tz::Etc__Greenwich),
        ("America/Fort_Wayne", Tz::America__Fort_Wayne),
        ("Pacific/Kwajalein", Tz::Pacific__Kwajalein),
        ("Europe/Lisbon", Tz::Europe__Lisbon),
        ("America/Regina", Tz::America__Regina),
        ("America/Marigot", Tz::America__Marigot),
        ("Etc/GMT+7", Tz::Etc__GMTPlus7),
        ("America/Halifax", Tz::America__Halifax),
        ("America/Indianapolis", Tz::America__Indianapolis),
        ("US/Samoa", Tz::US__Samoa),
        ("America/Thunder_Bay", Tz::America__Thunder_Bay),
        ("Japan", Tz::Japan),
        ("Africa/Harare", Tz::Africa__Harare),
        ("America/Resolute", Tz::America__Resolute),
        ("America/Moncton", Tz::America__Moncton),
        ("Asia/Harbin", Tz::Asia__Harbin),
        ("Asia/Rangoon", Tz::Asia__Rangoon),
        ("Europe/Gibraltar", Tz::Europe__Gibraltar),
        ("Canada/Central", Tz::Canada__Central),
        ("Europe/Saratov", Tz::Europe__Saratov),
        ("Antarctica/Macquarie", Tz::Antarctica__Macquarie),
        ("America/Indiana/Marengo", Tz::America__Indiana__Marengo),
        ("Pacific/Gambier", Tz::Pacific__Gambier),
        ("Asia/Ulaanbaatar", Tz::Asia__Ulaanbaatar),
        ("Africa/Maseru", Tz::Africa__Maseru),
        ("Europe/Helsinki", Tz::Europe__Helsinki),
        ("America/St_Vincent", Tz::America__St_Vincent),
        ("MST7MDT", Tz::MST7MDT),
        ("Portugal", Tz::Portugal),
        ("Asia/Bishkek", Tz::Asia__Bishkek),
        ("Indian/Antananarivo", Tz::Indian__Antananarivo),
        ("America/Edmonton", Tz::America__Edmonton),
        ("Antarctica/DumontDUrville", Tz::Antarctica__DumontDUrville),
        ("Australia/Melbourne", Tz::Australia__Melbourne),
        ("America/Ensenada", Tz::America__Ensenada),
        ("Pacific/Majuro", Tz::Pacific__Majuro),
        ("America/Knox_IN", Tz::America__Knox_IN),
        ("Etc/GMT+11", Tz::Etc__GMTPlus11),
        ("Asia/Kuching", Tz::Asia__Kuching),
        ("Jamaica", Tz::Jamaica),
        ("US/Aleutian", Tz::US__Aleutian),
        ("America/Buenos_Aires", Tz::America__Buenos_Aires),
        ("America/Dawson_Creek", Tz::America__Dawson_Creek),
        ("US/Central", Tz::US__Central),
        ("America/Argentina/San_Luis", Tz::America__Argentina__San_Luis),
        ("America/Monterrey", Tz::America__Monterrey),
        ("Universal", Tz::Universal),
        ("Etc/GMT+10", Tz::Etc__GMTPlus10),
        ("Pacific/Niue", Tz::Pacific__Niue),
        ("Asia/Chita", Tz::Asia__Chita),
        ("America/Port_of_Spain", Tz::America__Port_of_Spain),
        ("Etc/GMT-11", Tz::Etc__GMTMinus11),
        ("Asia/Magadan", Tz::Asia__Magadan),
        ("Africa/Lubumbashi", Tz::Africa__Lubumbashi),
        ("Asia/Thimphu", Tz::Asia__Thimphu),
        ("Africa/Kampala", Tz::Africa__Kampala),
        ("America/Panama", Tz::America__Panama),
        ("Asia/Chongqing", Tz::Asia__Chongqing),
        ("Africa/Conakry", Tz::Africa__Conakry),
        ("Asia/Dushanbe", Tz::Asia__Dushanbe),
        ("Europe/Oslo", Tz::Europe__Oslo),
        ("Asia/Qyzylorda", Tz::Asia__Qyzylorda),
        ("Atlantic/Faeroe", Tz::Atlantic__Faeroe),
        ("America/Jujuy", Tz::America__Jujuy),
        ("Europe/Dublin", Tz::Europe__Dublin),
        ("Asia/Aqtau", Tz::Asia__Aqtau),
        ("Asia/Dacca", Tz::Asia__Dacca),
        ("America/Antigua", Tz::America__Antigua),
        ("America/New_York", Tz::America__New_York),
        ("Australia/North", Tz::Australia__North),
        ("US/Mountain", Tz::US__Mountain),
        ("America/Argentina/Rio_Gallegos", Tz::America__Argentina__Rio_Gallegos),
        ("Europe/Madrid", Tz::Europe__Madrid),
        ("Asia/Kashgar", Tz::Asia__Kashgar),
        ("America/Punta_Arenas", Tz::America__Punta_Arenas),
        ("Asia/Barnaul", Tz::Asia__Barnaul),
        ("America/North_Dakota/New_Salem", Tz::America__North_Dakota__New_Salem),
        ("America/Virgin", Tz::America__Virgin),
        ("Iran", Tz::Iran),
        ("Europe/Kaliningrad", Tz::Europe__Kaliningrad),
        ("PRC", Tz::PRC),
        ("Europe/Volgograd", Tz::Europe__Volgograd),
        ("America/Guatemala", Tz::America__Guatemala),
        ("Asia/Amman", Tz::Asia__Amman),
        ("America/Indiana/Tell_City", Tz::America__Indiana__Tell_City),
        ("Atlantic/Jan_Mayen", Tz::Atlantic__Jan_Mayen),
        ("Asia/Ho_Chi_Minh", Tz::Asia__Ho_Chi_Minh),
        ("Brazil/East", Tz::Brazil__East),
        ("Etc/GMT-4", Tz::Etc__GMTMinus4),
        ("America/Pangnirtung", Tz::America__Pangnirtung),
        ("Canada/Newfoundland", Tz::Canada__Newfoundland),
        ("Africa/Douala", Tz::Africa__Douala),
        ("GMT", Tz::GMT),
        ("America/Glace_Bay", Tz::America__Glace_Bay),
        ("Africa/Nairobi", Tz::Africa__Nairobi),
        ("Kwajalein", Tz::Kwajalein),
        ("America/Guadeloupe", Tz::America__Guadeloupe),
        ("Pacific/Funafuti", Tz::Pacific__Funafuti),
        ("Etc/GMT-1", Tz::Etc__GMTMinus1),
        ("Africa/Tunis", Tz::Africa__Tunis),
        ("America/Anchorage", Tz::America__Anchorage),
        ("US/Eastern", Tz::US__Eastern),
        ("Africa/Dar_es_Salaam", Tz::Africa__Dar_es_Salaam),
        ("Pacific/Yap", Tz::Pacific__Yap),
        ("Asia/Karachi", Tz::Asia__Karachi),
        ("Asia/Dhaka", Tz::Asia__Dhaka),
        ("America/Argentina/ComodRivadavia", Tz::America__Argentina__ComodRivadavia),
        ("Etc/GMT+6", Tz::Etc__GMTPlus6),
        ("Australia/Perth", Tz::Australia__Perth),
        ("CST6CDT", Tz::CST6CDT),
        ("Europe/Luxembourg", Tz::Europe__Luxembourg),
        ("Pacific/Chuuk", Tz::Pacific__Chuuk),
        ("Europe/Rome", Tz::Europe__Rome),
        ("US/Michigan", Tz::US__Michigan),
        ("America/Menominee", Tz::America__Menominee),
        ("Antarctica/Vostok", Tz::Antarctica__Vostok),
        ("Chile/EasterIsland", Tz::Chile__EasterIsland),
        ("ROC", Tz::ROC),
        ("Asia/Aqtobe", Tz::Asia__Aqtobe),
        ("Greenwich", Tz::Greenwich),
        ("Asia/Riyadh", Tz::Asia__Riyadh),
        ("Antarctica/Davis", Tz::Antarctica__Davis),
        ("America/Indiana/Indianapolis", Tz::America__Indiana__Indianapolis),
        ("Africa/Tripoli", Tz::Africa__Tripoli),
        ("Hongkong", Tz::Hongkong),
        ("America/Mazatlan", Tz::America__Mazatlan),
        ("America/Montserrat", Tz::America__Montserrat),
        ("EET", Tz::EET),
        ("Europe/Copenhagen", Tz::Europe__Copenhagen),
        ("Australia/Darwin", Tz::Australia__Darwin),
        ("Asia/Ulan_Bator", Tz::Asia__Ulan_Bator),
        ("Etc/GMT-13", Tz::Etc__GMTMinus13),
        ("Pacific/Guam", Tz::Pacific__Guam),
        ("Atlantic/Canary", Tz::Atlantic__Canary),
        ("Europe/Belfast", Tz::Europe__Belfast),
        ("Chile/Continental", Tz::Chile__Continental),
        ("America/Scoresbysund", Tz::America__Scoresbysund),
        ("Asia/Omsk", Tz::Asia__Omsk),
        ("Asia/Hong_Kong", Tz::Asia__Hong_Kong),
        ("Africa/Lagos", Tz::Africa__Lagos),
        ("Europe/Guernsey", Tz::Europe__Guernsey),
        ("America/Iqaluit", Tz::America__Iqaluit),
        ("Asia/Shanghai", Tz::Asia__Shanghai),
        ("Asia/Yerevan", Tz::Asia__Yerevan),
        ("America/Atikokan", Tz::America__Atikokan),
        ("America/Argentina/Catamarca", Tz::America__Argentina__Catamarca),
        ("America/Maceio", Tz::America__Maceio),
        ("Canada/Yukon", Tz::Canada__Yukon),
        ("Africa/Monrovia", Tz::Africa__Monrovia),
        ("America/Nome", Tz::America__Nome),
        ("Europe/Kyiv", Tz::Europe__Kyiv),
        ("America/Eirunepe", Tz::America__Eirunepe),
        ("Europe/Skopje", Tz::Europe__Skopje),
        ("Asia/Beirut", Tz::Asia__Beirut),
        ("America/Yakutat", Tz::America__Yakutat),
        ("GMT+0", Tz::GMTPlus0),
        ("Europe/Astrakhan", Tz::Europe__Astrakhan),
        ("Asia/Tbilisi", Tz::Asia__Tbilisi),
        ("Asia/Nicosia", Tz::Asia__Nicosia),
        ("Indian/Kerguelen", Tz::Indian__Kerguelen),
        ("Etc/GMT+9", Tz::Etc__GMTPlus9),
        ("Indian/Mayotte", Tz::Indian__Mayotte),
        ("Indian/Mahe", Tz::Indian__Mahe),
        ("Europe/Athens", Tz::Europe__Athens),
        ("Asia/Kabul", Tz::Asia__Kabul),
        ("Pacific/Kanton", Tz::Pacific__Kanton),
        ("Africa/Djibouti", Tz::Africa__Djibouti),
        ("America/Cambridge_Bay", Tz::America__Cambridge_Bay),
        ("America/Mexico_City", Tz::America__Mexico_City),
        ("Europe/Brussels", Tz::Europe__Brussels),
        ("America/Martinique", Tz::America__Martinique),
        ("Asia/Kuwait", Tz::Asia__Kuwait),
        ("Australia/Eucla", Tz::Australia__Eucla),
        ("Asia/Khandyga", Tz::Asia__Khandyga),
        ("US/Indiana-Starke", Tz::US__IndianaStarke),
        ("Asia/Kolkata", Tz::Asia__Kolkata),
        ("Pacific/Pitcairn", Tz::Pacific__Pitcairn),
        ("America/Nipigon", Tz::America__Nipigon),
        ("Antarctica/South_Pole", Tz::Antarctica__South_Pole),
        ("Mexico/General", Tz::Mexico__General),
        ("Europe/Tirane", Tz::Europe__Tirane),
        ("Asia/Samarkand", Tz::Asia__Samarkand),
        ("Canada/Eastern", Tz::Canada__Eastern),
        ("Antarctica/Mawson", Tz::Antarctica__Mawson),
        ("Europe/Berlin", Tz::Europe__Berlin),
        ("America/Cancun", Tz::America__Cancun),
        ("Asia/Vientiane", Tz::Asia__Vientiane),
        ("Africa/Windhoek", Tz::Africa__Windhoek),
        ("Asia/Anadyr", Tz::Asia__Anadyr),
        ("Africa/Khartoum", Tz::Africa__Khartoum),
        ("Africa/Gaborone", Tz::Africa__Gaborone),
        ("Europe/Bucharest", Tz::Europe__Bucharest),
        ("Africa/Kigali", Tz::Africa__Kigali),
        ("America/Inuvik", Tz::America__Inuvik),
        ("Australia/Canberra", Tz::Australia__Canberra),
        ("America/Denver", Tz::America__Denver),
        ("America/Shiprock", Tz::America__Shiprock),
        ("Europe/Nicosia", Tz::Europe__Nicosia),
        ("Europe/London", Tz::Europe__London),
        ("Europe/Ljubljana", Tz::Europe__Ljubljana),
        ("Antarctica/Casey", Tz::Antarctica__Casey),
        ("Atlantic/Cape_Verde", Tz::Atlantic__Cape_Verde),
        ("Australia/LHI", Tz::Australia__LHI),
        ("US/Hawaii", Tz::US__Hawaii),
        ("Libya", Tz::Libya),
        ("Asia/Novosibirsk", Tz::Asia__Novosibirsk),
        ("Europe/Tallinn", Tz::Europe__Tallinn),
        ("Asia/Calcutta", Tz::Asia__Calcutta),
        ("Pacific/Palau", Tz::Pacific__Palau),
        ("Africa/Ceuta", Tz::Africa__Ceuta),
        ("Brazil/Acre", Tz::Brazil__Acre),
        ("Pacific/Guadalcanal", Tz::Pacific__Guadalcanal),
        ("Asia/Ashkhabad", Tz::Asia__Ashkhabad),
        ("America/Jamaica", Tz::America__Jamaica),
        ("Pacific/Tarawa", Tz::Pacific__Tarawa),
        ("GB-Eire", Tz::GBEire),
        ("Indian/Reunion", Tz::Indian__Reunion),
        ("America/Argentina/La_Rioja", Tz::America__Argentina__La_Rioja),
        ("Australia/West", Tz::Australia__West),
        ("America/Belem", Tz::America__Belem),
        ("America/Porto_Acre", Tz::America__Porto_Acre),
        ("Asia/Chungking", Tz::Asia__Chungking),
        ("EST5EDT", Tz::EST5EDT),
        ("America/Louisville", Tz::America__Louisville),
        ("Asia/Qostanay", Tz::Asia__Qostanay),
        ("America/Cayman", Tz::America__Cayman),
        ("Pacific/Johnston", Tz::Pacific__Johnston),
        ("Asia/Urumqi", Tz::Asia__Urumqi),
        ("Africa/Mbabane", Tz::Africa__Mbabane),
        ("Africa/Casablanca", Tz::Africa__Casablanca),
        ("America/Sao_Paulo", Tz::America__Sao_Paulo),
        ("Navajo", Tz::Navajo),
        ("America/Winnipeg", Tz::America__Winnipeg),
        ("ROK", Tz::ROK),
        ("America/Fort_Nelson", Tz::America__Fort_Nelson),
        ("Asia/Tomsk", Tz::Asia__Tomsk),
        ("Africa/Maputo", Tz::Africa__Maputo),
        ("Europe/Samara", Tz::Europe__Samara),
        ("Pacific/Nauru", Tz::Pacific__Nauru),
        ("Europe/Istanbul", Tz::Europe__Istanbul),
        ("Africa/Dakar", Tz::Africa__Dakar),
        ("America/Yellowknife", Tz::America__Yellowknife),
        ("Asia/Novokuznetsk", Tz::Asia__Novokuznetsk),
        ("America/Sitka", Tz::America__Sitka),
        ("HST", Tz::HST),
        ("Antarctica/Palmer", Tz::Antarctica__Palmer),
        ("Australia/Lord_Howe", Tz::Australia__Lord_Howe),
        ("America/Rosario", Tz::America__Rosario),
        ("W-SU", Tz::WSU),
        ("Australia/NSW", Tz::Australia__NSW),
        ("CET", Tz::CET),
        ("America/Kralendijk", Tz::America__Kralendijk),
        ("US/Pacific", Tz::US__Pacific),
        ("Pacific/Port_Moresby", Tz::Pacific__Port_Moresby),
        ("Asia/Ashgabat", Tz::Asia__Ashgabat),
        ("Etc/GMT+12", Tz::Etc__GMTPlus12),
        ("America/Managua", Tz::America__Managua),
        ("Pacific/Marquesas", Tz::Pacific__Marquesas),
        ("Mexico/BajaNorte", Tz::Mexico__BajaNorte),
        ("America/Barbados", Tz::America__Barbados),
        ("Africa/Luanda", Tz::Africa__Luanda),
        ("Brazil/West", Tz::Brazil__West),
        ("Asia/Choibalsan", Tz::Asia__Choibalsan),
        ("America/Whitehorse", Tz::America__Whitehorse),
        ("America/Argentina/Tucuman", Tz::America__Argentina__Tucuman),
        ("Asia/Dili", Tz::Asia__Dili),
        ("Canada/Pacific", Tz::Canada__Pacific),
        ("Asia/Katmandu", Tz::Asia__Katmandu),
        ("Pacific/Noumea", Tz::Pacific__Noumea),
        ("Atlantic/Bermuda", Tz::Atlantic__Bermuda),
        ("Indian/Mauritius", Tz::Indian__Mauritius),
        ("Asia/Vladivostok", Tz::Asia__Vladivostok),
        ("Etc/GMT+0", Tz::Etc__GMTPlus0),
        ("America/Grenada", Tz::America__Grenada),
        ("America/Cayenne", Tz::America__Cayenne),
        ("Etc/GMT-2", Tz::Etc__GMTMinus2),
        ("Atlantic/Azores", Tz::Atlantic__Azores),
        ("UTC", Tz::UTC),
        ("America/Argentina/Mendoza", Tz::America__Argentina__Mendoza),
        ("Pacific/Tahiti", Tz::Pacific__Tahiti),
        ("Europe/Kirov", Tz::Europe__Kirov),
        ("Europe/Vilnius", Tz::Europe__Vilnius),
        ("Pacific/Midway", Tz::Pacific__Midway),
        ("America/Juneau", Tz::America__Juneau),
        ("America/Cordoba", Tz::America__Cordoba),
        ("America/North_Dakota/Center", Tz::America__North_Dakota__Center),
        ("Asia/Saigon", Tz::Asia__Saigon),
        ("America/Matamoros", Tz::America__Matamoros),
        ("Etc/GMT+4", Tz::Etc__GMTPlus4),
        ("America/Los_Angeles", Tz::America__Los_Angeles),
        ("Europe/Moscow", Tz::Europe__Moscow),
        ("Africa/Ndjamena", Tz::Africa__Ndjamena),
        ("Africa/Bangui", Tz::Africa__Bangui),
        ("Pacific/Galapagos", Tz::Pacific__Galapagos),
        ("Canada/Saskatchewan", Tz::Canada__Saskatchewan),
        ("Australia/South", Tz::Australia__South),
        ("Etc/GMT", Tz::Etc__GMT),
        ("Africa/Bissau", Tz::Africa__Bissau),
        ("Etc/GMT-7", Tz::Etc__GMTMinus7),
        ("Pacific/Pago_Pago", Tz::Pacific__Pago_Pago),
        ("America/Araguaina", Tz::America__Araguaina),
        ("America/Ciudad_Juarez", Tz::America__Ciudad_Juarez),
        ("Asia/Jayapura", Tz::Asia__Jayapura),
        ("Europe/Budapest", Tz::Europe__Budapest),
        ("America/Creston", Tz::America__Creston),
        ("Europe/Warsaw", Tz::Europe__Warsaw),
        ("Etc/GMT+1", Tz::Etc__GMTPlus1),
        ("Pacific/Rarotonga", Tz::Pacific__Rarotonga),
        ("Etc/GMT-5", Tz::Etc__GMTMinus5),
        ("Asia/Pontianak", Tz::Asia__Pontianak),
        ("Asia/Phnom_Penh", Tz::Asia__Phnom_Penh),
        ("Australia/Currie", Tz::Australia__Currie),
        ("Australia/Queensland", Tz::Australia__Queensland),
        ("Atlantic/Reykjavik", Tz::Atlantic__Reykjavik),
        ("Pacific/Auckland", Tz::Pacific__Auckland),
        ("Asia/Jerusalem", Tz::Asia__Jerusalem),
        ("Pacific/Chatham", Tz::Pacific__Chatham),
        ("Asia/Ust-Nera", Tz::Asia__UstNera),
        ("America/Tijuana", Tz::America__Tijuana),
        ("Pacific/Apia", Tz::Pacific__Apia),
        ("Asia/Kathmandu", Tz::Asia__Kathmandu),
        ("Canada/Atlantic", Tz::Canada__Atlantic),
        ("Pacific/Saipan", Tz::Pacific__Saipan),
        ("America/Argentina/Cordoba", Tz::America__Argentina__Cordoba),
        ("Asia/Macao", Tz::Asia__Macao),
        ("Europe/Zaporozhye", Tz::Europe__Zaporozhye),
        ("America/Kentucky/Louisville", Tz::America__Kentucky__Louisville),
        ("America/Argentina/Ushuaia", Tz::America__Argentina__Ushuaia),
        ("WET", Tz::WET),
        ("Europe/Uzhgorod", Tz::Europe__Uzhgorod),
        ("Etc/UCT", Tz::Etc__UCT),
        ("Etc/GMT-8", Tz::Etc__GMTMinus8),
        ("Poland", Tz::Poland),
        ("Africa/Cairo", Tz::Africa__Cairo),
        ("Asia/Singapore", Tz::Asia__Singapore),
        ("Asia/Bahrain", Tz::Asia__Bahrain),
        ("Europe/Andorra", Tz::Europe__Andorra),
        ("America/Bahia_Banderas", Tz::America__Bahia_Banderas),
        ("Indian/Comoro", Tz::Indian__Comoro),
        ("Asia/Gaza", Tz::Asia__Gaza),
        ("America/Santo_Domingo", Tz::America__Santo_Domingo),
        ("Europe/Vienna", Tz::Europe__Vienna),
        ("America/Dawson", Tz::America__Dawson),
        ("America/Indiana/Vevay", Tz::America__Indiana__Vevay),
        ("Brazil/DeNoronha", Tz::Brazil__DeNoronha),
        ("Asia/Almaty", Tz::Asia__Almaty),
        ("Europe/Stockholm", Tz::Europe__Stockholm),
        ("Europe/Riga", Tz::Europe__Riga),
        ("Africa/Addis_Ababa", Tz::Africa__Addis_Ababa),
        ("Asia/Muscat", Tz::Asia__Muscat),
        ("America/Indiana/Knox", Tz::America__Indiana__Knox),
        ("Europe/Sarajevo", Tz::Europe__Sarajevo),
        ("America/Danmarkshavn", Tz::America__Danmarkshavn),
        ("America/Rankin_Inlet", Tz::America__Rankin_Inlet),
        ("Africa/Ouagadougou", Tz::Africa__Ouagadougou),
        ("Africa/Porto-Novo", Tz::Africa__PortoNovo),
        ("America/Toronto", Tz::America__Toronto),
        ("America/Vancouver", Tz::America__Vancouver),
        ("Africa/Johannesburg", Tz::Africa__Johannesburg),
        ("Europe/Tiraspol", Tz::Europe__Tiraspol),
        ("Africa/Lusaka", Tz::Africa__Lusaka),
        ("America/Argentina/Jujuy", Tz::America__Argentina__Jujuy),
        ("GMT0", Tz::GMT0),
        ("America/Rainy_River", Tz::America__Rainy_River),
        ("Australia/Hobart", Tz::Australia__Hobart),
        ("EST", Tz::EST),
        ("Europe/Prague", Tz::Europe__Prague),
        ("Etc/GMT-0", Tz::Etc__GMTMinus0),
        ("Antarctica/Troll", Tz::Antarctica__Troll),
        ("Africa/Mogadishu", Tz::Africa__Mogadishu),
        ("America/Argentina/Buenos_Aires", Tz::America__Argentina__Buenos_Aires),
        ("America/Adak", Tz::America__Adak),
        ("MST", Tz::MST),
        ("Asia/Dubai", Tz::Asia__Dubai),
        ("Pacific/Easter", Tz::Pacific__Easter),
        ("Africa/Lome", Tz::Africa__Lome),
        ("Pacific/Norfolk", Tz::Pacific__Norfolk),
        ("Atlantic/Faroe", Tz::Atlantic__Faroe),
        ("Atlantic/St_Helena", Tz::Atlantic__St_Helena),
        ("Etc/GMT-9", Tz::Etc__GMTMinus9),
        ("America/St_Barthelemy", Tz::America__St_Barthelemy),
        ("Africa/Niamey", Tz::Africa__Niamey),
        ("Africa/Libreville", Tz::Africa__Libreville),
        ("Asia/Famagusta", Tz::Asia__Famagusta),
        ("America/Goose_Bay", Tz::America__Goose_Bay),
        ("Zulu", Tz::Zulu),
        ("Australia/Yancowinna", Tz::Australia__Yancowinna),
        ("Europe/San_Marino", Tz::Europe__San_Marino),
        ("Asia/Jakarta", Tz::Asia__Jakarta),
        ("America/Costa_Rica", Tz::America__Costa_Rica),
        ("Asia/Kamchatka", Tz::Asia__Kamchatka),
        ("Europe/Amsterdam", Tz::Europe__Amsterdam),
        ("Asia/Yangon", Tz::Asia__Yangon),
        ("Antarctica/Syowa", Tz::Antarctica__Syowa),
        ("Etc/GMT+5", Tz::Etc__GMTPlus5),
        ("America/Montevideo", Tz::America__Montevideo),
        ("Africa/Algiers", Tz::Africa__Algiers),
        ("America/Thule", Tz::America__Thule),
        ("Europe/Bratislava", Tz::Europe__Bratislava),
        ("Indian/Christmas", Tz::Indian__Christmas),
        ("Asia/Baku", Tz::Asia__Baku),
        ("Etc/GMT-10", Tz::Etc__GMTMinus10),
        ("Africa/Malabo", Tz::Africa__Malabo),
        ("America/Kentucky/Monticello", Tz::America__Kentucky__Monticello),
        ("America/Atka", Tz::America__Atka),
        ("America/Asuncion", Tz::America__Asuncion),
        ("America/North_Dakota/Beulah", Tz::America__North_Dakota__Beulah),
        ("Atlantic/Stanley", Tz::Atlantic__Stanley),
        ("Israel", Tz::Israel),
        ("America/Miquelon", Tz::America__Miquelon),
        ("Asia/Hovd", Tz::Asia__Hovd),
        ("Europe/Zurich", Tz::Europe__Zurich),
        ("America/Curacao", Tz::America__Curacao),
        ("America/Phoenix", Tz::America__Phoenix),
        ("America/Indiana/Petersburg", Tz::America__Indiana__Petersburg),
        ("Europe/Simferopol", Tz::Europe__Simferopol),
        ("America/St_Lucia", Tz::America__St_Lucia),
        ("Asia/Tashkent", Tz::Asia__Tashkent),
        ("Pacific/Truk", Tz::Pacific__Truk),
        ("Asia/Hebron", Tz::Asia__Hebron),
        ("Pacific/Tongatapu", Tz::Pacific__Tongatapu),
        ("Eire", Tz::Eire),
        ("Europe/Ulyanovsk", Tz::Europe__Ulyanovsk),
        ("America/Port-au-Prince", Tz::America__PortauPrince),
        ("Africa/Timbuktu", Tz::Africa__Timbuktu),
        ("Indian/Maldives", Tz::Indian__Maldives),
        ("Asia/Colombo", Tz::Asia__Colombo),
        ("Africa/Juba", Tz::Africa__Juba),
        ("Australia/Lindeman", Tz::Australia__Lindeman),
        ("Egypt", Tz::Egypt),
        ("Asia/Kuala_Lumpur", Tz::Asia__Kuala_Lumpur),
        ("GB", Tz::GB),
        ("America/Puerto_Rico", Tz::America__Puerto_Rico),
        ("America/Fortaleza", Tz::America__Fortaleza),
        ("America/El_Salvador", Tz::America__El_Salvador),
        ("US/Arizona", Tz::US__Arizona),
        ("America/Metlakatla", Tz::America__Metlakatla),
        ("Iceland", Tz::Iceland),
        ("Europe/Kiev", Tz::Europe__Kiev),
        ("America/Chihuahua", Tz::America__Chihuahua),
        ("Africa/Bamako", Tz::Africa__Bamako),
        ("Australia/Adelaide", Tz::Australia__Adelaide),
        ("Australia/Broken_Hill", Tz::Australia__Broken_Hill),
        ("Asia/Atyrau", Tz::Asia__Atyrau),
        ("Asia/Qatar", Tz::Asia__Qatar),
        ("America/Santiago", Tz::America__Santiago),
        ("America/St_Thomas", Tz::America__St_Thomas),
        ("Etc/UTC", Tz::Etc__UTC),
        ("Etc/Universal", Tz::Etc__Universal),
        ("Africa/Bujumbura", Tz::Africa__Bujumbura),
        ("America/Santa_Isabel", Tz::America__Santa_Isabel),
        ("Pacific/Fiji", Tz::Pacific__Fiji),
        ("Asia/Makassar", Tz::Asia__Makassar),
        ("Asia/Thimbu", Tz::Asia__Thimbu),
        ("America/Nuuk", Tz::America__Nuuk),
        ("Africa/Banjul", Tz::Africa__Banjul),
        ("America/Cuiaba", Tz::America__Cuiaba),
        ("America/Grand_Turk", Tz::America__Grand_Turk),
        ("Pacific/Samoa", Tz::Pacific__Samoa),
    ],
};
#[cfg(feature = "std")]
pub type ParseError = String;
#[cfg(not(feature = "std"))]
pub type ParseError = &'static str;

impl FromStr for Tz {
    type Err = ParseError;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        #[cfg(feature = "std")]
        return TIMEZONES.get(s).cloned().ok_or_else(|| format!("'{}' is not a valid timezone", s));
        #[cfg(not(feature = "std"))]
        return TIMEZONES.get(s).cloned().ok_or("received invalid timezone");
    }
}

impl Tz {
    pub fn name(self) -> &'static str {
        match self {
            Tz::Africa__Abidjan => "Africa/Abidjan",
            Tz::Africa__Accra => "Africa/Accra",
            Tz::Africa__Addis_Ababa => "Africa/Addis_Ababa",
            Tz::Africa__Algiers => "Africa/Algiers",
            Tz::Africa__Asmara => "Africa/Asmara",
            Tz::Africa__Asmera => "Africa/Asmera",
            Tz::Africa__Bamako => "Africa/Bamako",
            Tz::Africa__Bangui => "Africa/Bangui",
            Tz::Africa__Banjul => "Africa/Banjul",
            Tz::Africa__Bissau => "Africa/Bissau",
            Tz::Africa__Blantyre => "Africa/Blantyre",
            Tz::Africa__Brazzaville => "Africa/Brazzaville",
            Tz::Africa__Bujumbura => "Africa/Bujumbura",
            Tz::Africa__Cairo => "Africa/Cairo",
            Tz::Africa__Casablanca => "Africa/Casablanca",
            Tz::Africa__Ceuta => "Africa/Ceuta",
            Tz::Africa__Conakry => "Africa/Conakry",
            Tz::Africa__Dakar => "Africa/Dakar",
            Tz::Africa__Dar_es_Salaam => "Africa/Dar_es_Salaam",
            Tz::Africa__Djibouti => "Africa/Djibouti",
            Tz::Africa__Douala => "Africa/Douala",
            Tz::Africa__El_Aaiun => "Africa/El_Aaiun",
            Tz::Africa__Freetown => "Africa/Freetown",
            Tz::Africa__Gaborone => "Africa/Gaborone",
            Tz::Africa__Harare => "Africa/Harare",
            Tz::Africa__Johannesburg => "Africa/Johannesburg",
            Tz::Africa__Juba => "Africa/Juba",
            Tz::Africa__Kampala => "Africa/Kampala",
            Tz::Africa__Khartoum => "Africa/Khartoum",
            Tz::Africa__Kigali => "Africa/Kigali",
            Tz::Africa__Kinshasa => "Africa/Kinshasa",
            Tz::Africa__Lagos => "Africa/Lagos",
            Tz::Africa__Libreville => "Africa/Libreville",
            Tz::Africa__Lome => "Africa/Lome",
            Tz::Africa__Luanda => "Africa/Luanda",
            Tz::Africa__Lubumbashi => "Africa/Lubumbashi",
            Tz::Africa__Lusaka => "Africa/Lusaka",
            Tz::Africa__Malabo => "Africa/Malabo",
            Tz::Africa__Maputo => "Africa/Maputo",
            Tz::Africa__Maseru => "Africa/Maseru",
            Tz::Africa__Mbabane => "Africa/Mbabane",
            Tz::Africa__Mogadishu => "Africa/Mogadishu",
            Tz::Africa__Monrovia => "Africa/Monrovia",
            Tz::Africa__Nairobi => "Africa/Nairobi",
            Tz::Africa__Ndjamena => "Africa/Ndjamena",
            Tz::Africa__Niamey => "Africa/Niamey",
            Tz::Africa__Nouakchott => "Africa/Nouakchott",
            Tz::Africa__Ouagadougou => "Africa/Ouagadougou",
            Tz::Africa__PortoNovo => "Africa/Porto-Novo",
            Tz::Africa__Sao_Tome => "Africa/Sao_Tome",
            Tz::Africa__Timbuktu => "Africa/Timbuktu",
            Tz::Africa__Tripoli => "Africa/Tripoli",
            Tz::Africa__Tunis => "Africa/Tunis",
            Tz::Africa__Windhoek => "Africa/Windhoek",
            Tz::America__Adak => "America/Adak",
            Tz::America__Anchorage => "America/Anchorage",
            Tz::America__Anguilla => "America/Anguilla",
            Tz::America__Antigua => "America/Antigua",
            Tz::America__Araguaina => "America/Araguaina",
            Tz::America__Argentina__Buenos_Aires => "America/Argentina/Buenos_Aires",
            Tz::America__Argentina__Catamarca => "America/Argentina/Catamarca",
            Tz::America__Argentina__ComodRivadavia => "America/Argentina/ComodRivadavia",
            Tz::America__Argentina__Cordoba => "America/Argentina/Cordoba",
            Tz::America__Argentina__Jujuy => "America/Argentina/Jujuy",
            Tz::America__Argentina__La_Rioja => "America/Argentina/La_Rioja",
            Tz::America__Argentina__Mendoza => "America/Argentina/Mendoza",
            Tz::America__Argentina__Rio_Gallegos => "America/Argentina/Rio_Gallegos",
            Tz::America__Argentina__Salta => "America/Argentina/Salta",
            Tz::America__Argentina__San_Juan => "America/Argentina/San_Juan",
            Tz::America__Argentina__San_Luis => "America/Argentina/San_Luis",
            Tz::America__Argentina__Tucuman => "America/Argentina/Tucuman",
            Tz::America__Argentina__Ushuaia => "America/Argentina/Ushuaia",
            Tz::America__Aruba => "America/Aruba",
            Tz::America__Asuncion => "America/Asuncion",
            Tz::America__Atikokan => "America/Atikokan",
            Tz::America__Atka => "America/Atka",
            Tz::America__Bahia => "America/Bahia",
            Tz::America__Bahia_Banderas => "America/Bahia_Banderas",
            Tz::America__Barbados => "America/Barbados",
            Tz::America__Belem => "America/Belem",
            Tz::America__Belize => "America/Belize",
            Tz::America__BlancSablon => "America/Blanc-Sablon",
            Tz::America__Boa_Vista => "America/Boa_Vista",
            Tz::America__Bogota => "America/Bogota",
            Tz::America__Boise => "America/Boise",
            Tz::America__Buenos_Aires => "America/Buenos_Aires",
            Tz::America__Cambridge_Bay => "America/Cambridge_Bay",
            Tz::America__Campo_Grande => "America/Campo_Grande",
            Tz::America__Cancun => "America/Cancun",
            Tz::America__Caracas => "America/Caracas",
            Tz::America__Catamarca => "America/Catamarca",
            Tz::America__Cayenne => "America/Cayenne",
            Tz::America__Cayman => "America/Cayman",
            Tz::America__Chicago => "America/Chicago",
            Tz::America__Chihuahua => "America/Chihuahua",
            Tz::America__Ciudad_Juarez => "America/Ciudad_Juarez",
            Tz::America__Coral_Harbour => "America/Coral_Harbour",
            Tz::America__Cordoba => "America/Cordoba",
            Tz::America__Costa_Rica => "America/Costa_Rica",
            Tz::America__Creston => "America/Creston",
            Tz::America__Cuiaba => "America/Cuiaba",
            Tz::America__Curacao => "America/Curacao",
            Tz::America__Danmarkshavn => "America/Danmarkshavn",
            Tz::America__Dawson => "America/Dawson",
            Tz::America__Dawson_Creek => "America/Dawson_Creek",
            Tz::America__Denver => "America/Denver",
            Tz::America__Detroit => "America/Detroit",
            Tz::America__Dominica => "America/Dominica",
            Tz::America__Edmonton => "America/Edmonton",
            Tz::America__Eirunepe => "America/Eirunepe",
            Tz::America__El_Salvador => "America/El_Salvador",
            Tz::America__Ensenada => "America/Ensenada",
            Tz::America__Fort_Nelson => "America/Fort_Nelson",
            Tz::America__Fort_Wayne => "America/Fort_Wayne",
            Tz::America__Fortaleza => "America/Fortaleza",
            Tz::America__Glace_Bay => "America/Glace_Bay",
            Tz::America__Godthab => "America/Godthab",
            Tz::America__Goose_Bay => "America/Goose_Bay",
            Tz::America__Grand_Turk => "America/Grand_Turk",
            Tz::America__Grenada => "America/Grenada",
            Tz::America__Guadeloupe => "America/Guadeloupe",
            Tz::America__Guatemala => "America/Guatemala",
            Tz::America__Guayaquil => "America/Guayaquil",
            Tz::America__Guyana => "America/Guyana",
            Tz::America__Halifax => "America/Halifax",
            Tz::America__Havana => "America/Havana",
            Tz::America__Hermosillo => "America/Hermosillo",
            Tz::America__Indiana__Indianapolis => "America/Indiana/Indianapolis",
            Tz::America__Indiana__Knox => "America/Indiana/Knox",
            Tz::America__Indiana__Marengo => "America/Indiana/Marengo",
            Tz::America__Indiana__Petersburg => "America/Indiana/Petersburg",
            Tz::America__Indiana__Tell_City => "America/Indiana/Tell_City",
            Tz::America__Indiana__Vevay => "America/Indiana/Vevay",
            Tz::America__Indiana__Vincennes => "America/Indiana/Vincennes",
            Tz::America__Indiana__Winamac => "America/Indiana/Winamac",
            Tz::America__Indianapolis => "America/Indianapolis",
            Tz::America__Inuvik => "America/Inuvik",
            Tz::America__Iqaluit => "America/Iqaluit",
            Tz::America__Jamaica => "America/Jamaica",
            Tz::America__Jujuy => "America/Jujuy",
            Tz::America__Juneau => "America/Juneau",
            Tz::America__Kentucky__Louisville => "America/Kentucky/Louisville",
            Tz::America__Kentucky__Monticello => "America/Kentucky/Monticello",
            Tz::America__Knox_IN => "America/Knox_IN",
            Tz::America__Kralendijk => "America/Kralendijk",
            Tz::America__La_Paz => "America/La_Paz",
            Tz::America__Lima => "America/Lima",
            Tz::America__Los_Angeles => "America/Los_Angeles",
            Tz::America__Louisville => "America/Louisville",
            Tz::America__Lower_Princes => "America/Lower_Princes",
            Tz::America__Maceio => "America/Maceio",
            Tz::America__Managua => "America/Managua",
            Tz::America__Manaus => "America/Manaus",
            Tz::America__Marigot => "America/Marigot",
            Tz::America__Martinique => "America/Martinique",
            Tz::America__Matamoros => "America/Matamoros",
            Tz::America__Mazatlan => "America/Mazatlan",
            Tz::America__Mendoza => "America/Mendoza",
            Tz::America__Menominee => "America/Menominee",
            Tz::America__Merida => "America/Merida",
            Tz::America__Metlakatla => "America/Metlakatla",
            Tz::America__Mexico_City => "America/Mexico_City",
            Tz::America__Miquelon => "America/Miquelon",
            Tz::America__Moncton => "America/Moncton",
            Tz::America__Monterrey => "America/Monterrey",
            Tz::America__Montevideo => "America/Montevideo",
            Tz::America__Montreal => "America/Montreal",
            Tz::America__Montserrat => "America/Montserrat",
            Tz::America__Nassau => "America/Nassau",
            Tz::America__New_York => "America/New_York",
            Tz::America__Nipigon => "America/Nipigon",
            Tz::America__Nome => "America/Nome",
            Tz::America__Noronha => "America/Noronha",
            Tz::America__North_Dakota__Beulah => "America/North_Dakota/Beulah",
            Tz::America__North_Dakota__Center => "America/North_Dakota/Center",
            Tz::America__North_Dakota__New_Salem => "America/North_Dakota/New_Salem",
            Tz::America__Nuuk => "America/Nuuk",
            Tz::America__Ojinaga => "America/Ojinaga",
            Tz::America__Panama => "America/Panama",
            Tz::America__Pangnirtung => "America/Pangnirtung",
            Tz::America__Paramaribo => "America/Paramaribo",
            Tz::America__Phoenix => "America/Phoenix",
            Tz::America__PortauPrince => "America/Port-au-Prince",
            Tz::America__Port_of_Spain => "America/Port_of_Spain",
            Tz::America__Porto_Acre => "America/Porto_Acre",
            Tz::America__Porto_Velho => "America/Porto_Velho",
            Tz::America__Puerto_Rico => "America/Puerto_Rico",
            Tz::America__Punta_Arenas => "America/Punta_Arenas",
            Tz::America__Rainy_River => "America/Rainy_River",
            Tz::America__Rankin_Inlet => "America/Rankin_Inlet",
            Tz::America__Recife => "America/Recife",
            Tz::America__Regina => "America/Regina",
            Tz::America__Resolute => "America/Resolute",
            Tz::America__Rio_Branco => "America/Rio_Branco",
            Tz::America__Rosario => "America/Rosario",
            Tz::America__Santa_Isabel => "America/Santa_Isabel",
            Tz::America__Santarem => "America/Santarem",
            Tz::America__Santiago => "America/Santiago",
            Tz::America__Santo_Domingo => "America/Santo_Domingo",
            Tz::America__Sao_Paulo => "America/Sao_Paulo",
            Tz::America__Scoresbysund => "America/Scoresbysund",
            Tz::America__Shiprock => "America/Shiprock",
            Tz::America__Sitka => "America/Sitka",
            Tz::America__St_Barthelemy => "America/St_Barthelemy",
            Tz::America__St_Johns => "America/St_Johns",
            Tz::America__St_Kitts => "America/St_Kitts",
            Tz::America__St_Lucia => "America/St_Lucia",
            Tz::America__St_Thomas => "America/St_Thomas",
            Tz::America__St_Vincent => "America/St_Vincent",
            Tz::America__Swift_Current => "America/Swift_Current",
            Tz::America__Tegucigalpa => "America/Tegucigalpa",
            Tz::America__Thule => "America/Thule",
            Tz::America__Thunder_Bay => "America/Thunder_Bay",
            Tz::America__Tijuana => "America/Tijuana",
            Tz::America__Toronto => "America/Toronto",
            Tz::America__Tortola => "America/Tortola",
            Tz::America__Vancouver => "America/Vancouver",
            Tz::America__Virgin => "America/Virgin",
            Tz::America__Whitehorse => "America/Whitehorse",
            Tz::America__Winnipeg => "America/Winnipeg",
            Tz::America__Yakutat => "America/Yakutat",
            Tz::America__Yellowknife => "America/Yellowknife",
            Tz::Antarctica__Casey => "Antarctica/Casey",
            Tz::Antarctica__Davis => "Antarctica/Davis",
            Tz::Antarctica__DumontDUrville => "Antarctica/DumontDUrville",
            Tz::Antarctica__Macquarie => "Antarctica/Macquarie",
            Tz::Antarctica__Mawson => "Antarctica/Mawson",
            Tz::Antarctica__McMurdo => "Antarctica/McMurdo",
            Tz::Antarctica__Palmer => "Antarctica/Palmer",
            Tz::Antarctica__Rothera => "Antarctica/Rothera",
            Tz::Antarctica__South_Pole => "Antarctica/South_Pole",
            Tz::Antarctica__Syowa => "Antarctica/Syowa",
            Tz::Antarctica__Troll => "Antarctica/Troll",
            Tz::Antarctica__Vostok => "Antarctica/Vostok",
            Tz::Arctic__Longyearbyen => "Arctic/Longyearbyen",
            Tz::Asia__Aden => "Asia/Aden",
            Tz::Asia__Almaty => "Asia/Almaty",
            Tz::Asia__Amman => "Asia/Amman",
            Tz::Asia__Anadyr => "Asia/Anadyr",
            Tz::Asia__Aqtau => "Asia/Aqtau",
            Tz::Asia__Aqtobe => "Asia/Aqtobe",
            Tz::Asia__Ashgabat => "Asia/Ashgabat",
            Tz::Asia__Ashkhabad => "Asia/Ashkhabad",
            Tz::Asia__Atyrau => "Asia/Atyrau",
            Tz::Asia__Baghdad => "Asia/Baghdad",
            Tz::Asia__Bahrain => "Asia/Bahrain",
            Tz::Asia__Baku => "Asia/Baku",
            Tz::Asia__Bangkok => "Asia/Bangkok",
            Tz::Asia__Barnaul => "Asia/Barnaul",
            Tz::Asia__Beirut => "Asia/Beirut",
            Tz::Asia__Bishkek => "Asia/Bishkek",
            Tz::Asia__Brunei => "Asia/Brunei",
            Tz::Asia__Calcutta => "Asia/Calcutta",
            Tz::Asia__Chita => "Asia/Chita",
            Tz::Asia__Choibalsan => "Asia/Choibalsan",
            Tz::Asia__Chongqing => "Asia/Chongqing",
            Tz::Asia__Chungking => "Asia/Chungking",
            Tz::Asia__Colombo => "Asia/Colombo",
            Tz::Asia__Dacca => "Asia/Dacca",
            Tz::Asia__Damascus => "Asia/Damascus",
            Tz::Asia__Dhaka => "Asia/Dhaka",
            Tz::Asia__Dili => "Asia/Dili",
            Tz::Asia__Dubai => "Asia/Dubai",
            Tz::Asia__Dushanbe => "Asia/Dushanbe",
            Tz::Asia__Famagusta => "Asia/Famagusta",
            Tz::Asia__Gaza => "Asia/Gaza",
            Tz::Asia__Harbin => "Asia/Harbin",
            Tz::Asia__Hebron => "Asia/Hebron",
            Tz::Asia__Ho_Chi_Minh => "Asia/Ho_Chi_Minh",
            Tz::Asia__Hong_Kong => "Asia/Hong_Kong",
            Tz::Asia__Hovd => "Asia/Hovd",
            Tz::Asia__Irkutsk => "Asia/Irkutsk",
            Tz::Asia__Istanbul => "Asia/Istanbul",
            Tz::Asia__Jakarta => "Asia/Jakarta",
            Tz::Asia__Jayapura => "Asia/Jayapura",
            Tz::Asia__Jerusalem => "Asia/Jerusalem",
            Tz::Asia__Kabul => "Asia/Kabul",
            Tz::Asia__Kamchatka => "Asia/Kamchatka",
            Tz::Asia__Karachi => "Asia/Karachi",
            Tz::Asia__Kashgar => "Asia/Kashgar",
            Tz::Asia__Kathmandu => "Asia/Kathmandu",
            Tz::Asia__Katmandu => "Asia/Katmandu",
            Tz::Asia__Khandyga => "Asia/Khandyga",
            Tz::Asia__Kolkata => "Asia/Kolkata",
            Tz::Asia__Krasnoyarsk => "Asia/Krasnoyarsk",
            Tz::Asia__Kuala_Lumpur => "Asia/Kuala_Lumpur",
            Tz::Asia__Kuching => "Asia/Kuching",
            Tz::Asia__Kuwait => "Asia/Kuwait",
            Tz::Asia__Macao => "Asia/Macao",
            Tz::Asia__Macau => "Asia/Macau",
            Tz::Asia__Magadan => "Asia/Magadan",
            Tz::Asia__Makassar => "Asia/Makassar",
            Tz::Asia__Manila => "Asia/Manila",
            Tz::Asia__Muscat => "Asia/Muscat",
            Tz::Asia__Nicosia => "Asia/Nicosia",
            Tz::Asia__Novokuznetsk => "Asia/Novokuznetsk",
            Tz::Asia__Novosibirsk => "Asia/Novosibirsk",
            Tz::Asia__Omsk => "Asia/Omsk",
            Tz::Asia__Oral => "Asia/Oral",
            Tz::Asia__Phnom_Penh => "Asia/Phnom_Penh",
            Tz::Asia__Pontianak => "Asia/Pontianak",
            Tz::Asia__Pyongyang => "Asia/Pyongyang",
            Tz::Asia__Qatar => "Asia/Qatar",
            Tz::Asia__Qostanay => "Asia/Qostanay",
            Tz::Asia__Qyzylorda => "Asia/Qyzylorda",
            Tz::Asia__Rangoon => "Asia/Rangoon",
            Tz::Asia__Riyadh => "Asia/Riyadh",
            Tz::Asia__Saigon => "Asia/Saigon",
            Tz::Asia__Sakhalin => "Asia/Sakhalin",
            Tz::Asia__Samarkand => "Asia/Samarkand",
            Tz::Asia__Seoul => "Asia/Seoul",
            Tz::Asia__Shanghai => "Asia/Shanghai",
            Tz::Asia__Singapore => "Asia/Singapore",
            Tz::Asia__Srednekolymsk => "Asia/Srednekolymsk",
            Tz::Asia__Taipei => "Asia/Taipei",
            Tz::Asia__Tashkent => "Asia/Tashkent",
            Tz::Asia__Tbilisi => "Asia/Tbilisi",
            Tz::Asia__Tehran => "Asia/Tehran",
            Tz::Asia__Tel_Aviv => "Asia/Tel_Aviv",
            Tz::Asia__Thimbu => "Asia/Thimbu",
            Tz::Asia__Thimphu => "Asia/Thimphu",
            Tz::Asia__Tokyo => "Asia/Tokyo",
            Tz::Asia__Tomsk => "Asia/Tomsk",
            Tz::Asia__Ujung_Pandang => "Asia/Ujung_Pandang",
            Tz::Asia__Ulaanbaatar => "Asia/Ulaanbaatar",
            Tz::Asia__Ulan_Bator => "Asia/Ulan_Bator",
            Tz::Asia__Urumqi => "Asia/Urumqi",
            Tz::Asia__UstNera => "Asia/Ust-Nera",
            Tz::Asia__Vientiane => "Asia/Vientiane",
            Tz::Asia__Vladivostok => "Asia/Vladivostok",
            Tz::Asia__Yakutsk => "Asia/Yakutsk",
            Tz::Asia__Yangon => "Asia/Yangon",
            Tz::Asia__Yekaterinburg => "Asia/Yekaterinburg",
            Tz::Asia__Yerevan => "Asia/Yerevan",
            Tz::Atlantic__Azores => "Atlantic/Azores",
            Tz::Atlantic__Bermuda => "Atlantic/Bermuda",
            Tz::Atlantic__Canary => "Atlantic/Canary",
            Tz::Atlantic__Cape_Verde => "Atlantic/Cape_Verde",
            Tz::Atlantic__Faeroe => "Atlantic/Faeroe",
            Tz::Atlantic__Faroe => "Atlantic/Faroe",
            Tz::Atlantic__Jan_Mayen => "Atlantic/Jan_Mayen",
            Tz::Atlantic__Madeira => "Atlantic/Madeira",
            Tz::Atlantic__Reykjavik => "Atlantic/Reykjavik",
            Tz::Atlantic__South_Georgia => "Atlantic/South_Georgia",
            Tz::Atlantic__St_Helena => "Atlantic/St_Helena",
            Tz::Atlantic__Stanley => "Atlantic/Stanley",
            Tz::Australia__ACT => "Australia/ACT",
            Tz::Australia__Adelaide => "Australia/Adelaide",
            Tz::Australia__Brisbane => "Australia/Brisbane",
            Tz::Australia__Broken_Hill => "Australia/Broken_Hill",
            Tz::Australia__Canberra => "Australia/Canberra",
            Tz::Australia__Currie => "Australia/Currie",
            Tz::Australia__Darwin => "Australia/Darwin",
            Tz::Australia__Eucla => "Australia/Eucla",
            Tz::Australia__Hobart => "Australia/Hobart",
            Tz::Australia__LHI => "Australia/LHI",
            Tz::Australia__Lindeman => "Australia/Lindeman",
            Tz::Australia__Lord_Howe => "Australia/Lord_Howe",
            Tz::Australia__Melbourne => "Australia/Melbourne",
            Tz::Australia__NSW => "Australia/NSW",
            Tz::Australia__North => "Australia/North",
            Tz::Australia__Perth => "Australia/Perth",
            Tz::Australia__Queensland => "Australia/Queensland",
            Tz::Australia__South => "Australia/South",
            Tz::Australia__Sydney => "Australia/Sydney",
            Tz::Australia__Tasmania => "Australia/Tasmania",
            Tz::Australia__Victoria => "Australia/Victoria",
            Tz::Australia__West => "Australia/West",
            Tz::Australia__Yancowinna => "Australia/Yancowinna",
            Tz::Brazil__Acre => "Brazil/Acre",
            Tz::Brazil__DeNoronha => "Brazil/DeNoronha",
            Tz::Brazil__East => "Brazil/East",
            Tz::Brazil__West => "Brazil/West",
            Tz::CET => "CET",
            Tz::CST6CDT => "CST6CDT",
            Tz::Canada__Atlantic => "Canada/Atlantic",
            Tz::Canada__Central => "Canada/Central",
            Tz::Canada__Eastern => "Canada/Eastern",
            Tz::Canada__Mountain => "Canada/Mountain",
            Tz::Canada__Newfoundland => "Canada/Newfoundland",
            Tz::Canada__Pacific => "Canada/Pacific",
            Tz::Canada__Saskatchewan => "Canada/Saskatchewan",
            Tz::Canada__Yukon => "Canada/Yukon",
            Tz::Chile__Continental => "Chile/Continental",
            Tz::Chile__EasterIsland => "Chile/EasterIsland",
            Tz::Cuba => "Cuba",
            Tz::EET => "EET",
            Tz::EST => "EST",
            Tz::EST5EDT => "EST5EDT",
            Tz::Egypt => "Egypt",
            Tz::Eire => "Eire",
            Tz::Etc__GMT => "Etc/GMT",
            Tz::Etc__GMTPlus0 => "Etc/GMT+0",
            Tz::Etc__GMTPlus1 => "Etc/GMT+1",
            Tz::Etc__GMTPlus10 => "Etc/GMT+10",
            Tz::Etc__GMTPlus11 => "Etc/GMT+11",
            Tz::Etc__GMTPlus12 => "Etc/GMT+12",
            Tz::Etc__GMTPlus2 => "Etc/GMT+2",
            Tz::Etc__GMTPlus3 => "Etc/GMT+3",
            Tz::Etc__GMTPlus4 => "Etc/GMT+4",
            Tz::Etc__GMTPlus5 => "Etc/GMT+5",
            Tz::Etc__GMTPlus6 => "Etc/GMT+6",
            Tz::Etc__GMTPlus7 => "Etc/GMT+7",
            Tz::Etc__GMTPlus8 => "Etc/GMT+8",
            Tz::Etc__GMTPlus9 => "Etc/GMT+9",
            Tz::Etc__GMTMinus0 => "Etc/GMT-0",
            Tz::Etc__GMTMinus1 => "Etc/GMT-1",
            Tz::Etc__GMTMinus10 => "Etc/GMT-10",
            Tz::Etc__GMTMinus11 => "Etc/GMT-11",
            Tz::Etc__GMTMinus12 => "Etc/GMT-12",
            Tz::Etc__GMTMinus13 => "Etc/GMT-13",
            Tz::Etc__GMTMinus14 => "Etc/GMT-14",
            Tz::Etc__GMTMinus2 => "Etc/GMT-2",
            Tz::Etc__GMTMinus3 => "Etc/GMT-3",
            Tz::Etc__GMTMinus4 => "Etc/GMT-4",
            Tz::Etc__GMTMinus5 => "Etc/GMT-5",
            Tz::Etc__GMTMinus6 => "Etc/GMT-6",
            Tz::Etc__GMTMinus7 => "Etc/GMT-7",
            Tz::Etc__GMTMinus8 => "Etc/GMT-8",
            Tz::Etc__GMTMinus9 => "Etc/GMT-9",
            Tz::Etc__GMT0 => "Etc/GMT0",
            Tz::Etc__Greenwich => "Etc/Greenwich",
            Tz::Etc__UCT => "Etc/UCT",
            Tz::Etc__UTC => "Etc/UTC",
            Tz::Etc__Universal => "Etc/Universal",
            Tz::Etc__Zulu => "Etc/Zulu",
            Tz::Europe__Amsterdam => "Europe/Amsterdam",
            Tz::Europe__Andorra => "Europe/Andorra",
            Tz::Europe__Astrakhan => "Europe/Astrakhan",
            Tz::Europe__Athens => "Europe/Athens",
            Tz::Europe__Belfast => "Europe/Belfast",
            Tz::Europe__Belgrade => "Europe/Belgrade",
            Tz::Europe__Berlin => "Europe/Berlin",
            Tz::Europe__Bratislava => "Europe/Bratislava",
            Tz::Europe__Brussels => "Europe/Brussels",
            Tz::Europe__Bucharest => "Europe/Bucharest",
            Tz::Europe__Budapest => "Europe/Budapest",
            Tz::Europe__Busingen => "Europe/Busingen",
            Tz::Europe__Chisinau => "Europe/Chisinau",
            Tz::Europe__Copenhagen => "Europe/Copenhagen",
            Tz::Europe__Dublin => "Europe/Dublin",
            Tz::Europe__Gibraltar => "Europe/Gibraltar",
            Tz::Europe__Guernsey => "Europe/Guernsey",
            Tz::Europe__Helsinki => "Europe/Helsinki",
            Tz::Europe__Isle_of_Man => "Europe/Isle_of_Man",
            Tz::Europe__Istanbul => "Europe/Istanbul",
            Tz::Europe__Jersey => "Europe/Jersey",
            Tz::Europe__Kaliningrad => "Europe/Kaliningrad",
            Tz::Europe__Kiev => "Europe/Kiev",
            Tz::Europe__Kirov => "Europe/Kirov",
            Tz::Europe__Kyiv => "Europe/Kyiv",
            Tz::Europe__Lisbon => "Europe/Lisbon",
            Tz::Europe__Ljubljana => "Europe/Ljubljana",
            Tz::Europe__London => "Europe/London",
            Tz::Europe__Luxembourg => "Europe/Luxembourg",
            Tz::Europe__Madrid => "Europe/Madrid",
            Tz::Europe__Malta => "Europe/Malta",
            Tz::Europe__Mariehamn => "Europe/Mariehamn",
            Tz::Europe__Minsk => "Europe/Minsk",
            Tz::Europe__Monaco => "Europe/Monaco",
            Tz::Europe__Moscow => "Europe/Moscow",
            Tz::Europe__Nicosia => "Europe/Nicosia",
            Tz::Europe__Oslo => "Europe/Oslo",
            Tz::Europe__Paris => "Europe/Paris",
            Tz::Europe__Podgorica => "Europe/Podgorica",
            Tz::Europe__Prague => "Europe/Prague",
            Tz::Europe__Riga => "Europe/Riga",
            Tz::Europe__Rome => "Europe/Rome",
            Tz::Europe__Samara => "Europe/Samara",
            Tz::Europe__San_Marino => "Europe/San_Marino",
            Tz::Europe__Sarajevo => "Europe/Sarajevo",
            Tz::Europe__Saratov => "Europe/Saratov",
            Tz::Europe__Simferopol => "Europe/Simferopol",
            Tz::Europe__Skopje => "Europe/Skopje",
            Tz::Europe__Sofia => "Europe/Sofia",
            Tz::Europe__Stockholm => "Europe/Stockholm",
            Tz::Europe__Tallinn => "Europe/Tallinn",
            Tz::Europe__Tirane => "Europe/Tirane",
            Tz::Europe__Tiraspol => "Europe/Tiraspol",
            Tz::Europe__Ulyanovsk => "Europe/Ulyanovsk",
            Tz::Europe__Uzhgorod => "Europe/Uzhgorod",
            Tz::Europe__Vaduz => "Europe/Vaduz",
            Tz::Europe__Vatican => "Europe/Vatican",
            Tz::Europe__Vienna => "Europe/Vienna",
            Tz::Europe__Vilnius => "Europe/Vilnius",
            Tz::Europe__Volgograd => "Europe/Volgograd",
            Tz::Europe__Warsaw => "Europe/Warsaw",
            Tz::Europe__Zagreb => "Europe/Zagreb",
            Tz::Europe__Zaporozhye => "Europe/Zaporozhye",
            Tz::Europe__Zurich => "Europe/Zurich",
            Tz::GB => "GB",
            Tz::GBEire => "GB-Eire",
            Tz::GMT => "GMT",
            Tz::GMTPlus0 => "GMT+0",
            Tz::GMTMinus0 => "GMT-0",
            Tz::GMT0 => "GMT0",
            Tz::Greenwich => "Greenwich",
            Tz::HST => "HST",
            Tz::Hongkong => "Hongkong",
            Tz::Iceland => "Iceland",
            Tz::Indian__Antananarivo => "Indian/Antananarivo",
            Tz::Indian__Chagos => "Indian/Chagos",
            Tz::Indian__Christmas => "Indian/Christmas",
            Tz::Indian__Cocos => "Indian/Cocos",
            Tz::Indian__Comoro => "Indian/Comoro",
            Tz::Indian__Kerguelen => "Indian/Kerguelen",
            Tz::Indian__Mahe => "Indian/Mahe",
            Tz::Indian__Maldives => "Indian/Maldives",
            Tz::Indian__Mauritius => "Indian/Mauritius",
            Tz::Indian__Mayotte => "Indian/Mayotte",
            Tz::Indian__Reunion => "Indian/Reunion",
            Tz::Iran => "Iran",
            Tz::Israel => "Israel",
            Tz::Jamaica => "Jamaica",
            Tz::Japan => "Japan",
            Tz::Kwajalein => "Kwajalein",
            Tz::Libya => "Libya",
            Tz::MET => "MET",
            Tz::MST => "MST",
            Tz::MST7MDT => "MST7MDT",
            Tz::Mexico__BajaNorte => "Mexico/BajaNorte",
            Tz::Mexico__BajaSur => "Mexico/BajaSur",
            Tz::Mexico__General => "Mexico/General",
            Tz::NZ => "NZ",
            Tz::NZCHAT => "NZ-CHAT",
            Tz::Navajo => "Navajo",
            Tz::PRC => "PRC",
            Tz::PST8PDT => "PST8PDT",
            Tz::Pacific__Apia => "Pacific/Apia",
            Tz::Pacific__Auckland => "Pacific/Auckland",
            Tz::Pacific__Bougainville => "Pacific/Bougainville",
            Tz::Pacific__Chatham => "Pacific/Chatham",
            Tz::Pacific__Chuuk => "Pacific/Chuuk",
            Tz::Pacific__Easter => "Pacific/Easter",
            Tz::Pacific__Efate => "Pacific/Efate",
            Tz::Pacific__Enderbury => "Pacific/Enderbury",
            Tz::Pacific__Fakaofo => "Pacific/Fakaofo",
            Tz::Pacific__Fiji => "Pacific/Fiji",
            Tz::Pacific__Funafuti => "Pacific/Funafuti",
            Tz::Pacific__Galapagos => "Pacific/Galapagos",
            Tz::Pacific__Gambier => "Pacific/Gambier",
            Tz::Pacific__Guadalcanal => "Pacific/Guadalcanal",
            Tz::Pacific__Guam => "Pacific/Guam",
            Tz::Pacific__Honolulu => "Pacific/Honolulu",
            Tz::Pacific__Johnston => "Pacific/Johnston",
            Tz::Pacific__Kanton => "Pacific/Kanton",
            Tz::Pacific__Kiritimati => "Pacific/Kiritimati",
            Tz::Pacific__Kosrae => "Pacific/Kosrae",
            Tz::Pacific__Kwajalein => "Pacific/Kwajalein",
            Tz::Pacific__Majuro => "Pacific/Majuro",
            Tz::Pacific__Marquesas => "Pacific/Marquesas",
            Tz::Pacific__Midway => "Pacific/Midway",
            Tz::Pacific__Nauru => "Pacific/Nauru",
            Tz::Pacific__Niue => "Pacific/Niue",
            Tz::Pacific__Norfolk => "Pacific/Norfolk",
            Tz::Pacific__Noumea => "Pacific/Noumea",
            Tz::Pacific__Pago_Pago => "Pacific/Pago_Pago",
            Tz::Pacific__Palau => "Pacific/Palau",
            Tz::Pacific__Pitcairn => "Pacific/Pitcairn",
            Tz::Pacific__Pohnpei => "Pacific/Pohnpei",
            Tz::Pacific__Ponape => "Pacific/Ponape",
            Tz::Pacific__Port_Moresby => "Pacific/Port_Moresby",
            Tz::Pacific__Rarotonga => "Pacific/Rarotonga",
            Tz::Pacific__Saipan => "Pacific/Saipan",
            Tz::Pacific__Samoa => "Pacific/Samoa",
            Tz::Pacific__Tahiti => "Pacific/Tahiti",
            Tz::Pacific__Tarawa => "Pacific/Tarawa",
            Tz::Pacific__Tongatapu => "Pacific/Tongatapu",
            Tz::Pacific__Truk => "Pacific/Truk",
            Tz::Pacific__Wake => "Pacific/Wake",
            Tz::Pacific__Wallis => "Pacific/Wallis",
            Tz::Pacific__Yap => "Pacific/Yap",
            Tz::Poland => "Poland",
            Tz::Portugal => "Portugal",
            Tz::ROC => "ROC",
            Tz::ROK => "ROK",
            Tz::Singapore => "Singapore",
            Tz::Turkey => "Turkey",
            Tz::UCT => "UCT",
            Tz::US__Alaska => "US/Alaska",
            Tz::US__Aleutian => "US/Aleutian",
            Tz::US__Arizona => "US/Arizona",
            Tz::US__Central => "US/Central",
            Tz::US__EastIndiana => "US/East-Indiana",
            Tz::US__Eastern => "US/Eastern",
            Tz::US__Hawaii => "US/Hawaii",
            Tz::US__IndianaStarke => "US/Indiana-Starke",
            Tz::US__Michigan => "US/Michigan",
            Tz::US__Mountain => "US/Mountain",
            Tz::US__Pacific => "US/Pacific",
            Tz::US__Samoa => "US/Samoa",
            Tz::UTC => "UTC",
            Tz::Universal => "Universal",
            Tz::WSU => "W-SU",
            Tz::WET => "WET",
            Tz::Zulu => "Zulu",
        }
    }
}
impl Debug for Tz {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        f.write_str(self.name().as_ref())
    }
}

impl Display for Tz {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        f.write_str(self.name().as_ref())
    }
}

impl TimeSpans for Tz {
    fn timespans(&self) -> FixedTimespanSet {
        match *self {
            Tz::Africa__Abidjan => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Accra => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Addis_Ababa => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: "+0245" }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Algiers => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2486592732, FixedTimespan { utc_offset: 561, dst_offset: 0, name: "PMT" }),
                    (-1855958961, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-1689814800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-1680397200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-1665363600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-1648342800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-1635123600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-1616893200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-1604278800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-1585443600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-1574038800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-1552266000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-1539997200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-1531443600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-956365200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-950486400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-942012000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-812502000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-796262400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-781052400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-766630800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-733280400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-439430400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-212029200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (41468400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (54774000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (231724800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (246236400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (259545600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (275274000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (309740400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (325468800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (341802000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (357523200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 732,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Asmara => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: "+0245" }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Asmera => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: "+0245" }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Bamako => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Bangui => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: "LMT" }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: "+0030" }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Banjul => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Bissau => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830376660, FixedTimespan { utc_offset: -3600, dst_offset: 0, name: "-01" }),
                    (157770000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -3740,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Blantyre => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2109291020, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7820,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Brazzaville => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: "LMT" }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: "+0030" }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Bujumbura => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2109291020, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7820,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Cairo => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2185409109, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-929844000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-923108400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-906170400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-892868400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-875844000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-857790000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-844308000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-825822000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-812685600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-794199600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-779853600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-762663600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-399088800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-386650800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-368330400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-355114800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-336790800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-323654400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-305168400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-292032000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-273632400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-260496000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-242096400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-228960000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-210560400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-197424000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-178938000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-165801600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-147402000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-134265600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-115866000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-102643200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-84330000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-71107200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-52707600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-39484800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (-21171600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (-7948800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (10364400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (23587200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (41900400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (55123200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (73522800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (86745600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (105058800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (118281600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (136594800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (149817600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (168130800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (181353600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (199753200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (212976000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (231289200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (244512000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (262825200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (276048000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (294361200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (307584000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (325983600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (339206400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (357519600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (370742400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (396399600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (402278400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (426812400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (433814400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (452214000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (465436800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (483750000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (496972800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (515286000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (528508800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (546822000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (560044800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (578444400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (591667200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (610412400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (623203200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (641516400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (654739200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (673052400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (686275200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (704674800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (717897600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (736210800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (749433600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (767746800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (780969600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (799020000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (812322000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (830469600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (843771600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (861919200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (875221200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (893368800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (906670800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (925423200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (938725200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (956872800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (970174800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (988322400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1001624400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1019772000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1033074000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1051221600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1064523600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1083276000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1096578000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1114725600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1128027600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1146175200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1158872400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1177624800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1189112400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1209074400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1219957200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1240524000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1250802000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1272578400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1281474000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1284069600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1285880400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1400191200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1403816400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1406844000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1411678800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1682632800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1698354000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1714082400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1730408400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1745532000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1761858000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1776981600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1793307600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1809036000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1824757200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1840485600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1856206800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1871935200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1887656400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1903384800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1919710800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1934834400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1951160400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1966888800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (1982610000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1998338400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2014059600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2029788000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2045509200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2061237600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2076958800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2092687200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2109013200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2124136800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2140462800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2156191200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2171912400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2187640800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2203362000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2219090400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2234811600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2250540000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2266866000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2281989600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2298315600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2313439200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2329765200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2345493600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2361214800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2376943200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2392664400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2408392800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2424114000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2439842400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2456168400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2471292000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2487618000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2503346400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2519067600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2534796000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2550517200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2566245600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2581966800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2597695200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2614021200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2629144800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2645470800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2660594400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2676920400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2692648800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2708370000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2724098400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2739819600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2755548000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2771269200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2786997600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2803323600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2818447200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2834773200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2850501600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2866222800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2881951200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2897672400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2913400800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2929122000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2944850400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2960571600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (2976300000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (2992626000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3007749600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3024075600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3039804000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3055525200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3071253600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3086974800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3102703200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3118424400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3134152800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3150478800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3165602400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3181928400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3197052000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3213378000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3229106400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3244827600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3260556000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3276277200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3292005600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3307726800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3323455200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3339781200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3354904800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3371230800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3386959200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3402680400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3418408800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3434130000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3449858400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3465579600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3481308000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3497634000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3512757600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3529083600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3544207200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3560533200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3576261600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3591982800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3607711200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3623432400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3639160800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3654882000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3670610400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3686936400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3702060000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3718386000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3734114400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3749835600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3765564000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3781285200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3797013600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3812734800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3828463200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3844184400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3859912800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3876238800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3891362400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3907688400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3923416800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3939138000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3954866400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (3970587600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (3986316000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (4002037200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (4017765600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (4034091600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (4049215200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (4065541200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (4080664800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "EEST" }),
                    (4096990800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7509,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Casablanca => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1773012580, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (-956361600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (-950490000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (-942019200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (-761187600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (-617241600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (-605149200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (-81432000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (-71110800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (141264000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (147222000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (199756800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (207702000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (231292800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (244249200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (265507200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (271033200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (448243200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (504918000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1212278400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1220223600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1243814400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1250809200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1272758400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1281222000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1301788800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1312066800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1335664800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1342749600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1345428000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1348970400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1367114400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1373162400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1376100000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1382839200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1396144800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1403920800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1406944800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1414288800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1427594400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1434247200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1437271200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1445738400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1459044000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1465092000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1468116000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1477792800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1490493600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1495332000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1498960800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1509242400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1521943200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1526176800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1529200800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1540692000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1557021600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1560045600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1587261600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1590890400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1618106400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1621130400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1648346400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1651975200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1679191200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1682215200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1710036000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1713060000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1740276000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1743904800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1771120800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1774144800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1801965600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1804989600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1832205600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1835834400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1863050400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1866074400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1893290400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1896919200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1924135200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1927159200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1954980000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1958004000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1985220000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1988848800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2016064800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2019088800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2046304800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2049933600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2077149600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2080778400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2107994400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2111018400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2138234400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2141863200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2169079200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2172103200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2199924000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2202948000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2230164000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2233792800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2261008800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2264032800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2291248800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2294877600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2322093600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2325722400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2352938400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2355962400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2383178400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2386807200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2414023200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2417047200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2444868000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2447892000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2475108000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2478736800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2505952800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2508976800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2536192800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2539821600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2567037600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2570666400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2597882400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2600906400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2628122400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2631751200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2658967200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2661991200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2689812000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2692836000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2720052000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2723680800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2750896800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2753920800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2781136800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2784765600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2811981600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2815610400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2842826400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2845850400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2873066400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2876695200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2903911200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2906935200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2934756000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2937780000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2964996000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2968624800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2995840800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2998864800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3026080800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3029709600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3056925600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3060554400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3087770400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3090794400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3118010400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3121639200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3148855200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3151879200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3179700000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3182724000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3209940000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3213568800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3240784800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3243808800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3271024800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3274653600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3301869600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3305498400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3332714400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3335738400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3362954400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3366583200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3393799200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3396823200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3424644000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3427668000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3454884000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3458512800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3485728800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3488752800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3515968800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3519597600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3546813600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3549837600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3577658400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3580682400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3607898400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3611527200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3638743200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3641767200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3669588000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3672612000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3699828000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3703456800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -1820,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Ceuta => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2177451524, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-1630112400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-1616810400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-1442451600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-1427673600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-1379293200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-1364774400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-1348448400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-1333324800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-1316390400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-1301270400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (-81432000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (-71110800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (141264000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (147222000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (199756800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (207702000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (231292800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (244249200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (265507200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "WEST" }),
                    (271033200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "WET" }),
                    (448243200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (512528400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (528253200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (543978000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (559702800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (575427600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (591152400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (606877200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (622602000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (638326800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (654656400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (670381200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (686106000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (701830800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (717555600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (733280400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (749005200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (764730000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (780454800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (796179600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (811904400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (828234000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (846378000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (859683600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (877827600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (891133200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (909277200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (922582800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (941331600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (954032400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (972781200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (985482000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1004230800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1017536400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1035680400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1048986000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1067130000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1080435600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1099184400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1111885200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1130634000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1143334800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1162083600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1174784400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1193533200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1206838800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1224982800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1238288400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1256432400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1269738000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1288486800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1301187600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1319936400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1332637200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1351386000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1364691600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1382835600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1396141200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1414285200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1427590800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1445734800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1459040400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1477789200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1490490000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1509238800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1521939600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1540688400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1553994000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1572138000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1585443600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1603587600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1616893200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1635642000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1648342800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1667091600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1679792400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1698541200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1711846800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1729990800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1743296400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1761440400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1774746000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1792890000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1806195600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1824944400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1837645200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1856394000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1869094800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1887843600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1901149200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1919293200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1932598800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1950742800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1964048400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1982797200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1995498000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2014246800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2026947600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2045696400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2058397200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2077146000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2090451600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2108595600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2121901200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2140045200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2153350800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2172099600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2184800400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2203549200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2216250000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2234998800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2248304400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2266448400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2279754000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2297898000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2311203600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2329347600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2342653200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2361402000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2374102800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2392851600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2405552400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2424301200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2437606800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2455750800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2469056400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2487200400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2500506000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2519254800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2531955600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2550704400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2563405200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2582154000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2595459600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2613603600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2626909200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2645053200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2658358800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2676502800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2689808400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2708557200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2721258000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2740006800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2752707600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2771456400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2784762000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2802906000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2816211600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2834355600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2847661200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2866410000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2879110800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2897859600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2910560400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2929309200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2942010000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2960758800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (2974064400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (2992208400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3005514000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3023658000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3036963600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3055712400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3068413200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3087162000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3099862800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3118611600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3131917200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3150061200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3163366800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3181510800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3194816400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3212960400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3226266000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3245014800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3257715600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3276464400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3289165200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3307914000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3321219600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3339363600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3352669200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3370813200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3384118800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3402867600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3415568400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3434317200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3447018000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3465766800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3479072400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3497216400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3510522000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3528666000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3541971600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3560115600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3573421200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3592170000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3604870800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3623619600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3636320400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3655069200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3668374800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3686518800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3699824400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3717968400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3731274000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3750022800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3762723600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3781472400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3794173200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3812922000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3825622800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3844371600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3857677200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3875821200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3889126800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3907270800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3920576400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3939325200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3952026000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (3970774800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (3983475600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (4002224400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (4015530000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (4033674000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (4046979600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (4065123600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (4078429200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (4096573200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -1276,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Conakry => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Dakar => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Dar_es_Salaam => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: "+0245" }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Djibouti => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: "+0245" }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Douala => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: "LMT" }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: "+0030" }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__El_Aaiun => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1136070432, FixedTimespan { utc_offset: -3600, dst_offset: 0, name: "-01" }),
                    (198291600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (199756800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (207702000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (231292800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (244249200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (265507200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (271033200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1212278400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1220223600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1243814400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1250809200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1272758400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1281222000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1301788800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1312066800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1335664800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1342749600, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1345428000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1348970400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1367114400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1373162400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1376100000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1382839200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1396144800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1403920800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1406944800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1414288800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1427594400, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1434247200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1437271200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1445738400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1459044000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1465092000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1468116000, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1477792800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1490493600, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1495332000, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1498960800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1509242400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1521943200, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1526176800, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "+00" }),
                    (1529200800, FixedTimespan { utc_offset: 0, dst_offset: 3600, name: "+01" }),
                    (1540692000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1557021600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1560045600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1587261600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1590890400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1618106400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1621130400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1648346400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1651975200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1679191200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1682215200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1710036000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1713060000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1740276000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1743904800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1771120800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1774144800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1801965600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1804989600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1832205600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1835834400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1863050400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1866074400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1893290400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1896919200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1924135200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1927159200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1954980000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1958004000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (1985220000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (1988848800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2016064800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2019088800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2046304800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2049933600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2077149600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2080778400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2107994400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2111018400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2138234400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2141863200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2169079200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2172103200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2199924000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2202948000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2230164000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2233792800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2261008800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2264032800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2291248800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2294877600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2322093600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2325722400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2352938400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2355962400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2383178400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2386807200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2414023200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2417047200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2444868000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2447892000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2475108000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2478736800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2505952800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2508976800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2536192800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2539821600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2567037600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2570666400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2597882400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2600906400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2628122400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2631751200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2658967200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2661991200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2689812000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2692836000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2720052000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2723680800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2750896800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2753920800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2781136800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2784765600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2811981600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2815610400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2842826400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2845850400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2873066400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2876695200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2903911200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2906935200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2934756000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2937780000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2964996000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2968624800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (2995840800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (2998864800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3026080800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3029709600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3056925600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3060554400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3087770400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3090794400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3118010400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3121639200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3148855200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3151879200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3179700000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3182724000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3209940000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3213568800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3240784800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3243808800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3271024800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3274653600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3301869600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3305498400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3332714400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3335738400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3362954400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3366583200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3393799200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3396823200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3424644000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3427668000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3454884000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3458512800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3485728800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3488752800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3515968800, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3519597600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3546813600, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3549837600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3577658400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3580682400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3607898400, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3611527200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3638743200, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3641767200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3669588000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3672612000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                    (3699828000, FixedTimespan { utc_offset: 3600, dst_offset: -3600, name: "+00" }),
                    (3703456800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "+01" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -3168,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Freetown => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Gaborone => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2109291020, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7820,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Harare => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2109291020, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7820,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Johannesburg => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2458173120, FixedTimespan { utc_offset: 5400, dst_offset: 0, name: "SAST" }),
                    (-2109288600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "SAST" }),
                    (-860976000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "SAST" }),
                    (-845254800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "SAST" }),
                    (-829526400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "SAST" }),
                    (-813805200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "SAST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 6720,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Juba => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1230775588, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (10360800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (24786000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (41810400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (56322000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (73432800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (87944400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (104882400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (119480400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (136332000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (151016400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (167781600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (182552400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (199231200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (214174800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (230680800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (245710800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (262735200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (277246800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (294184800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (308782800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (325634400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (340405200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (357084000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (371941200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (388533600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (403477200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (419983200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (435013200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (452037600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (466635600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (483487200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (498171600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (947930400, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                    (1612126800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7588,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Kampala => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: "+0245" }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Khartoum => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1230775808, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (10360800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (24786000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (41810400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (56322000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (73432800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (87944400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (104882400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (119480400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (136332000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (151016400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (167781600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (182552400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (199231200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (214174800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (230680800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (245710800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (262735200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (277246800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (294184800, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (308782800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (325634400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (340405200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (357084000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (371941200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (388533600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (403477200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (419983200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (435013200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (452037600, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (466635600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (483487200, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "CAST" }),
                    (498171600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (947930400, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                    (1509483600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7808,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Kigali => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2109291020, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7820,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Kinshasa => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: "LMT" }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: "+0030" }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Lagos => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: "LMT" }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: "+0030" }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Libreville => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: "LMT" }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: "+0030" }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Lome => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Luanda => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: "LMT" }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: "+0030" }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Lubumbashi => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2109291020, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7820,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Lusaka => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2109291020, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7820,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Malabo => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: "LMT" }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: "+0030" }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Maputo => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2109291020, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 7820,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Maseru => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2458173120, FixedTimespan { utc_offset: 5400, dst_offset: 0, name: "SAST" }),
                    (-2109288600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "SAST" }),
                    (-860976000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "SAST" }),
                    (-845254800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "SAST" }),
                    (-829526400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "SAST" }),
                    (-813805200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "SAST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 6720,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Mbabane => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2458173120, FixedTimespan { utc_offset: 5400, dst_offset: 0, name: "SAST" }),
                    (-2109288600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "SAST" }),
                    (-860976000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "SAST" }),
                    (-845254800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "SAST" }),
                    (-829526400, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "SAST" }),
                    (-813805200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "SAST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 6720,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Mogadishu => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: "+0245" }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Monrovia => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2776979812, FixedTimespan { utc_offset: -2588, dst_offset: 0, name: "MMT" }),
                    (-1604359012, FixedTimespan { utc_offset: -2670, dst_offset: 0, name: "MMT" }),
                    (63593070, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -2588,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Nairobi => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1946168836, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1309746600, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                    (-1261969200, FixedTimespan { utc_offset: 9000, dst_offset: 0, name: "+0230" }),
                    (-1041388200, FixedTimespan { utc_offset: 9900, dst_offset: 0, name: "+0245" }),
                    (-865305900, FixedTimespan { utc_offset: 10800, dst_offset: 0, name: "EAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 8836,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Ndjamena => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830387612, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                    (308703600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "WAST" }),
                    (321314400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 3612,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Niamey => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: "LMT" }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: "+0030" }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Nouakchott => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Ouagadougou => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__PortoNovo => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2035584815, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                    (-1940889600, FixedTimespan { utc_offset: 815, dst_offset: 0, name: "LMT" }),
                    (-1767226415, FixedTimespan { utc_offset: 1800, dst_offset: 0, name: "+0030" }),
                    (-1588465800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 815,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Sao_Tome => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2713912016, FixedTimespan { utc_offset: -2205, dst_offset: 0, name: "LMT" }),
                    (-1830381795, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                    (1514768400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "WAT" }),
                    (1546304400, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 1616,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Timbuktu => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1830383032, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -968,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Tripoli => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1577926364, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-574902000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-568087200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-512175600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-504928800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-449888400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-441856800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-347158800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (378684000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (386463600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (402271200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (417999600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (433807200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (449622000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (465429600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (481590000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (496965600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (512953200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (528674400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (544230000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (560037600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (575852400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (591660000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (607388400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (623196000, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (641775600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (844034400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (860108400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (875916000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                    (1352505600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1364515200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1382659200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "EET" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 3164,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Tunis => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2797202444, FixedTimespan { utc_offset: 561, dst_offset: 0, name: "PMT" }),
                    (-1855958961, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-969242400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-950493600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-941940000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-891136800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-877827600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-857257200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-844556400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-842918400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-842223600, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-828230400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-812502000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-796269600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (-781052400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (-766634400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (231202800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (243903600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (262825200, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (276044400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (581122800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (591145200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (606870000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (622594800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (641516400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (654649200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1114902000, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1128038400, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1143334800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1162083600, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1174784400, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1193533200, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                    (1206838800, FixedTimespan { utc_offset: 3600, dst_offset: 3600, name: "CEST" }),
                    (1224982800, FixedTimespan { utc_offset: 3600, dst_offset: 0, name: "CET" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 2444,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::Africa__Windhoek => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2458170504, FixedTimespan { utc_offset: 5400, dst_offset: 0, name: "+0130" }),
                    (-2109288600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "SAST" }),
                    (-860976000, FixedTimespan { utc_offset: 7200, dst_offset: 3600, name: "SAST" }),
                    (-845254800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "SAST" }),
                    (637970400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (764200800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (778640400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (796780800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (810090000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (828835200, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (841539600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (860284800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (873594000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (891734400, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (905043600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (923184000, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (936493200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (954633600, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (967942800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (986083200, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (999392400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1018137600, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1030842000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1049587200, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1062896400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1081036800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1094346000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1112486400, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1125795600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1143936000, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1157245200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1175385600, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1188694800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1207440000, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1220749200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1238889600, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1252198800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1270339200, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1283648400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1301788800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1315098000, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1333238400, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1346547600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1365292800, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1377997200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1396742400, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1410051600, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1428192000, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1441501200, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1459641600, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1472950800, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                    (1491091200, FixedTimespan { utc_offset: 7200, dst_offset: -3600, name: "WAT" }),
                    (1504400400, FixedTimespan { utc_offset: 7200, dst_offset: 0, name: "CAT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 4104,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Adak => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-3225223727, FixedTimespan { utc_offset: -42398, dst_offset: 0, name: "LMT" }),
                    (-2188944802, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "NST" }),
                    (-880196400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "NWT" }),
                    (-769395600, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "NPT" }),
                    (-765374400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "NST" }),
                    (-86878800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (-21466800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (-5745600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (9982800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (25704000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (41432400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (57758400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (73486800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (89208000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (104936400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (120657600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (126709200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (152107200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (162392400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (183556800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (199285200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (215611200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (230734800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (247060800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (262789200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (278510400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (294238800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (309960000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (325688400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (341409600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (357138000, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (372859200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (388587600, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (404913600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (420037200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (436363200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (439034400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (452088000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (467809200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (483537600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (499258800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (514987200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (530708400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (544622400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (562158000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (576072000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (594212400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (607521600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (625662000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (638971200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (657111600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (671025600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (688561200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (702475200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (720010800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (733924800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (752065200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (765374400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (783514800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (796824000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (814964400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (828878400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (846414000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (860328000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (877863600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (891777600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (909313200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (923227200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (941367600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (954676800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (972817200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (986126400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1004266800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1018180800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1035716400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1049630400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1067166000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1081080000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1099220400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1112529600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1130670000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1143979200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1162119600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1173614400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1194174000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1205064000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1225623600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1236513600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1257073200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1268568000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1289127600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1300017600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1320577200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1331467200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1352026800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1362916800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1383476400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1394366400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1414926000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1425816000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1446375600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1457870400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1478430000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1489320000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1509879600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1520769600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1541329200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1552219200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1572778800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1583668800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1604228400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1615723200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1636282800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1647172800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1667732400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1678622400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1699182000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1710072000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1730631600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1741521600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1762081200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1772971200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1793530800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1805025600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1825585200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1836475200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1857034800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1867924800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1888484400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1899374400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1919934000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1930824000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1951383600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1962878400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1983438000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1994328000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2014887600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2025777600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2046337200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2057227200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2077786800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2088676800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2109236400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2120126400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2140686000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2152180800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2172740400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2183630400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2204190000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2215080000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2235639600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2246529600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2267089200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2277979200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2298538800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2309428800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2329988400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2341483200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2362042800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2372932800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2393492400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2404382400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2424942000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2435832000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2456391600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2467281600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2487841200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2499336000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2519895600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2530785600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2551345200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2562235200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2582794800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2593684800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2614244400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2625134400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2645694000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2656584000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2677143600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2688638400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2709198000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2720088000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2740647600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2751537600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2772097200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2782987200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2803546800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2814436800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2834996400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2846491200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2867050800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2877940800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2898500400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2909390400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2929950000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2940840000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2961399600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2972289600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2992849200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3003739200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3024298800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3035793600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3056353200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3067243200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3087802800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3098692800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3119252400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3130142400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3150702000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3161592000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3182151600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3193041600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3213601200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3225096000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3245655600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3256545600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3277105200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3287995200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3308554800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3319444800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3340004400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3350894400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3371454000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3382948800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3403508400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3414398400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3434958000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3445848000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3466407600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3477297600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3497857200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3508747200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3529306800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3540196800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3560756400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3572251200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3592810800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3603700800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3624260400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3635150400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3655710000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3666600000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3687159600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3698049600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3718609200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3730104000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3750663600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3761553600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3782113200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3793003200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3813562800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3824452800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3845012400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3855902400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3876462000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3887352000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3907911600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3919406400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3939966000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3950856000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3971415600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3982305600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (4002865200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (4013755200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (4034314800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (4045204800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (4065764400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (4076654400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (4097214000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 44002,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Anchorage => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-3225223727, FixedTimespan { utc_offset: -35976, dst_offset: 0, name: "LMT" }),
                    (-2188951224, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AST" }),
                    (-880200000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AWT" }),
                    (-769395600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "APT" }),
                    (-765378000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AST" }),
                    (-86882400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (-21470400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (-5749200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (9979200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (25700400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (41428800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (57754800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (73483200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (89204400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (104932800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (120654000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (126705600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (152103600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (162388800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (183553200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (199281600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (215607600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (230731200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (247057200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (262785600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (278506800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (294235200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (309956400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (325684800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (341406000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (357134400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (372855600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (388584000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (404910000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (420033600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "AHDT" }),
                    (436359600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "YST" }),
                    (439030800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (452084400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (467805600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (483534000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (499255200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (514983600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (530704800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (544618800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (562154400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (576068400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (594208800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (607518000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (625658400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (638967600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (657108000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (671022000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (688557600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (702471600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (720007200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (733921200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (752061600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (765370800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (783511200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (796820400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (814960800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (828874800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (846410400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (860324400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (877860000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (891774000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (909309600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (923223600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (941364000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (954673200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (972813600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (986122800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1004263200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1018177200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1035712800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1049626800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1067162400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1081076400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1099216800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1112526000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1130666400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1143975600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1162116000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1173610800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1194170400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1205060400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1225620000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1236510000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1257069600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1268564400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1289124000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1300014000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1320573600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1331463600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1352023200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1362913200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1383472800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1394362800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1414922400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1425812400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1446372000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1457866800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1478426400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1489316400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1509876000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1520766000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1541325600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1552215600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1572775200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1583665200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1604224800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1615719600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1636279200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1647169200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1667728800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1678618800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1699178400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1710068400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1730628000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1741518000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1762077600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1772967600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1793527200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1805022000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1825581600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1836471600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1857031200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1867921200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1888480800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1899370800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1919930400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1930820400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1951380000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1962874800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (1983434400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (1994324400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2014884000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2025774000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2046333600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2057223600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2077783200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2088673200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2109232800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2120122800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2140682400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2152177200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2172736800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2183626800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2204186400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2215076400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2235636000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2246526000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2267085600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2277975600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2298535200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2309425200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2329984800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2341479600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2362039200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2372929200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2393488800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2404378800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2424938400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2435828400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2456388000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2467278000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2487837600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2499332400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2519892000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2530782000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2551341600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2562231600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2582791200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2593681200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2614240800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2625130800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2645690400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2656580400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2677140000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2688634800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2709194400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2720084400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2740644000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2751534000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2772093600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2782983600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2803543200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2814433200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2834992800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2846487600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2867047200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2877937200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2898496800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2909386800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2929946400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2940836400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2961396000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (2972286000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (2992845600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3003735600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3024295200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3035790000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3056349600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3067239600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3087799200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3098689200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3119248800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3130138800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3150698400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3161588400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3182148000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3193038000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3213597600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3225092400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3245652000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3256542000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3277101600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3287991600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3308551200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3319441200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3340000800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3350890800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3371450400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3382945200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3403504800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3414394800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3434954400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3445844400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3466404000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3477294000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3497853600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3508743600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3529303200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3540193200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3560752800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3572247600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3592807200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3603697200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3624256800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3635146800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3655706400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3666596400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3687156000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3698046000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3718605600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3730100400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3750660000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3761550000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3782109600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3792999600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3813559200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3824449200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3845008800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3855898800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3876458400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3887348400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3907908000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3919402800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3939962400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3950852400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (3971412000, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (3982302000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (4002861600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (4013751600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (4034311200, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (4045201200, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (4065760800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                    (4076650800, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "AKDT" }),
                    (4097210400, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "AKST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 50424,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Anguilla => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "AWT" }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "APT" }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Antigua => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "AWT" }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "APT" }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Araguaina => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767214032, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-1206957600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-1191362400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-1175374800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-1159826400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-633819600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-622069200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-602283600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-591832800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-570747600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-560210400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-539125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-531352800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-191365200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-184197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-155163600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-150069600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-128898000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-121125600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-99954000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-89589600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-68418000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-57967200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (499748400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (511236000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (530593200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (540266400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (562129200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (571197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (592974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (602042400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (634701600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (813726000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (824004000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (844570800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (856058400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (876106800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (888717600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (908074800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (919562400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (951616800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (970974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (982461600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1003028400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1013911200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1036292400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1045360800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1350788400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1361066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -11568,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Buenos_Aires => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372097972, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667965600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1224385200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1237082400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14028,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Catamarca => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096212, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15788,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__ComodRivadavia => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096212, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15788,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Cordoba => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096592, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1224385200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1237082400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15408,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Jujuy => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096328, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (657086400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (669178800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (686721600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15672,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__La_Rioja => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372095956, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667792800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (673588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16044,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Mendoza => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372095484, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (655963200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (667796400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (687499200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (699418800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (719380800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1085281200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1096171200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16516,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Rio_Gallegos => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372095388, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667965600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16612,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Salta => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096300, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15700,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__San_Juan => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372095556, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667792800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (673588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1085972400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1090728000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16444,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__San_Luis => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096076, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (637380000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (655963200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (667796400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (675748800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1085972400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1090728000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1200880800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1205031600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1223784000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1236481200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1255233600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15924,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Tucuman => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096348, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1087099200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1224385200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1237082400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15652,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Argentina__Ushuaia => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372095608, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667965600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1085886000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16392,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Aruba => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "AWT" }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "APT" }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Asuncion => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524507760, FixedTimespan { utc_offset: -13840, dst_offset: 0, name: "AMT" }),
                    (-1206389360, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (86760000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (134017200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (181368000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (194497200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (212990400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (226033200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (244526400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (257569200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (276062400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (291783600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (307598400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (323406000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (339220800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (354942000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (370756800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (386478000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (402292800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (418014000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (433828800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (449636400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (465451200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (481172400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (496987200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (512708400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (528523200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (544244400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (560059200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (575866800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (591681600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (607402800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (625032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (638938800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (654753600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (670474800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (686721600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (699418800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (718257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (733546800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (749448000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (762318000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (780984000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (793767600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (812520000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (825649200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (844574400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (856666800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (876024000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (888721200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (907473600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (920775600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (938923200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952225200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (970372800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (983674800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1002427200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1018148400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1030852800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1049598000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1062907200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1081047600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1097985600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1110682800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1129435200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1142132400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1160884800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1173582000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1192939200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1205031600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1224388800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1236481200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1255838400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1270954800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1286078400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1302404400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1317528000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1333854000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1349582400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1364094000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1381032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1395543600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1412481600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1426993200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1443931200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1459047600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1475380800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1490497200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1506830400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1521946800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1538884800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1553396400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1570334400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1584846000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1601784000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1616900400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1633233600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1648350000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1664683200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1679799600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1696132800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1711249200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1728187200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1742698800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1759636800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1774148400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1791086400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1806202800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1822536000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1837652400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1853985600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1869102000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1886040000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1900551600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1917489600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1932001200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1948939200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1964055600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1980388800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1995505200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2011838400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2026954800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2043288000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2058404400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2075342400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2089854000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2106792000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2121303600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2138241600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2153358000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2169691200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2184807600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2201140800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2216257200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2233195200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2247706800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2264644800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2279156400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2296094400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2310606000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2327544000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2342660400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2358993600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2374110000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2390443200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2405559600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2422497600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2437009200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2453947200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2468458800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2485396800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2500513200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2516846400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2531962800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2548296000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2563412400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2579745600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2594862000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2611800000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2626311600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2643249600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2657761200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2674699200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2689815600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2706148800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2721265200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2737598400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2752714800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2769652800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2784164400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2801102400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2815614000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2832552000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2847668400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2864001600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2879118000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2895451200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2910567600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2926900800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2942017200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2958955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (2973466800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (2990404800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3004916400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3021854400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3036970800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3053304000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3068420400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3084753600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3099870000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3116808000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3131319600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3148257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3162769200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3179707200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3194218800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3211156800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3226273200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3242606400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3257722800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3274056000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3289172400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3306110400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3320622000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3337560000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3352071600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3369009600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3384126000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3400459200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3415575600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3431908800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3447025200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3463358400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3478474800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3495412800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3509924400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3526862400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3541374000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3558312000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3573428400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3589761600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3604878000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3621211200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3636327600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3653265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3667777200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3684715200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3699226800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3716164800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3731281200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3747614400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3762730800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3779064000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3794180400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3810513600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3825630000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3842568000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3857079600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3874017600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3888529200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3905467200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3920583600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3936916800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3952033200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (3968366400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (3983482800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (4000420800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (4014932400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (4031870400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (4046382000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (4063320000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (4077831600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (4094769600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -13840,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Atikokan => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524502512, FixedTimespan { utc_offset: -19176, dst_offset: 0, name: "CMT" }),
                    (-1946918424, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -19088,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Atka => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-3225223727, FixedTimespan { utc_offset: -42398, dst_offset: 0, name: "LMT" }),
                    (-2188944802, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "NST" }),
                    (-880196400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "NWT" }),
                    (-769395600, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "NPT" }),
                    (-765374400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "NST" }),
                    (-86878800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (-21466800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (-5745600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (9982800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (25704000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (41432400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (57758400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (73486800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (89208000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (104936400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (120657600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (126709200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (152107200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (162392400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (183556800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (199285200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (215611200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (230734800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (247060800, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (262789200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (278510400, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (294238800, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (309960000, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (325688400, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (341409600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (357138000, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (372859200, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (388587600, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (404913600, FixedTimespan { utc_offset: -39600, dst_offset: 0, name: "BST" }),
                    (420037200, FixedTimespan { utc_offset: -39600, dst_offset: 3600, name: "BDT" }),
                    (436363200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "AHST" }),
                    (439034400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (452088000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (467809200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (483537600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (499258800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (514987200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (530708400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (544622400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (562158000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (576072000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (594212400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (607521600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (625662000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (638971200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (657111600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (671025600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (688561200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (702475200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (720010800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (733924800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (752065200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (765374400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (783514800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (796824000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (814964400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (828878400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (846414000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (860328000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (877863600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (891777600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (909313200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (923227200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (941367600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (954676800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (972817200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (986126400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1004266800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1018180800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1035716400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1049630400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1067166000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1081080000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1099220400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1112529600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1130670000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1143979200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1162119600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1173614400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1194174000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1205064000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1225623600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1236513600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1257073200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1268568000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1289127600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1300017600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1320577200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1331467200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1352026800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1362916800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1383476400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1394366400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1414926000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1425816000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1446375600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1457870400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1478430000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1489320000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1509879600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1520769600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1541329200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1552219200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1572778800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1583668800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1604228400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1615723200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1636282800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1647172800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1667732400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1678622400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1699182000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1710072000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1730631600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1741521600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1762081200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1772971200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1793530800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1805025600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1825585200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1836475200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1857034800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1867924800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1888484400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1899374400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1919934000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1930824000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1951383600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1962878400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (1983438000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (1994328000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2014887600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2025777600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2046337200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2057227200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2077786800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2088676800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2109236400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2120126400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2140686000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2152180800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2172740400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2183630400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2204190000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2215080000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2235639600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2246529600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2267089200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2277979200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2298538800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2309428800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2329988400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2341483200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2362042800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2372932800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2393492400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2404382400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2424942000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2435832000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2456391600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2467281600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2487841200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2499336000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2519895600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2530785600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2551345200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2562235200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2582794800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2593684800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2614244400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2625134400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2645694000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2656584000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2677143600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2688638400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2709198000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2720088000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2740647600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2751537600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2772097200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2782987200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2803546800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2814436800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2834996400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2846491200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2867050800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2877940800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2898500400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2909390400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2929950000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2940840000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2961399600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (2972289600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (2992849200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3003739200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3024298800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3035793600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3056353200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3067243200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3087802800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3098692800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3119252400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3130142400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3150702000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3161592000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3182151600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3193041600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3213601200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3225096000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3245655600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3256545600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3277105200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3287995200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3308554800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3319444800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3340004400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3350894400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3371454000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3382948800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3403508400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3414398400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3434958000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3445848000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3466407600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3477297600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3497857200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3508747200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3529306800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3540196800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3560756400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3572251200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3592810800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3603700800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3624260400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3635150400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3655710000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3666600000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3687159600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3698049600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3718609200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3730104000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3750663600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3761553600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3782113200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3793003200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3813562800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3824452800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3845012400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3855902400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3876462000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3887352000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3907911600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3919406400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3939966000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3950856000, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (3971415600, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (3982305600, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (4002865200, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (4013755200, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (4034314800, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (4045204800, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (4065764400, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                    (4076654400, FixedTimespan { utc_offset: -36000, dst_offset: 3600, name: "HDT" }),
                    (4097214000, FixedTimespan { utc_offset: -36000, dst_offset: 0, name: "HST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 44002,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Bahia => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767216356, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-1206957600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-1191362400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-1175374800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-1159826400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-633819600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-622069200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-602283600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-591832800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-570747600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-560210400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-539125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-531352800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-191365200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-184197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-155163600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-150069600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-128898000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-121125600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-99954000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-89589600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-68418000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-57967200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (499748400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (511236000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (530593200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (540266400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (562129200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (571197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (592974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (602042400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (634701600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (666756000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (697600800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719982000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (728445600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (750826800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (761709600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (782276400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (793159200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (813726000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (824004000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (844570800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (856058400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (876106800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (888717600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (908074800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (919562400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (951616800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (970974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (982461600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1003028400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1013911200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1036292400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1045360800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1318734000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1330221600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -9244,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Bahia_Banderas => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1514714340, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1343066400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1234807200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1220292000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1207159200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1191344400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-873828000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-661539600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (28800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (828867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (846403200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (860317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (877852800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (989139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1001836800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1175418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1193558400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1207472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1225008000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1238922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1256457600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1270371600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1288508400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1301817600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1319958000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1333267200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1351407600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1365321600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1382857200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1396771200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1414306800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1428220800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1445756400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1459670400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1477810800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1491120000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1509260400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1522569600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1540710000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1554624000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1572159600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1586073600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1603609200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1617523200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1635663600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1648972800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1667113200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -25260,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Barbados => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1841256091, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-874263600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-862682400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-841604400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-830714400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-811882800, FixedTimespan { utc_offset: -14400, dst_offset: 1800, name: "-0330" }),
                    (-798660000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (234943200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (244616400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (261554400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (276066000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (293004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (307515600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (325058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (338706000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14309,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Belem => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767213964, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-1206957600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-1191362400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-1175374800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-1159826400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-633819600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-622069200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-602283600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-591832800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-570747600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-560210400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-539125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-531352800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-191365200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-184197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-155163600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-150069600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-128898000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-121125600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-99954000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-89589600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-68418000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-57967200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (499748400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (511236000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (530593200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (540266400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (562129200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (571197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -11636,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Belize => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1822500432, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1616954400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1606069800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1585504800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1574015400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1554055200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1542565800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1522605600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1511116200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1490551200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1479666600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1459101600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1448217000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1427652000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1416162600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1396202400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1384713000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1364752800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1353263400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1333303200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1321813800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1301248800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1290364200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1269799200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1258914600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1238349600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1226860200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1206900000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1195410600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1175450400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1163961000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1143396000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1132511400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1111946400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1101061800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1080496800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1069612200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1049047200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1037557800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1017597600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-1006108200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-986148000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-974658600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-954093600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-943209000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-922644000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-911759400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-891194400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-879705000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-868212000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CWT" }),
                    (-769395600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CPT" }),
                    (-758746800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-701892000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-690402600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-670442400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-658953000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-638992800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-627503400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-606938400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-596053800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-575488800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-564604200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-544039200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-532549800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-512589600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-501100200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-481140000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-469650600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-449690400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-438201000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-417636000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-406751400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-386186400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-375301800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-354736800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-343247400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-323287200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-311797800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-291837600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-280348200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-259783200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-248898600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-228333600, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-217449000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-196884000, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-185999400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-165434400, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-153945000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-133984800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-122495400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-102535200, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-91045800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-70480800, FixedTimespan { utc_offset: -21600, dst_offset: 1800, name: "-0530" }),
                    (-59596200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (123919200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (129618000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (409039200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (413874000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -21168,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__BlancSablon => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "AWT" }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "APT" }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Boa_Vista => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767211040, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1206954000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1191358800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1175371200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1159822800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-633816000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-622065600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-602280000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-591829200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-570744000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-560206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-539121600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-531349200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-191361600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-155160000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-150066000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-128894400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-99950400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-89586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-68414400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-57963600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (499752000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (511239600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (530596800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (540270000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (562132800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (571201200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (938923200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (951620400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (970977600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (971578800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14560,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Bogota => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2707671824, FixedTimespan { utc_offset: -17776, dst_offset: 0, name: "BMT" }),
                    (-1739041424, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (704869200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (729057600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -17776,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Boise => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2717612111, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-1633269600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-1615129200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-1601820000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-1583679600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-1471788000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-880210800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MWT" }),
                    (-769395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MPT" }),
                    (-765388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-84380400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-68659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-52930800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-37209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-21481200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-5760000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (9968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (25689600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (41418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (57744000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (73472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (89193600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (104922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (120643200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (129114000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (152092800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (162378000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (183542400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (199270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (215596800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (230720400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (247046400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (262774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (278496000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (294224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (309945600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (325674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (341395200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (357123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (372844800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (388573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (404899200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (420022800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (436348800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (452077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (467798400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (483526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (499248000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (514976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (530697600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (544611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (562147200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (576061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (594201600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (607510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (625651200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (638960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (657100800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (671014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (688550400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (702464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (720000000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (733914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (752054400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (765363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (783504000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (796813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (814953600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (828867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (846403200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (860317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (877852800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (986115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1004256000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1173603600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1194163200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1205053200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1225612800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1236502800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1257062400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1268557200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1289116800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1300006800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1320566400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1331456400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1352016000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1362906000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1383465600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1394355600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1414915200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1425805200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1446364800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1457859600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1478419200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1489309200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1509868800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1520758800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1541318400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1552208400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1572768000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1583658000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1604217600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1615712400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1636272000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1647162000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1667721600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1678611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1699171200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1710061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1730620800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1741510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1762070400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1772960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1793520000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1805014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1825574400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1836464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1857024000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1867914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1888473600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1899363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1919923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1930813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1951372800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1962867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1983427200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1994317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2014876800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2025766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2046326400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2057216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2077776000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2088666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2109225600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2120115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2140675200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2152170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2172729600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2183619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2204179200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2215069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2235628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2246518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2267078400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2277968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2298528000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2309418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2329977600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2341472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2362032000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2372922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2393481600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2404371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2424931200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2435821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2456380800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2467270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2487830400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2499325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2519884800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2530774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2551334400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2562224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2582784000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2593674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2614233600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2625123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2645683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2656573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2677132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2688627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2709187200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2720077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2740636800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2751526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2772086400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2782976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2803536000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2814426000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2834985600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2846480400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2867040000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2877930000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2898489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2909379600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2929939200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2940829200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2961388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2972278800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2992838400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3003728400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3024288000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3035782800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3056342400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3067232400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3087792000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3098682000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3119241600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3130131600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3150691200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3161581200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3182140800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3193030800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3213590400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3225085200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3245644800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3256534800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3277094400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3287984400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3308544000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3319434000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3339993600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3350883600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3371443200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3382938000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3403497600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3414387600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3434947200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3445837200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3466396800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3477286800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3497846400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3508736400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3529296000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3540186000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3560745600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3572240400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3592800000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3603690000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3624249600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3635139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3655699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3666589200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3687148800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3698038800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3718598400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3730093200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3750652800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3761542800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3782102400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3792992400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3813552000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3824442000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3845001600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3855891600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3876451200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3887341200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3907900800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3919395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3939955200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3950845200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3971404800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3982294800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4002854400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4013744400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4034304000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4045194000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4065753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4076643600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4097203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -27889,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Buenos_Aires => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372097972, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667965600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (687927600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1224385200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1237082400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14028,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Cambridge_Bay => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1577923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-880210800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MWT" }),
                    (-769395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MPT" }),
                    (-765388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (73472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (89193600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (104922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (120643200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (136371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (152092800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (167821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (183542400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (199270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (215596800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (230720400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (247046400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (262774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (278496000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (294224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (309945600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (325674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (341395200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (357123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (372844800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (388573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (404899200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (420022800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (436348800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (452077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (467798400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (483526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (499248000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (514976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (530697600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (544611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (562147200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (576061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (594201600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (607510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (625651200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (638960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (657100800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (671014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (688550400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (702464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (720000000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (733914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (752054400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (765363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (783504000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (796813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (814953600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (828867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (846403200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (860317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (877852800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (941356800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (954662400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (972802800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (973400400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (986115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1004256000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1173603600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1194163200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1205053200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1225612800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1236502800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1257062400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1268557200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1289116800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1300006800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1320566400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1331456400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1352016000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1362906000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1383465600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1394355600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1414915200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1425805200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1446364800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1457859600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1478419200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1489309200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1509868800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1520758800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1541318400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1552208400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1572768000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1583658000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1604217600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1615712400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1636272000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1647162000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1667721600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1678611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1699171200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1710061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1730620800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1741510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1762070400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1772960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1793520000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1805014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1825574400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1836464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1857024000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1867914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1888473600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1899363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1919923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1930813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1951372800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1962867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1983427200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1994317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2014876800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2025766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2046326400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2057216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2077776000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2088666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2109225600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2120115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2140675200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2152170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2172729600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2183619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2204179200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2215069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2235628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2246518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2267078400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2277968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2298528000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2309418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2329977600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2341472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2362032000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2372922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2393481600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2404371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2424931200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2435821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2456380800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2467270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2487830400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2499325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2519884800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2530774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2551334400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2562224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2582784000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2593674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2614233600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2625123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2645683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2656573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2677132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2688627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2709187200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2720077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2740636800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2751526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2772086400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2782976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2803536000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2814426000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2834985600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2846480400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2867040000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2877930000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2898489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2909379600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2929939200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2940829200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2961388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2972278800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2992838400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3003728400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3024288000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3035782800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3056342400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3067232400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3087792000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3098682000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3119241600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3130131600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3150691200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3161581200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3182140800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3193030800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3213590400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3225085200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3245644800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3256534800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3277094400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3287984400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3308544000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3319434000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3339993600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3350883600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3371443200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3382938000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3403497600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3414387600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3434947200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3445837200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3466396800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3477286800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3497846400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3508736400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3529296000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3540186000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3560745600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3572240400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3592800000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3603690000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3624249600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3635139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3655699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3666589200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3687148800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3698038800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3718598400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3730093200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3750652800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3761542800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3782102400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3792992400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3813552000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3824442000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3845001600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3855891600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3876451200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3887341200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3907900800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3919395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3939955200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3950845200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3971404800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3982294800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4002854400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4013744400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4034304000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4045194000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4065753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4076643600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4097203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: 0,
                        dst_offset: 0,
                        name: "-00",
                    },
                    rest: REST
                }
            },

            Tz::America__Campo_Grande => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767212492, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1206954000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1191358800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1175371200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1159822800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-633816000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-622065600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-602280000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-591829200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-570744000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-560206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-539121600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-531349200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-191361600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-155160000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-150066000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-128894400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-99950400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-89586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-68414400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-57963600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (499752000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (511239600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (530596800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (540270000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (562132800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (571201200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (592977600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (602046000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (624427200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (634705200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (656481600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (666759600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (687931200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (697604400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (719985600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (728449200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (750830400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (761713200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (782280000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (793162800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (813729600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (824007600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (844574400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (856062000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (876110400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (888721200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (908078400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (919566000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (938923200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (951620400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (970977600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (982465200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1003032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1013914800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1036296000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1045364400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1066536000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1076814000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1099368000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1108868400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1129435200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1140318000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1162699200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1172372400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1192334400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1203217200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1224388800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1234666800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1255838400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1266721200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1287288000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1298170800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1318737600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1330225200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1350792000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1361070000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1382241600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1392519600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1413691200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1424574000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1445140800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1456023600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1476590400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1487473200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1508040000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1518922800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1541304000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1550372400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -13108,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Cancun => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1514722376, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (377935200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (828860400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (846396000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (860310000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (877845600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (891759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (902037600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (909298800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (923212800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (941353200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (954662400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (972802800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (989136000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1001833200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1018166400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1035702000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1049616000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1067151600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1081065600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1099206000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1112515200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1130655600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1143964800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1162105200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1175414400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1193554800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1207468800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1225004400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1238918400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1256454000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1270368000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1288508400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1301817600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1319958000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1333267200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1351407600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1365321600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1382857200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1396771200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1414306800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1422777600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -20824,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Caracas => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524505536, FixedTimespan { utc_offset: -16060, dst_offset: 0, name: "CMT" }),
                    (-1826739140, FixedTimespan { utc_offset: -16200, dst_offset: 0, name: "-0430" }),
                    (-157750200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1197183600, FixedTimespan { utc_offset: -16200, dst_offset: 0, name: "-0430" }),
                    (1462086000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16064,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Catamarca => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096212, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1086058800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1087704000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15788,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Cayenne => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1846269040, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -12560,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Cayman => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524502512, FixedTimespan { utc_offset: -19176, dst_offset: 0, name: "CMT" }),
                    (-1946918424, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -19088,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Chicago => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2717626164, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1633276800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1615136400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1601827200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1583686800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1563724800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1551632400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1538928000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1520182800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1504454400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1491757200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1473004800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1459702800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1441555200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1428253200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1410105600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1396803600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1378656000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1365354000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1347206400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1333904400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1315152000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1301850000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1283702400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1270400400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1252252800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1238950800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1220803200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1207501200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1189353600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1176051600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1157299200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1144602000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1125849600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1112547600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1094400000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1081098000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1067788800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (-1045414800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1031500800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1018198800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1000051200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-986749200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-967996800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-955299600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-936547200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-923245200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-905097600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-891795600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-880214400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CWT" }),
                    (-769395600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CPT" }),
                    (-765392400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-747244800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-733942800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-715795200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-702493200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-684345600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-671043600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-652896000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-639594000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-620841600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-608144400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-589392000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-576090000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-557942400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-544640400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-526492800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-513190800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-495043200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-481741200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-463593600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-447267600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-431539200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-415818000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-400089600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-384368400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-368640000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-352918800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-337190400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-321469200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-305740800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-289414800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-273686400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-257965200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-242236800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-226515600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-210787200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-195066000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-179337600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-163616400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-147888000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-131562000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-116438400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-100112400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-84384000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-68662800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-52934400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-37213200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-21484800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-5763600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (9964800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (25686000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (41414400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (57740400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (73468800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (89190000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (104918400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (120639600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (126691200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (152089200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (162374400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (183538800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (199267200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (215593200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (230716800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (247042800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (262771200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (278492400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (294220800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (309942000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (325670400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (341391600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (357120000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (372841200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (388569600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (404895600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (420019200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (436345200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (452073600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (467794800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (483523200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (499244400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (514972800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (530694000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (544608000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (562143600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (576057600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (594198000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (607507200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (625647600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (638956800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (657097200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (671011200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (688546800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (702460800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (719996400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (733910400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (752050800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (765360000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (783500400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (796809600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (814950000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (828864000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (846399600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (860313600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (877849200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (891763200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (909298800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (923212800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (941353200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (954662400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (972802800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (986112000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1004252400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1018166400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1035702000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1049616000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1067151600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1081065600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1099206000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1112515200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1130655600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1143964800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1162105200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1173600000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1194159600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1205049600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1225609200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1236499200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1257058800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1268553600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1289113200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1300003200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1320562800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1331452800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1352012400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1362902400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1383462000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1394352000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1414911600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1425801600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1446361200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1457856000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1478415600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1489305600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1509865200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1520755200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1541314800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1552204800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1572764400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1583654400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1604214000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1615708800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1636268400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1647158400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1667718000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1678608000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1699167600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1710057600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1730617200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1741507200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1762066800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1772956800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1793516400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1805011200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1825570800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1836460800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1857020400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1867910400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1888470000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1899360000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1919919600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1930809600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1951369200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1962864000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1983423600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1994313600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2014873200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2025763200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2046322800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2057212800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2077772400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2088662400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2109222000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2120112000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2140671600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2152166400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2172726000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2183616000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2204175600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2215065600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2235625200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2246515200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2267074800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2277964800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2298524400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2309414400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2329974000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2341468800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2362028400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2372918400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2393478000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2404368000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2424927600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2435817600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2456377200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2467267200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2487826800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2499321600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2519881200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2530771200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2551330800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2562220800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2582780400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2593670400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2614230000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2625120000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2645679600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2656569600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2677129200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2688624000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2709183600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2720073600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2740633200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2751523200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2772082800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2782972800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2803532400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2814422400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2834982000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2846476800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2867036400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2877926400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2898486000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2909376000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2929935600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2940825600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2961385200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (2972275200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (2992834800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3003724800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3024284400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3035779200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3056338800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3067228800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3087788400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3098678400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3119238000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3130128000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3150687600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3161577600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3182137200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3193027200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3213586800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3225081600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3245641200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3256531200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3277090800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3287980800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3308540400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3319430400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3339990000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3350880000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3371439600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3382934400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3403494000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3414384000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3434943600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3445833600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3466393200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3477283200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3497842800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3508732800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3529292400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3540182400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3560742000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3572236800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3592796400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3603686400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3624246000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3635136000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3655695600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3666585600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3687145200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3698035200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3718594800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3730089600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3750649200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3761539200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3782098800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3792988800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3813548400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3824438400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3844998000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3855888000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3876447600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3887337600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3907897200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3919392000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3939951600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3950841600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (3971401200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (3982291200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (4002850800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (4013740800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (4034300400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (4045190400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (4065750000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (4076640000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (4097199600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -21036,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Chihuahua => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1514714140, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1343066400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1234807200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1220292000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1207159200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1191344400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (828864000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (846399600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (860313600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (877849200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (989139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1001836800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1175418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1193558400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1207472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1225008000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1238922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1256457600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1270371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1288512000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1301821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1319961600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1333270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1351411200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1365325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1382860800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1396774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1414310400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1428224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1445760000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1459674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1477814400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1491123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1509264000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1522573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1540713600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1554627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1572163200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1586077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1603612800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1617526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1635667200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1648976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1667116800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -25460,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Ciudad_Juarez => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1514714044, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1343066400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1234807200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1220292000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1207159200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1191344400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (828864000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (846399600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (860313600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (877849200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (989139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1001836800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1175418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1193558400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1207472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1225008000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1238922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1256457600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1268557200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1289116800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1300006800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1320566400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1331456400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1352016000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1362906000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1383465600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1394355600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1414915200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1425805200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1446364800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1457859600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1478419200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1489309200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1509868800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1520758800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1541318400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1552208400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1572768000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1583658000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1604217600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1615712400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1636272000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1647162000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1667116800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1669788000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1678611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1699171200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1710061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1730620800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1741510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1762070400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1772960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1793520000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1805014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1825574400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1836464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1857024000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1867914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1888473600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1899363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1919923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1930813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1951372800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1962867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1983427200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1994317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2014876800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2025766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2046326400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2057216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2077776000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2088666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2109225600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2120115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2140675200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2152170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2172729600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2183619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2204179200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2215069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2235628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2246518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2267078400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2277968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2298528000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2309418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2329977600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2341472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2362032000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2372922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2393481600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2404371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2424931200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2435821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2456380800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2467270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2487830400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2499325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2519884800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2530774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2551334400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2562224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2582784000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2593674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2614233600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2625123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2645683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2656573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2677132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2688627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2709187200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2720077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2740636800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2751526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2772086400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2782976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2803536000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2814426000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2834985600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2846480400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2867040000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2877930000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2898489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2909379600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2929939200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2940829200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2961388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2972278800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2992838400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3003728400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3024288000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3035782800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3056342400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3067232400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3087792000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3098682000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3119241600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3130131600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3150691200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3161581200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3182140800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3193030800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3213590400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3225085200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3245644800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3256534800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3277094400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3287984400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3308544000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3319434000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3339993600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3350883600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3371443200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3382938000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3403497600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3414387600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3434947200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3445837200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3466396800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3477286800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3497846400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3508736400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3529296000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3540186000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3560745600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3572240400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3592800000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3603690000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3624249600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3635139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3655699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3666589200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3687148800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3698038800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3718598400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3730093200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3750652800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3761542800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3782102400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3792992400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3813552000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3824442000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3845001600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3855891600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3876451200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3887341200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3907900800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3919395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3939955200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3950845200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3971404800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3982294800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4002854400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4013744400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4034304000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4045194000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4065753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4076643600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4097203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -25556,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Coral_Harbour => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524502512, FixedTimespan { utc_offset: -19176, dst_offset: 0, name: "CMT" }),
                    (-1946918424, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -19088,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Cordoba => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2372096592, FixedTimespan { utc_offset: -15408, dst_offset: 0, name: "CMT" }),
                    (-1567453392, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1233432000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1222981200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1205956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1194037200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1172865600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1162501200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1141329600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1130965200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1109793600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1099429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1078257600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1067806800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1046635200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1036270800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1015099200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1004734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-983563200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-973198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-952027200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-941576400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-931032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-900882000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-890337600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-833749200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-827265600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-752274000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-733780800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-197326800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-190843200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-164491200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-152658000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-132955200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-101419200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-86821200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-71092800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-54766800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-39038400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-23317200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-7588800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (128142000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (136605600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (596948400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (605066400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (636516000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (656478000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (667965600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (687931200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (699415200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (719377200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (731469600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (952052400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1198983600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1205632800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1224385200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1237082400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15408,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Costa_Rica => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524501427, FixedTimespan { utc_offset: -20173, dst_offset: 0, name: "SJMT" }),
                    (-1545071027, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (288770400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (297234000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (320220000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (328683600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (664264800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (678344400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (695714400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (700635600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -20173,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Creston => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2717616702, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1633273200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1615132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1601823600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1583683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-880210800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MWT" }),
                    (-820519140, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-812653140, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MWT" }),
                    (-796845540, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-84380400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-68659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -26898,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Cuiaba => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767212140, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1206954000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1191358800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1175371200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-1159822800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-633816000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-622065600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-602280000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-591829200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-570744000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-560206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-539121600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-531349200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-191361600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-184194000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-155160000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-150066000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-128894400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-121122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-99950400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-89586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-68414400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (-57963600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (499752000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (511239600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (530596800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (540270000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (562132800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (571201200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (592977600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (602046000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (624427200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (634705200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (656481600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (666759600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (687931200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (697604400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (719985600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (728449200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (750830400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (761713200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (782280000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (793162800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (813729600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (824007600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (844574400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (856062000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (876110400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (888721200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (908078400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (919566000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (938923200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (951620400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (970977600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (982465200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1003032000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1013914800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1036296000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1045364400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1099368000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1108868400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1129435200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1140318000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1162699200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1172372400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1192334400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1203217200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1224388800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1234666800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1255838400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1266721200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1287288000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1298170800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1318737600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1330225200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1350792000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1361070000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1382241600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1392519600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1413691200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1424574000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1445140800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1456023600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1476590400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1487473200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1508040000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1518922800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1541304000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "-03" }),
                    (1550372400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -13460,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Curacao => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "AWT" }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "APT" }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Danmarkshavn => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1686091520, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (323845200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (338950800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (354675600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (370400400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (386125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (401850000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (417574800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (433299600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (449024400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (465354000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (481078800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (496803600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (512528400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (528253200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (543978000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (559702800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (575427600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (591152400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (606877200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (622602000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (638326800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (654656400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (670381200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (686106000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (701830800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (717555600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (733280400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (749005200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (764730000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (780454800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (796179600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (811904400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (820465200, FixedTimespan { utc_offset: 0, dst_offset: 0, name: "GMT" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -4480,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Dawson => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2188996940, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "YST" }),
                    (-1632056400, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "YDT" }),
                    (-1615125600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "YST" }),
                    (-1596978000, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "YDT" }),
                    (-1583164800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "YST" }),
                    (-880203600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "YWT" }),
                    (-769395600, FixedTimespan { utc_offset: -32400, dst_offset: 3600, name: "YPT" }),
                    (-765381600, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "YST" }),
                    (-147884400, FixedTimespan { utc_offset: -32400, dst_offset: 7200, name: "YDDT" }),
                    (-131554800, FixedTimespan { utc_offset: -32400, dst_offset: 0, name: "YST" }),
                    (120646800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (325677600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (341398800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (357127200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (372848400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (388576800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (404902800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (420026400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (436352400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (452080800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (467802000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (483530400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (499251600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (514980000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (530701200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (544615200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (562150800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (576064800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (594205200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (607514400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (625654800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (638964000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (657104400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (671018400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (688554000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (702468000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (720003600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (733917600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (752058000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (765367200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (783507600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (796816800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (814957200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (828871200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (846406800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (860320800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (877856400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (891770400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (909306000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (923220000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (941360400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (954669600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (972810000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (986119200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1004259600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1018173600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1035709200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1049623200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1067158800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1081072800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1099213200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1112522400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1130662800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1143972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1162112400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1173607200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1194166800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1205056800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1225616400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1236506400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1257066000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1268560800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1289120400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1300010400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1320570000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1331460000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1352019600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1362909600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1383469200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1394359200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1414918800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1425808800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1446368400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1457863200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1478422800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1489312800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1509872400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1520762400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1541322000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1552212000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1572771600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1583661600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1604214000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -33460,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Dawson_Creek => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2713881544, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-1632060000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-1615129200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-880207200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PWT" }),
                    (-769395600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PPT" }),
                    (-765385200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-715788000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-702486000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-684338400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-671036400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-652888800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-639586800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-620834400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-608137200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-589384800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-576082800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-557935200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-544633200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-526485600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-513183600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-495036000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-481734000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-463586400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-450284400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-431532000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-418230000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-400082400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-386780400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-368632800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-355330800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-337183200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-323881200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-305733600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-292431600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-273679200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-260982000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-242229600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-226508400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-210780000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-195058800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-179330400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-163609200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-147880800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-131554800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-116431200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-100105200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-84376800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-68655600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-52927200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-37206000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-21477600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-5756400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (9972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (25693200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (41421600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (57747600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (73476000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (84013200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -28856,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Denver => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2717618404, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1633273200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1615132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1601823600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1583683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1570374000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1551628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1538924400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1534089600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-880210800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MWT" }),
                    (-769395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MPT" }),
                    (-765388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-147884400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-131558400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-116434800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-100108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-84380400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-68659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-52930800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-37209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-21481200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-5760000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (9968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (25689600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (41418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (57744000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (73472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (89193600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (104922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (120643200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (126694800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (152092800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (162378000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (183542400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (199270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (215596800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (230720400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (247046400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (262774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (278496000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (294224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (309945600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (325674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (341395200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (357123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (372844800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (388573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (404899200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (420022800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (436348800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (452077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (467798400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (483526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (499248000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (514976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (530697600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (544611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (562147200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (576061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (594201600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (607510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (625651200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (638960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (657100800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (671014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (688550400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (702464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (720000000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (733914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (752054400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (765363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (783504000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (796813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (814953600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (828867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (846403200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (860317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (877852800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (986115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1004256000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1173603600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1194163200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1205053200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1225612800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1236502800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1257062400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1268557200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1289116800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1300006800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1320566400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1331456400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1352016000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1362906000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1383465600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1394355600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1414915200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1425805200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1446364800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1457859600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1478419200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1489309200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1509868800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1520758800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1541318400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1552208400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1572768000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1583658000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1604217600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1615712400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1636272000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1647162000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1667721600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1678611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1699171200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1710061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1730620800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1741510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1762070400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1772960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1793520000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1805014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1825574400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1836464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1857024000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1867914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1888473600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1899363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1919923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1930813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1951372800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1962867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1983427200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1994317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2014876800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2025766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2046326400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2057216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2077776000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2088666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2109225600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2120115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2140675200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2152170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2172729600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2183619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2204179200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2215069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2235628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2246518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2267078400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2277968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2298528000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2309418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2329977600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2341472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2362032000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2372922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2393481600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2404371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2424931200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2435821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2456380800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2467270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2487830400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2499325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2519884800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2530774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2551334400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2562224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2582784000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2593674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2614233600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2625123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2645683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2656573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2677132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2688627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2709187200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2720077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2740636800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2751526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2772086400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2782976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2803536000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2814426000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2834985600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2846480400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2867040000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2877930000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2898489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2909379600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2929939200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2940829200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2961388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2972278800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2992838400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3003728400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3024288000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3035782800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3056342400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3067232400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3087792000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3098682000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3119241600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3130131600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3150691200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3161581200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3182140800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3193030800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3213590400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3225085200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3245644800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3256534800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3277094400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3287984400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3308544000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3319434000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3339993600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3350883600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3371443200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3382938000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3403497600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3414387600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3434947200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3445837200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3466396800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3477286800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3497846400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3508736400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3529296000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3540186000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3560745600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3572240400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3592800000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3603690000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3624249600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3635139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3655699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3666589200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3687148800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3698038800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3718598400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3730093200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3750652800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3761542800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3782102400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3792992400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3813552000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3824442000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3845001600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3855891600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3876451200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3887341200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3907900800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3919395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3939955200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3950845200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3971404800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3982294800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4002854400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4013744400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4034304000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4045194000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4065753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4076643600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4097203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -25196,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Detroit => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2051202469, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1724083200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (-880218000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EWT" }),
                    (-769395600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EPT" }),
                    (-765396000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (-684349200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (-671047200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (-80506740, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (-68666400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (-52938000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (-37216800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (104914800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (120636000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (126687600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (152085600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (167814000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (183535200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (199263600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (215589600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (230713200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (247039200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (262767600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (278488800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (294217200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (309938400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (325666800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (341388000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (357116400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (372837600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (388566000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (404892000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (420015600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (436341600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (452070000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (467791200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (483519600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (499240800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (514969200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (530690400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (544604400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (562140000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (576054000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (594194400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (607503600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (625644000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (638953200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (657093600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (671007600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (688543200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (702457200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (719992800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (733906800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (752047200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (765356400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (783496800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (796806000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (814946400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (828860400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (846396000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (860310000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (877845600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (891759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (909295200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (923209200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (941349600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (954658800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (972799200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (986108400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1004248800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1018162800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1035698400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1049612400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1067148000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1081062000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1099202400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1112511600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1130652000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1143961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1162101600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1173596400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1194156000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1205046000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1225605600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1236495600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1257055200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1268550000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1289109600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1299999600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1320559200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1331449200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1352008800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1362898800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1383458400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1394348400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1414908000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1425798000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1446357600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1457852400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1478412000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1489302000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1509861600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1520751600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1541311200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1552201200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1572760800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1583650800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1604210400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1615705200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1636264800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1647154800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1667714400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1678604400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1699164000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1710054000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1730613600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1741503600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1762063200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1772953200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1793512800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1805007600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1825567200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1836457200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1857016800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1867906800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1888466400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1899356400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1919916000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1930806000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1951365600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1962860400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1983420000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1994310000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2014869600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2025759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2046319200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2057209200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2077768800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2088658800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2109218400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2120108400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2140668000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2152162800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2172722400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2183612400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2204172000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2215062000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2235621600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2246511600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2267071200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2277961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2298520800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2309410800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2329970400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2341465200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2362024800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2372914800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2393474400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2404364400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2424924000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2435814000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2456373600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2467263600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2487823200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2499318000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2519877600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2530767600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2551327200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2562217200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2582776800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2593666800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2614226400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2625116400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2645676000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2656566000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2677125600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2688620400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2709180000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2720070000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2740629600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2751519600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2772079200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2782969200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2803528800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2814418800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2834978400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2846473200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2867032800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2877922800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2898482400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2909372400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2929932000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2940822000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2961381600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2972271600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2992831200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3003721200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3024280800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3035775600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3056335200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3067225200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3087784800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3098674800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3119234400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3130124400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3150684000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3161574000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3182133600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3193023600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3213583200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3225078000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3245637600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3256527600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3277087200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3287977200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3308536800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3319426800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3339986400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3350876400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3371436000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3382930800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3403490400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3414380400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3434940000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3445830000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3466389600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3477279600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3497839200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3508729200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3529288800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3540178800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3560738400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3572233200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3592792800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3603682800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3624242400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3635132400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3655692000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3666582000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3687141600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3698031600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3718591200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3730086000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3750645600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3761535600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3782095200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3792985200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3813544800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3824434800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3844994400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3855884400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3876444000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3887334000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3907893600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3919388400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3939948000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3950838000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3971397600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3982287600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4002847200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (4013737200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4034296800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (4045186800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4065746400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (4076636400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4097196000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -19931,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Dominica => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "AWT" }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "APT" }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Edmonton => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1998663968, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1632063600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1615132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1600614000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1596816000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1567954800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1551628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1536505200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1523203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1504450800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1491753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1473001200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-1459699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-880210800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MWT" }),
                    (-769395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MPT" }),
                    (-765388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-715791600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (-702489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (73472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (89193600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (104922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (120643200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (136371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (152092800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (167821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (183542400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (199270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (215596800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (230720400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (247046400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (262774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (278496000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (294224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (309945600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (325674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (341395200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (357123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (372844800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (388573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (404899200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (420022800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (436348800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (452077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (467798400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (483526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (499248000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (514976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (530697600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (544611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (562147200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (576061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (594201600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (607510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (625651200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (638960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (657100800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (671014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (688550400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (702464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (720000000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (733914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (752054400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (765363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (783504000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (796813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (814953600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (828867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (846403200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (860317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (877852800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (891766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (909302400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (923216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (941356800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (954666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (972806400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (986115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1004256000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1018170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1035705600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1049619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1067155200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1081069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1099209600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1112518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1130659200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1143968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1162108800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1173603600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1194163200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1205053200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1225612800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1236502800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1257062400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1268557200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1289116800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1300006800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1320566400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1331456400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1352016000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1362906000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1383465600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1394355600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1414915200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1425805200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1446364800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1457859600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1478419200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1489309200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1509868800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1520758800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1541318400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1552208400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1572768000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1583658000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1604217600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1615712400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1636272000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1647162000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1667721600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1678611600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1699171200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1710061200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1730620800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1741510800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1762070400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1772960400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1793520000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1805014800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1825574400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1836464400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1857024000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1867914000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1888473600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1899363600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1919923200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1930813200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1951372800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1962867600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (1983427200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (1994317200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2014876800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2025766800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2046326400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2057216400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2077776000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2088666000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2109225600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2120115600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2140675200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2152170000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2172729600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2183619600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2204179200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2215069200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2235628800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2246518800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2267078400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2277968400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2298528000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2309418000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2329977600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2341472400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2362032000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2372922000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2393481600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2404371600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2424931200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2435821200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2456380800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2467270800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2487830400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2499325200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2519884800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2530774800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2551334400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2562224400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2582784000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2593674000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2614233600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2625123600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2645683200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2656573200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2677132800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2688627600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2709187200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2720077200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2740636800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2751526800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2772086400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2782976400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2803536000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2814426000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2834985600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2846480400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2867040000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2877930000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2898489600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2909379600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2929939200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2940829200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2961388800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (2972278800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (2992838400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3003728400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3024288000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3035782800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3056342400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3067232400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3087792000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3098682000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3119241600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3130131600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3150691200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3161581200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3182140800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3193030800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3213590400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3225085200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3245644800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3256534800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3277094400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3287984400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3308544000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3319434000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3339993600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3350883600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3371443200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3382938000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3403497600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3414387600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3434947200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3445837200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3466396800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3477286800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3497846400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3508736400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3529296000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3540186000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3560745600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3572240400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3592800000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3603690000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3624249600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3635139600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3655699200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3666589200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3687148800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3698038800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3718598400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3730093200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3750652800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3761542800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3782102400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3792992400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3813552000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3824442000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3845001600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3855891600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3876451200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3887341200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3907900800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3919395600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3939955200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3950845200, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (3971404800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (3982294800, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4002854400, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4013744400, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4034304000, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4045194000, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4065753600, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (4076643600, FixedTimespan { utc_offset: -25200, dst_offset: 3600, name: "MDT" }),
                    (4097203200, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -27232,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Eirunepe => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767208832, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (-1206950400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (-1191355200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (-1175367600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (-1159819200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (-633812400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (-622062000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (-602276400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (-591825600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (-570740400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (-560203200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (-539118000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (-531345600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (-191358000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (-184190400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (-155156400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (-150062400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (-128890800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (-121118400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (-99946800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (-89582400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (-68410800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (-57960000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (499755600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (511243200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (530600400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (540273600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (562136400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (571204800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (750834000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (761716800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (1214283600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (1384056000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -16768,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__El_Salvador => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1546279392, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (547020000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (559717200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (578469600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (591166800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -21408,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Ensenada => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1514711516, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1451667600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-1343062800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                    (-1234803600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-1222963200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-1207242000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-873820800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PWT" }),
                    (-769370400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PPT" }),
                    (-761677200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-686073600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-661539600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-495039600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-481734000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-463590000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-450284400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-431535600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-418230000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-400086000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-386780400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-368636400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-355330800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-337186800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-323881200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-305737200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-292431600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (199274400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (215600400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (230724000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (247050000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (262778400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (278499600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (294228000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (309949200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (325677600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (341398800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (357127200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (372848400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (388576800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (404902800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (420026400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (436352400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (452080800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (467802000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (483530400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (499251600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (514980000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (530701200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (544615200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (562150800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (576064800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (594205200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (607514400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (625654800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (638964000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (657104400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (671018400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (688554000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (702468000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (720003600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (733917600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (752058000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (765367200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (783507600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (796816800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (814957200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (828871200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (846406800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (860320800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (877856400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (891770400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (909306000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (923220000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (941360400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (954669600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (972810000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (986119200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1004259600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1018173600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1035709200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1049623200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1067158800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1081072800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1099213200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1112522400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1130662800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1143972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1162112400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1175421600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1193562000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1207476000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1225011600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1238925600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1256461200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1268560800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1289120400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1300010400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1320570000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1331460000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1352019600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1362909600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1383469200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1394359200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1414918800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1425808800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1446368400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1457863200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1478422800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1489312800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1509872400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1520762400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1541322000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1552212000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1572771600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1583661600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1604221200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1615716000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1636275600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1647165600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1667725200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1678615200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1699174800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1710064800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1730624400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1741514400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1762074000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1772964000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1793523600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1805018400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1825578000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1836468000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1857027600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1867917600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1888477200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1899367200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1919926800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1930816800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1951376400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1962871200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1983430800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1994320800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2014880400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2025770400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2046330000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2057220000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2077779600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2088669600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2109229200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2120119200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2140678800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2152173600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2172733200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2183623200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2204182800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2215072800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2235632400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2246522400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2267082000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2277972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2298531600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2309421600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2329981200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2341476000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2362035600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2372925600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2393485200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2404375200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2424934800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2435824800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2456384400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2467274400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2487834000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2499328800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2519888400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2530778400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2551338000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2562228000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2582787600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2593677600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2614237200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2625127200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2645686800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2656576800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2677136400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2688631200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2709190800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2720080800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2740640400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2751530400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2772090000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2782980000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2803539600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2814429600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2834989200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2846484000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2867043600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2877933600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2898493200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2909383200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2929942800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2940832800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2961392400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (2972282400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (2992842000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3003732000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3024291600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3035786400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3056346000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3067236000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3087795600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3098685600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3119245200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3130135200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3150694800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3161584800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3182144400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3193034400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3213594000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3225088800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3245648400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3256538400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3277098000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3287988000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3308547600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3319437600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3339997200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3350887200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3371446800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3382941600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3403501200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3414391200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3434950800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3445840800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3466400400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3477290400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3497850000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3508740000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3529299600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3540189600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3560749200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3572244000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3592803600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3603693600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3624253200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3635143200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3655702800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3666592800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3687152400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3698042400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3718602000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3730096800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3750656400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3761546400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3782106000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3792996000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3813555600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3824445600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3845005200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3855895200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3876454800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3887344800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3907904400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3919399200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3939958800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3950848800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (3971408400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (3982298400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (4002858000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (4013748000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (4034307600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (4045197600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (4065757200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (4076647200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (4097206800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -28084,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Fort_Nelson => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2713880953, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-1632060000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-1615129200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-880207200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PWT" }),
                    (-769395600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PPT" }),
                    (-765385200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-715788000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-702486000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-684338400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-671036400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-652888800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-639586800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-620834400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-608137200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-589384800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-576082800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-557935200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-544633200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-526485600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-513183600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-495036000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-481734000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-463586400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-450284400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-431532000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-418230000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-400082400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-386780400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-368632800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-355330800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-337183200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-323881200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-305733600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-292431600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-273679200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-260982000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-242229600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-226508400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-210780000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-195058800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-179330400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-163609200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-147880800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-131554800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-116431200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-100105200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-84376800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-68655600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-52927200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-37206000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (-21477600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (-5756400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (9972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (25693200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (41421600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (57747600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (73476000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (89197200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (104925600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (120646800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (136375200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (152096400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (167824800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (183546000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (199274400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (215600400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (230724000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (247050000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (262778400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (278499600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (294228000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (309949200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (325677600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (341398800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (357127200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (372848400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (388576800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (404902800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (420026400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (436352400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (452080800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (467802000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (483530400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (499251600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (514980000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (530701200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (544615200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (562150800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (576064800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (594205200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (607514400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (625654800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (638964000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (657104400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (671018400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (688554000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (702468000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (720003600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (733917600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (752058000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (765367200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (783507600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (796816800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (814957200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (828871200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (846406800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (860320800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (877856400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (891770400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (909306000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (923220000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (941360400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (954669600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (972810000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (986119200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1004259600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1018173600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1035709200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1049623200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1067158800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1081072800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1099213200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1112522400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1130662800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1143972000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1162112400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1173607200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1194166800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1205056800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1225616400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1236506400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1257066000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1268560800, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1289120400, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1300010400, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1320570000, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1331460000, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1352019600, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1362909600, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1383469200, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1394359200, FixedTimespan { utc_offset: -28800, dst_offset: 3600, name: "PDT" }),
                    (1414918800, FixedTimespan { utc_offset: -28800, dst_offset: 0, name: "PST" }),
                    (1425808800, FixedTimespan { utc_offset: -25200, dst_offset: 0, name: "MST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -29447,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Fort_Wayne => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2717626522, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1633276800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1615136400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-1601827200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-1583686800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-900259200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-891795600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-880214400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CWT" }),
                    (-769395600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CPT" }),
                    (-765392400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-747244800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-733942800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-715795200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-702493200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-684345600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-671043600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-652896000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-639594000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-620841600, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-608144400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-589392000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-576090000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-557942400, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-544640400, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-526492800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-513190800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-495043200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (-481741200, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-463593600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (-386787600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (-368640000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (-21488400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (-5767200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (9961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (25682400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1143961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1162101600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1173596400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1194156000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1205046000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1225605600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1236495600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1257055200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1268550000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1289109600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1299999600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1320559200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1331449200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1352008800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1362898800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1383458400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1394348400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1414908000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1425798000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1446357600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1457852400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1478412000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1489302000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1509861600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1520751600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1541311200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1552201200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1572760800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1583650800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1604210400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1615705200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1636264800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1647154800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1667714400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1678604400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1699164000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1710054000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1730613600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1741503600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1762063200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1772953200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1793512800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1805007600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1825567200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1836457200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1857016800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1867906800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1888466400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1899356400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1919916000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1930806000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1951365600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1962860400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1983420000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1994310000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2014869600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2025759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2046319200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2057209200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2077768800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2088658800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2109218400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2120108400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2140668000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2152162800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2172722400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2183612400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2204172000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2215062000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2235621600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2246511600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2267071200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2277961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2298520800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2309410800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2329970400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2341465200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2362024800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2372914800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2393474400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2404364400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2424924000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2435814000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2456373600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2467263600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2487823200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2499318000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2519877600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2530767600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2551327200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2562217200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2582776800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2593666800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2614226400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2625116400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2645676000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2656566000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2677125600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2688620400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2709180000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2720070000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2740629600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2751519600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2772079200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2782969200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2803528800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2814418800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2834978400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2846473200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2867032800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2877922800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2898482400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2909372400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2929932000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2940822000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2961381600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2972271600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2992831200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3003721200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3024280800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3035775600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3056335200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3067225200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3087784800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3098674800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3119234400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3130124400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3150684000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3161574000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3182133600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3193023600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3213583200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3225078000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3245637600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3256527600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3277087200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3287977200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3308536800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3319426800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3339986400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3350876400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3371436000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3382930800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3403490400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3414380400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3434940000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3445830000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3466389600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3477279600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3497839200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3508729200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3529288800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3540178800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3560738400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3572233200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3592792800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3603682800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3624242400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3635132400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3655692000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3666582000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3687141600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3698031600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3718591200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3730086000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3750645600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3761535600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3782095200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3792985200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3813544800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3824434800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3844994400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3855884400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3876444000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3887334000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3907893600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3919388400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3939948000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3950838000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3971397600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3982287600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4002847200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (4013737200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4034296800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (4045186800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4065746400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (4076636400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4097196000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -20678,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Fortaleza => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1767216360, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-1206957600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-1191362400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-1175374800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-1159826400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-633819600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-622069200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-602283600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-591832800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-570747600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-560210400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-539125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-531352800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-191365200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-184197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-155163600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-150069600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-128898000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-121125600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-99954000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-89589600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (-68418000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (-57967200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (499748400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (511236000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (530593200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (540266400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (562129200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (571197600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (592974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (602042400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (624423600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (634701600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (938919600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (951616800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (970974000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (972180000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1003028400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1013911200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -9240,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Glace_Bay => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2131646412, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1632074400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1615143600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-880221600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "AWT" }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "APT" }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-526500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-513198000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (73461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (89182800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (104911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (120632400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (136360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (152082000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (167810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (183531600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (199260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (215586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (230709600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (247035600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (262764000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (278485200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (294213600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (309934800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (325663200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (341384400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (357112800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (372834000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (388562400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (404888400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (420012000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (436338000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (452066400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (467787600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (483516000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (499237200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (514965600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (530686800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (544600800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (562136400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (576050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (594190800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (607500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (625640400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (638949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (657090000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (671004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (688539600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (702453600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (719989200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (733903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (752043600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (765352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (783493200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (796802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (814942800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (828856800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (846392400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (860306400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (877842000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (891756000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (909291600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (923205600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (941346000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (954655200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (972795600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (986104800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1004245200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1018159200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1035694800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1049608800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1067144400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1081058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1099198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1112508000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1130648400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1143957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1162098000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1173592800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1194152400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1205042400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1225602000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1236492000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1257051600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1268546400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1289106000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1299996000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1320555600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1331445600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1352005200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1362895200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1383454800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1394344800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1414904400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1425794400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1446354000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1457848800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1478408400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1489298400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1509858000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1520748000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1541307600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1552197600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1572757200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1583647200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1604206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1615701600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1636261200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1647151200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1667710800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1678600800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1699160400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1710050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1730610000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1741500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1762059600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1772949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1793509200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1805004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1825563600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1836453600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1857013200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1867903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1888462800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1899352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1919912400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1930802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1951362000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1962856800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1983416400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1994306400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2014866000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2025756000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2046315600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2057205600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2077765200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2088655200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2109214800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2120104800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2140664400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2152159200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2172718800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2183608800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2204168400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2215058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2235618000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2246508000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2267067600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2277957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2298517200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2309407200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2329966800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2341461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2362021200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2372911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2393470800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2404360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2424920400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2435810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2456370000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2467260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2487819600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2499314400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2519874000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2530764000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2551323600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2562213600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2582773200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2593663200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2614222800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2625112800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2645672400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2656562400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2677122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2688616800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2709176400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2720066400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2740626000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2751516000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2772075600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2782965600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2803525200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2814415200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2834974800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2846469600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2867029200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2877919200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2898478800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2909368800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2929928400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2940818400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2961378000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2972268000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2992827600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3003717600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3024277200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3035772000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3056331600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3067221600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3087781200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3098671200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3119230800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3130120800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3150680400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3161570400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3182130000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3193020000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3213579600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3225074400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3245634000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3256524000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3277083600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3287973600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3308533200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3319423200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3339982800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3350872800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3371432400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3382927200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3403486800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3414376800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3434936400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3445826400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3466386000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3477276000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3497835600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3508725600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3529285200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3540175200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3560734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3572229600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3592789200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3603679200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3624238800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3635128800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3655688400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3666578400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3687138000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3698028000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3718587600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3730082400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3750642000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3761532000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3782091600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3792981600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3813541200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3824431200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3844990800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3855880800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3876440400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3887330400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3907890000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3919384800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3939944400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3950834400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3971394000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3982284000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4002843600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (4013733600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4034293200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (4045183200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4065742800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (4076632800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4097192400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14388,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Godthab => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1686083584, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (323845200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (338950800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (354675600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (370400400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (386125200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (401850000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (417574800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (433299600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (449024400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (465354000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (481078800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (496803600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (512528400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (528253200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (543978000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (559702800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (575427600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (591152400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (606877200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (622602000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (638326800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (654656400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (670381200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (686106000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (701830800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (717555600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (733280400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (749005200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (764730000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (780454800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (796179600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (811904400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (828234000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (846378000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (859683600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (877827600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (891133200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (909277200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (922582800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (941331600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (954032400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (972781200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (985482000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1004230800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1017536400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1035680400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1048986000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1067130000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1080435600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1099184400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1111885200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1130634000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1143334800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1162083600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1174784400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1193533200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1206838800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1224982800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1238288400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1256432400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1269738000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1288486800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1301187600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1319936400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1332637200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1351386000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1364691600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1382835600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1396141200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1414285200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1427590800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1445734800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1459040400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1477789200, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1490490000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1509238800, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1521939600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1540688400, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1553994000, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1572138000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1585443600, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1603587600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1616893200, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1635642000, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1648342800, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1667091600, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (1679792400, FixedTimespan { utc_offset: -10800, dst_offset: 3600, name: "-02" }),
                    (1679799600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (1711846800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (1729990800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (1743296400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (1761440400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (1774746000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (1792890000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (1806195600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (1824944400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (1837645200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (1856394000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (1869094800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (1887843600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (1901149200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (1919293200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (1932598800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (1950742800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (1964048400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (1982797200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (1995498000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2014246800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2026947600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2045696400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2058397200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2077146000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2090451600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2108595600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2121901200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2140045200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2153350800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2172099600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2184800400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2203549200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2216250000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2234998800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2248304400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2266448400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2279754000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2297898000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2311203600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2329347600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2342653200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2361402000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2374102800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2392851600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2405552400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2424301200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2437606800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2455750800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2469056400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2487200400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2500506000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2519254800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2531955600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2550704400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2563405200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2582154000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2595459600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2613603600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2626909200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2645053200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2658358800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2676502800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2689808400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2708557200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2721258000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2740006800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2752707600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2771456400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2784762000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2802906000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2816211600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2834355600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2847661200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2866410000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2879110800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2897859600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2910560400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2929309200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2942010000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2960758800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (2974064400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (2992208400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3005514000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3023658000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3036963600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3055712400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3068413200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3087162000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3099862800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3118611600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3131917200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3150061200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3163366800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3181510800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3194816400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3212960400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3226266000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3245014800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3257715600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3276464400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3289165200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3307914000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3321219600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3339363600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3352669200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3370813200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3384118800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3402867600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3415568400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3434317200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3447018000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3465766800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3479072400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3497216400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3510522000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3528666000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3541971600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3560115600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3573421200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3592170000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3604870800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3623619600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3636320400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3655069200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3668374800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3686518800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3699824400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3717968400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3731274000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3750022800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3762723600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3781472400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3794173200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3812922000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3825622800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3844371600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3857677200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3875821200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3889126800, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3907270800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3920576400, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3939325200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3952026000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (3970774800, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (3983475600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (4002224400, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (4015530000, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (4033674000, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (4046979600, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (4065123600, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                    (4078429200, FixedTimespan { utc_offset: -7200, dst_offset: 3600, name: "-01" }),
                    (4096573200, FixedTimespan { utc_offset: -7200, dst_offset: 0, name: "-02" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -12416,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Goose_Bay => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2713895900, FixedTimespan { utc_offset: -12652, dst_offset: 0, name: "NST" }),
                    (-1632076148, FixedTimespan { utc_offset: -12652, dst_offset: 3600, name: "NDT" }),
                    (-1615145348, FixedTimespan { utc_offset: -12652, dst_offset: 0, name: "NST" }),
                    (-1096921748, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-1061670600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-1048973400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-1030221000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-1017523800, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-998771400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-986074200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-966717000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-954624600, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-935267400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-922570200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-903817800, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-891120600, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-872368200, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NWT" }),
                    (-769395600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NPT" }),
                    (-765401400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-746044200, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-733347000, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-714594600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-701897400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-683145000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-670447800, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-651695400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-638998200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-619641000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-606943800, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-589401000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-576099000, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-557951400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-544649400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-526501800, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-513199800, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-495052200, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-481750200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-463602600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-450300600, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-431548200, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-418246200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-400098600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-386796600, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-368649000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-355347000, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-337199400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-323897400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-305749800, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-289423800, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-273695400, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-257974200, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-242245800, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-226524600, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-210796200, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-195075000, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-179346600, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-163625400, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-147897000, FixedTimespan { utc_offset: -12600, dst_offset: 3600, name: "NDT" }),
                    (-131571000, FixedTimespan { utc_offset: -12600, dst_offset: 0, name: "NST" }),
                    (-119903400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-116445600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-100119600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-84391200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-68670000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-52941600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-37220400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-21492000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-5770800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (9957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (25678800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (41407200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (57733200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (73461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (89182800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (104911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (120632400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (136360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (152082000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (167810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (183531600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (199260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (215586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (230709600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (247035600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (262764000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (278485200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (294213600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (309934800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (325663200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (341384400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (357112800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (372834000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (388562400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (404888400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (420012000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (436338000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (452066400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (467787600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (483516000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (499237200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (514965600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (530686800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (544593660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (562129260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (576043260, FixedTimespan { utc_offset: -14400, dst_offset: 7200, name: "ADDT" }),
                    (594180060, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (607492860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (625633260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (638942460, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (657082860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (670996860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (688532460, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (702446460, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (719982060, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (733896060, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (752036460, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (765345660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (783486060, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (796795260, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (814935660, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (828849660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (846385260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (860299260, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (877834860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (891748860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (909284460, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (923198460, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (941338860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (954648060, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (972788460, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (986097660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1004238060, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1018152060, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1035687660, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1049601660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1067137260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1081051260, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1099191660, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1112500860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1130641260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1143950460, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1162090860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1173585660, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1194145260, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1205035260, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1225594860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1236484860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1257044460, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1268539260, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1289098860, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1299988860, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1320555600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1331445600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1352005200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1362895200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1383454800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1394344800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1414904400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1425794400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1446354000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1457848800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1478408400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1489298400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1509858000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1520748000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1541307600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1552197600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1572757200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1583647200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1604206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1615701600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1636261200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1647151200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1667710800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1678600800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1699160400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1710050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1730610000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1741500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1762059600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1772949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1793509200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1805004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1825563600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1836453600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1857013200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1867903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1888462800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1899352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1919912400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1930802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1951362000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1962856800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1983416400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1994306400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2014866000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2025756000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2046315600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2057205600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2077765200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2088655200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2109214800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2120104800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2140664400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2152159200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2172718800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2183608800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2204168400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2215058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2235618000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2246508000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2267067600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2277957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2298517200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2309407200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2329966800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2341461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2362021200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2372911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2393470800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2404360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2424920400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2435810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2456370000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2467260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2487819600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2499314400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2519874000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2530764000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2551323600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2562213600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2582773200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2593663200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2614222800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2625112800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2645672400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2656562400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2677122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2688616800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2709176400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2720066400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2740626000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2751516000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2772075600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2782965600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2803525200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2814415200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2834974800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2846469600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2867029200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2877919200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2898478800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2909368800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2929928400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2940818400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2961378000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2972268000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2992827600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3003717600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3024277200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3035772000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3056331600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3067221600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3087781200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3098671200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3119230800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3130120800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3150680400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3161570400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3182130000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3193020000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3213579600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3225074400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3245634000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3256524000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3277083600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3287973600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3308533200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3319423200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3339982800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3350872800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3371432400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3382927200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3403486800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3414376800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3434936400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3445826400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3466386000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3477276000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3497835600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3508725600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3529285200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3540175200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3560734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3572229600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3592789200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3603679200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3624238800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3635128800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3655688400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3666578400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3687138000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3698028000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3718587600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3730082400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3750642000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3761532000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3782091600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3792981600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3813541200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3824431200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3844990800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3855880800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3876440400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3887330400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3907890000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3919384800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3939944400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3950834400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3971394000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3982284000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4002843600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (4013733600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4034293200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (4045183200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4065742800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (4076632800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4097192400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -14500,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Grand_Turk => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524504528, FixedTimespan { utc_offset: -18430, dst_offset: 0, name: "KMT" }),
                    (-1827687170, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (294217200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (309938400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (325666800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (341388000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (357116400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (372837600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (388566000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (404892000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (420015600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (436341600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (452070000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (467791200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (483519600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (499240800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (514969200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (530690400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (544604400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (562140000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (576054000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (594194400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (607503600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (625644000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (638953200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (657093600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (671007600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (688543200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (702457200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (719992800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (733906800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (752047200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (765356400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (783496800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (796806000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (814946400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (828860400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (846396000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (860310000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (877845600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (891759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (909295200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (923209200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (941349600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (954658800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (972799200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (986108400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1004248800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1018162800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1035698400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1049612400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1067148000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1081062000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1099202400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1112511600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1130652000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1143961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1162101600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1173596400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1194156000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1205046000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1225605600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1236495600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1257055200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1268550000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1289109600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1299999600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1320559200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1331449200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1352008800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1362898800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1383458400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1394348400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1414908000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1425798000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1520751600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1541311200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1552201200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1572760800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1583650800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1604210400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1615705200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1636264800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1647154800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1667714400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1678604400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1699164000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1710054000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1730613600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1741503600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1762063200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1772953200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1793512800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1805007600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1825567200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1836457200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1857016800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1867906800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1888466400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1899356400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1919916000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1930806000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1951365600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1962860400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (1983420000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (1994310000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2014869600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2025759600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2046319200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2057209200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2077768800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2088658800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2109218400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2120108400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2140668000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2152162800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2172722400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2183612400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2204172000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2215062000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2235621600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2246511600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2267071200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2277961200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2298520800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2309410800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2329970400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2341465200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2362024800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2372914800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2393474400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2404364400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2424924000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2435814000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2456373600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2467263600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2487823200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2499318000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2519877600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2530767600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2551327200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2562217200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2582776800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2593666800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2614226400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2625116400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2645676000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2656566000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2677125600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2688620400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2709180000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2720070000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2740629600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2751519600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2772079200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2782969200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2803528800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2814418800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2834978400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2846473200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2867032800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2877922800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2898482400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2909372400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2929932000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2940822000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2961381600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (2972271600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (2992831200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3003721200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3024280800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3035775600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3056335200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3067225200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3087784800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3098674800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3119234400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3130124400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3150684000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3161574000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3182133600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3193023600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3213583200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3225078000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3245637600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3256527600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3277087200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3287977200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3308536800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3319426800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3339986400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3350876400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3371436000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3382930800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3403490400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3414380400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3434940000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3445830000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3466389600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3477279600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3497839200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3508729200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3529288800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3540178800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3560738400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3572233200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3592792800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3603682800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3624242400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3635132400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3655692000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3666582000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3687141600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3698031600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3718591200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3730086000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3750645600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3761535600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3782095200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3792985200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3813544800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3824434800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3844994400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3855884400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3876444000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3887334000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3907893600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3919388400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3939948000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3950838000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (3971397600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (3982287600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4002847200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (4013737200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4034296800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (4045186800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4065746400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                    (4076636400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "EDT" }),
                    (4097196000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "EST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -17072,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Grenada => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "AWT" }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "APT" }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Guadeloupe => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2233035335, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-873057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "AWT" }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "APT" }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15865,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Guatemala => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1617040676, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (123055200, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (130914000, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (422344800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (433054800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (669708000, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (684219600, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                    (1146376800, FixedTimespan { utc_offset: -21600, dst_offset: 3600, name: "CDT" }),
                    (1159678800, FixedTimespan { utc_offset: -21600, dst_offset: 0, name: "CST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -21724,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Guayaquil => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524502440, FixedTimespan { utc_offset: -18840, dst_offset: 0, name: "QMT" }),
                    (-1230749160, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                    (722926800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "-04" }),
                    (728884800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "-05" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -19160,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Guyana => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-1843589241, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                    (-1730577600, FixedTimespan { utc_offset: -13500, dst_offset: 0, name: "-0345" }),
                    (176096700, FixedTimespan { utc_offset: -10800, dst_offset: 0, name: "-03" }),
                    (701841600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "-04" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -13959,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Halifax => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2131645536, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1696276800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1680469200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1632074400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1615143600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1566763200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1557090000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1535486400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1524949200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1504468800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1493413200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1472414400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1461963600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1440964800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1429390800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1409515200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1396731600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1376856000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1366491600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1346616000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1333832400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1313956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1303678800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1282507200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1272661200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1251057600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1240088400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1219608000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1207429200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1188763200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1175979600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1157313600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1143925200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1124049600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1113771600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1091390400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1081026000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1059854400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1050786000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-1030910400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-1018126800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-999460800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-986677200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-965592000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-955227600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-935956800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-923173200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-904507200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-891723600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-880221600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "AWT" }),
                    (-769395600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "APT" }),
                    (-765399600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-747252000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-733950000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-715802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-702500400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-684352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-671050800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-652903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-639601200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-589399200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-576097200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-557949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-544647600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-526500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-513198000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-495050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-481748400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-431546400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-418244400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-400096800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-386794800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-368647200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-355345200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-337197600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-323895600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-242244000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-226522800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-210794400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-195073200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-179344800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-163623600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-147895200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-131569200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-116445600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-100119600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-84391200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-68670000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-52941600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-37220400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (-21492000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (-5770800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (9957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (25678800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (41407200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (57733200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (73461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (89182800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (104911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (120632400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (136360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (152082000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (167810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (183531600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (199260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (215586000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (230709600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (247035600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (262764000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (278485200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (294213600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (309934800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (325663200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (341384400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (357112800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (372834000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (388562400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (404888400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (420012000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (436338000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (452066400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (467787600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (483516000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (499237200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (514965600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (530686800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (544600800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (562136400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (576050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (594190800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (607500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (625640400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (638949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (657090000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (671004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (688539600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (702453600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (719989200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (733903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (752043600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (765352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (783493200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (796802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (814942800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (828856800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (846392400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (860306400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (877842000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (891756000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (909291600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (923205600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (941346000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (954655200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (972795600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (986104800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1004245200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1018159200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1035694800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1049608800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1067144400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1081058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1099198800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1112508000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1130648400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1143957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1162098000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1173592800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1194152400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1205042400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1225602000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1236492000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1257051600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1268546400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1289106000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1299996000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1320555600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1331445600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1352005200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1362895200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1383454800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1394344800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1414904400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1425794400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1446354000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1457848800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1478408400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1489298400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1509858000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1520748000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1541307600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1552197600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1572757200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1583647200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1604206800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1615701600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1636261200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1647151200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1667710800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1678600800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1699160400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1710050400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1730610000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1741500000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1762059600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1772949600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1793509200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1805004000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1825563600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1836453600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1857013200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1867903200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1888462800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1899352800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1919912400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1930802400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1951362000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1962856800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (1983416400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (1994306400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2014866000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2025756000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2046315600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2057205600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2077765200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2088655200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2109214800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2120104800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2140664400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2152159200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2172718800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2183608800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2204168400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2215058400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2235618000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2246508000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2267067600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2277957600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2298517200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2309407200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2329966800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2341461600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2362021200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2372911200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2393470800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2404360800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2424920400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2435810400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2456370000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2467260000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2487819600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2499314400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2519874000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2530764000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2551323600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2562213600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2582773200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2593663200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2614222800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2625112800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2645672400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2656562400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2677122000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2688616800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2709176400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2720066400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2740626000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2751516000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2772075600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2782965600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2803525200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2814415200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2834974800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2846469600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2867029200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2877919200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2898478800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2909368800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2929928400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2940818400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2961378000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (2972268000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (2992827600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3003717600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3024277200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3035772000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3056331600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3067221600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3087781200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3098671200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3119230800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3130120800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3150680400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3161570400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3182130000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3193020000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3213579600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3225074400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3245634000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3256524000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3277083600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3287973600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3308533200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3319423200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3339982800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3350872800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3371432400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3382927200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3403486800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3414376800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3434936400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3445826400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3466386000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3477276000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3497835600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3508725600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3529285200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3540175200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3560734800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3572229600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3592789200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3603679200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3624238800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3635128800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3655688400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3666578400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3687138000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3698028000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3718587600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3730082400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3750642000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3761532000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3782091600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3792981600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3813541200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3824431200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3844990800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3855880800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3876440400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3887330400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3907890000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3919384800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3939944400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3950834400, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (3971394000, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (3982284000, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4002843600, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (4013733600, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4034293200, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (4045183200, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4065742800, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                    (4076632800, FixedTimespan { utc_offset: -14400, dst_offset: 3600, name: "ADT" }),
                    (4097192400, FixedTimespan { utc_offset: -14400, dst_offset: 0, name: "AST" }),
                ];
                FixedTimespanSet {
                    first: FixedTimespan {
                        utc_offset: -15264,
                        dst_offset: 0,
                        name: "LMT",
                    },
                    rest: REST
                }
            },

            Tz::America__Havana => {
                const REST: &[(i64, FixedTimespan)] = &[
                    (-2524501832, FixedTimespan { utc_offset: -19776, dst_offset: 0, name: "HMT" }),
                    (-1402813824, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (-1311534000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (-1300996800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (-933534000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (-925675200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (-902084400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (-893620800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (-870030000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (-862171200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (-775681200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (-767822400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (-744231600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (-736372800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (-144702000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (-134251200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (-113425200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (-102542400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (-86295600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (-72907200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (-54154800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (-41457600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (-21495600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (-5774400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (9954000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (25675200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (41403600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (57729600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (73458000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (87364800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (104907600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (118900800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (136357200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (150436800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (167806800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (183528000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (199256400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (215582400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (230706000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (247032000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (263365200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (276667200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (290581200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (308721600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (322030800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (340171200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (358318800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (371620800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (389768400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (403070400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (421218000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (434520000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (452667600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (466574400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (484117200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (498024000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (511333200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (529473600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (542782800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (560923200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (574837200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (592372800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (606286800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (623822400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (638946000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (655876800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (671000400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (687330000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (702450000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (718779600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (733899600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (750229200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (765349200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (781678800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (796798800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (813128400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (828853200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (844578000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (860302800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (876632400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (891147600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (909291600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (922597200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (941346000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (954651600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (972795600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (986101200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1004245200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1018155600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1035694800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1049605200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1067144400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1080450000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1162098000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1173589200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1193547600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1205643600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1224997200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1236488400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1256446800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1268542800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1288501200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1300597200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1321160400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1333256400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1352005200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1362891600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1383454800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1394341200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1414904400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1425790800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1446354000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1457845200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1478408400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1489294800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1509858000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1520744400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1541307600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1552194000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1572757200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1583643600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1604206800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1615698000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1636261200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1647147600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1667710800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1678597200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1699160400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1710046800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1730610000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1741496400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1762059600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1772946000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1793509200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1805000400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1825563600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1836450000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1857013200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1867899600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1888462800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1899349200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1919912400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1930798800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1951362000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1962853200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (1983416400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (1994302800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2014866000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2025752400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2046315600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2057202000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2077765200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2088651600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2109214800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2120101200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2140664400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2152155600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2172718800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2183605200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2204168400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2215054800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2235618000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2246504400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2267067600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2277954000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2298517200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2309403600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2329966800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2341458000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2362021200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2372907600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2393470800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2404357200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2424920400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2435806800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2456370000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2467256400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2487819600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2499310800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2519874000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2530760400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2551323600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2562210000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2582773200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2593659600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2614222800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2625109200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2645672400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2656558800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2677122000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2688613200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2709176400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2720062800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2740626000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2751512400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2772075600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2782962000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2803525200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2814411600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2834974800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2846466000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2867029200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2877915600, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2898478800, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2909365200, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2929928400, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2940814800, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2961378000, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (2972264400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (2992827600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (3003714000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (3024277200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (3035768400, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (3056331600, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (3067218000, FixedTimespan { utc_offset: -18000, dst_offset: 3600, name: "CDT" }),
                    (3087781200, FixedTimespan { utc_offset: -18000, dst_offset: 0, name: "CST" }),
                    (3098667600, FixedTimespan { u