/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/source3/librpc/gen_ndr/ndr_secrets.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_samr.h"
#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_netlogon.h"
#include "librpc/gen_ndr/ndr_security.h"
_PUBLIC_ enum ndr_err_code ndr_push_TRUSTED_DOM_PASS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct TRUSTED_DOM_PASS *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen_m_term(r->uni_name)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->uni_name, 32, sizeof(uint16_t), CH_UTF16));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen(r->pass)));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->pass));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->mod_time));
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->domain_sid));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_TRUSTED_DOM_PASS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct TRUSTED_DOM_PASS *r)
{
	uint32_t size_uni_name_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->uni_name_len));
			size_uni_name_0 = 32;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->uni_name, size_uni_name_0, sizeof(uint16_t), CH_UTF16));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pass_len));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->pass));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->mod_time));
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->domain_sid));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_TRUSTED_DOM_PASS(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct TRUSTED_DOM_PASS *r)
{
	ndr_print_TRUSTED_DOM_PASS(ndr, name, r);
}

_PUBLIC_ void ndr_print_TRUSTED_DOM_PASS(struct ndr_print *ndr, const char *name, const struct TRUSTED_DOM_PASS *r)
{
	ndr_print_struct(ndr, name, "TRUSTED_DOM_PASS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "uni_name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m_term(r->uni_name):r->uni_name_len);
		ndr_print_string(ndr, "uni_name", r->uni_name);
		ndr_print_uint32(ndr, "pass_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen(r->pass):r->pass_len);
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			ndr_print_string(ndr, "pass", r->pass);
			ndr->flags = _flags_save_string;
		}
		ndr_print_time_t(ndr, "mod_time", r->mod_time);
		ndr_print_dom_sid(ndr, "domain_sid", &r->domain_sid);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_secret(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct lsa_secret *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->secret_current));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->secret_current_lastchange));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->secret_old));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->secret_old_lastchange));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sd));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->secret_current) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->secret_current));
		}
		if (r->secret_old) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->secret_old));
		}
		if (r->sd) {
			NDR_CHECK(ndr_push_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->sd));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_secret(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct lsa_secret *r)
{
	uint32_t _ptr_secret_current;
	TALLOC_CTX *_mem_save_secret_current_0 = NULL;
	uint32_t _ptr_secret_old;
	TALLOC_CTX *_mem_save_secret_old_0 = NULL;
	uint32_t _ptr_sd;
	TALLOC_CTX *_mem_save_sd_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_secret_current));
		if (_ptr_secret_current) {
			NDR_PULL_ALLOC(ndr, r->secret_current);
		} else {
			r->secret_current = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->secret_current_lastchange));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_secret_old));
		if (_ptr_secret_old) {
			NDR_PULL_ALLOC(ndr, r->secret_old);
		} else {
			r->secret_old = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->secret_old_lastchange));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sd));
		if (_ptr_sd) {
			NDR_PULL_ALLOC(ndr, r->sd);
		} else {
			r->sd = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->secret_current) {
			_mem_save_secret_current_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->secret_current, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->secret_current));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secret_current_0, 0);
		}
		if (r->secret_old) {
			_mem_save_secret_old_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->secret_old, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->secret_old));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secret_old_0, 0);
		}
		if (r->sd) {
			_mem_save_sd_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sd, 0);
			NDR_CHECK(ndr_pull_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->sd));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sd_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_lsa_secret(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct lsa_secret *r)
{
	ndr_print_lsa_secret(ndr, name, r);
}

_PUBLIC_ void ndr_print_lsa_secret(struct ndr_print *ndr, const char *name, const struct lsa_secret *r)
{
	ndr_print_struct(ndr, name, "lsa_secret");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "secret_current", r->secret_current);
	ndr->depth++;
	if (r->secret_current) {
		ndr_print_DATA_BLOB(ndr, "secret_current", *r->secret_current);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "secret_current_lastchange", r->secret_current_lastchange);
	ndr_print_ptr(ndr, "secret_old", r->secret_old);
	ndr->depth++;
	if (r->secret_old) {
		ndr_print_DATA_BLOB(ndr, "secret_old", *r->secret_old);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "secret_old_lastchange", r->secret_old_lastchange);
	ndr_print_ptr(ndr, "sd", r->sd);
	ndr->depth++;
	if (r->sd) {
		ndr_print_security_descriptor(ndr, "sd", r->sd);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_secrets_domain_info1_kerberos_key(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct secrets_domain_info1_kerberos_key *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->keytype));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->iteration_count));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->value));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_secrets_domain_info1_kerberos_key(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct secrets_domain_info1_kerberos_key *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->keytype));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->iteration_count));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->value));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_secrets_domain_info1_kerberos_key(struct ndr_print *ndr, const char *name, const struct secrets_domain_info1_kerberos_key *r)
{
	ndr_print_struct(ndr, name, "secrets_domain_info1_kerberos_key");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "keytype", r->keytype);
	ndr_print_uint32(ndr, "iteration_count", r->iteration_count);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
		ndr_print_DATA_BLOB(ndr, "value", r->value);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_secrets_domain_info1_password(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct secrets_domain_info1_password *r)
{
	uint32_t cntr_keys_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->change_time));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->change_server, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->change_server, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->change_server, ndr_charset_length(r->change_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->cleartext_blob));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_samr_Password = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, &r->nt_hash));
			ndr->flags = _flags_save_samr_Password;
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->salt_data));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->default_iteration_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->num_keys));
		for (cntr_keys_0 = 0; cntr_keys_0 < (r->num_keys); cntr_keys_0++) {
			NDR_CHECK(ndr_push_secrets_domain_info1_kerberos_key(ndr, NDR_SCALARS, &r->keys[cntr_keys_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->salt_data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->salt_data, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->salt_data, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->salt_data, ndr_charset_length(r->salt_data, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_secrets_domain_info1_password(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct secrets_domain_info1_password *r)
{
	uint32_t size_change_server_0 = 0;
	uint32_t length_change_server_0 = 0;
	uint32_t _ptr_salt_data;
	uint32_t size_salt_data_1 = 0;
	uint32_t length_salt_data_1 = 0;
	TALLOC_CTX *_mem_save_salt_data_0 = NULL;
	uint32_t size_keys_0 = 0;
	uint32_t cntr_keys_0;
	TALLOC_CTX *_mem_save_keys_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->change_time));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->change_server));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->change_server));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->change_server, &size_change_server_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->change_server, &length_change_server_0));
		if (length_change_server_0 > size_change_server_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_change_server_0, length_change_server_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_change_server_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->change_server, length_change_server_0, sizeof(uint16_t), CH_UTF16));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->cleartext_blob));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_samr_Password = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, &r->nt_hash));
			ndr->flags = _flags_save_samr_Password;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_salt_data));
		if (_ptr_salt_data) {
			NDR_PULL_ALLOC(ndr, r->salt_data);
		} else {
			r->salt_data = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->default_iteration_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->num_keys));
		size_keys_0 = r->num_keys;
		NDR_PULL_ALLOC_N(ndr, r->keys, size_keys_0);
		_mem_save_keys_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->keys, 0);
		for (cntr_keys_0 = 0; cntr_keys_0 < (size_keys_0); cntr_keys_0++) {
			NDR_CHECK(ndr_pull_secrets_domain_info1_kerberos_key(ndr, NDR_SCALARS, &r->keys[cntr_keys_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_keys_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->salt_data) {
			_mem_save_salt_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->salt_data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->salt_data));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->salt_data));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->salt_data, &size_salt_data_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->salt_data, &length_salt_data_1));
			if (length_salt_data_1 > size_salt_data_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_salt_data_1, length_salt_data_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_salt_data_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->salt_data, length_salt_data_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_salt_data_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_secrets_domain_info1_password(struct ndr_print *ndr, const char *name, const struct secrets_domain_info1_password *r)
{
	uint32_t cntr_keys_0;
	ndr_print_struct(ndr, name, "secrets_domain_info1_password");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTTIME(ndr, "change_time", r->change_time);
	ndr_print_string(ndr, "change_server", r->change_server);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
		ndr_print_DATA_BLOB(ndr, "cleartext_blob", r->cleartext_blob);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	{
		libndr_flags _flags_save_samr_Password = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
		ndr_print_samr_Password(ndr, "nt_hash", &r->nt_hash);
		ndr->flags = _flags_save_samr_Password;
	}
	ndr_print_ptr(ndr, "salt_data", r->salt_data);
	ndr->depth++;
	if (r->salt_data) {
		ndr_print_string(ndr, "salt_data", r->salt_data);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "default_iteration_count", r->default_iteration_count);
	ndr_print_uint16(ndr, "num_keys", r->num_keys);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "keys", (uint32_t)(r->num_keys));
	ndr->depth++;
	for (cntr_keys_0 = 0; cntr_keys_0 < (r->num_keys); cntr_keys_0++) {
		ndr_print_secrets_domain_info1_kerberos_key(ndr, "keys", &r->keys[cntr_keys_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_secrets_domain_info1_change(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct secrets_domain_info1_change *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->password == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->local_status));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->remote_status));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->change_time));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->change_server, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->change_server, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->change_server, ndr_charset_length(r->change_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->password */
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_secrets_domain_info1_password(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_secrets_domain_info1_change(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct secrets_domain_info1_change *r)
{
	uint32_t size_change_server_0 = 0;
	uint32_t length_change_server_0 = 0;
	uint32_t _ptr_password;
	TALLOC_CTX *_mem_save_password_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->local_status));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->remote_status));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->change_time));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->change_server));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->change_server));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->change_server, &size_change_server_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->change_server, &length_change_server_0));
		if (length_change_server_0 > size_change_server_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_change_server_0, length_change_server_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_change_server_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->change_server, length_change_server_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->password);
		} else {
			r->password = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->password, 0);
		NDR_CHECK(ndr_pull_secrets_domain_info1_password(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_secrets_domain_info1_change(struct ndr_print *ndr, const char *name, const struct secrets_domain_info1_change *r)
{
	ndr_print_struct(ndr, name, "secrets_domain_info1_change");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTSTATUS(ndr, "local_status", r->local_status);
	ndr_print_NTSTATUS(ndr, "remote_status", r->remote_status);
	ndr_print_NTTIME(ndr, "change_time", r->change_time);
	ndr_print_string(ndr, "change_server", r->change_server);
	ndr_print_ptr(ndr, "password", r->password);
	ndr->depth++;
	ndr_print_secrets_domain_info1_password(ndr, "password", r->password);
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_secrets_domain_info1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct secrets_domain_info1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->password == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->join_time));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->computer_name, ndr_charset_length(r->computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->account_name, ndr_charset_length(r->account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_netr_SchannelType(ndr, NDR_SCALARS, r->secure_channel_type));
		NDR_CHECK(ndr_push_lsa_DnsDomainInfo(ndr, NDR_SCALARS, &r->domain_info));
		NDR_CHECK(ndr_push_netr_TrustFlags(ndr, NDR_SCALARS, r->trust_flags));
		NDR_CHECK(ndr_push_lsa_TrustType(ndr, NDR_SCALARS, r->trust_type));
		NDR_CHECK(ndr_push_lsa_TrustAttributes(ndr, NDR_SCALARS, r->trust_attributes));
		NDR_CHECK(ndr_push_unique_ptr(ndr, NULL));
		NDR_CHECK(ndr_push_kerb_EncTypes(ndr, NDR_SCALARS, r->supported_enc_types));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->salt_principal));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->password_last_change));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->password_changes));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->next_change));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->password */
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->old_password));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->older_password));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_DnsDomainInfo(ndr, NDR_BUFFERS, &r->domain_info));
		if (NULL) {
			NDR_CHECK(ndr_push_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, NULL));
		}
		if (r->salt_principal) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->salt_principal, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->salt_principal, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->salt_principal, ndr_charset_length(r->salt_principal, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->next_change) {
			NDR_CHECK(ndr_push_secrets_domain_info1_change(ndr, NDR_SCALARS|NDR_BUFFERS, r->next_change));
		}
		NDR_CHECK(ndr_push_secrets_domain_info1_password(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
		if (r->old_password) {
			NDR_CHECK(ndr_push_secrets_domain_info1_password(ndr, NDR_SCALARS|NDR_BUFFERS, r->old_password));
		}
		if (r->older_password) {
			NDR_CHECK(ndr_push_secrets_domain_info1_password(ndr, NDR_SCALARS|NDR_BUFFERS, r->older_password));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_secrets_domain_info1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct secrets_domain_info1 *r)
{
	uint32_t size_computer_name_0 = 0;
	uint32_t length_computer_name_0 = 0;
	uint32_t size_account_name_0 = 0;
	uint32_t length_account_name_0 = 0;
	uint32_t _ptr_reserved_routing;
	TALLOC_CTX *_mem_save_reserved_routing_0 = NULL;
	uint32_t _ptr_salt_principal;
	uint32_t size_salt_principal_1 = 0;
	uint32_t length_salt_principal_1 = 0;
	TALLOC_CTX *_mem_save_salt_principal_0 = NULL;
	uint32_t _ptr_next_change;
	TALLOC_CTX *_mem_save_next_change_0 = NULL;
	uint32_t _ptr_password;
	TALLOC_CTX *_mem_save_password_0 = NULL;
	uint32_t _ptr_old_password;
	TALLOC_CTX *_mem_save_old_password_0 = NULL;
	uint32_t _ptr_older_password;
	TALLOC_CTX *_mem_save_older_password_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->reserved_flags));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->join_time));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->computer_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->computer_name, &size_computer_name_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->computer_name, &length_computer_name_0));
		if (length_computer_name_0 > size_computer_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_computer_name_0, length_computer_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->computer_name, length_computer_name_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->account_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->account_name, &size_account_name_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->account_name, &length_account_name_0));
		if (length_account_name_0 > size_account_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_account_name_0, length_account_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->account_name, length_account_name_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_netr_SchannelType(ndr, NDR_SCALARS, &r->secure_channel_type));
		NDR_CHECK(ndr_pull_lsa_DnsDomainInfo(ndr, NDR_SCALARS, &r->domain_info));
		NDR_CHECK(ndr_pull_netr_TrustFlags(ndr, NDR_SCALARS, &r->trust_flags));
		NDR_CHECK(ndr_pull_lsa_TrustType(ndr, NDR_SCALARS, &r->trust_type));
		NDR_CHECK(ndr_pull_lsa_TrustAttributes(ndr, NDR_SCALARS, &r->trust_attributes));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_reserved_routing));
		if (_ptr_reserved_routing) {
			NDR_PULL_ALLOC(ndr, r->reserved_routing);
		} else {
			r->reserved_routing = NULL;
		}
		NDR_CHECK(ndr_pull_kerb_EncTypes(ndr, NDR_SCALARS, &r->supported_enc_types));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_salt_principal));
		if (_ptr_salt_principal) {
			NDR_PULL_ALLOC(ndr, r->salt_principal);
		} else {
			r->salt_principal = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->password_last_change));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->password_changes));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_next_change));
		if (_ptr_next_change) {
			NDR_PULL_ALLOC(ndr, r->next_change);
		} else {
			r->next_change = NULL;
		}
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->password);
		} else {
			r->password = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_password));
		if (_ptr_old_password) {
			NDR_PULL_ALLOC(ndr, r->old_password);
		} else {
			r->old_password = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_older_password));
		if (_ptr_older_password) {
			NDR_PULL_ALLOC(ndr, r->older_password);
		} else {
			r->older_password = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_DnsDomainInfo(ndr, NDR_BUFFERS, &r->domain_info));
		if (r->reserved_routing) {
			_mem_save_reserved_routing_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->reserved_routing, 0);
			NDR_CHECK(ndr_pull_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->reserved_routing));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reserved_routing_0, 0);
		}
		if (r->salt_principal) {
			_mem_save_salt_principal_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->salt_principal, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->salt_principal));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->salt_principal));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->salt_principal, &size_salt_principal_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->salt_principal, &length_salt_principal_1));
			if (length_salt_principal_1 > size_salt_principal_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_salt_principal_1, length_salt_principal_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_salt_principal_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->salt_principal, length_salt_principal_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_salt_principal_0, 0);
		}
		if (r->next_change) {
			_mem_save_next_change_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->next_change, 0);
			NDR_CHECK(ndr_pull_secrets_domain_info1_change(ndr, NDR_SCALARS|NDR_BUFFERS, r->next_change));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_change_0, 0);
		}
		_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->password, 0);
		NDR_CHECK(ndr_pull_secrets_domain_info1_password(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		if (r->old_password) {
			_mem_save_old_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->old_password, 0);
			NDR_CHECK(ndr_pull_secrets_domain_info1_password(ndr, NDR_SCALARS|NDR_BUFFERS, r->old_password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_password_0, 0);
		}
		if (r->older_password) {
			_mem_save_older_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->older_password, 0);
			NDR_CHECK(ndr_pull_secrets_domain_info1_password(ndr, NDR_SCALARS|NDR_BUFFERS, r->older_password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_older_password_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_secrets_domain_info1(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct secrets_domain_info1 *r)
{
	ndr_print_secrets_domain_info1(ndr, name, r);
}

_PUBLIC_ void ndr_print_secrets_domain_info1(struct ndr_print *ndr, const char *name, const struct secrets_domain_info1 *r)
{
	ndr_print_struct(ndr, name, "secrets_domain_info1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "reserved_flags", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved_flags);
	ndr_print_NTTIME(ndr, "join_time", r->join_time);
	ndr_print_string(ndr, "computer_name", r->computer_name);
	ndr_print_string(ndr, "account_name", r->account_name);
	ndr_print_netr_SchannelType(ndr, "secure_channel_type", r->secure_channel_type);
	ndr_print_lsa_DnsDomainInfo(ndr, "domain_info", &r->domain_info);
	ndr_print_netr_TrustFlags(ndr, "trust_flags", r->trust_flags);
	ndr_print_lsa_TrustType(ndr, "trust_type", r->trust_type);
	ndr_print_lsa_TrustAttributes(ndr, "trust_attributes", r->trust_attributes);
	ndr_print_ptr(ndr, "reserved_routing", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NULL:r->reserved_routing);
	ndr->depth++;
	if ((ndr->flags & LIBNDR_PRINT_SET_VALUES)?NULL:r->reserved_routing) {
		ndr_print_lsa_ForestTrustInformation(ndr, "reserved_routing", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NULL:r->reserved_routing);
	}
	ndr->depth--;
	ndr_print_kerb_EncTypes(ndr, "supported_enc_types", r->supported_enc_types);
	ndr_print_ptr(ndr, "salt_principal", r->salt_principal);
	ndr->depth++;
	if (r->salt_principal) {
		ndr_print_string(ndr, "salt_principal", r->salt_principal);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "password_last_change", r->password_last_change);
	ndr_print_hyper(ndr, "password_changes", r->password_changes);
	ndr_print_ptr(ndr, "next_change", r->next_change);
	ndr->depth++;
	if (r->next_change) {
		ndr_print_secrets_domain_info1_change(ndr, "next_change", r->next_change);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "password", r->password);
	ndr->depth++;
	ndr_print_secrets_domain_info1_password(ndr, "password", r->password);
	ndr->depth--;
	ndr_print_ptr(ndr, "old_password", r->old_password);
	ndr->depth++;
	if (r->old_password) {
		ndr_print_secrets_domain_info1_password(ndr, "old_password", r->old_password);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "older_password", r->older_password);
	ndr->depth++;
	if (r->older_password) {
		ndr_print_secrets_domain_info1_password(ndr, "older_password", r->older_password);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_secrets_domain_info_version(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum secrets_domain_info_version r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_secrets_domain_info_version(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum secrets_domain_info_version *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_secrets_domain_info_version(struct ndr_print *ndr, const char *name, enum secrets_domain_info_version r)
{
	const char *val = NULL;

	switch (r) {
		case SECRETS_DOMAIN_INFO_VERSION_1: val = "SECRETS_DOMAIN_INFO_VERSION_1"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_secrets_domain_infoU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union secrets_domain_infoU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case SECRETS_DOMAIN_INFO_VERSION_1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case SECRETS_DOMAIN_INFO_VERSION_1:
				if (r->info1) {
					NDR_CHECK(ndr_push_secrets_domain_info1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_secrets_domain_infoU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union secrets_domain_infoU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info1_0 = NULL;
	uint32_t _ptr_info1;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case SECRETS_DOMAIN_INFO_VERSION_1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case SECRETS_DOMAIN_INFO_VERSION_1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_secrets_domain_info1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_secrets_domain_infoU(struct ndr_print *ndr, const char *name, const union secrets_domain_infoU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "secrets_domain_infoU");
	switch (level) {
		case SECRETS_DOMAIN_INFO_VERSION_1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_secrets_domain_info1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_secrets_domain_infoB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct secrets_domain_infoB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_secrets_domain_info_version(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_secrets_domain_infoU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_secrets_domain_infoU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_secrets_domain_infoB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct secrets_domain_infoB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_secrets_domain_info_version(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_secrets_domain_infoU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_secrets_domain_infoU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_secrets_domain_infoB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct secrets_domain_infoB *r)
{
	ndr_print_secrets_domain_infoB(ndr, name, r);
}

_PUBLIC_ void ndr_print_secrets_domain_infoB(struct ndr_print *ndr, const char *name, const struct secrets_domain_infoB *r)
{
	ndr_print_struct(ndr, name, "secrets_domain_infoB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_secrets_domain_info_version(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_secrets_domain_infoU(ndr, "info", &r->info);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_secrets
static const struct ndr_interface_public_struct secrets_public_structs[] = {
	{
		.name = "TRUSTED_DOM_PASS",
		.struct_size = sizeof(struct TRUSTED_DOM_PASS ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_TRUSTED_DOM_PASS,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_TRUSTED_DOM_PASS,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_TRUSTED_DOM_PASS,
	},
	{
		.name = "lsa_secret",
		.struct_size = sizeof(struct lsa_secret ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_lsa_secret,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_lsa_secret,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_lsa_secret,
	},
	{
		.name = "secrets_domain_info1",
		.struct_size = sizeof(struct secrets_domain_info1 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_secrets_domain_info1,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_secrets_domain_info1,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_secrets_domain_info1,
	},
	{
		.name = "secrets_domain_infoB",
		.struct_size = sizeof(struct secrets_domain_infoB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_secrets_domain_infoB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_secrets_domain_infoB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_secrets_domain_infoB,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call secrets_calls[] = {
	{ .name = NULL }
};

static const char * const secrets_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\secrets]", 
};

static const struct ndr_interface_string_array secrets_endpoints = {
	.count	= 1,
	.names	= secrets_endpoint_strings
};

static const char * const secrets_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array secrets_authservices = {
	.count	= 1,
	.names	= secrets_authservice_strings
};


const struct ndr_interface_table ndr_table_secrets = {
	.name		= "secrets",
	.num_calls	= 0,
	.calls		= secrets_calls,
	.num_public_structs	= 4,
	.public_structs		= secrets_public_structs,
	.endpoints	= &secrets_endpoints,
	.authservices	= &secrets_authservices
};

#endif /* SKIP_NDR_TABLE_secrets */
