
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/source3/librpc/gen_ndr/ndr_smbXsrv.h"
#include "bin/default/source3/librpc/gen_ndr/ndr_smbXsrv_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/server_id.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/auth.h"
static PyTypeObject smbXsrv_version_node0_Type;
static PyTypeObject smbXsrv_version_global0_Type;
static PyTypeObject smbXsrv_version_globalU_Type;
static PyTypeObject smbXsrv_version_globalB_Type;
static PyTypeObject smbXsrv_client_global0_Type;
static PyTypeObject smbXsrv_client_globalU_Type;
static PyTypeObject smbXsrv_client_globalB_Type;
static PyTypeObject smbXsrv_client_Type;
static PyTypeObject smbXsrv_clientU_Type;
static PyTypeObject smbXsrv_clientB_Type;
static PyTypeObject smbXsrv_connection_pass0_Type;
static PyTypeObject smbXsrv_connection_passU_Type;
static PyTypeObject smbXsrv_connection_passB_Type;
static PyTypeObject smbXsrv_connection_drop0_Type;
static PyTypeObject smbXsrv_connection_dropU_Type;
static PyTypeObject smbXsrv_connection_dropB_Type;
static PyTypeObject smbXsrv_channel_global0_Type;
static PyTypeObject smbXsrv_session_global0_Type;
static PyTypeObject smbXsrv_session_globalU_Type;
static PyTypeObject smbXsrv_session_globalB_Type;
static PyTypeObject smbXsrv_session_auth0_Type;
static PyTypeObject smbXsrv_session_Type;
static PyTypeObject smbXsrv_sessionU_Type;
static PyTypeObject smbXsrv_sessionB_Type;
static PyTypeObject smbXsrv_session_close0_Type;
static PyTypeObject smbXsrv_session_closeU_Type;
static PyTypeObject smbXsrv_session_closeB_Type;
static PyTypeObject smbXsrv_tcon_global0_Type;
static PyTypeObject smbXsrv_tcon_globalU_Type;
static PyTypeObject smbXsrv_tcon_globalB_Type;
static PyTypeObject smbXsrv_tcon_Type;
static PyTypeObject smbXsrv_tconU_Type;
static PyTypeObject smbXsrv_tconB_Type;
static PyTypeObject smbXsrv_open_global0_Type;
static PyTypeObject smbXsrv_open_globalU_Type;
static PyTypeObject smbXsrv_open_globalB_Type;
static PyTypeObject smbXsrv_open_Type;
static PyTypeObject smbXsrv_openU_Type;
static PyTypeObject smbXsrv_openB_Type;
static PyTypeObject smbXsrv_open_replay_cache_key_Type;
static PyTypeObject smbXsrv_open_replay_cache_Type;
static PyTypeObject smbXsrv_InterfaceType;

static PyTypeObject *server_id_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *auth_session_info_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_smbXsrv_version_node0_get_server_id(PyObject *obj, void *closure)
{
	struct smbXsrv_version_node0 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_id;
	py_server_id = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->server_id);
	return py_server_id;
}

static int py_smbXsrv_version_node0_set_server_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_version_node0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_id");
		return -1;
	}
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server_id = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_version_node0_get_min_version(PyObject *obj, void *closure)
{
	struct smbXsrv_version_node0 *object = pytalloc_get_ptr(obj);
	PyObject *py_min_version;
	py_min_version = PyLong_FromUnsignedLongLong((uint32_t)(object->min_version));
	return py_min_version;
}

static int py_smbXsrv_version_node0_set_min_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_version_node0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->min_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->min_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->min_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_version_node0_get_max_version(PyObject *obj, void *closure)
{
	struct smbXsrv_version_node0 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_version;
	py_max_version = PyLong_FromUnsignedLongLong((uint32_t)(object->max_version));
	return py_max_version;
}

static int py_smbXsrv_version_node0_set_max_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_version_node0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_version_node0_get_current_version(PyObject *obj, void *closure)
{
	struct smbXsrv_version_node0 *object = pytalloc_get_ptr(obj);
	PyObject *py_current_version;
	py_current_version = PyLong_FromUnsignedLongLong((uint32_t)(object->current_version));
	return py_current_version;
}

static int py_smbXsrv_version_node0_set_current_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_version_node0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->current_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->current_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->current_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_version_node0_getsetters[] = {
	{
		.name = discard_const_p(char, "server_id"),
		.get = py_smbXsrv_version_node0_get_server_id,
		.set = py_smbXsrv_version_node0_set_server_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{
		.name = discard_const_p(char, "min_version"),
		.get = py_smbXsrv_version_node0_get_min_version,
		.set = py_smbXsrv_version_node0_set_min_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "max_version"),
		.get = py_smbXsrv_version_node0_get_max_version,
		.set = py_smbXsrv_version_node0_set_max_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "current_version"),
		.get = py_smbXsrv_version_node0_get_current_version,
		.set = py_smbXsrv_version_node0_set_current_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_version_node0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_version_node0, type);
}


static PyTypeObject smbXsrv_version_node0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.version_node0",
	.tp_getset = py_smbXsrv_version_node0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_version_node0_new,
};


static PyObject *py_smbXsrv_version_global0_get_num_nodes(PyObject *obj, void *closure)
{
	struct smbXsrv_version_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_nodes;
	py_num_nodes = PyLong_FromUnsignedLongLong((uint32_t)(object->num_nodes));
	return py_num_nodes;
}

static int py_smbXsrv_version_global0_set_num_nodes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_version_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_nodes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_nodes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_nodes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_version_global0_get_nodes(PyObject *obj, void *closure)
{
	struct smbXsrv_version_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_nodes;
	py_nodes = PyList_New(object->num_nodes);
	if (py_nodes == NULL) {
		return NULL;
	}
	{
		int nodes_cntr_0;
		for (nodes_cntr_0 = 0; nodes_cntr_0 < (object->num_nodes); nodes_cntr_0++) {
			PyObject *py_nodes_0;
			py_nodes_0 = pytalloc_reference_ex(&smbXsrv_version_node0_Type, object->nodes, &(object->nodes)[nodes_cntr_0]);
			PyList_SetItem(py_nodes, nodes_cntr_0, py_nodes_0);
		}
	}
	return py_nodes;
}

static int py_smbXsrv_version_global0_set_nodes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_version_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nodes");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int nodes_cntr_0;
		object->nodes = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->nodes, PyList_GET_SIZE(value));
		if (!object->nodes) { return -1; }
		talloc_set_name_const(object->nodes, "ARRAY: object->nodes");
		for (nodes_cntr_0 = 0; nodes_cntr_0 < PyList_GET_SIZE(value); nodes_cntr_0++) {
			if (PyList_GET_ITEM(value, nodes_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->nodes)[nodes_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&smbXsrv_version_node0_Type, PyList_GET_ITEM(value, nodes_cntr_0), return -1;);
			if (talloc_reference(object->nodes, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, nodes_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->nodes)[nodes_cntr_0] = *(struct smbXsrv_version_node0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, nodes_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_version_global0_getsetters[] = {
	{
		.name = discard_const_p(char, "num_nodes"),
		.get = py_smbXsrv_version_global0_get_num_nodes,
		.set = py_smbXsrv_version_global0_set_num_nodes,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "nodes"),
		.get = py_smbXsrv_version_global0_get_nodes,
		.set = py_smbXsrv_version_global0_set_nodes,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_node0")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_version_global0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_version_global0, type);
}


static PyTypeObject smbXsrv_version_global0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.version_global0",
	.tp_getset = py_smbXsrv_version_global0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_version_global0_new,
};

static PyObject *py_import_smbXsrv_version_globalU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_version_globalU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_version_global0_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_version_globalU *py_export_smbXsrv_version_globalU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_version_globalU *ret = talloc_zero(mem_ctx, union smbXsrv_version_globalU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_version_global0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_version_global0 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_version_globalU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_version_globalU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_version_globalU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_version_globalU!");
		return NULL;
	}

	return py_import_smbXsrv_version_globalU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_version_globalU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_version_globalU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_version_globalU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_version_globalU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_version_globalU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_version_globalU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_version_globalU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_version_globalU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.version_globalU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_version_globalU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_version_globalU_new,
};


static PyObject *py_smbXsrv_version_globalB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_version_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_version_globalB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_version_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_version_globalB_get_seqnum(PyObject *obj, void *closure)
{
	struct smbXsrv_version_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_seqnum;
	py_seqnum = PyLong_FromUnsignedLongLong((uint32_t)(object->seqnum));
	return py_seqnum;
}

static int py_smbXsrv_version_globalB_set_seqnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_version_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->seqnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->seqnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->seqnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_version_globalB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_version_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_version_globalU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_version_globalU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_version_globalB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_version_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_version_globalU *info_switch_0;
		info_switch_0 = (union smbXsrv_version_globalU *)pyrpc_export_union(&smbXsrv_version_globalU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_version_globalU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_version_globalB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_version_globalB_get_version,
		.set = py_smbXsrv_version_globalB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "seqnum"),
		.get = py_smbXsrv_version_globalB_get_seqnum,
		.set = py_smbXsrv_version_globalB_set_seqnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_version_globalB_get_info,
		.set = py_smbXsrv_version_globalB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_globalU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_version_globalB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_version_globalB, type);
}

static PyObject *py_smbXsrv_version_globalB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_version_globalB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_version_globalB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_version_globalB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_version_globalB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_version_globalB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_version_globalB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_version_globalB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_version_globalB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_version_globalB, "smbXsrv_version_globalB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_version_globalB, "smbXsrv_version_globalB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_version_globalB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_version_globalB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_version_globalB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_version_globalB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_version_globalB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.version_globalB",
	.tp_getset = py_smbXsrv_version_globalB_getsetters,
	.tp_methods = py_smbXsrv_version_globalB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_version_globalB_new,
};


static PyObject *py_smbXsrv_client_global0_get_db_rec(PyObject *obj, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_db_rec;
	if (object->db_rec == NULL) {
		Py_RETURN_NONE;
	}
	if (object->db_rec == NULL) {
		py_db_rec = Py_None;
		Py_INCREF(py_db_rec);
	} else {
		py_db_rec = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->db_rec to Python");
		return NULL;
	}
	return py_db_rec;
}

static int py_smbXsrv_client_global0_set_db_rec(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->db_rec));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->db_rec");
		return -1;
	}
	if (value == Py_None) {
		object->db_rec = NULL;
	} else {
		object->db_rec = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->db_rec");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_global0_get_server_id(PyObject *obj, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_id;
	py_server_id = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->server_id);
	return py_server_id;
}

static int py_smbXsrv_client_global0_set_server_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_id");
		return -1;
	}
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server_id = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_client_global0_get_local_address(PyObject *obj, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_local_address;
	if (object->local_address == NULL) {
		py_local_address = Py_None;
		Py_INCREF(py_local_address);
	} else {
		py_local_address = PyUnicode_Decode(object->local_address, strlen(object->local_address), "utf-8", "ignore");
	}
	return py_local_address;
}

static int py_smbXsrv_client_global0_set_local_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->local_address");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->local_address = talloc_str;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_global0_get_remote_address(PyObject *obj, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_remote_address;
	if (object->remote_address == NULL) {
		py_remote_address = Py_None;
		Py_INCREF(py_remote_address);
	} else {
		py_remote_address = PyUnicode_Decode(object->remote_address, strlen(object->remote_address), "utf-8", "ignore");
	}
	return py_remote_address;
}

static int py_smbXsrv_client_global0_set_remote_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->remote_address");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->remote_address = talloc_str;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_global0_get_remote_name(PyObject *obj, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_remote_name;
	if (object->remote_name == NULL) {
		py_remote_name = Py_None;
		Py_INCREF(py_remote_name);
	} else {
		py_remote_name = PyUnicode_Decode(object->remote_name, strlen(object->remote_name), "utf-8", "ignore");
	}
	return py_remote_name;
}

static int py_smbXsrv_client_global0_set_remote_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->remote_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->remote_name = talloc_str;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_global0_get_initial_connect_time(PyObject *obj, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_initial_connect_time;
	py_initial_connect_time = PyLong_FromUnsignedLongLong(object->initial_connect_time);
	return py_initial_connect_time;
}

static int py_smbXsrv_client_global0_set_initial_connect_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initial_connect_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initial_connect_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initial_connect_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_client_global0_get_client_guid(PyObject *obj, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_guid;
	py_client_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->client_guid);
	return py_client_guid;
}

static int py_smbXsrv_client_global0_set_client_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_client_global0_get_stored(PyObject *obj, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_stored;
	py_stored = PyLong_FromLong((uint16_t)(object->stored));
	return py_stored;
}

static int py_smbXsrv_client_global0_set_stored(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->stored");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->stored));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->stored = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_client_global0_getsetters[] = {
	{
		.name = discard_const_p(char, "db_rec"),
		.get = py_smbXsrv_client_global0_get_db_rec,
		.set = py_smbXsrv_client_global0_set_db_rec,
		.doc = discard_const_p(char, "PIDL-generated element of base type db_record")
	},
	{
		.name = discard_const_p(char, "server_id"),
		.get = py_smbXsrv_client_global0_get_server_id,
		.set = py_smbXsrv_client_global0_set_server_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{
		.name = discard_const_p(char, "local_address"),
		.get = py_smbXsrv_client_global0_get_local_address,
		.set = py_smbXsrv_client_global0_set_local_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "remote_address"),
		.get = py_smbXsrv_client_global0_get_remote_address,
		.set = py_smbXsrv_client_global0_set_remote_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "remote_name"),
		.get = py_smbXsrv_client_global0_get_remote_name,
		.set = py_smbXsrv_client_global0_set_remote_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "initial_connect_time"),
		.get = py_smbXsrv_client_global0_get_initial_connect_time,
		.set = py_smbXsrv_client_global0_set_initial_connect_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "client_guid"),
		.get = py_smbXsrv_client_global0_get_client_guid,
		.set = py_smbXsrv_client_global0_set_client_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "stored"),
		.get = py_smbXsrv_client_global0_get_stored,
		.set = py_smbXsrv_client_global0_set_stored,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_client_global0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_client_global0, type);
}


static PyTypeObject smbXsrv_client_global0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.client_global0",
	.tp_getset = py_smbXsrv_client_global0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_client_global0_new,
};

static PyObject *py_import_smbXsrv_client_globalU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_client_globalU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_client_global0_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_client_globalU *py_export_smbXsrv_client_globalU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_client_globalU *ret = talloc_zero(mem_ctx, union smbXsrv_client_globalU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_client_global0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_client_global0 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_client_globalU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_client_globalU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_client_globalU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_client_globalU!");
		return NULL;
	}

	return py_import_smbXsrv_client_globalU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_client_globalU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_client_globalU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_client_globalU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_client_globalU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_client_globalU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_client_globalU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_client_globalU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_client_globalU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.client_globalU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_client_globalU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_client_globalU_new,
};


static PyObject *py_smbXsrv_client_globalB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_client_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_client_globalB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_client_globalB_get_seqnum(PyObject *obj, void *closure)
{
	struct smbXsrv_client_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_seqnum;
	py_seqnum = PyLong_FromUnsignedLongLong((uint32_t)(object->seqnum));
	return py_seqnum;
}

static int py_smbXsrv_client_globalB_set_seqnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->seqnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->seqnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->seqnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_client_globalB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_client_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_client_globalU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_client_globalU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_client_globalB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_client_globalU *info_switch_0;
		info_switch_0 = (union smbXsrv_client_globalU *)pyrpc_export_union(&smbXsrv_client_globalU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_client_globalU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_client_globalB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_client_globalB_get_version,
		.set = py_smbXsrv_client_globalB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "seqnum"),
		.get = py_smbXsrv_client_globalB_get_seqnum,
		.set = py_smbXsrv_client_globalB_set_seqnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_client_globalB_get_info,
		.set = py_smbXsrv_client_globalB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_client_globalU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_client_globalB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_client_globalB, type);
}

static PyObject *py_smbXsrv_client_globalB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_client_globalB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_client_globalB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_client_globalB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_client_globalB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_client_globalB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_client_globalB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_client_globalB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_client_globalB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_client_globalB, "smbXsrv_client_globalB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_client_globalB, "smbXsrv_client_globalB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_client_globalB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_client_globalB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_client_globalB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_client_globalB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_client_globalB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.client_globalB",
	.tp_getset = py_smbXsrv_client_globalB_getsetters,
	.tp_methods = py_smbXsrv_client_globalB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_client_globalB_new,
};


static PyObject *py_smbXsrv_client_get_table(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_table;
	if (object->table == NULL) {
		Py_RETURN_NONE;
	}
	if (object->table == NULL) {
		py_table = Py_None;
		Py_INCREF(py_table);
	} else {
		py_table = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->table to Python");
		return NULL;
	}
	return py_table;
}

static int py_smbXsrv_client_set_table(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->table));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->table");
		return -1;
	}
	if (value == Py_None) {
		object->table = NULL;
	} else {
		object->table = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->table");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_raw_ev_ctx(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_raw_ev_ctx;
	if (object->raw_ev_ctx == NULL) {
		Py_RETURN_NONE;
	}
	if (object->raw_ev_ctx == NULL) {
		py_raw_ev_ctx = Py_None;
		Py_INCREF(py_raw_ev_ctx);
	} else {
		py_raw_ev_ctx = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->raw_ev_ctx to Python");
		return NULL;
	}
	return py_raw_ev_ctx;
}

static int py_smbXsrv_client_set_raw_ev_ctx(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->raw_ev_ctx));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->raw_ev_ctx");
		return -1;
	}
	if (value == Py_None) {
		object->raw_ev_ctx = NULL;
	} else {
		object->raw_ev_ctx = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->raw_ev_ctx");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_msg_ctx(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_msg_ctx;
	if (object->msg_ctx == NULL) {
		Py_RETURN_NONE;
	}
	if (object->msg_ctx == NULL) {
		py_msg_ctx = Py_None;
		Py_INCREF(py_msg_ctx);
	} else {
		py_msg_ctx = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->msg_ctx to Python");
		return NULL;
	}
	return py_msg_ctx;
}

static int py_smbXsrv_client_set_msg_ctx(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->msg_ctx));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->msg_ctx");
		return -1;
	}
	if (value == Py_None) {
		object->msg_ctx = NULL;
	} else {
		object->msg_ctx = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->msg_ctx");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_global(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_global;
	if (object->global == NULL) {
		Py_RETURN_NONE;
	}
	py_global = pytalloc_reference_ex(&smbXsrv_client_global0_Type, object->global, object->global);
	return py_global;
}

static int py_smbXsrv_client_set_global(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->global));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->global");
		return -1;
	}
	object->global = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->global);
	if (object->global == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&smbXsrv_client_global0_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->global = (struct smbXsrv_client_global0 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_client_get_sconn(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_sconn;
	if (object->sconn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sconn == NULL) {
		py_sconn = Py_None;
		Py_INCREF(py_sconn);
	} else {
		py_sconn = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->sconn to Python");
		return NULL;
	}
	return py_sconn;
}

static int py_smbXsrv_client_set_sconn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sconn));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sconn");
		return -1;
	}
	if (value == Py_None) {
		object->sconn = NULL;
	} else {
		object->sconn = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->sconn");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_session_table(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_session_table;
	if (object->session_table == NULL) {
		Py_RETURN_NONE;
	}
	if (object->session_table == NULL) {
		py_session_table = Py_None;
		Py_INCREF(py_session_table);
	} else {
		py_session_table = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->session_table to Python");
		return NULL;
	}
	return py_session_table;
}

static int py_smbXsrv_client_set_session_table(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->session_table));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->session_table");
		return -1;
	}
	if (value == Py_None) {
		object->session_table = NULL;
	} else {
		object->session_table = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->session_table");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_tcon_table(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_tcon_table;
	if (object->tcon_table == NULL) {
		Py_RETURN_NONE;
	}
	if (object->tcon_table == NULL) {
		py_tcon_table = Py_None;
		Py_INCREF(py_tcon_table);
	} else {
		py_tcon_table = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->tcon_table to Python");
		return NULL;
	}
	return py_tcon_table;
}

static int py_smbXsrv_client_set_tcon_table(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->tcon_table));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tcon_table");
		return -1;
	}
	if (value == Py_None) {
		object->tcon_table = NULL;
	} else {
		object->tcon_table = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->tcon_table");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_open_table(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_open_table;
	if (object->open_table == NULL) {
		Py_RETURN_NONE;
	}
	if (object->open_table == NULL) {
		py_open_table = Py_None;
		Py_INCREF(py_open_table);
	} else {
		py_open_table = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->open_table to Python");
		return NULL;
	}
	return py_open_table;
}

static int py_smbXsrv_client_set_open_table(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->open_table));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->open_table");
		return -1;
	}
	if (value == Py_None) {
		object->open_table = NULL;
	} else {
		object->open_table = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->open_table");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_connections(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_connections;
	if (object->connections == NULL) {
		Py_RETURN_NONE;
	}
	if (object->connections == NULL) {
		py_connections = Py_None;
		Py_INCREF(py_connections);
	} else {
		py_connections = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->connections to Python");
		return NULL;
	}
	return py_connections;
}

static int py_smbXsrv_client_set_connections(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->connections));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->connections");
		return -1;
	}
	if (value == Py_None) {
		object->connections = NULL;
	} else {
		object->connections = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->connections");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_server_multi_channel_enabled(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_server_multi_channel_enabled;
	py_server_multi_channel_enabled = PyLong_FromLong((uint16_t)(object->server_multi_channel_enabled));
	return py_server_multi_channel_enabled;
}

static int py_smbXsrv_client_set_server_multi_channel_enabled(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_multi_channel_enabled");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->server_multi_channel_enabled));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->server_multi_channel_enabled = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_next_channel_id(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_next_channel_id;
	py_next_channel_id = PyLong_FromUnsignedLongLong(object->next_channel_id);
	return py_next_channel_id;
}

static int py_smbXsrv_client_set_next_channel_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->next_channel_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->next_channel_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->next_channel_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_connection_pass_subreq(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_connection_pass_subreq;
	if (object->connection_pass_subreq == NULL) {
		Py_RETURN_NONE;
	}
	if (object->connection_pass_subreq == NULL) {
		py_connection_pass_subreq = Py_None;
		Py_INCREF(py_connection_pass_subreq);
	} else {
		py_connection_pass_subreq = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->connection_pass_subreq to Python");
		return NULL;
	}
	return py_connection_pass_subreq;
}

static int py_smbXsrv_client_set_connection_pass_subreq(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->connection_pass_subreq));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->connection_pass_subreq");
		return -1;
	}
	if (value == Py_None) {
		object->connection_pass_subreq = NULL;
	} else {
		object->connection_pass_subreq = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->connection_pass_subreq");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_connection_drop_subreq(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_connection_drop_subreq;
	if (object->connection_drop_subreq == NULL) {
		Py_RETURN_NONE;
	}
	if (object->connection_drop_subreq == NULL) {
		py_connection_drop_subreq = Py_None;
		Py_INCREF(py_connection_drop_subreq);
	} else {
		py_connection_drop_subreq = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->connection_drop_subreq to Python");
		return NULL;
	}
	return py_connection_drop_subreq;
}

static int py_smbXsrv_client_set_connection_drop_subreq(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->connection_drop_subreq));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->connection_drop_subreq");
		return -1;
	}
	if (value == Py_None) {
		object->connection_drop_subreq = NULL;
	} else {
		object->connection_drop_subreq = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->connection_drop_subreq");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_client_get_pending_breaks(PyObject *obj, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(obj);
	PyObject *py_pending_breaks;
	if (object->pending_breaks == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pending_breaks == NULL) {
		py_pending_breaks = Py_None;
		Py_INCREF(py_pending_breaks);
	} else {
		py_pending_breaks = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->pending_breaks to Python");
		return NULL;
	}
	return py_pending_breaks;
}

static int py_smbXsrv_client_set_pending_breaks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pending_breaks));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pending_breaks");
		return -1;
	}
	if (value == Py_None) {
		object->pending_breaks = NULL;
	} else {
		object->pending_breaks = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->pending_breaks");
		return -1;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_client_getsetters[] = {
	{
		.name = discard_const_p(char, "table"),
		.get = py_smbXsrv_client_get_table,
		.set = py_smbXsrv_client_set_table,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_client_table")
	},
	{
		.name = discard_const_p(char, "raw_ev_ctx"),
		.get = py_smbXsrv_client_get_raw_ev_ctx,
		.set = py_smbXsrv_client_set_raw_ev_ctx,
		.doc = discard_const_p(char, "PIDL-generated element of base type tevent_context")
	},
	{
		.name = discard_const_p(char, "msg_ctx"),
		.get = py_smbXsrv_client_get_msg_ctx,
		.set = py_smbXsrv_client_set_msg_ctx,
		.doc = discard_const_p(char, "PIDL-generated element of base type messaging_context")
	},
	{
		.name = discard_const_p(char, "global"),
		.get = py_smbXsrv_client_get_global,
		.set = py_smbXsrv_client_set_global,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_client_global0")
	},
	{
		.name = discard_const_p(char, "sconn"),
		.get = py_smbXsrv_client_get_sconn,
		.set = py_smbXsrv_client_set_sconn,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbd_server_connection")
	},
	{
		.name = discard_const_p(char, "session_table"),
		.get = py_smbXsrv_client_get_session_table,
		.set = py_smbXsrv_client_set_session_table,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_session_table")
	},
	{
		.name = discard_const_p(char, "tcon_table"),
		.get = py_smbXsrv_client_get_tcon_table,
		.set = py_smbXsrv_client_set_tcon_table,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_tcon_table")
	},
	{
		.name = discard_const_p(char, "open_table"),
		.get = py_smbXsrv_client_get_open_table,
		.set = py_smbXsrv_client_set_open_table,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_open_table")
	},
	{
		.name = discard_const_p(char, "connections"),
		.get = py_smbXsrv_client_get_connections,
		.set = py_smbXsrv_client_set_connections,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_connection")
	},
	{
		.name = discard_const_p(char, "server_multi_channel_enabled"),
		.get = py_smbXsrv_client_get_server_multi_channel_enabled,
		.set = py_smbXsrv_client_set_server_multi_channel_enabled,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "next_channel_id"),
		.get = py_smbXsrv_client_get_next_channel_id,
		.set = py_smbXsrv_client_set_next_channel_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "connection_pass_subreq"),
		.get = py_smbXsrv_client_get_connection_pass_subreq,
		.set = py_smbXsrv_client_set_connection_pass_subreq,
		.doc = discard_const_p(char, "PIDL-generated element of base type tevent_req")
	},
	{
		.name = discard_const_p(char, "connection_drop_subreq"),
		.get = py_smbXsrv_client_get_connection_drop_subreq,
		.set = py_smbXsrv_client_set_connection_drop_subreq,
		.doc = discard_const_p(char, "PIDL-generated element of base type tevent_req")
	},
	{
		.name = discard_const_p(char, "pending_breaks"),
		.get = py_smbXsrv_client_get_pending_breaks,
		.set = py_smbXsrv_client_set_pending_breaks,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_pending_break")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_client_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_client, type);
}

static PyObject *py_smbXsrv_client_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_client);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_client_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_client);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_client);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_client_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_client *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_client, "smbXsrv_client", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_client, "smbXsrv_client", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_client_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_client_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_client_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_client_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_client_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.client",
	.tp_getset = py_smbXsrv_client_getsetters,
	.tp_methods = py_smbXsrv_client_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_client_new,
};

static PyObject *py_import_smbXsrv_clientU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_clientU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_client_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_clientU *py_export_smbXsrv_clientU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_clientU *ret = talloc_zero(mem_ctx, union smbXsrv_clientU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_client_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_client *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_clientU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_clientU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_clientU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_clientU!");
		return NULL;
	}

	return py_import_smbXsrv_clientU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_clientU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_clientU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_clientU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_clientU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_clientU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_clientU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_clientU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_clientU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.clientU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_clientU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_clientU_new,
};


static PyObject *py_smbXsrv_clientB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_clientB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_clientB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_clientB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_clientB_get_reserved(PyObject *obj, void *closure)
{
	struct smbXsrv_clientB *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_smbXsrv_clientB_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_clientB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_clientB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_clientB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_clientU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_clientU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_clientB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_clientB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_clientU *info_switch_0;
		info_switch_0 = (union smbXsrv_clientU *)pyrpc_export_union(&smbXsrv_clientU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_clientU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_clientB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_clientB_get_version,
		.set = py_smbXsrv_clientB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_smbXsrv_clientB_get_reserved,
		.set = py_smbXsrv_clientB_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_clientB_get_info,
		.set = py_smbXsrv_clientB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_clientU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_clientB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_clientB, type);
}

static PyObject *py_smbXsrv_clientB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_clientB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_clientB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_clientB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_clientB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_clientB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_clientB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_clientB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_clientB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_clientB, "smbXsrv_clientB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_clientB, "smbXsrv_clientB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_clientB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_clientB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_clientB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_clientB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_clientB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.clientB",
	.tp_getset = py_smbXsrv_clientB_getsetters,
	.tp_methods = py_smbXsrv_clientB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_clientB_new,
};


static PyObject *py_smbXsrv_connection_pass0_get_client_guid(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_guid;
	py_client_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->client_guid);
	return py_client_guid;
}

static int py_smbXsrv_connection_pass0_set_client_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_connection_pass0_get_src_server_id(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(obj);
	PyObject *py_src_server_id;
	py_src_server_id = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->src_server_id);
	return py_src_server_id;
}

static int py_smbXsrv_connection_pass0_set_src_server_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->src_server_id");
		return -1;
	}
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->src_server_id = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_connection_pass0_get_xconn_connect_time(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(obj);
	PyObject *py_xconn_connect_time;
	py_xconn_connect_time = PyLong_FromUnsignedLongLong(object->xconn_connect_time);
	return py_xconn_connect_time;
}

static int py_smbXsrv_connection_pass0_set_xconn_connect_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->xconn_connect_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->xconn_connect_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->xconn_connect_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_connection_pass0_get_dst_server_id(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(obj);
	PyObject *py_dst_server_id;
	py_dst_server_id = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->dst_server_id);
	return py_dst_server_id;
}

static int py_smbXsrv_connection_pass0_set_dst_server_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dst_server_id");
		return -1;
	}
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dst_server_id = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_connection_pass0_get_client_connect_time(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_connect_time;
	py_client_connect_time = PyLong_FromUnsignedLongLong(object->client_connect_time);
	return py_client_connect_time;
}

static int py_smbXsrv_connection_pass0_set_client_connect_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_connect_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->client_connect_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->client_connect_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_connection_pass0_get_transport_type(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(obj);
	PyObject *py_transport_type;
	py_transport_type = PyLong_FromLong((uint16_t)(object->transport_type));
	return py_transport_type;
}

static int py_smbXsrv_connection_pass0_set_transport_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->transport_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->transport_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->transport_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_connection_pass0_get_negotiate_request(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(obj);
	PyObject *py_negotiate_request;
	py_negotiate_request = PyBytes_FromStringAndSize((char *)(object->negotiate_request).data, (object->negotiate_request).length);
	return py_negotiate_request;
}

static int py_smbXsrv_connection_pass0_set_negotiate_request(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_pass0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->negotiate_request");
		return -1;
	}
	object->negotiate_request = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_smbXsrv_connection_pass0_getsetters[] = {
	{
		.name = discard_const_p(char, "client_guid"),
		.get = py_smbXsrv_connection_pass0_get_client_guid,
		.set = py_smbXsrv_connection_pass0_set_client_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "src_server_id"),
		.get = py_smbXsrv_connection_pass0_get_src_server_id,
		.set = py_smbXsrv_connection_pass0_set_src_server_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{
		.name = discard_const_p(char, "xconn_connect_time"),
		.get = py_smbXsrv_connection_pass0_get_xconn_connect_time,
		.set = py_smbXsrv_connection_pass0_set_xconn_connect_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "dst_server_id"),
		.get = py_smbXsrv_connection_pass0_get_dst_server_id,
		.set = py_smbXsrv_connection_pass0_set_dst_server_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{
		.name = discard_const_p(char, "client_connect_time"),
		.get = py_smbXsrv_connection_pass0_get_client_connect_time,
		.set = py_smbXsrv_connection_pass0_set_client_connect_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "transport_type"),
		.get = py_smbXsrv_connection_pass0_get_transport_type,
		.set = py_smbXsrv_connection_pass0_set_transport_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "negotiate_request"),
		.get = py_smbXsrv_connection_pass0_get_negotiate_request,
		.set = py_smbXsrv_connection_pass0_set_negotiate_request,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_connection_pass0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_connection_pass0, type);
}


static PyTypeObject smbXsrv_connection_pass0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.connection_pass0",
	.tp_getset = py_smbXsrv_connection_pass0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_connection_pass0_new,
};

static PyObject *py_import_smbXsrv_connection_passU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_connection_passU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_connection_pass0_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_connection_passU *py_export_smbXsrv_connection_passU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_connection_passU *ret = talloc_zero(mem_ctx, union smbXsrv_connection_passU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_connection_pass0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_connection_pass0 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_connection_passU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_connection_passU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_connection_passU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_connection_passU!");
		return NULL;
	}

	return py_import_smbXsrv_connection_passU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_connection_passU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_connection_passU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_connection_passU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_connection_passU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_connection_passU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_connection_passU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_connection_passU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_connection_passU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.connection_passU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_connection_passU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_connection_passU_new,
};


static PyObject *py_smbXsrv_connection_passB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_passB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_connection_passB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_passB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_connection_passB_get_reserved(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_passB *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_smbXsrv_connection_passB_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_passB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_connection_passB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_passB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_connection_passU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_connection_passU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_connection_passB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_passB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_connection_passU *info_switch_0;
		info_switch_0 = (union smbXsrv_connection_passU *)pyrpc_export_union(&smbXsrv_connection_passU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_connection_passU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_connection_passB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_connection_passB_get_version,
		.set = py_smbXsrv_connection_passB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_smbXsrv_connection_passB_get_reserved,
		.set = py_smbXsrv_connection_passB_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_connection_passB_get_info,
		.set = py_smbXsrv_connection_passB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_connection_passU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_connection_passB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_connection_passB, type);
}

static PyObject *py_smbXsrv_connection_passB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_connection_passB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_connection_passB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_connection_passB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_connection_passB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_connection_passB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_connection_passB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_connection_passB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_connection_passB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_connection_passB, "smbXsrv_connection_passB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_connection_passB, "smbXsrv_connection_passB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_connection_passB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_connection_passB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_connection_passB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_connection_passB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_connection_passB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.connection_passB",
	.tp_getset = py_smbXsrv_connection_passB_getsetters,
	.tp_methods = py_smbXsrv_connection_passB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_connection_passB_new,
};


static PyObject *py_smbXsrv_connection_drop0_get_client_guid(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_drop0 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_guid;
	py_client_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->client_guid);
	return py_client_guid;
}

static int py_smbXsrv_connection_drop0_set_client_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_drop0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_connection_drop0_get_src_server_id(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_drop0 *object = pytalloc_get_ptr(obj);
	PyObject *py_src_server_id;
	py_src_server_id = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->src_server_id);
	return py_src_server_id;
}

static int py_smbXsrv_connection_drop0_set_src_server_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_drop0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->src_server_id");
		return -1;
	}
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->src_server_id = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_connection_drop0_get_xconn_connect_time(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_drop0 *object = pytalloc_get_ptr(obj);
	PyObject *py_xconn_connect_time;
	py_xconn_connect_time = PyLong_FromUnsignedLongLong(object->xconn_connect_time);
	return py_xconn_connect_time;
}

static int py_smbXsrv_connection_drop0_set_xconn_connect_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_drop0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->xconn_connect_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->xconn_connect_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->xconn_connect_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_connection_drop0_get_dst_server_id(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_drop0 *object = pytalloc_get_ptr(obj);
	PyObject *py_dst_server_id;
	py_dst_server_id = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->dst_server_id);
	return py_dst_server_id;
}

static int py_smbXsrv_connection_drop0_set_dst_server_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_drop0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dst_server_id");
		return -1;
	}
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dst_server_id = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_connection_drop0_get_client_connect_time(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_drop0 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_connect_time;
	py_client_connect_time = PyLong_FromUnsignedLongLong(object->client_connect_time);
	return py_client_connect_time;
}

static int py_smbXsrv_connection_drop0_set_client_connect_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_drop0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_connect_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->client_connect_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->client_connect_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_connection_drop0_getsetters[] = {
	{
		.name = discard_const_p(char, "client_guid"),
		.get = py_smbXsrv_connection_drop0_get_client_guid,
		.set = py_smbXsrv_connection_drop0_set_client_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "src_server_id"),
		.get = py_smbXsrv_connection_drop0_get_src_server_id,
		.set = py_smbXsrv_connection_drop0_set_src_server_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{
		.name = discard_const_p(char, "xconn_connect_time"),
		.get = py_smbXsrv_connection_drop0_get_xconn_connect_time,
		.set = py_smbXsrv_connection_drop0_set_xconn_connect_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "dst_server_id"),
		.get = py_smbXsrv_connection_drop0_get_dst_server_id,
		.set = py_smbXsrv_connection_drop0_set_dst_server_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{
		.name = discard_const_p(char, "client_connect_time"),
		.get = py_smbXsrv_connection_drop0_get_client_connect_time,
		.set = py_smbXsrv_connection_drop0_set_client_connect_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_connection_drop0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_connection_drop0, type);
}


static PyTypeObject smbXsrv_connection_drop0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.connection_drop0",
	.tp_getset = py_smbXsrv_connection_drop0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_connection_drop0_new,
};

static PyObject *py_import_smbXsrv_connection_dropU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_connection_dropU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_connection_drop0_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_connection_dropU *py_export_smbXsrv_connection_dropU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_connection_dropU *ret = talloc_zero(mem_ctx, union smbXsrv_connection_dropU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_connection_drop0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_connection_drop0 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_connection_dropU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_connection_dropU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_connection_dropU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_connection_dropU!");
		return NULL;
	}

	return py_import_smbXsrv_connection_dropU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_connection_dropU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_connection_dropU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_connection_dropU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_connection_dropU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_connection_dropU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_connection_dropU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_connection_dropU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_connection_dropU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.connection_dropU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_connection_dropU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_connection_dropU_new,
};


static PyObject *py_smbXsrv_connection_dropB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_dropB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_connection_dropB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_dropB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_connection_dropB_get_reserved(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_dropB *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_smbXsrv_connection_dropB_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_dropB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_connection_dropB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_connection_dropB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_connection_dropU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_connection_dropU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_connection_dropB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_connection_dropB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_connection_dropU *info_switch_0;
		info_switch_0 = (union smbXsrv_connection_dropU *)pyrpc_export_union(&smbXsrv_connection_dropU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_connection_dropU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_connection_dropB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_connection_dropB_get_version,
		.set = py_smbXsrv_connection_dropB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_smbXsrv_connection_dropB_get_reserved,
		.set = py_smbXsrv_connection_dropB_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_connection_dropB_get_info,
		.set = py_smbXsrv_connection_dropB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_connection_dropU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_connection_dropB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_connection_dropB, type);
}

static PyObject *py_smbXsrv_connection_dropB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_connection_dropB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_connection_dropB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_connection_dropB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_connection_dropB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_connection_dropB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_connection_dropB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_connection_dropB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_connection_dropB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_connection_dropB, "smbXsrv_connection_dropB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_connection_dropB, "smbXsrv_connection_dropB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_connection_dropB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_connection_dropB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_connection_dropB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_connection_dropB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_connection_dropB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.connection_dropB",
	.tp_getset = py_smbXsrv_connection_dropB_getsetters,
	.tp_methods = py_smbXsrv_connection_dropB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_connection_dropB_new,
};


static PyObject *py_smbXsrv_channel_global0_get_server_id(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_id;
	py_server_id = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->server_id);
	return py_server_id;
}

static int py_smbXsrv_channel_global0_set_server_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_id");
		return -1;
	}
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server_id = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_channel_id(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_channel_id;
	py_channel_id = PyLong_FromUnsignedLongLong(object->channel_id);
	return py_channel_id;
}

static int py_smbXsrv_channel_global0_set_channel_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->channel_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->channel_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->channel_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_creation_time(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_creation_time;
	py_creation_time = PyLong_FromUnsignedLongLong(object->creation_time);
	return py_creation_time;
}

static int py_smbXsrv_channel_global0_set_creation_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->creation_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->creation_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->creation_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_local_address(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_local_address;
	if (object->local_address == NULL) {
		py_local_address = Py_None;
		Py_INCREF(py_local_address);
	} else {
		py_local_address = PyUnicode_Decode(object->local_address, strlen(object->local_address), "utf-8", "ignore");
	}
	return py_local_address;
}

static int py_smbXsrv_channel_global0_set_local_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->local_address");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->local_address = talloc_str;
	}
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_remote_address(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_remote_address;
	if (object->remote_address == NULL) {
		py_remote_address = Py_None;
		Py_INCREF(py_remote_address);
	} else {
		py_remote_address = PyUnicode_Decode(object->remote_address, strlen(object->remote_address), "utf-8", "ignore");
	}
	return py_remote_address;
}

static int py_smbXsrv_channel_global0_set_remote_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->remote_address");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->remote_address = talloc_str;
	}
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_remote_name(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_remote_name;
	if (object->remote_name == NULL) {
		py_remote_name = Py_None;
		Py_INCREF(py_remote_name);
	} else {
		py_remote_name = PyUnicode_Decode(object->remote_name, strlen(object->remote_name), "utf-8", "ignore");
	}
	return py_remote_name;
}

static int py_smbXsrv_channel_global0_set_remote_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->remote_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->remote_name = talloc_str;
	}
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_signing_key_blob(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_signing_key_blob;
	py_signing_key_blob = PyBytes_FromStringAndSize((char *)(object->signing_key_blob).data, (object->signing_key_blob).length);
	return py_signing_key_blob;
}

static int py_smbXsrv_channel_global0_set_signing_key_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->signing_key_blob");
		return -1;
	}
	object->signing_key_blob = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_signing_key(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_signing_key;
	if (object->signing_key == NULL) {
		Py_RETURN_NONE;
	}
	if (object->signing_key == NULL) {
		py_signing_key = Py_None;
		Py_INCREF(py_signing_key);
	} else {
		py_signing_key = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->signing_key to Python");
		return NULL;
	}
	return py_signing_key;
}

static int py_smbXsrv_channel_global0_set_signing_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->signing_key));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->signing_key");
		return -1;
	}
	if (value == Py_None) {
		object->signing_key = NULL;
	} else {
		object->signing_key = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->signing_key");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_auth_session_info_seqnum(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_session_info_seqnum;
	py_auth_session_info_seqnum = PyLong_FromUnsignedLongLong((uint32_t)(object->auth_session_info_seqnum));
	return py_auth_session_info_seqnum;
}

static int py_smbXsrv_channel_global0_set_auth_session_info_seqnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_session_info_seqnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_session_info_seqnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_session_info_seqnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_connection(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_connection;
	if (object->connection == NULL) {
		Py_RETURN_NONE;
	}
	if (object->connection == NULL) {
		py_connection = Py_None;
		Py_INCREF(py_connection);
	} else {
		py_connection = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->connection to Python");
		return NULL;
	}
	return py_connection;
}

static int py_smbXsrv_channel_global0_set_connection(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->connection));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->connection");
		return -1;
	}
	if (value == Py_None) {
		object->connection = NULL;
	} else {
		object->connection = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->connection");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_signing_algo(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_signing_algo;
	py_signing_algo = PyLong_FromLong((uint16_t)(object->signing_algo));
	return py_signing_algo;
}

static int py_smbXsrv_channel_global0_set_signing_algo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->signing_algo");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->signing_algo));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->signing_algo = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_encryption_cipher(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_encryption_cipher;
	py_encryption_cipher = PyLong_FromLong((uint16_t)(object->encryption_cipher));
	return py_encryption_cipher;
}

static int py_smbXsrv_channel_global0_set_encryption_cipher(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->encryption_cipher");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->encryption_cipher));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->encryption_cipher = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_channel_global0_get_transport_type(PyObject *obj, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_transport_type;
	py_transport_type = PyLong_FromLong((uint16_t)(object->transport_type));
	return py_transport_type;
}

static int py_smbXsrv_channel_global0_set_transport_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_channel_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->transport_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->transport_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->transport_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_channel_global0_getsetters[] = {
	{
		.name = discard_const_p(char, "server_id"),
		.get = py_smbXsrv_channel_global0_get_server_id,
		.set = py_smbXsrv_channel_global0_set_server_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{
		.name = discard_const_p(char, "channel_id"),
		.get = py_smbXsrv_channel_global0_get_channel_id,
		.set = py_smbXsrv_channel_global0_set_channel_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "creation_time"),
		.get = py_smbXsrv_channel_global0_get_creation_time,
		.set = py_smbXsrv_channel_global0_set_creation_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "local_address"),
		.get = py_smbXsrv_channel_global0_get_local_address,
		.set = py_smbXsrv_channel_global0_set_local_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "remote_address"),
		.get = py_smbXsrv_channel_global0_get_remote_address,
		.set = py_smbXsrv_channel_global0_set_remote_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "remote_name"),
		.get = py_smbXsrv_channel_global0_get_remote_name,
		.set = py_smbXsrv_channel_global0_set_remote_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "signing_key_blob"),
		.get = py_smbXsrv_channel_global0_get_signing_key_blob,
		.set = py_smbXsrv_channel_global0_set_signing_key_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "signing_key"),
		.get = py_smbXsrv_channel_global0_get_signing_key,
		.set = py_smbXsrv_channel_global0_set_signing_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb2_signing_key")
	},
	{
		.name = discard_const_p(char, "auth_session_info_seqnum"),
		.get = py_smbXsrv_channel_global0_get_auth_session_info_seqnum,
		.set = py_smbXsrv_channel_global0_set_auth_session_info_seqnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "connection"),
		.get = py_smbXsrv_channel_global0_get_connection,
		.set = py_smbXsrv_channel_global0_set_connection,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_connection")
	},
	{
		.name = discard_const_p(char, "signing_algo"),
		.get = py_smbXsrv_channel_global0_get_signing_algo,
		.set = py_smbXsrv_channel_global0_set_signing_algo,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "encryption_cipher"),
		.get = py_smbXsrv_channel_global0_get_encryption_cipher,
		.set = py_smbXsrv_channel_global0_set_encryption_cipher,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "transport_type"),
		.get = py_smbXsrv_channel_global0_get_transport_type,
		.set = py_smbXsrv_channel_global0_set_transport_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_channel_global0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_channel_global0, type);
}


static PyTypeObject smbXsrv_channel_global0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.channel_global0",
	.tp_getset = py_smbXsrv_channel_global0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_channel_global0_new,
};


static PyObject *py_smbXsrv_session_global0_get_db_rec(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_db_rec;
	if (object->db_rec == NULL) {
		Py_RETURN_NONE;
	}
	if (object->db_rec == NULL) {
		py_db_rec = Py_None;
		Py_INCREF(py_db_rec);
	} else {
		py_db_rec = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->db_rec to Python");
		return NULL;
	}
	return py_db_rec;
}

static int py_smbXsrv_session_global0_set_db_rec(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->db_rec));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->db_rec");
		return -1;
	}
	if (value == Py_None) {
		object->db_rec = NULL;
	} else {
		object->db_rec = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->db_rec");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_session_global_id(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_session_global_id;
	py_session_global_id = PyLong_FromUnsignedLongLong((uint32_t)(object->session_global_id));
	return py_session_global_id;
}

static int py_smbXsrv_session_global0_set_session_global_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->session_global_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->session_global_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->session_global_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_session_wire_id(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_session_wire_id;
	py_session_wire_id = PyLong_FromUnsignedLongLong(object->session_wire_id);
	return py_session_wire_id;
}

static int py_smbXsrv_session_global0_set_session_wire_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->session_wire_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->session_wire_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->session_wire_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_creation_time(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_creation_time;
	py_creation_time = PyLong_FromUnsignedLongLong(object->creation_time);
	return py_creation_time;
}

static int py_smbXsrv_session_global0_set_creation_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->creation_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->creation_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->creation_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_expiration_time(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_expiration_time;
	py_expiration_time = PyLong_FromUnsignedLongLong(object->expiration_time);
	return py_expiration_time;
}

static int py_smbXsrv_session_global0_set_expiration_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->expiration_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->expiration_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->expiration_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_auth_time(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_time;
	py_auth_time = PyLong_FromUnsignedLongLong(object->auth_time);
	return py_auth_time;
}

static int py_smbXsrv_session_global0_set_auth_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_auth_session_info_seqnum(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_session_info_seqnum;
	py_auth_session_info_seqnum = PyLong_FromUnsignedLongLong((uint32_t)(object->auth_session_info_seqnum));
	return py_auth_session_info_seqnum;
}

static int py_smbXsrv_session_global0_set_auth_session_info_seqnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_session_info_seqnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_session_info_seqnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_session_info_seqnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_auth_session_info(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_session_info;
	if (object->auth_session_info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->auth_session_info == NULL) {
		py_auth_session_info = Py_None;
		Py_INCREF(py_auth_session_info);
	} else {
		py_auth_session_info = pytalloc_reference_ex(auth_session_info_Type, object->auth_session_info, object->auth_session_info);
	}
	return py_auth_session_info;
}

static int py_smbXsrv_session_global0_set_auth_session_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->auth_session_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_session_info");
		return -1;
	}
	if (value == Py_None) {
		object->auth_session_info = NULL;
	} else {
		object->auth_session_info = NULL;
		PY_CHECK_TYPE(auth_session_info_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->auth_session_info = (struct auth_session_info *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_connection_dialect(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_connection_dialect;
	py_connection_dialect = PyLong_FromLong((uint16_t)(object->connection_dialect));
	return py_connection_dialect;
}

static int py_smbXsrv_session_global0_set_connection_dialect(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->connection_dialect");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->connection_dialect));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->connection_dialect = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_client_guid(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_guid;
	py_client_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->client_guid);
	return py_client_guid;
}

static int py_smbXsrv_session_global0_set_client_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_signing_flags(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_signing_flags;
	py_signing_flags = PyLong_FromLong((uint16_t)(object->signing_flags));
	return py_signing_flags;
}

static int py_smbXsrv_session_global0_set_signing_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->signing_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->signing_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->signing_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_signing_algo(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_signing_algo;
	py_signing_algo = PyLong_FromLong((uint16_t)(object->signing_algo));
	return py_signing_algo;
}

static int py_smbXsrv_session_global0_set_signing_algo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->signing_algo");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->signing_algo));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->signing_algo = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_encryption_flags(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_encryption_flags;
	py_encryption_flags = PyLong_FromLong((uint16_t)(object->encryption_flags));
	return py_encryption_flags;
}

static int py_smbXsrv_session_global0_set_encryption_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->encryption_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->encryption_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->encryption_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_encryption_cipher(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_encryption_cipher;
	py_encryption_cipher = PyLong_FromLong((uint16_t)(object->encryption_cipher));
	return py_encryption_cipher;
}

static int py_smbXsrv_session_global0_set_encryption_cipher(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->encryption_cipher");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->encryption_cipher));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->encryption_cipher = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_signing_key_blob(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_signing_key_blob;
	py_signing_key_blob = PyBytes_FromStringAndSize((char *)(object->signing_key_blob).data, (object->signing_key_blob).length);
	return py_signing_key_blob;
}

static int py_smbXsrv_session_global0_set_signing_key_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->signing_key_blob");
		return -1;
	}
	object->signing_key_blob = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_signing_key(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_signing_key;
	if (object->signing_key == NULL) {
		Py_RETURN_NONE;
	}
	if (object->signing_key == NULL) {
		py_signing_key = Py_None;
		Py_INCREF(py_signing_key);
	} else {
		py_signing_key = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->signing_key to Python");
		return NULL;
	}
	return py_signing_key;
}

static int py_smbXsrv_session_global0_set_signing_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->signing_key));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->signing_key");
		return -1;
	}
	if (value == Py_None) {
		object->signing_key = NULL;
	} else {
		object->signing_key = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->signing_key");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_encryption_key_blob(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_encryption_key_blob;
	py_encryption_key_blob = PyBytes_FromStringAndSize((char *)(object->encryption_key_blob).data, (object->encryption_key_blob).length);
	return py_encryption_key_blob;
}

static int py_smbXsrv_session_global0_set_encryption_key_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->encryption_key_blob");
		return -1;
	}
	object->encryption_key_blob = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_encryption_key(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_encryption_key;
	if (object->encryption_key == NULL) {
		Py_RETURN_NONE;
	}
	if (object->encryption_key == NULL) {
		py_encryption_key = Py_None;
		Py_INCREF(py_encryption_key);
	} else {
		py_encryption_key = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->encryption_key to Python");
		return NULL;
	}
	return py_encryption_key;
}

static int py_smbXsrv_session_global0_set_encryption_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->encryption_key));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->encryption_key");
		return -1;
	}
	if (value == Py_None) {
		object->encryption_key = NULL;
	} else {
		object->encryption_key = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->encryption_key");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_decryption_key_blob(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_decryption_key_blob;
	py_decryption_key_blob = PyBytes_FromStringAndSize((char *)(object->decryption_key_blob).data, (object->decryption_key_blob).length);
	return py_decryption_key_blob;
}

static int py_smbXsrv_session_global0_set_decryption_key_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->decryption_key_blob");
		return -1;
	}
	object->decryption_key_blob = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_decryption_key(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_decryption_key;
	if (object->decryption_key == NULL) {
		Py_RETURN_NONE;
	}
	if (object->decryption_key == NULL) {
		py_decryption_key = Py_None;
		Py_INCREF(py_decryption_key);
	} else {
		py_decryption_key = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->decryption_key to Python");
		return NULL;
	}
	return py_decryption_key;
}

static int py_smbXsrv_session_global0_set_decryption_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->decryption_key));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->decryption_key");
		return -1;
	}
	if (value == Py_None) {
		object->decryption_key = NULL;
	} else {
		object->decryption_key = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->decryption_key");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_application_key_blob(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_application_key_blob;
	py_application_key_blob = PyBytes_FromStringAndSize((char *)(object->application_key_blob).data, (object->application_key_blob).length);
	return py_application_key_blob;
}

static int py_smbXsrv_session_global0_set_application_key_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->application_key_blob");
		return -1;
	}
	object->application_key_blob = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_application_key(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_application_key;
	if (object->application_key == NULL) {
		Py_RETURN_NONE;
	}
	if (object->application_key == NULL) {
		py_application_key = Py_None;
		Py_INCREF(py_application_key);
	} else {
		py_application_key = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->application_key to Python");
		return NULL;
	}
	return py_application_key;
}

static int py_smbXsrv_session_global0_set_application_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->application_key));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->application_key");
		return -1;
	}
	if (value == Py_None) {
		object->application_key = NULL;
	} else {
		object->application_key = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->application_key");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_num_channels(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_channels;
	py_num_channels = PyLong_FromUnsignedLongLong((uint32_t)(object->num_channels));
	return py_num_channels;
}

static int py_smbXsrv_session_global0_set_num_channels(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_channels");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_channels));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_channels = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_global0_get_channels(PyObject *obj, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_channels;
	py_channels = PyList_New(object->num_channels);
	if (py_channels == NULL) {
		return NULL;
	}
	{
		int channels_cntr_0;
		for (channels_cntr_0 = 0; channels_cntr_0 < (object->num_channels); channels_cntr_0++) {
			PyObject *py_channels_0;
			py_channels_0 = pytalloc_reference_ex(&smbXsrv_channel_global0_Type, object->channels, &(object->channels)[channels_cntr_0]);
			PyList_SetItem(py_channels, channels_cntr_0, py_channels_0);
		}
	}
	return py_channels;
}

static int py_smbXsrv_session_global0_set_channels(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->channels");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int channels_cntr_0;
		object->channels = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->channels, PyList_GET_SIZE(value));
		if (!object->channels) { return -1; }
		talloc_set_name_const(object->channels, "ARRAY: object->channels");
		for (channels_cntr_0 = 0; channels_cntr_0 < PyList_GET_SIZE(value); channels_cntr_0++) {
			if (PyList_GET_ITEM(value, channels_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->channels)[channels_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&smbXsrv_channel_global0_Type, PyList_GET_ITEM(value, channels_cntr_0), return -1;);
			if (talloc_reference(object->channels, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, channels_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->channels)[channels_cntr_0] = *(struct smbXsrv_channel_global0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, channels_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_session_global0_getsetters[] = {
	{
		.name = discard_const_p(char, "db_rec"),
		.get = py_smbXsrv_session_global0_get_db_rec,
		.set = py_smbXsrv_session_global0_set_db_rec,
		.doc = discard_const_p(char, "PIDL-generated element of base type db_record")
	},
	{
		.name = discard_const_p(char, "session_global_id"),
		.get = py_smbXsrv_session_global0_get_session_global_id,
		.set = py_smbXsrv_session_global0_set_session_global_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "session_wire_id"),
		.get = py_smbXsrv_session_global0_get_session_wire_id,
		.set = py_smbXsrv_session_global0_set_session_wire_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "creation_time"),
		.get = py_smbXsrv_session_global0_get_creation_time,
		.set = py_smbXsrv_session_global0_set_creation_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "expiration_time"),
		.get = py_smbXsrv_session_global0_get_expiration_time,
		.set = py_smbXsrv_session_global0_set_expiration_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "auth_time"),
		.get = py_smbXsrv_session_global0_get_auth_time,
		.set = py_smbXsrv_session_global0_set_auth_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "auth_session_info_seqnum"),
		.get = py_smbXsrv_session_global0_get_auth_session_info_seqnum,
		.set = py_smbXsrv_session_global0_set_auth_session_info_seqnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "auth_session_info"),
		.get = py_smbXsrv_session_global0_get_auth_session_info,
		.set = py_smbXsrv_session_global0_set_auth_session_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type auth_session_info")
	},
	{
		.name = discard_const_p(char, "connection_dialect"),
		.get = py_smbXsrv_session_global0_get_connection_dialect,
		.set = py_smbXsrv_session_global0_set_connection_dialect,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "client_guid"),
		.get = py_smbXsrv_session_global0_get_client_guid,
		.set = py_smbXsrv_session_global0_set_client_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "signing_flags"),
		.get = py_smbXsrv_session_global0_get_signing_flags,
		.set = py_smbXsrv_session_global0_set_signing_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_signing_flags")
	},
	{
		.name = discard_const_p(char, "signing_algo"),
		.get = py_smbXsrv_session_global0_get_signing_algo,
		.set = py_smbXsrv_session_global0_set_signing_algo,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "encryption_flags"),
		.get = py_smbXsrv_session_global0_get_encryption_flags,
		.set = py_smbXsrv_session_global0_set_encryption_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_encrpytion_flags")
	},
	{
		.name = discard_const_p(char, "encryption_cipher"),
		.get = py_smbXsrv_session_global0_get_encryption_cipher,
		.set = py_smbXsrv_session_global0_set_encryption_cipher,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "signing_key_blob"),
		.get = py_smbXsrv_session_global0_get_signing_key_blob,
		.set = py_smbXsrv_session_global0_set_signing_key_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "signing_key"),
		.get = py_smbXsrv_session_global0_get_signing_key,
		.set = py_smbXsrv_session_global0_set_signing_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb2_signing_key")
	},
	{
		.name = discard_const_p(char, "encryption_key_blob"),
		.get = py_smbXsrv_session_global0_get_encryption_key_blob,
		.set = py_smbXsrv_session_global0_set_encryption_key_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "encryption_key"),
		.get = py_smbXsrv_session_global0_get_encryption_key,
		.set = py_smbXsrv_session_global0_set_encryption_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb2_signing_key")
	},
	{
		.name = discard_const_p(char, "decryption_key_blob"),
		.get = py_smbXsrv_session_global0_get_decryption_key_blob,
		.set = py_smbXsrv_session_global0_set_decryption_key_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "decryption_key"),
		.get = py_smbXsrv_session_global0_get_decryption_key,
		.set = py_smbXsrv_session_global0_set_decryption_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb2_signing_key")
	},
	{
		.name = discard_const_p(char, "application_key_blob"),
		.get = py_smbXsrv_session_global0_get_application_key_blob,
		.set = py_smbXsrv_session_global0_set_application_key_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "application_key"),
		.get = py_smbXsrv_session_global0_get_application_key,
		.set = py_smbXsrv_session_global0_set_application_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb2_signing_key")
	},
	{
		.name = discard_const_p(char, "num_channels"),
		.get = py_smbXsrv_session_global0_get_num_channels,
		.set = py_smbXsrv_session_global0_set_num_channels,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "channels"),
		.get = py_smbXsrv_session_global0_get_channels,
		.set = py_smbXsrv_session_global0_set_channels,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_channel_global0")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_session_global0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_session_global0, type);
}


static PyTypeObject smbXsrv_session_global0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.session_global0",
	.tp_getset = py_smbXsrv_session_global0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_session_global0_new,
};

static PyObject *py_import_smbXsrv_session_globalU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_session_globalU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_session_global0_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_session_globalU *py_export_smbXsrv_session_globalU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_session_globalU *ret = talloc_zero(mem_ctx, union smbXsrv_session_globalU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_session_global0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_session_global0 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_session_globalU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_session_globalU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_session_globalU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_session_globalU!");
		return NULL;
	}

	return py_import_smbXsrv_session_globalU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_session_globalU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_session_globalU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_session_globalU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_session_globalU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_session_globalU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_session_globalU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_session_globalU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_session_globalU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.session_globalU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_session_globalU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_session_globalU_new,
};


static PyObject *py_smbXsrv_session_globalB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_session_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_session_globalB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_globalB_get_seqnum(PyObject *obj, void *closure)
{
	struct smbXsrv_session_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_seqnum;
	py_seqnum = PyLong_FromUnsignedLongLong((uint32_t)(object->seqnum));
	return py_seqnum;
}

static int py_smbXsrv_session_globalB_set_seqnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->seqnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->seqnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->seqnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_globalB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_session_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_session_globalU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_session_globalU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_session_globalB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_session_globalU *info_switch_0;
		info_switch_0 = (union smbXsrv_session_globalU *)pyrpc_export_union(&smbXsrv_session_globalU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_session_globalU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_session_globalB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_session_globalB_get_version,
		.set = py_smbXsrv_session_globalB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "seqnum"),
		.get = py_smbXsrv_session_globalB_get_seqnum,
		.set = py_smbXsrv_session_globalB_set_seqnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_session_globalB_get_info,
		.set = py_smbXsrv_session_globalB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_session_globalU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_session_globalB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_session_globalB, type);
}

static PyObject *py_smbXsrv_session_globalB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_session_globalB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_session_globalB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_session_globalB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_session_globalB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_session_globalB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_session_globalB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_session_globalB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_session_globalB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_session_globalB, "smbXsrv_session_globalB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_session_globalB, "smbXsrv_session_globalB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_session_globalB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_session_globalB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_session_globalB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_session_globalB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_session_globalB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.session_globalB",
	.tp_getset = py_smbXsrv_session_globalB_getsetters,
	.tp_methods = py_smbXsrv_session_globalB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_session_globalB_new,
};


static PyObject *py_smbXsrv_session_auth0_get_prev(PyObject *obj, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(obj);
	PyObject *py_prev;
	if (object->prev == NULL) {
		Py_RETURN_NONE;
	}
	if (object->prev == NULL) {
		py_prev = Py_None;
		Py_INCREF(py_prev);
	} else {
		py_prev = pytalloc_reference_ex(&smbXsrv_session_auth0_Type, object->prev, object->prev);
	}
	return py_prev;
}

static int py_smbXsrv_session_auth0_set_prev(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->prev));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->prev");
		return -1;
	}
	if (value == Py_None) {
		object->prev = NULL;
	} else {
		object->prev = NULL;
		PY_CHECK_TYPE(&smbXsrv_session_auth0_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->prev = (struct smbXsrv_session_auth0 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_smbXsrv_session_auth0_get_next(PyObject *obj, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(obj);
	PyObject *py_next;
	if (object->next == NULL) {
		Py_RETURN_NONE;
	}
	if (object->next == NULL) {
		py_next = Py_None;
		Py_INCREF(py_next);
	} else {
		py_next = pytalloc_reference_ex(&smbXsrv_session_auth0_Type, object->next, object->next);
	}
	return py_next;
}

static int py_smbXsrv_session_auth0_set_next(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->next));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->next");
		return -1;
	}
	if (value == Py_None) {
		object->next = NULL;
	} else {
		object->next = NULL;
		PY_CHECK_TYPE(&smbXsrv_session_auth0_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->next = (struct smbXsrv_session_auth0 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_smbXsrv_session_auth0_get_session(PyObject *obj, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(obj);
	PyObject *py_session;
	if (object->session == NULL) {
		Py_RETURN_NONE;
	}
	if (object->session == NULL) {
		py_session = Py_None;
		Py_INCREF(py_session);
	} else {
		py_session = pytalloc_reference_ex(&smbXsrv_session_Type, object->session, object->session);
	}
	return py_session;
}

static int py_smbXsrv_session_auth0_set_session(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->session));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->session");
		return -1;
	}
	if (value == Py_None) {
		object->session = NULL;
	} else {
		object->session = NULL;
		PY_CHECK_TYPE(&smbXsrv_session_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->session = (struct smbXsrv_session *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_smbXsrv_session_auth0_get_connection(PyObject *obj, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(obj);
	PyObject *py_connection;
	if (object->connection == NULL) {
		Py_RETURN_NONE;
	}
	if (object->connection == NULL) {
		py_connection = Py_None;
		Py_INCREF(py_connection);
	} else {
		py_connection = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->connection to Python");
		return NULL;
	}
	return py_connection;
}

static int py_smbXsrv_session_auth0_set_connection(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->connection));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->connection");
		return -1;
	}
	if (value == Py_None) {
		object->connection = NULL;
	} else {
		object->connection = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->connection");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_session_auth0_get_gensec(PyObject *obj, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(obj);
	PyObject *py_gensec;
	if (object->gensec == NULL) {
		Py_RETURN_NONE;
	}
	if (object->gensec == NULL) {
		py_gensec = Py_None;
		Py_INCREF(py_gensec);
	} else {
		py_gensec = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->gensec to Python");
		return NULL;
	}
	return py_gensec;
}

static int py_smbXsrv_session_auth0_set_gensec(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->gensec));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->gensec");
		return -1;
	}
	if (value == Py_None) {
		object->gensec = NULL;
	} else {
		object->gensec = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->gensec");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_session_auth0_get_preauth(PyObject *obj, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(obj);
	PyObject *py_preauth;
	if (object->preauth == NULL) {
		Py_RETURN_NONE;
	}
	if (object->preauth == NULL) {
		py_preauth = Py_None;
		Py_INCREF(py_preauth);
	} else {
		py_preauth = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->preauth to Python");
		return NULL;
	}
	return py_preauth;
}

static int py_smbXsrv_session_auth0_set_preauth(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->preauth));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->preauth");
		return -1;
	}
	if (value == Py_None) {
		object->preauth = NULL;
	} else {
		object->preauth = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->preauth");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_session_auth0_get_in_flags(PyObject *obj, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(obj);
	PyObject *py_in_flags;
	py_in_flags = PyLong_FromLong((uint16_t)(object->in_flags));
	return py_in_flags;
}

static int py_smbXsrv_session_auth0_set_in_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_auth0_get_in_security_mode(PyObject *obj, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(obj);
	PyObject *py_in_security_mode;
	py_in_security_mode = PyLong_FromLong((uint16_t)(object->in_security_mode));
	return py_in_security_mode;
}

static int py_smbXsrv_session_auth0_set_in_security_mode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in_security_mode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in_security_mode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in_security_mode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_auth0_get_creation_time(PyObject *obj, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(obj);
	PyObject *py_creation_time;
	py_creation_time = PyLong_FromUnsignedLongLong(object->creation_time);
	return py_creation_time;
}

static int py_smbXsrv_session_auth0_set_creation_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->creation_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->creation_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->creation_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_auth0_get_idle_time(PyObject *obj, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(obj);
	PyObject *py_idle_time;
	py_idle_time = PyLong_FromUnsignedLongLong(object->idle_time);
	return py_idle_time;
}

static int py_smbXsrv_session_auth0_set_idle_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idle_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idle_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idle_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_auth0_get_channel_id(PyObject *obj, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(obj);
	PyObject *py_channel_id;
	py_channel_id = PyLong_FromUnsignedLongLong(object->channel_id);
	return py_channel_id;
}

static int py_smbXsrv_session_auth0_set_channel_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_auth0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->channel_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->channel_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->channel_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_session_auth0_getsetters[] = {
	{
		.name = discard_const_p(char, "prev"),
		.get = py_smbXsrv_session_auth0_get_prev,
		.set = py_smbXsrv_session_auth0_set_prev,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_session_auth0")
	},
	{
		.name = discard_const_p(char, "next"),
		.get = py_smbXsrv_session_auth0_get_next,
		.set = py_smbXsrv_session_auth0_set_next,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_session_auth0")
	},
	{
		.name = discard_const_p(char, "session"),
		.get = py_smbXsrv_session_auth0_get_session,
		.set = py_smbXsrv_session_auth0_set_session,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_session")
	},
	{
		.name = discard_const_p(char, "connection"),
		.get = py_smbXsrv_session_auth0_get_connection,
		.set = py_smbXsrv_session_auth0_set_connection,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_connection")
	},
	{
		.name = discard_const_p(char, "gensec"),
		.get = py_smbXsrv_session_auth0_get_gensec,
		.set = py_smbXsrv_session_auth0_set_gensec,
		.doc = discard_const_p(char, "PIDL-generated element of base type gensec_security")
	},
	{
		.name = discard_const_p(char, "preauth"),
		.get = py_smbXsrv_session_auth0_get_preauth,
		.set = py_smbXsrv_session_auth0_set_preauth,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_preauth")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_smbXsrv_session_auth0_get_in_flags,
		.set = py_smbXsrv_session_auth0_set_in_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_security_mode"),
		.get = py_smbXsrv_session_auth0_get_in_security_mode,
		.set = py_smbXsrv_session_auth0_set_in_security_mode,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "creation_time"),
		.get = py_smbXsrv_session_auth0_get_creation_time,
		.set = py_smbXsrv_session_auth0_set_creation_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "idle_time"),
		.get = py_smbXsrv_session_auth0_get_idle_time,
		.set = py_smbXsrv_session_auth0_set_idle_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "channel_id"),
		.get = py_smbXsrv_session_auth0_get_channel_id,
		.set = py_smbXsrv_session_auth0_set_channel_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_session_auth0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_session_auth0, type);
}


static PyTypeObject smbXsrv_session_auth0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.session_auth0",
	.tp_getset = py_smbXsrv_session_auth0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_session_auth0_new,
};


static PyObject *py_smbXsrv_session_get_table(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_table;
	if (object->table == NULL) {
		Py_RETURN_NONE;
	}
	if (object->table == NULL) {
		py_table = Py_None;
		Py_INCREF(py_table);
	} else {
		py_table = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->table to Python");
		return NULL;
	}
	return py_table;
}

static int py_smbXsrv_session_set_table(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->table));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->table");
		return -1;
	}
	if (value == Py_None) {
		object->table = NULL;
	} else {
		object->table = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->table");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_session_get_db_rec(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_db_rec;
	if (object->db_rec == NULL) {
		Py_RETURN_NONE;
	}
	if (object->db_rec == NULL) {
		py_db_rec = Py_None;
		Py_INCREF(py_db_rec);
	} else {
		py_db_rec = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->db_rec to Python");
		return NULL;
	}
	return py_db_rec;
}

static int py_smbXsrv_session_set_db_rec(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->db_rec));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->db_rec");
		return -1;
	}
	if (value == Py_None) {
		object->db_rec = NULL;
	} else {
		object->db_rec = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->db_rec");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_session_get_client(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_client;
	if (object->client == NULL) {
		Py_RETURN_NONE;
	}
	if (object->client == NULL) {
		py_client = Py_None;
		Py_INCREF(py_client);
	} else {
		py_client = pytalloc_reference_ex(&smbXsrv_client_Type, object->client, object->client);
	}
	return py_client;
}

static int py_smbXsrv_session_set_client(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->client));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client");
		return -1;
	}
	if (value == Py_None) {
		object->client = NULL;
	} else {
		object->client = NULL;
		PY_CHECK_TYPE(&smbXsrv_client_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->client = (struct smbXsrv_client *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_smbXsrv_session_get_local_id(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_local_id;
	py_local_id = PyLong_FromUnsignedLongLong((uint32_t)(object->local_id));
	return py_local_id;
}

static int py_smbXsrv_session_set_local_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->local_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->local_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->local_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_get_global(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_global;
	if (object->global == NULL) {
		Py_RETURN_NONE;
	}
	py_global = pytalloc_reference_ex(&smbXsrv_session_global0_Type, object->global, object->global);
	return py_global;
}

static int py_smbXsrv_session_set_global(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->global));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->global");
		return -1;
	}
	object->global = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->global);
	if (object->global == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&smbXsrv_session_global0_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->global = (struct smbXsrv_session_global0 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_session_get_status(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromNTSTATUS(object->status);
	return py_status;
}

static int py_smbXsrv_session_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	object->status = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_smbXsrv_session_get_idle_time(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_idle_time;
	py_idle_time = PyLong_FromUnsignedLongLong(object->idle_time);
	return py_idle_time;
}

static int py_smbXsrv_session_set_idle_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idle_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idle_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idle_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_get_nonce_high_random(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_nonce_high_random;
	py_nonce_high_random = PyLong_FromUnsignedLongLong(object->nonce_high_random);
	return py_nonce_high_random;
}

static int py_smbXsrv_session_set_nonce_high_random(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nonce_high_random");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nonce_high_random));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nonce_high_random = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_get_nonce_high_max(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_nonce_high_max;
	py_nonce_high_max = PyLong_FromUnsignedLongLong(object->nonce_high_max);
	return py_nonce_high_max;
}

static int py_smbXsrv_session_set_nonce_high_max(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nonce_high_max");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nonce_high_max));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nonce_high_max = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_get_nonce_high(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_nonce_high;
	py_nonce_high = PyLong_FromUnsignedLongLong(object->nonce_high);
	return py_nonce_high;
}

static int py_smbXsrv_session_set_nonce_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nonce_high");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nonce_high));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nonce_high = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_get_nonce_low(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_nonce_low;
	py_nonce_low = PyLong_FromUnsignedLongLong(object->nonce_low);
	return py_nonce_low;
}

static int py_smbXsrv_session_set_nonce_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nonce_low");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nonce_low));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nonce_low = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_get_tcon_table(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_tcon_table;
	if (object->tcon_table == NULL) {
		Py_RETURN_NONE;
	}
	if (object->tcon_table == NULL) {
		py_tcon_table = Py_None;
		Py_INCREF(py_tcon_table);
	} else {
		py_tcon_table = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->tcon_table to Python");
		return NULL;
	}
	return py_tcon_table;
}

static int py_smbXsrv_session_set_tcon_table(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->tcon_table));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tcon_table");
		return -1;
	}
	if (value == Py_None) {
		object->tcon_table = NULL;
	} else {
		object->tcon_table = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->tcon_table");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_session_get_homes_snum(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_homes_snum;
	py_homes_snum = PyLong_FromUnsignedLongLong((uint32_t)(object->homes_snum));
	return py_homes_snum;
}

static int py_smbXsrv_session_set_homes_snum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->homes_snum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->homes_snum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->homes_snum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_get_pending_auth(PyObject *obj, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(obj);
	PyObject *py_pending_auth;
	if (object->pending_auth == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pending_auth == NULL) {
		py_pending_auth = Py_None;
		Py_INCREF(py_pending_auth);
	} else {
		py_pending_auth = pytalloc_reference_ex(&smbXsrv_session_auth0_Type, object->pending_auth, object->pending_auth);
	}
	return py_pending_auth;
}

static int py_smbXsrv_session_set_pending_auth(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pending_auth));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pending_auth");
		return -1;
	}
	if (value == Py_None) {
		object->pending_auth = NULL;
	} else {
		object->pending_auth = NULL;
		PY_CHECK_TYPE(&smbXsrv_session_auth0_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pending_auth = (struct smbXsrv_session_auth0 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_session_getsetters[] = {
	{
		.name = discard_const_p(char, "table"),
		.get = py_smbXsrv_session_get_table,
		.set = py_smbXsrv_session_set_table,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_session_table")
	},
	{
		.name = discard_const_p(char, "db_rec"),
		.get = py_smbXsrv_session_get_db_rec,
		.set = py_smbXsrv_session_set_db_rec,
		.doc = discard_const_p(char, "PIDL-generated element of base type db_record")
	},
	{
		.name = discard_const_p(char, "client"),
		.get = py_smbXsrv_session_get_client,
		.set = py_smbXsrv_session_set_client,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_client")
	},
	{
		.name = discard_const_p(char, "local_id"),
		.get = py_smbXsrv_session_get_local_id,
		.set = py_smbXsrv_session_set_local_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "global"),
		.get = py_smbXsrv_session_get_global,
		.set = py_smbXsrv_session_set_global,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_session_global0")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_smbXsrv_session_get_status,
		.set = py_smbXsrv_session_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTSTATUS")
	},
	{
		.name = discard_const_p(char, "idle_time"),
		.get = py_smbXsrv_session_get_idle_time,
		.set = py_smbXsrv_session_set_idle_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "nonce_high_random"),
		.get = py_smbXsrv_session_get_nonce_high_random,
		.set = py_smbXsrv_session_set_nonce_high_random,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "nonce_high_max"),
		.get = py_smbXsrv_session_get_nonce_high_max,
		.set = py_smbXsrv_session_set_nonce_high_max,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "nonce_high"),
		.get = py_smbXsrv_session_get_nonce_high,
		.set = py_smbXsrv_session_set_nonce_high,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "nonce_low"),
		.get = py_smbXsrv_session_get_nonce_low,
		.set = py_smbXsrv_session_set_nonce_low,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "tcon_table"),
		.get = py_smbXsrv_session_get_tcon_table,
		.set = py_smbXsrv_session_set_tcon_table,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_tcon_table")
	},
	{
		.name = discard_const_p(char, "homes_snum"),
		.get = py_smbXsrv_session_get_homes_snum,
		.set = py_smbXsrv_session_set_homes_snum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pending_auth"),
		.get = py_smbXsrv_session_get_pending_auth,
		.set = py_smbXsrv_session_set_pending_auth,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_session_auth0")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_session_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_session, type);
}


static PyTypeObject smbXsrv_session_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.session",
	.tp_getset = py_smbXsrv_session_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_session_new,
};

static PyObject *py_import_smbXsrv_sessionU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_sessionU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_session_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_sessionU *py_export_smbXsrv_sessionU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_sessionU *ret = talloc_zero(mem_ctx, union smbXsrv_sessionU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_session_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_session *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_sessionU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_sessionU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_sessionU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_sessionU!");
		return NULL;
	}

	return py_import_smbXsrv_sessionU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_sessionU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_sessionU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_sessionU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_sessionU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_sessionU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_sessionU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_sessionU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_sessionU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.sessionU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_sessionU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_sessionU_new,
};


static PyObject *py_smbXsrv_sessionB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_sessionB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_sessionB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_sessionB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_sessionB_get_reserved(PyObject *obj, void *closure)
{
	struct smbXsrv_sessionB *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_smbXsrv_sessionB_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_sessionB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_sessionB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_sessionB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_sessionU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_sessionU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_sessionB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_sessionB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_sessionU *info_switch_0;
		info_switch_0 = (union smbXsrv_sessionU *)pyrpc_export_union(&smbXsrv_sessionU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_sessionU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_sessionB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_sessionB_get_version,
		.set = py_smbXsrv_sessionB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_smbXsrv_sessionB_get_reserved,
		.set = py_smbXsrv_sessionB_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_sessionB_get_info,
		.set = py_smbXsrv_sessionB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_sessionU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_sessionB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_sessionB, type);
}

static PyObject *py_smbXsrv_sessionB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_sessionB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_sessionB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_sessionB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_sessionB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_sessionB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_sessionB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_sessionB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_sessionB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_sessionB, "smbXsrv_sessionB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_sessionB, "smbXsrv_sessionB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_sessionB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_sessionB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_sessionB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_sessionB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_sessionB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.sessionB",
	.tp_getset = py_smbXsrv_sessionB_getsetters,
	.tp_methods = py_smbXsrv_sessionB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_sessionB_new,
};


static PyObject *py_smbXsrv_session_close0_get_old_session_global_id(PyObject *obj, void *closure)
{
	struct smbXsrv_session_close0 *object = pytalloc_get_ptr(obj);
	PyObject *py_old_session_global_id;
	py_old_session_global_id = PyLong_FromUnsignedLongLong((uint32_t)(object->old_session_global_id));
	return py_old_session_global_id;
}

static int py_smbXsrv_session_close0_set_old_session_global_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_close0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->old_session_global_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->old_session_global_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->old_session_global_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_close0_get_old_session_wire_id(PyObject *obj, void *closure)
{
	struct smbXsrv_session_close0 *object = pytalloc_get_ptr(obj);
	PyObject *py_old_session_wire_id;
	py_old_session_wire_id = PyLong_FromUnsignedLongLong(object->old_session_wire_id);
	return py_old_session_wire_id;
}

static int py_smbXsrv_session_close0_set_old_session_wire_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_close0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->old_session_wire_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->old_session_wire_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->old_session_wire_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_close0_get_old_creation_time(PyObject *obj, void *closure)
{
	struct smbXsrv_session_close0 *object = pytalloc_get_ptr(obj);
	PyObject *py_old_creation_time;
	py_old_creation_time = PyLong_FromUnsignedLongLong(object->old_creation_time);
	return py_old_creation_time;
}

static int py_smbXsrv_session_close0_set_old_creation_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_close0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->old_creation_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->old_creation_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->old_creation_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_close0_get_new_session_wire_id(PyObject *obj, void *closure)
{
	struct smbXsrv_session_close0 *object = pytalloc_get_ptr(obj);
	PyObject *py_new_session_wire_id;
	py_new_session_wire_id = PyLong_FromUnsignedLongLong(object->new_session_wire_id);
	return py_new_session_wire_id;
}

static int py_smbXsrv_session_close0_set_new_session_wire_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_close0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->new_session_wire_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->new_session_wire_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->new_session_wire_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_session_close0_getsetters[] = {
	{
		.name = discard_const_p(char, "old_session_global_id"),
		.get = py_smbXsrv_session_close0_get_old_session_global_id,
		.set = py_smbXsrv_session_close0_set_old_session_global_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "old_session_wire_id"),
		.get = py_smbXsrv_session_close0_get_old_session_wire_id,
		.set = py_smbXsrv_session_close0_set_old_session_wire_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "old_creation_time"),
		.get = py_smbXsrv_session_close0_get_old_creation_time,
		.set = py_smbXsrv_session_close0_set_old_creation_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "new_session_wire_id"),
		.get = py_smbXsrv_session_close0_get_new_session_wire_id,
		.set = py_smbXsrv_session_close0_set_new_session_wire_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_session_close0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_session_close0, type);
}


static PyTypeObject smbXsrv_session_close0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.session_close0",
	.tp_getset = py_smbXsrv_session_close0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_session_close0_new,
};

static PyObject *py_import_smbXsrv_session_closeU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_session_closeU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_session_close0_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_session_closeU *py_export_smbXsrv_session_closeU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_session_closeU *ret = talloc_zero(mem_ctx, union smbXsrv_session_closeU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_session_close0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_session_close0 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_session_closeU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_session_closeU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_session_closeU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_session_closeU!");
		return NULL;
	}

	return py_import_smbXsrv_session_closeU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_session_closeU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_session_closeU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_session_closeU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_session_closeU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_session_closeU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_session_closeU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_session_closeU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_session_closeU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.session_closeU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_session_closeU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_session_closeU_new,
};


static PyObject *py_smbXsrv_session_closeB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_session_closeB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_session_closeB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_closeB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_closeB_get_reserved(PyObject *obj, void *closure)
{
	struct smbXsrv_session_closeB *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_smbXsrv_session_closeB_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_closeB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_session_closeB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_session_closeB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_session_closeU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_session_closeU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_session_closeB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_session_closeB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_session_closeU *info_switch_0;
		info_switch_0 = (union smbXsrv_session_closeU *)pyrpc_export_union(&smbXsrv_session_closeU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_session_closeU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_session_closeB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_session_closeB_get_version,
		.set = py_smbXsrv_session_closeB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_smbXsrv_session_closeB_get_reserved,
		.set = py_smbXsrv_session_closeB_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_session_closeB_get_info,
		.set = py_smbXsrv_session_closeB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_session_closeU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_session_closeB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_session_closeB, type);
}

static PyObject *py_smbXsrv_session_closeB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_session_closeB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_session_closeB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_session_closeB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_session_closeB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_session_closeB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_session_closeB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_session_closeB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_session_closeB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_session_closeB, "smbXsrv_session_closeB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_session_closeB, "smbXsrv_session_closeB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_session_closeB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_session_closeB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_session_closeB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_session_closeB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_session_closeB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.session_closeB",
	.tp_getset = py_smbXsrv_session_closeB_getsetters,
	.tp_methods = py_smbXsrv_session_closeB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_session_closeB_new,
};


static PyObject *py_smbXsrv_tcon_global0_get_db_rec(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_db_rec;
	if (object->db_rec == NULL) {
		Py_RETURN_NONE;
	}
	if (object->db_rec == NULL) {
		py_db_rec = Py_None;
		Py_INCREF(py_db_rec);
	} else {
		py_db_rec = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->db_rec to Python");
		return NULL;
	}
	return py_db_rec;
}

static int py_smbXsrv_tcon_global0_set_db_rec(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->db_rec));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->db_rec");
		return -1;
	}
	if (value == Py_None) {
		object->db_rec = NULL;
	} else {
		object->db_rec = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->db_rec");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_global0_get_tcon_global_id(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_tcon_global_id;
	py_tcon_global_id = PyLong_FromUnsignedLongLong((uint32_t)(object->tcon_global_id));
	return py_tcon_global_id;
}

static int py_smbXsrv_tcon_global0_set_tcon_global_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tcon_global_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tcon_global_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tcon_global_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_global0_get_tcon_wire_id(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_tcon_wire_id;
	py_tcon_wire_id = PyLong_FromUnsignedLongLong((uint32_t)(object->tcon_wire_id));
	return py_tcon_wire_id;
}

static int py_smbXsrv_tcon_global0_set_tcon_wire_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tcon_wire_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tcon_wire_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tcon_wire_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_global0_get_server_id(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_id;
	py_server_id = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->server_id);
	return py_server_id;
}

static int py_smbXsrv_tcon_global0_set_server_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_id");
		return -1;
	}
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server_id = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_tcon_global0_get_creation_time(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_creation_time;
	py_creation_time = PyLong_FromUnsignedLongLong(object->creation_time);
	return py_creation_time;
}

static int py_smbXsrv_tcon_global0_set_creation_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->creation_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->creation_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->creation_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_global0_get_share_name(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_share_name;
	if (object->share_name == NULL) {
		py_share_name = Py_None;
		Py_INCREF(py_share_name);
	} else {
		py_share_name = PyUnicode_Decode(object->share_name, strlen(object->share_name), "utf-8", "ignore");
	}
	return py_share_name;
}

static int py_smbXsrv_tcon_global0_set_share_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->share_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->share_name = talloc_str;
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_global0_get_encryption_flags(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_encryption_flags;
	py_encryption_flags = PyLong_FromLong((uint16_t)(object->encryption_flags));
	return py_encryption_flags;
}

static int py_smbXsrv_tcon_global0_set_encryption_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->encryption_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->encryption_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->encryption_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_global0_get_session_global_id(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_session_global_id;
	py_session_global_id = PyLong_FromUnsignedLongLong((uint32_t)(object->session_global_id));
	return py_session_global_id;
}

static int py_smbXsrv_tcon_global0_set_session_global_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->session_global_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->session_global_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->session_global_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_global0_get_signing_flags(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_signing_flags;
	py_signing_flags = PyLong_FromLong((uint16_t)(object->signing_flags));
	return py_signing_flags;
}

static int py_smbXsrv_tcon_global0_set_signing_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->signing_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->signing_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->signing_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_tcon_global0_getsetters[] = {
	{
		.name = discard_const_p(char, "db_rec"),
		.get = py_smbXsrv_tcon_global0_get_db_rec,
		.set = py_smbXsrv_tcon_global0_set_db_rec,
		.doc = discard_const_p(char, "PIDL-generated element of base type db_record")
	},
	{
		.name = discard_const_p(char, "tcon_global_id"),
		.get = py_smbXsrv_tcon_global0_get_tcon_global_id,
		.set = py_smbXsrv_tcon_global0_set_tcon_global_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "tcon_wire_id"),
		.get = py_smbXsrv_tcon_global0_get_tcon_wire_id,
		.set = py_smbXsrv_tcon_global0_set_tcon_wire_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "server_id"),
		.get = py_smbXsrv_tcon_global0_get_server_id,
		.set = py_smbXsrv_tcon_global0_set_server_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{
		.name = discard_const_p(char, "creation_time"),
		.get = py_smbXsrv_tcon_global0_get_creation_time,
		.set = py_smbXsrv_tcon_global0_set_creation_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "share_name"),
		.get = py_smbXsrv_tcon_global0_get_share_name,
		.set = py_smbXsrv_tcon_global0_set_share_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "encryption_flags"),
		.get = py_smbXsrv_tcon_global0_get_encryption_flags,
		.set = py_smbXsrv_tcon_global0_set_encryption_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_encrpytion_flags")
	},
	{
		.name = discard_const_p(char, "session_global_id"),
		.get = py_smbXsrv_tcon_global0_get_session_global_id,
		.set = py_smbXsrv_tcon_global0_set_session_global_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "signing_flags"),
		.get = py_smbXsrv_tcon_global0_get_signing_flags,
		.set = py_smbXsrv_tcon_global0_set_signing_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_signing_flags")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_tcon_global0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_tcon_global0, type);
}


static PyTypeObject smbXsrv_tcon_global0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.tcon_global0",
	.tp_getset = py_smbXsrv_tcon_global0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_tcon_global0_new,
};

static PyObject *py_import_smbXsrv_tcon_globalU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_tcon_globalU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_tcon_global0_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_tcon_globalU *py_export_smbXsrv_tcon_globalU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_tcon_globalU *ret = talloc_zero(mem_ctx, union smbXsrv_tcon_globalU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_tcon_global0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_tcon_global0 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_tcon_globalU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_tcon_globalU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_tcon_globalU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_tcon_globalU!");
		return NULL;
	}

	return py_import_smbXsrv_tcon_globalU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_tcon_globalU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_tcon_globalU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_tcon_globalU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_tcon_globalU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_tcon_globalU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_tcon_globalU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_tcon_globalU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_tcon_globalU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.tcon_globalU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_tcon_globalU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_tcon_globalU_new,
};


static PyObject *py_smbXsrv_tcon_globalB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_tcon_globalB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_globalB_get_seqnum(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_seqnum;
	py_seqnum = PyLong_FromUnsignedLongLong((uint32_t)(object->seqnum));
	return py_seqnum;
}

static int py_smbXsrv_tcon_globalB_set_seqnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->seqnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->seqnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->seqnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_globalB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_tcon_globalU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_tcon_globalU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_tcon_globalB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_tcon_globalU *info_switch_0;
		info_switch_0 = (union smbXsrv_tcon_globalU *)pyrpc_export_union(&smbXsrv_tcon_globalU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_tcon_globalU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_tcon_globalB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_tcon_globalB_get_version,
		.set = py_smbXsrv_tcon_globalB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "seqnum"),
		.get = py_smbXsrv_tcon_globalB_get_seqnum,
		.set = py_smbXsrv_tcon_globalB_set_seqnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_tcon_globalB_get_info,
		.set = py_smbXsrv_tcon_globalB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_tcon_globalU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_tcon_globalB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_tcon_globalB, type);
}

static PyObject *py_smbXsrv_tcon_globalB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_tcon_globalB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_tcon_globalB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_tcon_globalB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_tcon_globalB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_tcon_globalB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_tcon_globalB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_tcon_globalB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_tcon_globalB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_tcon_globalB, "smbXsrv_tcon_globalB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_tcon_globalB, "smbXsrv_tcon_globalB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_tcon_globalB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_tcon_globalB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_tcon_globalB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_tcon_globalB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_tcon_globalB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.tcon_globalB",
	.tp_getset = py_smbXsrv_tcon_globalB_getsetters,
	.tp_methods = py_smbXsrv_tcon_globalB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_tcon_globalB_new,
};


static PyObject *py_smbXsrv_tcon_get_table(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(obj);
	PyObject *py_table;
	if (object->table == NULL) {
		Py_RETURN_NONE;
	}
	if (object->table == NULL) {
		py_table = Py_None;
		Py_INCREF(py_table);
	} else {
		py_table = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->table to Python");
		return NULL;
	}
	return py_table;
}

static int py_smbXsrv_tcon_set_table(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->table));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->table");
		return -1;
	}
	if (value == Py_None) {
		object->table = NULL;
	} else {
		object->table = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->table");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_get_db_rec(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(obj);
	PyObject *py_db_rec;
	if (object->db_rec == NULL) {
		Py_RETURN_NONE;
	}
	if (object->db_rec == NULL) {
		py_db_rec = Py_None;
		Py_INCREF(py_db_rec);
	} else {
		py_db_rec = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->db_rec to Python");
		return NULL;
	}
	return py_db_rec;
}

static int py_smbXsrv_tcon_set_db_rec(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->db_rec));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->db_rec");
		return -1;
	}
	if (value == Py_None) {
		object->db_rec = NULL;
	} else {
		object->db_rec = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->db_rec");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_get_local_id(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(obj);
	PyObject *py_local_id;
	py_local_id = PyLong_FromUnsignedLongLong((uint32_t)(object->local_id));
	return py_local_id;
}

static int py_smbXsrv_tcon_set_local_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->local_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->local_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->local_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_get_global(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(obj);
	PyObject *py_global;
	if (object->global == NULL) {
		Py_RETURN_NONE;
	}
	py_global = pytalloc_reference_ex(&smbXsrv_tcon_global0_Type, object->global, object->global);
	return py_global;
}

static int py_smbXsrv_tcon_set_global(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->global));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->global");
		return -1;
	}
	object->global = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->global);
	if (object->global == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&smbXsrv_tcon_global0_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->global = (struct smbXsrv_tcon_global0 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_tcon_get_status(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromNTSTATUS(object->status);
	return py_status;
}

static int py_smbXsrv_tcon_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	object->status = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_smbXsrv_tcon_get_idle_time(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(obj);
	PyObject *py_idle_time;
	py_idle_time = PyLong_FromUnsignedLongLong(object->idle_time);
	return py_idle_time;
}

static int py_smbXsrv_tcon_set_idle_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idle_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idle_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idle_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_tcon_get_compat(PyObject *obj, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(obj);
	PyObject *py_compat;
	if (object->compat == NULL) {
		Py_RETURN_NONE;
	}
	if (object->compat == NULL) {
		py_compat = Py_None;
		Py_INCREF(py_compat);
	} else {
		py_compat = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->compat to Python");
		return NULL;
	}
	return py_compat;
}

static int py_smbXsrv_tcon_set_compat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tcon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->compat));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->compat");
		return -1;
	}
	if (value == Py_None) {
		object->compat = NULL;
	} else {
		object->compat = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->compat");
		return -1;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_tcon_getsetters[] = {
	{
		.name = discard_const_p(char, "table"),
		.get = py_smbXsrv_tcon_get_table,
		.set = py_smbXsrv_tcon_set_table,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_tcon_table")
	},
	{
		.name = discard_const_p(char, "db_rec"),
		.get = py_smbXsrv_tcon_get_db_rec,
		.set = py_smbXsrv_tcon_set_db_rec,
		.doc = discard_const_p(char, "PIDL-generated element of base type db_record")
	},
	{
		.name = discard_const_p(char, "local_id"),
		.get = py_smbXsrv_tcon_get_local_id,
		.set = py_smbXsrv_tcon_set_local_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "global"),
		.get = py_smbXsrv_tcon_get_global,
		.set = py_smbXsrv_tcon_set_global,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_tcon_global0")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_smbXsrv_tcon_get_status,
		.set = py_smbXsrv_tcon_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTSTATUS")
	},
	{
		.name = discard_const_p(char, "idle_time"),
		.get = py_smbXsrv_tcon_get_idle_time,
		.set = py_smbXsrv_tcon_set_idle_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "compat"),
		.get = py_smbXsrv_tcon_get_compat,
		.set = py_smbXsrv_tcon_set_compat,
		.doc = discard_const_p(char, "PIDL-generated element of base type connection_struct")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_tcon_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_tcon, type);
}


static PyTypeObject smbXsrv_tcon_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.tcon",
	.tp_getset = py_smbXsrv_tcon_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_tcon_new,
};

static PyObject *py_import_smbXsrv_tconU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_tconU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_tcon_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_tconU *py_export_smbXsrv_tconU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_tconU *ret = talloc_zero(mem_ctx, union smbXsrv_tconU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_tcon_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_tcon *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_tconU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_tconU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_tconU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_tconU!");
		return NULL;
	}

	return py_import_smbXsrv_tconU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_tconU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_tconU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_tconU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_tconU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_tconU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_tconU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_tconU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_tconU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.tconU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_tconU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_tconU_new,
};


static PyObject *py_smbXsrv_tconB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_tconB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_tconB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tconB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_tconB_get_reserved(PyObject *obj, void *closure)
{
	struct smbXsrv_tconB *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_smbXsrv_tconB_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tconB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_tconB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_tconB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_tconU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_tconU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_tconB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_tconB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_tconU *info_switch_0;
		info_switch_0 = (union smbXsrv_tconU *)pyrpc_export_union(&smbXsrv_tconU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_tconU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_tconB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_tconB_get_version,
		.set = py_smbXsrv_tconB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_smbXsrv_tconB_get_reserved,
		.set = py_smbXsrv_tconB_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_tconB_get_info,
		.set = py_smbXsrv_tconB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_tconU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_tconB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_tconB, type);
}

static PyObject *py_smbXsrv_tconB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_tconB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_tconB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_tconB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_tconB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_tconB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_tconB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_tconB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_tconB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_tconB, "smbXsrv_tconB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_tconB, "smbXsrv_tconB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_tconB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_tconB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_tconB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_tconB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_tconB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.tconB",
	.tp_getset = py_smbXsrv_tconB_getsetters,
	.tp_methods = py_smbXsrv_tconB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_tconB_new,
};


static PyObject *py_smbXsrv_open_global0_get_server_id(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_id;
	py_server_id = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->server_id);
	return py_server_id;
}

static int py_smbXsrv_open_global0_set_server_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_id");
		return -1;
	}
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server_id = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_session_global_id(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_session_global_id;
	py_session_global_id = PyLong_FromUnsignedLongLong(object->session_global_id);
	return py_session_global_id;
}

static int py_smbXsrv_open_global0_set_session_global_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->session_global_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->session_global_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->session_global_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_tcon_global_id(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_tcon_global_id;
	py_tcon_global_id = PyLong_FromUnsignedLongLong((uint32_t)(object->tcon_global_id));
	return py_tcon_global_id;
}

static int py_smbXsrv_open_global0_set_tcon_global_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tcon_global_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tcon_global_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tcon_global_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_open_global_id(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_open_global_id;
	py_open_global_id = PyLong_FromUnsignedLongLong((uint32_t)(object->open_global_id));
	return py_open_global_id;
}

static int py_smbXsrv_open_global0_set_open_global_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->open_global_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->open_global_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->open_global_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_open_persistent_id(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_open_persistent_id;
	py_open_persistent_id = PyLong_FromUnsignedLongLong(object->open_persistent_id);
	return py_open_persistent_id;
}

static int py_smbXsrv_open_global0_set_open_persistent_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->open_persistent_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->open_persistent_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->open_persistent_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_open_volatile_id(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_open_volatile_id;
	py_open_volatile_id = PyLong_FromUnsignedLongLong(object->open_volatile_id);
	return py_open_volatile_id;
}

static int py_smbXsrv_open_global0_set_open_volatile_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->open_volatile_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->open_volatile_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->open_volatile_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_open_owner(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_open_owner;
	py_open_owner = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->open_owner);
	return py_open_owner;
}

static int py_smbXsrv_open_global0_set_open_owner(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->open_owner");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->open_owner = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_open_time(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_open_time;
	py_open_time = PyLong_FromUnsignedLongLong(object->open_time);
	return py_open_time;
}

static int py_smbXsrv_open_global0_set_open_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->open_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->open_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->open_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_create_guid(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_create_guid;
	py_create_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->create_guid);
	return py_create_guid;
}

static int py_smbXsrv_open_global0_set_create_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->create_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->create_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_client_guid(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_guid;
	py_client_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->client_guid);
	return py_client_guid;
}

static int py_smbXsrv_open_global0_set_client_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_app_instance_id(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_app_instance_id;
	py_app_instance_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->app_instance_id);
	return py_app_instance_id;
}

static int py_smbXsrv_open_global0_set_app_instance_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->app_instance_id");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->app_instance_id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_create_action(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_create_action;
	py_create_action = PyLong_FromUnsignedLongLong((uint32_t)(object->create_action));
	return py_create_action;
}

static int py_smbXsrv_open_global0_set_create_action(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->create_action");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->create_action));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->create_action = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_disconnect_time(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_disconnect_time;
	py_disconnect_time = PyLong_FromUnsignedLongLong(object->disconnect_time);
	return py_disconnect_time;
}

static int py_smbXsrv_open_global0_set_disconnect_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->disconnect_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->disconnect_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->disconnect_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_durable_timeout_msec(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_durable_timeout_msec;
	py_durable_timeout_msec = PyLong_FromUnsignedLongLong((uint32_t)(object->durable_timeout_msec));
	return py_durable_timeout_msec;
}

static int py_smbXsrv_open_global0_set_durable_timeout_msec(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->durable_timeout_msec");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->durable_timeout_msec));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->durable_timeout_msec = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_durable(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_durable;
	py_durable = PyLong_FromLong((uint16_t)(object->durable));
	return py_durable;
}

static int py_smbXsrv_open_global0_set_durable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->durable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->durable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->durable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_backend_cookie(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_backend_cookie;
	py_backend_cookie = PyBytes_FromStringAndSize((char *)(object->backend_cookie).data, (object->backend_cookie).length);
	return py_backend_cookie;
}

static int py_smbXsrv_open_global0_set_backend_cookie(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->backend_cookie");
		return -1;
	}
	object->backend_cookie = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_channel_sequence(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_channel_sequence;
	py_channel_sequence = PyLong_FromLong((uint16_t)(object->channel_sequence));
	return py_channel_sequence;
}

static int py_smbXsrv_open_global0_set_channel_sequence(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->channel_sequence");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->channel_sequence));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->channel_sequence = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_channel_generation(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_channel_generation;
	py_channel_generation = PyLong_FromUnsignedLongLong(object->channel_generation);
	return py_channel_generation;
}

static int py_smbXsrv_open_global0_set_channel_generation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->channel_generation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->channel_generation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->channel_generation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_global0_get_lock_sequence_array(PyObject *obj, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(obj);
	PyObject *py_lock_sequence_array;
	py_lock_sequence_array = PyList_New(64);
	if (py_lock_sequence_array == NULL) {
		return NULL;
	}
	{
		int lock_sequence_array_cntr_0;
		for (lock_sequence_array_cntr_0 = 0; lock_sequence_array_cntr_0 < (64); lock_sequence_array_cntr_0++) {
			PyObject *py_lock_sequence_array_0;
			py_lock_sequence_array_0 = PyLong_FromLong((uint16_t)((object->lock_sequence_array)[lock_sequence_array_cntr_0]));
			PyList_SetItem(py_lock_sequence_array, lock_sequence_array_cntr_0, py_lock_sequence_array_0);
		}
	}
	return py_lock_sequence_array;
}

static int py_smbXsrv_open_global0_set_lock_sequence_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_global0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lock_sequence_array");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int lock_sequence_array_cntr_0;
		if (ARRAY_SIZE(object->lock_sequence_array) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->lock_sequence_array),  PyList_GET_SIZE(value));
			return -1;
		}
		for (lock_sequence_array_cntr_0 = 0; lock_sequence_array_cntr_0 < PyList_GET_SIZE(value); lock_sequence_array_cntr_0++) {
			if (PyList_GET_ITEM(value, lock_sequence_array_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->lock_sequence_array)[lock_sequence_array_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->lock_sequence_array)[lock_sequence_array_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, lock_sequence_array_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, lock_sequence_array_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->lock_sequence_array)[lock_sequence_array_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_open_global0_getsetters[] = {
	{
		.name = discard_const_p(char, "server_id"),
		.get = py_smbXsrv_open_global0_get_server_id,
		.set = py_smbXsrv_open_global0_set_server_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{
		.name = discard_const_p(char, "session_global_id"),
		.get = py_smbXsrv_open_global0_get_session_global_id,
		.set = py_smbXsrv_open_global0_set_session_global_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "tcon_global_id"),
		.get = py_smbXsrv_open_global0_get_tcon_global_id,
		.set = py_smbXsrv_open_global0_set_tcon_global_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "open_global_id"),
		.get = py_smbXsrv_open_global0_get_open_global_id,
		.set = py_smbXsrv_open_global0_set_open_global_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "open_persistent_id"),
		.get = py_smbXsrv_open_global0_get_open_persistent_id,
		.set = py_smbXsrv_open_global0_set_open_persistent_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "open_volatile_id"),
		.get = py_smbXsrv_open_global0_get_open_volatile_id,
		.set = py_smbXsrv_open_global0_set_open_volatile_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "open_owner"),
		.get = py_smbXsrv_open_global0_get_open_owner,
		.set = py_smbXsrv_open_global0_set_open_owner,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "open_time"),
		.get = py_smbXsrv_open_global0_get_open_time,
		.set = py_smbXsrv_open_global0_set_open_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "create_guid"),
		.get = py_smbXsrv_open_global0_get_create_guid,
		.set = py_smbXsrv_open_global0_set_create_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "client_guid"),
		.get = py_smbXsrv_open_global0_get_client_guid,
		.set = py_smbXsrv_open_global0_set_client_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "app_instance_id"),
		.get = py_smbXsrv_open_global0_get_app_instance_id,
		.set = py_smbXsrv_open_global0_set_app_instance_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "create_action"),
		.get = py_smbXsrv_open_global0_get_create_action,
		.set = py_smbXsrv_open_global0_set_create_action,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "disconnect_time"),
		.get = py_smbXsrv_open_global0_get_disconnect_time,
		.set = py_smbXsrv_open_global0_set_disconnect_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "durable_timeout_msec"),
		.get = py_smbXsrv_open_global0_get_durable_timeout_msec,
		.set = py_smbXsrv_open_global0_set_durable_timeout_msec,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "durable"),
		.get = py_smbXsrv_open_global0_get_durable,
		.set = py_smbXsrv_open_global0_set_durable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "backend_cookie"),
		.get = py_smbXsrv_open_global0_get_backend_cookie,
		.set = py_smbXsrv_open_global0_set_backend_cookie,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "channel_sequence"),
		.get = py_smbXsrv_open_global0_get_channel_sequence,
		.set = py_smbXsrv_open_global0_set_channel_sequence,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "channel_generation"),
		.get = py_smbXsrv_open_global0_get_channel_generation,
		.set = py_smbXsrv_open_global0_set_channel_generation,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "lock_sequence_array"),
		.get = py_smbXsrv_open_global0_get_lock_sequence_array,
		.set = py_smbXsrv_open_global0_set_lock_sequence_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_open_global0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_open_global0, type);
}


static PyTypeObject smbXsrv_open_global0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.open_global0",
	.tp_getset = py_smbXsrv_open_global0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_open_global0_new,
};

static PyObject *py_import_smbXsrv_open_globalU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_open_globalU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_open_global0_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_open_globalU *py_export_smbXsrv_open_globalU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_open_globalU *ret = talloc_zero(mem_ctx, union smbXsrv_open_globalU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_open_global0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_open_global0 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_open_globalU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_open_globalU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_open_globalU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_open_globalU!");
		return NULL;
	}

	return py_import_smbXsrv_open_globalU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_open_globalU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_open_globalU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_open_globalU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_open_globalU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_open_globalU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_open_globalU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_open_globalU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_open_globalU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.open_globalU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_open_globalU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_open_globalU_new,
};


static PyObject *py_smbXsrv_open_globalB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_open_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_open_globalB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_globalB_get_seqnum(PyObject *obj, void *closure)
{
	struct smbXsrv_open_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_seqnum;
	py_seqnum = PyLong_FromUnsignedLongLong((uint32_t)(object->seqnum));
	return py_seqnum;
}

static int py_smbXsrv_open_globalB_set_seqnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->seqnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->seqnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->seqnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_globalB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_open_globalB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_open_globalU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_open_globalU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_open_globalB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_globalB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_open_globalU *info_switch_0;
		info_switch_0 = (union smbXsrv_open_globalU *)pyrpc_export_union(&smbXsrv_open_globalU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_open_globalU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_open_globalB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_open_globalB_get_version,
		.set = py_smbXsrv_open_globalB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "seqnum"),
		.get = py_smbXsrv_open_globalB_get_seqnum,
		.set = py_smbXsrv_open_globalB_set_seqnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_open_globalB_get_info,
		.set = py_smbXsrv_open_globalB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_open_globalU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_open_globalB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_open_globalB, type);
}

static PyObject *py_smbXsrv_open_globalB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_open_globalB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_open_globalB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_open_globalB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_open_globalB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_open_globalB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_open_globalB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_open_globalB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_open_globalB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_open_globalB, "smbXsrv_open_globalB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_open_globalB, "smbXsrv_open_globalB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_open_globalB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_open_globalB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_open_globalB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_open_globalB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_open_globalB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.open_globalB",
	.tp_getset = py_smbXsrv_open_globalB_getsetters,
	.tp_methods = py_smbXsrv_open_globalB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_open_globalB_new,
};


static PyObject *py_smbXsrv_open_get_table(PyObject *obj, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(obj);
	PyObject *py_table;
	if (object->table == NULL) {
		Py_RETURN_NONE;
	}
	if (object->table == NULL) {
		py_table = Py_None;
		Py_INCREF(py_table);
	} else {
		py_table = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->table to Python");
		return NULL;
	}
	return py_table;
}

static int py_smbXsrv_open_set_table(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->table));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->table");
		return -1;
	}
	if (value == Py_None) {
		object->table = NULL;
	} else {
		object->table = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->table");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_open_get_local_id(PyObject *obj, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(obj);
	PyObject *py_local_id;
	py_local_id = PyLong_FromUnsignedLongLong((uint32_t)(object->local_id));
	return py_local_id;
}

static int py_smbXsrv_open_set_local_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->local_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->local_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->local_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_get_global(PyObject *obj, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(obj);
	PyObject *py_global;
	if (object->global == NULL) {
		Py_RETURN_NONE;
	}
	py_global = pytalloc_reference_ex(&smbXsrv_open_global0_Type, object->global, object->global);
	return py_global;
}

static int py_smbXsrv_open_set_global(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->global));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->global");
		return -1;
	}
	object->global = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->global);
	if (object->global == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&smbXsrv_open_global0_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->global = (struct smbXsrv_open_global0 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_open_get_session(PyObject *obj, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(obj);
	PyObject *py_session;
	if (object->session == NULL) {
		Py_RETURN_NONE;
	}
	if (object->session == NULL) {
		py_session = Py_None;
		Py_INCREF(py_session);
	} else {
		py_session = pytalloc_reference_ex(&smbXsrv_session_Type, object->session, object->session);
	}
	return py_session;
}

static int py_smbXsrv_open_set_session(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->session));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->session");
		return -1;
	}
	if (value == Py_None) {
		object->session = NULL;
	} else {
		object->session = NULL;
		PY_CHECK_TYPE(&smbXsrv_session_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->session = (struct smbXsrv_session *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_smbXsrv_open_get_tcon(PyObject *obj, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(obj);
	PyObject *py_tcon;
	if (object->tcon == NULL) {
		Py_RETURN_NONE;
	}
	if (object->tcon == NULL) {
		py_tcon = Py_None;
		Py_INCREF(py_tcon);
	} else {
		py_tcon = pytalloc_reference_ex(&smbXsrv_tcon_Type, object->tcon, object->tcon);
	}
	return py_tcon;
}

static int py_smbXsrv_open_set_tcon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->tcon));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tcon");
		return -1;
	}
	if (value == Py_None) {
		object->tcon = NULL;
	} else {
		object->tcon = NULL;
		PY_CHECK_TYPE(&smbXsrv_tcon_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->tcon = (struct smbXsrv_tcon *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_smbXsrv_open_get_status(PyObject *obj, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromNTSTATUS(object->status);
	return py_status;
}

static int py_smbXsrv_open_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	object->status = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_smbXsrv_open_get_idle_time(PyObject *obj, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(obj);
	PyObject *py_idle_time;
	py_idle_time = PyLong_FromUnsignedLongLong(object->idle_time);
	return py_idle_time;
}

static int py_smbXsrv_open_set_idle_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idle_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idle_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idle_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_get_compat(PyObject *obj, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(obj);
	PyObject *py_compat;
	if (object->compat == NULL) {
		Py_RETURN_NONE;
	}
	if (object->compat == NULL) {
		py_compat = Py_None;
		Py_INCREF(py_compat);
	} else {
		py_compat = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->compat to Python");
		return NULL;
	}
	return py_compat;
}

static int py_smbXsrv_open_set_compat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->compat));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->compat");
		return -1;
	}
	if (value == Py_None) {
		object->compat = NULL;
	} else {
		object->compat = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->compat");
		return -1;
	}
	return 0;
}

static PyObject *py_smbXsrv_open_get_flags(PyObject *obj, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_smbXsrv_open_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_get_request_count(PyObject *obj, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(obj);
	PyObject *py_request_count;
	py_request_count = PyLong_FromUnsignedLongLong(object->request_count);
	return py_request_count;
}

static int py_smbXsrv_open_set_request_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->request_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->request_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->request_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_open_get_pre_request_count(PyObject *obj, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(obj);
	PyObject *py_pre_request_count;
	py_pre_request_count = PyLong_FromUnsignedLongLong(object->pre_request_count);
	return py_pre_request_count;
}

static int py_smbXsrv_open_set_pre_request_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pre_request_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pre_request_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pre_request_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_open_getsetters[] = {
	{
		.name = discard_const_p(char, "table"),
		.get = py_smbXsrv_open_get_table,
		.set = py_smbXsrv_open_set_table,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_open_table")
	},
	{
		.name = discard_const_p(char, "local_id"),
		.get = py_smbXsrv_open_get_local_id,
		.set = py_smbXsrv_open_set_local_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "global"),
		.get = py_smbXsrv_open_get_global,
		.set = py_smbXsrv_open_set_global,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_open_global0")
	},
	{
		.name = discard_const_p(char, "session"),
		.get = py_smbXsrv_open_get_session,
		.set = py_smbXsrv_open_set_session,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_session")
	},
	{
		.name = discard_const_p(char, "tcon"),
		.get = py_smbXsrv_open_get_tcon,
		.set = py_smbXsrv_open_set_tcon,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_tcon")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_smbXsrv_open_get_status,
		.set = py_smbXsrv_open_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTSTATUS")
	},
	{
		.name = discard_const_p(char, "idle_time"),
		.get = py_smbXsrv_open_get_idle_time,
		.set = py_smbXsrv_open_set_idle_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "compat"),
		.get = py_smbXsrv_open_get_compat,
		.set = py_smbXsrv_open_set_compat,
		.doc = discard_const_p(char, "PIDL-generated element of base type files_struct")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_smbXsrv_open_get_flags,
		.set = py_smbXsrv_open_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_open_flags")
	},
	{
		.name = discard_const_p(char, "request_count"),
		.get = py_smbXsrv_open_get_request_count,
		.set = py_smbXsrv_open_set_request_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "pre_request_count"),
		.get = py_smbXsrv_open_get_pre_request_count,
		.set = py_smbXsrv_open_set_pre_request_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_open_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_open, type);
}


static PyTypeObject smbXsrv_open_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.open",
	.tp_getset = py_smbXsrv_open_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_open_new,
};

static PyObject *py_import_smbXsrv_openU(TALLOC_CTX *mem_ctx, int level, union smbXsrv_openU *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&smbXsrv_open_Type, in->info0, in->info0);
			}
			return ret;

		default:
			if (in->dummy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->dummy);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbXsrv_openU *py_export_smbXsrv_openU(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbXsrv_openU *ret = talloc_zero(mem_ctx, union smbXsrv_openU);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&smbXsrv_open_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct smbXsrv_open *)pytalloc_get_ptr(in);
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->dummy = NULL;
			} else {
				ret->dummy = talloc_ptrtype(mem_ctx, ret->dummy);
				if (ret->dummy == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->dummy));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->dummy = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_smbXsrv_openU_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbXsrv_openU *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbXsrv_openU *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbXsrv_openU!");
		return NULL;
	}

	return py_import_smbXsrv_openU(mem_ctx, level, in);
}

static PyObject *py_smbXsrv_openU_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbXsrv_openU *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbXsrv_openU(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbXsrv_openU_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_openU_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_openU_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbXsrv_openU_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbXsrv_openU_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.openU",
	.tp_getset = NULL,
	.tp_methods = py_smbXsrv_openU_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_openU_new,
};


static PyObject *py_smbXsrv_openB_get_version(PyObject *obj, void *closure)
{
	struct smbXsrv_openB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_smbXsrv_openB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_openB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_openB_get_reserved(PyObject *obj, void *closure)
{
	struct smbXsrv_openB *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_smbXsrv_openB_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_openB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbXsrv_openB_get_info(PyObject *obj, void *closure)
{
	struct smbXsrv_openB *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbXsrv_openU_Type, pytalloc_get_mem_ctx(obj), object->version, &object->info, "union smbXsrv_openU");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbXsrv_openB_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_openB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smbXsrv_openU *info_switch_0;
		info_switch_0 = (union smbXsrv_openU *)pyrpc_export_union(&smbXsrv_openU_Type, pytalloc_get_mem_ctx(py_obj), object->version, value, "union smbXsrv_openU");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbXsrv_openB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_smbXsrv_openB_get_version,
		.set = py_smbXsrv_openB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_version_values")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_smbXsrv_openB_get_reserved,
		.set = py_smbXsrv_openB_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smbXsrv_openB_get_info,
		.set = py_smbXsrv_openB_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbXsrv_openU")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_openB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_openB, type);
}

static PyObject *py_smbXsrv_openB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_openB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_openB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_openB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_openB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_openB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_openB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_openB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_openB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_openB, "smbXsrv_openB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_openB, "smbXsrv_openB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_openB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_openB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_openB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_openB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_openB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.openB",
	.tp_getset = py_smbXsrv_openB_getsetters,
	.tp_methods = py_smbXsrv_openB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_openB_new,
};


static PyObject *py_smbXsrv_open_replay_cache_key_get_client_guid(PyObject *obj, void *closure)
{
	struct smbXsrv_open_replay_cache_key *object = pytalloc_get_ptr(obj);
	PyObject *py_client_guid;
	py_client_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->client_guid);
	return py_client_guid;
}

static int py_smbXsrv_open_replay_cache_key_set_client_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_replay_cache_key *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_smbXsrv_open_replay_cache_key_get_create_guid(PyObject *obj, void *closure)
{
	struct smbXsrv_open_replay_cache_key *object = pytalloc_get_ptr(obj);
	PyObject *py_create_guid;
	py_create_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->create_guid);
	return py_create_guid;
}

static int py_smbXsrv_open_replay_cache_key_set_create_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_replay_cache_key *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->create_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->create_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_smbXsrv_open_replay_cache_key_getsetters[] = {
	{
		.name = discard_const_p(char, "client_guid"),
		.get = py_smbXsrv_open_replay_cache_key_get_client_guid,
		.set = py_smbXsrv_open_replay_cache_key_set_client_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "create_guid"),
		.get = py_smbXsrv_open_replay_cache_key_get_create_guid,
		.set = py_smbXsrv_open_replay_cache_key_set_create_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_open_replay_cache_key_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_open_replay_cache_key, type);
}

static PyObject *py_smbXsrv_open_replay_cache_key_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_open_replay_cache_key *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_open_replay_cache_key);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_open_replay_cache_key_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_open_replay_cache_key *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_open_replay_cache_key);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_open_replay_cache_key);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_open_replay_cache_key_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_open_replay_cache_key *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_open_replay_cache_key, "smbXsrv_open_replay_cache_key", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_open_replay_cache_key, "smbXsrv_open_replay_cache_key", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_open_replay_cache_key_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_open_replay_cache_key_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_open_replay_cache_key_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_open_replay_cache_key_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_open_replay_cache_key_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.open_replay_cache_key",
	.tp_getset = py_smbXsrv_open_replay_cache_key_getsetters,
	.tp_methods = py_smbXsrv_open_replay_cache_key_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_open_replay_cache_key_new,
};


static PyObject *py_smbXsrv_open_replay_cache_get_open_global_key(PyObject *obj, void *closure)
{
	struct smbXsrv_open_replay_cache *object = pytalloc_get_ptr(obj);
	PyObject *py_open_global_key;
	py_open_global_key = PyBytes_FromStringAndSize((char *)(object->open_global_key).data, (object->open_global_key).length);
	return py_open_global_key;
}

static int py_smbXsrv_open_replay_cache_set_open_global_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbXsrv_open_replay_cache *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->open_global_key");
		return -1;
	}
	object->open_global_key = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_smbXsrv_open_replay_cache_getsetters[] = {
	{
		.name = discard_const_p(char, "open_global_key"),
		.get = py_smbXsrv_open_replay_cache_get_open_global_key,
		.set = py_smbXsrv_open_replay_cache_set_open_global_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_smbXsrv_open_replay_cache_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbXsrv_open_replay_cache, type);
}

static PyObject *py_smbXsrv_open_replay_cache_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct smbXsrv_open_replay_cache *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_smbXsrv_open_replay_cache);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_smbXsrv_open_replay_cache_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_open_replay_cache *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_open_replay_cache);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_smbXsrv_open_replay_cache);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_smbXsrv_open_replay_cache_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct smbXsrv_open_replay_cache *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_open_replay_cache, "smbXsrv_open_replay_cache", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_smbXsrv_open_replay_cache, "smbXsrv_open_replay_cache", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_smbXsrv_open_replay_cache_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_smbXsrv_open_replay_cache_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_open_replay_cache_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbXsrv_open_replay_cache_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbXsrv_open_replay_cache_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.open_replay_cache",
	.tp_getset = py_smbXsrv_open_replay_cache_getsetters,
	.tp_methods = py_smbXsrv_open_replay_cache_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbXsrv_open_replay_cache_new,
};


const struct PyNdrRpcMethodDef py_ndr_smbXsrv_methods[] = {
	{
		.name = NULL,
	},
};

static PyObject *interface_smbXsrv_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_smbXsrv);
}

#define PY_DOC_SMBXSRV "smbXsrv structures"
static PyTypeObject smbXsrv_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.smbXsrv",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "smbXsrv(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A smbXsrv client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n"PY_DOC_SMBXSRV,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_smbXsrv_new,
};

static PyObject *syntax_smbXsrv_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_smbXsrv.syntax_id);
}

#define PY_DOC_SMBXSRV_SYNTAX "smbXsrv structures"
static PyTypeObject smbXsrv_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smbXsrv.smbXsrv_abstract_syntax",
	.tp_doc = "smbXsrv_abstract_syntax()\n"PY_DOC_SMBXSRV_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_smbXsrv_new,
};

static PyMethodDef smbXsrv_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "smbXsrv",
	.m_doc = "smbXsrv DCE/RPC",
	.m_size = -1,
	.m_methods = smbXsrv_methods,
};
MODULE_INIT_FUNC(smbXsrv)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_samba_dcerpc_server_id = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_samba_dcerpc_auth = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_samba_dcerpc_server_id = PyImport_ImportModule("samba.dcerpc.server_id");
	if (dep_samba_dcerpc_server_id == NULL)
		goto out;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_samba_dcerpc_auth = PyImport_ImportModule("samba.dcerpc.auth");
	if (dep_samba_dcerpc_auth == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	server_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_server_id, "server_id");
	if (server_id_Type == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		goto out;

	auth_session_info_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_auth, "session_info");
	if (auth_session_info_Type == NULL)
		goto out;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	smbXsrv_version_node0_Type.tp_base = BaseObject_Type;
	smbXsrv_version_node0_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_version_global0_Type.tp_base = BaseObject_Type;
	smbXsrv_version_global0_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_version_globalU_Type.tp_base = BaseObject_Type;
	smbXsrv_version_globalU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_version_globalB_Type.tp_base = BaseObject_Type;
	smbXsrv_version_globalB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_client_global0_Type.tp_base = BaseObject_Type;
	smbXsrv_client_global0_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_client_globalU_Type.tp_base = BaseObject_Type;
	smbXsrv_client_globalU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_client_globalB_Type.tp_base = BaseObject_Type;
	smbXsrv_client_globalB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_client_Type.tp_base = BaseObject_Type;
	smbXsrv_client_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_clientU_Type.tp_base = BaseObject_Type;
	smbXsrv_clientU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_clientB_Type.tp_base = BaseObject_Type;
	smbXsrv_clientB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_connection_pass0_Type.tp_base = BaseObject_Type;
	smbXsrv_connection_pass0_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_connection_passU_Type.tp_base = BaseObject_Type;
	smbXsrv_connection_passU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_connection_passB_Type.tp_base = BaseObject_Type;
	smbXsrv_connection_passB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_connection_drop0_Type.tp_base = BaseObject_Type;
	smbXsrv_connection_drop0_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_connection_dropU_Type.tp_base = BaseObject_Type;
	smbXsrv_connection_dropU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_connection_dropB_Type.tp_base = BaseObject_Type;
	smbXsrv_connection_dropB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_channel_global0_Type.tp_base = BaseObject_Type;
	smbXsrv_channel_global0_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_session_global0_Type.tp_base = BaseObject_Type;
	smbXsrv_session_global0_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_session_globalU_Type.tp_base = BaseObject_Type;
	smbXsrv_session_globalU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_session_globalB_Type.tp_base = BaseObject_Type;
	smbXsrv_session_globalB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_session_auth0_Type.tp_base = BaseObject_Type;
	smbXsrv_session_auth0_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_session_Type.tp_base = BaseObject_Type;
	smbXsrv_session_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_sessionU_Type.tp_base = BaseObject_Type;
	smbXsrv_sessionU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_sessionB_Type.tp_base = BaseObject_Type;
	smbXsrv_sessionB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_session_close0_Type.tp_base = BaseObject_Type;
	smbXsrv_session_close0_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_session_closeU_Type.tp_base = BaseObject_Type;
	smbXsrv_session_closeU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_session_closeB_Type.tp_base = BaseObject_Type;
	smbXsrv_session_closeB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_tcon_global0_Type.tp_base = BaseObject_Type;
	smbXsrv_tcon_global0_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_tcon_globalU_Type.tp_base = BaseObject_Type;
	smbXsrv_tcon_globalU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_tcon_globalB_Type.tp_base = BaseObject_Type;
	smbXsrv_tcon_globalB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_tcon_Type.tp_base = BaseObject_Type;
	smbXsrv_tcon_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_tconU_Type.tp_base = BaseObject_Type;
	smbXsrv_tconU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_tconB_Type.tp_base = BaseObject_Type;
	smbXsrv_tconB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_open_global0_Type.tp_base = BaseObject_Type;
	smbXsrv_open_global0_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_open_globalU_Type.tp_base = BaseObject_Type;
	smbXsrv_open_globalU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_open_globalB_Type.tp_base = BaseObject_Type;
	smbXsrv_open_globalB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_open_Type.tp_base = BaseObject_Type;
	smbXsrv_open_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_openU_Type.tp_base = BaseObject_Type;
	smbXsrv_openU_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_openB_Type.tp_base = BaseObject_Type;
	smbXsrv_openB_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_open_replay_cache_key_Type.tp_base = BaseObject_Type;
	smbXsrv_open_replay_cache_key_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_open_replay_cache_Type.tp_base = BaseObject_Type;
	smbXsrv_open_replay_cache_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbXsrv_InterfaceType.tp_base = ClientConnection_Type;

	smbXsrv_SyntaxType.tp_base = ndr_syntax_id_Type;
	smbXsrv_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&smbXsrv_version_node0_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_version_global0_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_version_globalU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_version_globalB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_client_global0_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_client_globalU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_client_globalB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_client_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_clientU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_clientB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_connection_pass0_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_connection_passU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_connection_passB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_connection_drop0_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_connection_dropU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_connection_dropB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_channel_global0_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_session_global0_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_session_globalU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_session_globalB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_session_auth0_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_session_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_sessionU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_sessionB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_session_close0_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_session_closeU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_session_closeB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_tcon_global0_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_tcon_globalU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_tcon_globalB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_tcon_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_tconU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_tconB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_open_global0_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_open_globalU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_open_globalB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_open_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_openU_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_openB_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_open_replay_cache_key_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_open_replay_cache_Type) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&smbXsrv_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&smbXsrv_InterfaceType, py_ndr_smbXsrv_methods))
		return NULL;

#ifdef PY_VERSION_NODE0_PATCH
	PY_VERSION_NODE0_PATCH(&smbXsrv_version_node0_Type);
#endif
#ifdef PY_VERSION_GLOBAL0_PATCH
	PY_VERSION_GLOBAL0_PATCH(&smbXsrv_version_global0_Type);
#endif
#ifdef PY_VERSION_GLOBALU_PATCH
	PY_VERSION_GLOBALU_PATCH(&smbXsrv_version_globalU_Type);
#endif
#ifdef PY_VERSION_GLOBALB_PATCH
	PY_VERSION_GLOBALB_PATCH(&smbXsrv_version_globalB_Type);
#endif
#ifdef PY_CLIENT_GLOBAL0_PATCH
	PY_CLIENT_GLOBAL0_PATCH(&smbXsrv_client_global0_Type);
#endif
#ifdef PY_CLIENT_GLOBALU_PATCH
	PY_CLIENT_GLOBALU_PATCH(&smbXsrv_client_globalU_Type);
#endif
#ifdef PY_CLIENT_GLOBALB_PATCH
	PY_CLIENT_GLOBALB_PATCH(&smbXsrv_client_globalB_Type);
#endif
#ifdef PY_CLIENT_PATCH
	PY_CLIENT_PATCH(&smbXsrv_client_Type);
#endif
#ifdef PY_CLIENTU_PATCH
	PY_CLIENTU_PATCH(&smbXsrv_clientU_Type);
#endif
#ifdef PY_CLIENTB_PATCH
	PY_CLIENTB_PATCH(&smbXsrv_clientB_Type);
#endif
#ifdef PY_CONNECTION_PASS0_PATCH
	PY_CONNECTION_PASS0_PATCH(&smbXsrv_connection_pass0_Type);
#endif
#ifdef PY_CONNECTION_PASSU_PATCH
	PY_CONNECTION_PASSU_PATCH(&smbXsrv_connection_passU_Type);
#endif
#ifdef PY_CONNECTION_PASSB_PATCH
	PY_CONNECTION_PASSB_PATCH(&smbXsrv_connection_passB_Type);
#endif
#ifdef PY_CONNECTION_DROP0_PATCH
	PY_CONNECTION_DROP0_PATCH(&smbXsrv_connection_drop0_Type);
#endif
#ifdef PY_CONNECTION_DROPU_PATCH
	PY_CONNECTION_DROPU_PATCH(&smbXsrv_connection_dropU_Type);
#endif
#ifdef PY_CONNECTION_DROPB_PATCH
	PY_CONNECTION_DROPB_PATCH(&smbXsrv_connection_dropB_Type);
#endif
#ifdef PY_CHANNEL_GLOBAL0_PATCH
	PY_CHANNEL_GLOBAL0_PATCH(&smbXsrv_channel_global0_Type);
#endif
#ifdef PY_SESSION_GLOBAL0_PATCH
	PY_SESSION_GLOBAL0_PATCH(&smbXsrv_session_global0_Type);
#endif
#ifdef PY_SESSION_GLOBALU_PATCH
	PY_SESSION_GLOBALU_PATCH(&smbXsrv_session_globalU_Type);
#endif
#ifdef PY_SESSION_GLOBALB_PATCH
	PY_SESSION_GLOBALB_PATCH(&smbXsrv_session_globalB_Type);
#endif
#ifdef PY_SESSION_AUTH0_PATCH
	PY_SESSION_AUTH0_PATCH(&smbXsrv_session_auth0_Type);
#endif
#ifdef PY_SESSION_PATCH
	PY_SESSION_PATCH(&smbXsrv_session_Type);
#endif
#ifdef PY_SESSIONU_PATCH
	PY_SESSIONU_PATCH(&smbXsrv_sessionU_Type);
#endif
#ifdef PY_SESSIONB_PATCH
	PY_SESSIONB_PATCH(&smbXsrv_sessionB_Type);
#endif
#ifdef PY_SESSION_CLOSE0_PATCH
	PY_SESSION_CLOSE0_PATCH(&smbXsrv_session_close0_Type);
#endif
#ifdef PY_SESSION_CLOSEU_PATCH
	PY_SESSION_CLOSEU_PATCH(&smbXsrv_session_closeU_Type);
#endif
#ifdef PY_SESSION_CLOSEB_PATCH
	PY_SESSION_CLOSEB_PATCH(&smbXsrv_session_closeB_Type);
#endif
#ifdef PY_TCON_GLOBAL0_PATCH
	PY_TCON_GLOBAL0_PATCH(&smbXsrv_tcon_global0_Type);
#endif
#ifdef PY_TCON_GLOBALU_PATCH
	PY_TCON_GLOBALU_PATCH(&smbXsrv_tcon_globalU_Type);
#endif
#ifdef PY_TCON_GLOBALB_PATCH
	PY_TCON_GLOBALB_PATCH(&smbXsrv_tcon_globalB_Type);
#endif
#ifdef PY_TCON_PATCH
	PY_TCON_PATCH(&smbXsrv_tcon_Type);
#endif
#ifdef PY_TCONU_PATCH
	PY_TCONU_PATCH(&smbXsrv_tconU_Type);
#endif
#ifdef PY_TCONB_PATCH
	PY_TCONB_PATCH(&smbXsrv_tconB_Type);
#endif
#ifdef PY_OPEN_GLOBAL0_PATCH
	PY_OPEN_GLOBAL0_PATCH(&smbXsrv_open_global0_Type);
#endif
#ifdef PY_OPEN_GLOBALU_PATCH
	PY_OPEN_GLOBALU_PATCH(&smbXsrv_open_globalU_Type);
#endif
#ifdef PY_OPEN_GLOBALB_PATCH
	PY_OPEN_GLOBALB_PATCH(&smbXsrv_open_globalB_Type);
#endif
#ifdef PY_OPEN_PATCH
	PY_OPEN_PATCH(&smbXsrv_open_Type);
#endif
#ifdef PY_OPENU_PATCH
	PY_OPENU_PATCH(&smbXsrv_openU_Type);
#endif
#ifdef PY_OPENB_PATCH
	PY_OPENB_PATCH(&smbXsrv_openB_Type);
#endif
#ifdef PY_OPEN_REPLAY_CACHE_KEY_PATCH
	PY_OPEN_REPLAY_CACHE_KEY_PATCH(&smbXsrv_open_replay_cache_key_Type);
#endif
#ifdef PY_OPEN_REPLAY_CACHE_PATCH
	PY_OPEN_REPLAY_CACHE_PATCH(&smbXsrv_open_replay_cache_Type);
#endif
#ifdef PY_SMBXSRV_PATCH
	PY_SMBXSRV_PATCH(&smbXsrv_InterfaceType);
#endif
#ifdef PY_SMBXSRV_ABSTRACT_SYNTAX_PATCH
	PY_SMBXSRV_ABSTRACT_SYNTAX_PATCH(&smbXsrv_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&smbXsrv_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "SMBXSRV_VERSION_CURRENT", PyLong_FromUnsignedLongLong((uint32_t)(SMBXSRV_VERSION_0)));
	PyModule_AddObject(m, "SMBXSRV_OPEN_REPLAY_CACHE_KEY_FIXED_SIZE", PyLong_FromUnsignedLongLong(32));
	PyModule_AddObject(m, "SMBXSRV_VERSION_0", PyLong_FromUnsignedLongLong((uint32_t)(SMBXSRV_VERSION_0)));
	PyModule_AddObject(m, "SMBXSRV_ENCRYPTION_REQUIRED", PyLong_FromLong((uint16_t)(SMBXSRV_ENCRYPTION_REQUIRED)));
	PyModule_AddObject(m, "SMBXSRV_ENCRYPTION_DESIRED", PyLong_FromLong((uint16_t)(SMBXSRV_ENCRYPTION_DESIRED)));
	PyModule_AddObject(m, "SMBXSRV_PROCESSED_ENCRYPTED_PACKET", PyLong_FromLong((uint16_t)(SMBXSRV_PROCESSED_ENCRYPTED_PACKET)));
	PyModule_AddObject(m, "SMBXSRV_PROCESSED_UNENCRYPTED_PACKET", PyLong_FromLong((uint16_t)(SMBXSRV_PROCESSED_UNENCRYPTED_PACKET)));
	PyModule_AddObject(m, "SMBXSRV_SIGNING_REQUIRED", PyLong_FromLong((uint16_t)(SMBXSRV_SIGNING_REQUIRED)));
	PyModule_AddObject(m, "SMBXSRV_PROCESSED_SIGNED_PACKET", PyLong_FromLong((uint16_t)(SMBXSRV_PROCESSED_SIGNED_PACKET)));
	PyModule_AddObject(m, "SMBXSRV_PROCESSED_UNSIGNED_PACKET", PyLong_FromLong((uint16_t)(SMBXSRV_PROCESSED_UNSIGNED_PACKET)));
	PyModule_AddObject(m, "SMBXSRV_OPEN_NEED_REPLAY_CACHE", PyLong_FromLong((uint16_t)(SMBXSRV_OPEN_NEED_REPLAY_CACHE)));
	PyModule_AddObject(m, "SMBXSRV_OPEN_HAVE_REPLAY_CACHE", PyLong_FromLong((uint16_t)(SMBXSRV_OPEN_HAVE_REPLAY_CACHE)));
	Py_INCREF((PyObject *)(void *)&smbXsrv_version_node0_Type);
	PyModule_AddObject(m, "version_node0", (PyObject *)(void *)&smbXsrv_version_node0_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_version_global0_Type);
	PyModule_AddObject(m, "version_global0", (PyObject *)(void *)&smbXsrv_version_global0_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_version_globalU_Type);
	PyModule_AddObject(m, "version_globalU", (PyObject *)(void *)&smbXsrv_version_globalU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_version_globalB_Type);
	PyModule_AddObject(m, "version_globalB", (PyObject *)(void *)&smbXsrv_version_globalB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_client_global0_Type);
	PyModule_AddObject(m, "client_global0", (PyObject *)(void *)&smbXsrv_client_global0_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_client_globalU_Type);
	PyModule_AddObject(m, "client_globalU", (PyObject *)(void *)&smbXsrv_client_globalU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_client_globalB_Type);
	PyModule_AddObject(m, "client_globalB", (PyObject *)(void *)&smbXsrv_client_globalB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_client_Type);
	PyModule_AddObject(m, "client", (PyObject *)(void *)&smbXsrv_client_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_clientU_Type);
	PyModule_AddObject(m, "clientU", (PyObject *)(void *)&smbXsrv_clientU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_clientB_Type);
	PyModule_AddObject(m, "clientB", (PyObject *)(void *)&smbXsrv_clientB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_connection_pass0_Type);
	PyModule_AddObject(m, "connection_pass0", (PyObject *)(void *)&smbXsrv_connection_pass0_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_connection_passU_Type);
	PyModule_AddObject(m, "connection_passU", (PyObject *)(void *)&smbXsrv_connection_passU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_connection_passB_Type);
	PyModule_AddObject(m, "connection_passB", (PyObject *)(void *)&smbXsrv_connection_passB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_connection_drop0_Type);
	PyModule_AddObject(m, "connection_drop0", (PyObject *)(void *)&smbXsrv_connection_drop0_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_connection_dropU_Type);
	PyModule_AddObject(m, "connection_dropU", (PyObject *)(void *)&smbXsrv_connection_dropU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_connection_dropB_Type);
	PyModule_AddObject(m, "connection_dropB", (PyObject *)(void *)&smbXsrv_connection_dropB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_channel_global0_Type);
	PyModule_AddObject(m, "channel_global0", (PyObject *)(void *)&smbXsrv_channel_global0_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_session_global0_Type);
	PyModule_AddObject(m, "session_global0", (PyObject *)(void *)&smbXsrv_session_global0_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_session_globalU_Type);
	PyModule_AddObject(m, "session_globalU", (PyObject *)(void *)&smbXsrv_session_globalU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_session_globalB_Type);
	PyModule_AddObject(m, "session_globalB", (PyObject *)(void *)&smbXsrv_session_globalB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_session_auth0_Type);
	PyModule_AddObject(m, "session_auth0", (PyObject *)(void *)&smbXsrv_session_auth0_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_session_Type);
	PyModule_AddObject(m, "session", (PyObject *)(void *)&smbXsrv_session_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_sessionU_Type);
	PyModule_AddObject(m, "sessionU", (PyObject *)(void *)&smbXsrv_sessionU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_sessionB_Type);
	PyModule_AddObject(m, "sessionB", (PyObject *)(void *)&smbXsrv_sessionB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_session_close0_Type);
	PyModule_AddObject(m, "session_close0", (PyObject *)(void *)&smbXsrv_session_close0_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_session_closeU_Type);
	PyModule_AddObject(m, "session_closeU", (PyObject *)(void *)&smbXsrv_session_closeU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_session_closeB_Type);
	PyModule_AddObject(m, "session_closeB", (PyObject *)(void *)&smbXsrv_session_closeB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_tcon_global0_Type);
	PyModule_AddObject(m, "tcon_global0", (PyObject *)(void *)&smbXsrv_tcon_global0_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_tcon_globalU_Type);
	PyModule_AddObject(m, "tcon_globalU", (PyObject *)(void *)&smbXsrv_tcon_globalU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_tcon_globalB_Type);
	PyModule_AddObject(m, "tcon_globalB", (PyObject *)(void *)&smbXsrv_tcon_globalB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_tcon_Type);
	PyModule_AddObject(m, "tcon", (PyObject *)(void *)&smbXsrv_tcon_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_tconU_Type);
	PyModule_AddObject(m, "tconU", (PyObject *)(void *)&smbXsrv_tconU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_tconB_Type);
	PyModule_AddObject(m, "tconB", (PyObject *)(void *)&smbXsrv_tconB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_open_global0_Type);
	PyModule_AddObject(m, "open_global0", (PyObject *)(void *)&smbXsrv_open_global0_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_open_globalU_Type);
	PyModule_AddObject(m, "open_globalU", (PyObject *)(void *)&smbXsrv_open_globalU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_open_globalB_Type);
	PyModule_AddObject(m, "open_globalB", (PyObject *)(void *)&smbXsrv_open_globalB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_open_Type);
	PyModule_AddObject(m, "open", (PyObject *)(void *)&smbXsrv_open_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_openU_Type);
	PyModule_AddObject(m, "openU", (PyObject *)(void *)&smbXsrv_openU_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_openB_Type);
	PyModule_AddObject(m, "openB", (PyObject *)(void *)&smbXsrv_openB_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_open_replay_cache_key_Type);
	PyModule_AddObject(m, "open_replay_cache_key", (PyObject *)(void *)&smbXsrv_open_replay_cache_key_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_open_replay_cache_Type);
	PyModule_AddObject(m, "open_replay_cache", (PyObject *)(void *)&smbXsrv_open_replay_cache_Type);
	Py_INCREF((PyObject *)(void *)&smbXsrv_InterfaceType);
	PyModule_AddObject(m, "smbXsrv", (PyObject *)(void *)&smbXsrv_InterfaceType);
	Py_INCREF((PyObject *)(void *)&smbXsrv_SyntaxType);
	PyModule_AddObject(m, "smbXsrv_abstract_syntax", (PyObject *)(void *)&smbXsrv_SyntaxType);
	Py_INCREF((PyObject *)(void *)&smbXsrv_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&smbXsrv_SyntaxType);
#ifdef PY_MOD_SMBXSRV_PATCH
	PY_MOD_SMBXSRV_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_samba_dcerpc_server_id);
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_samba_dcerpc_auth);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
