/* SinglePhotoPage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SinglePhotoPage.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include "shotwell-plugin-dev-1.0.h"

#define SINGLE_PHOTO_PAGE_FAST_INTERP GDK_INTERP_NEAREST
#define SINGLE_PHOTO_PAGE_QUALITY_INTERP GDK_INTERP_BILINEAR
#define SINGLE_PHOTO_PAGE_KEY_REPEAT_INTERVAL_MSEC 200
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
typedef struct _PagePrivate PagePrivate;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_FULLSCREEN_WINDOW (fullscreen_window_get_type ())
#define FULLSCREEN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FULLSCREEN_WINDOW, FullscreenWindow))
#define FULLSCREEN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FULLSCREEN_WINDOW, FullscreenWindowClass))
#define IS_FULLSCREEN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FULLSCREEN_WINDOW))
#define IS_FULLSCREEN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FULLSCREEN_WINDOW))
#define FULLSCREEN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FULLSCREEN_WINDOW, FullscreenWindowClass))

typedef struct _FullscreenWindow FullscreenWindow;
typedef struct _FullscreenWindowClass FullscreenWindowClass;

#define TYPE_INJECTION_GROUP (injection_group_get_type ())
#define INJECTION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INJECTION_GROUP, InjectionGroup))
#define INJECTION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INJECTION_GROUP, InjectionGroupClass))
#define IS_INJECTION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INJECTION_GROUP))
#define IS_INJECTION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INJECTION_GROUP))
#define INJECTION_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INJECTION_GROUP, InjectionGroupClass))

typedef struct _InjectionGroup InjectionGroup;
typedef struct _InjectionGroupClass InjectionGroupClass;

#define TYPE_SINGLE_PHOTO_PAGE (single_photo_page_get_type ())
#define SINGLE_PHOTO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage))
#define SINGLE_PHOTO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPageClass))
#define IS_SINGLE_PHOTO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SINGLE_PHOTO_PAGE))
#define IS_SINGLE_PHOTO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SINGLE_PHOTO_PAGE))
#define SINGLE_PHOTO_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPageClass))

typedef struct _SinglePhotoPage SinglePhotoPage;
typedef struct _SinglePhotoPageClass SinglePhotoPageClass;
typedef struct _SinglePhotoPagePrivate SinglePhotoPagePrivate;

#define TYPE_ZOOM_BUFFER (zoom_buffer_get_type ())
#define ZOOM_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ZOOM_BUFFER, ZoomBuffer))
#define ZOOM_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ZOOM_BUFFER, ZoomBufferClass))
#define IS_ZOOM_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ZOOM_BUFFER))
#define IS_ZOOM_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ZOOM_BUFFER))
#define ZOOM_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ZOOM_BUFFER, ZoomBufferClass))

typedef struct _ZoomBuffer ZoomBuffer;
typedef struct _ZoomBufferClass ZoomBufferClass;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef enum  {
	SINGLE_PHOTO_PAGE_UPDATE_REASON_NEW_PIXBUF,
	SINGLE_PHOTO_PAGE_UPDATE_REASON_QUALITY_IMPROVEMENT,
	SINGLE_PHOTO_PAGE_UPDATE_REASON_RESIZED_CANVAS
} SinglePhotoPageUpdateReason;

#define SINGLE_PHOTO_PAGE_TYPE_UPDATE_REASON (single_photo_page_update_reason_get_type ())

#define TYPE_TRANSITION_CLOCK (transition_clock_get_type ())
#define TRANSITION_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSITION_CLOCK, TransitionClock))
#define TRANSITION_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSITION_CLOCK, TransitionClockClass))
#define IS_TRANSITION_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSITION_CLOCK))
#define IS_TRANSITION_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSITION_CLOCK))
#define TRANSITION_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSITION_CLOCK, TransitionClockClass))

typedef struct _TransitionClock TransitionClock;
typedef struct _TransitionClockClass TransitionClockClass;

#define TYPE_ZOOM_STATE (zoom_state_get_type ())
typedef struct _ZoomState ZoomState;
enum  {
	SINGLE_PHOTO_PAGE_0_PROPERTY,
	SINGLE_PHOTO_PAGE_NUM_PROPERTIES
};
static GParamSpec* single_photo_page_properties[SINGLE_PHOTO_PAGE_NUM_PROPERTIES];

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _transition_clock_unref0(var) ((var == NULL) ? NULL : (var = (transition_clock_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_TRANSITION_EFFECTS_MANAGER (transition_effects_manager_get_type ())
#define TRANSITION_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSITION_EFFECTS_MANAGER, TransitionEffectsManager))
#define TRANSITION_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSITION_EFFECTS_MANAGER, TransitionEffectsManagerClass))
#define IS_TRANSITION_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSITION_EFFECTS_MANAGER))
#define IS_TRANSITION_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSITION_EFFECTS_MANAGER))
#define TRANSITION_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSITION_EFFECTS_MANAGER, TransitionEffectsManagerClass))

typedef struct _TransitionEffectsManager TransitionEffectsManager;
typedef struct _TransitionEffectsManagerClass TransitionEffectsManagerClass;
#define _transition_effects_manager_unref0(var) ((var == NULL) ? NULL : (var = (transition_effects_manager_unref (var), NULL)))
typedef enum  {
	DIRECTION_FORWARD,
	DIRECTION_BACKWARD
} Direction;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
typedef void (*TransitionClockRepaintCallback) (gpointer user_data);
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Page {
	GtkScrolledWindow parent_instance;
	PagePrivate * priv;
	GtkBuilder* builder;
	GtkToolbar* toolbar;
	gboolean in_view;
	gdouble wheel_factor;
	gdouble modified_wheel_factor;
};

struct _PageClass {
	GtkScrolledWindowClass parent_class;
	void (*set_page_name) (Page* self, const gchar* page_name);
	void (*set_container) (Page* self, GtkWindow* container);
	void (*clear_container) (Page* self);
	GtkToolbar* (*get_toolbar) (Page* self);
	GtkMenu* (*get_page_context_menu) (Page* self);
	void (*switching_from) (Page* self);
	void (*switched_to) (Page* self);
	void (*ready) (Page* self);
	void (*switching_to_fullscreen) (Page* self, FullscreenWindow* fsw);
	void (*returning_from_fullscreen) (Page* self, FullscreenWindow* fsw);
	void (*add_actions) (Page* self, GActionMap* map);
	void (*remove_actions) (Page* self, GActionMap* map);
	void (*init_collect_ui_filenames) (Page* self, GeeList* ui_filenames);
	InjectionGroup** (*init_collect_injection_groups) (Page* self, gint* result_length1);
	void (*init_actions) (Page* self, gint selected_count, gint count);
	void (*update_actions) (Page* self, gint selected_count, gint count);
	gboolean (*on_left_click) (Page* self, GdkEventButton* event);
	gboolean (*on_middle_click) (Page* self, GdkEventButton* event);
	gboolean (*on_right_click) (Page* self, GdkEventButton* event);
	gboolean (*on_left_released) (Page* self, GdkEventButton* event);
	gboolean (*on_middle_released) (Page* self, GdkEventButton* event);
	gboolean (*on_right_released) (Page* self, GdkEventButton* event);
	gboolean (*on_ctrl_pressed) (Page* self, GdkEventKey* event);
	gboolean (*on_ctrl_released) (Page* self, GdkEventKey* event);
	gboolean (*on_alt_pressed) (Page* self, GdkEventKey* event);
	gboolean (*on_alt_released) (Page* self, GdkEventKey* event);
	gboolean (*on_shift_pressed) (Page* self, GdkEventKey* event);
	gboolean (*on_shift_released) (Page* self, GdkEventKey* event);
	gboolean (*on_super_pressed) (Page* self, GdkEventKey* event);
	gboolean (*on_super_released) (Page* self, GdkEventKey* event);
	gboolean (*on_app_key_pressed) (Page* self, GdkEventKey* event);
	gboolean (*on_app_key_released) (Page* self, GdkEventKey* event);
	void (*on_move) (Page* self, GdkRectangle* rect);
	void (*on_move_start) (Page* self, GdkRectangle* rect);
	void (*on_move_finished) (Page* self, GdkRectangle* rect);
	void (*on_resize) (Page* self, GdkRectangle* rect);
	void (*on_resize_start) (Page* self, GdkRectangle* rect);
	void (*on_resize_finished) (Page* self, GdkRectangle* rect);
	gboolean (*on_configure) (Page* self, GdkEventConfigure* event, GdkRectangle* rect);
	gboolean (*on_motion) (Page* self, GdkEventMotion* event, gint x, gint y, GdkModifierType mask);
	gboolean (*on_leave_notify_event) (Page* self);
	gboolean (*on_mousewheel_up) (Page* self, GdkEventScroll* event);
	gboolean (*on_mousewheel_down) (Page* self, GdkEventScroll* event);
	gboolean (*on_mousewheel_left) (Page* self, GdkEventScroll* event);
	gboolean (*on_mousewheel_right) (Page* self, GdkEventScroll* event);
	gboolean (*on_context_keypress) (Page* self);
	gboolean (*on_context_buttonpress) (Page* self, GdkEventButton* event);
	gboolean (*on_context_invoked) (Page* self);
	void (*set_page_cursor) (Page* self, GdkCursorType cursor_type);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _SinglePhotoPage {
	Page parent_instance;
	SinglePhotoPagePrivate * priv;
	GtkDrawingArea* canvas;
	GtkViewport* viewport;
};

struct _SinglePhotoPageClass {
	PageClass parent_class;
	gboolean (*is_zoom_supported) (SinglePhotoPage* self);
	void (*cancel_zoom) (SinglePhotoPage* self);
	void (*save_zoom_state) (SinglePhotoPage* self);
	void (*restore_zoom_state) (SinglePhotoPage* self);
	ZoomBuffer* (*get_zoom_buffer) (SinglePhotoPage* self);
	void (*new_surface) (SinglePhotoPage* self, cairo_t* ctx, Dimensions* ctx_dim);
	void (*updated_pixbuf) (SinglePhotoPage* self, GdkPixbuf* pixbuf, SinglePhotoPageUpdateReason reason, Dimensions* old_dim);
	void (*paint) (SinglePhotoPage* self, cairo_t* ctx, Dimensions* ctx_dim);
	void (*on_previous_photo) (SinglePhotoPage* self);
	void (*on_next_photo) (SinglePhotoPage* self);
};

struct _ZoomState {
	Dimensions content_dimensions;
	Dimensions viewport_dimensions;
	gdouble zoom_factor;
	gdouble interpolation_factor;
	gdouble min_factor;
	gdouble max_factor;
	GdkPoint viewport_center;
};

struct _SinglePhotoPagePrivate {
	gboolean scale_up_to_viewport;
	TransitionClock* transition_clock;
	gint transition_duration_msec;
	cairo_surface_t* pixmap;
	cairo_t* pixmap_ctx;
	cairo_t* text_ctx;
	Dimensions pixmap_dim;
	GdkPixbuf* unscaled;
	Dimensions max_dim;
	GdkPixbuf* scaled;
	GdkPixbuf* old_scaled;
	GdkRectangle scaled_pos;
	ZoomState static_zoom_state;
	gboolean zoom_high_quality;
	ZoomState saved_zoom_state;
	gboolean has_saved_zoom_state;
	guint32 last_nav_key;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

static gint SinglePhotoPage_private_offset;
static gpointer single_photo_page_parent_class = NULL;

VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType fullscreen_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FullscreenWindow, g_object_unref)
VALA_EXTERN gpointer injection_group_ref (gpointer instance);
VALA_EXTERN void injection_group_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_injection_group (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_injection_group (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_injection_group (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_injection_group (const GValue* value);
VALA_EXTERN GType injection_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (InjectionGroup, injection_group_unref)
VALA_EXTERN GType single_photo_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SinglePhotoPage, g_object_unref)
VALA_EXTERN GType zoom_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZoomBuffer, g_object_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType single_photo_page_update_reason_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer transition_clock_ref (gpointer instance);
VALA_EXTERN void transition_clock_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_transition_clock (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_transition_clock (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_transition_clock (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_transition_clock (const GValue* value);
VALA_EXTERN GType transition_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransitionClock, transition_clock_unref)
VALA_EXTERN GType zoom_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ZoomState* zoom_state_dup (const ZoomState* self);
VALA_EXTERN void zoom_state_free (ZoomState* self);
VALA_EXTERN gboolean single_photo_page_is_zoom_supported (SinglePhotoPage* self);
VALA_EXTERN void single_photo_page_cancel_zoom (SinglePhotoPage* self);
VALA_EXTERN void single_photo_page_save_zoom_state (SinglePhotoPage* self);
VALA_EXTERN void single_photo_page_restore_zoom_state (SinglePhotoPage* self);
VALA_EXTERN ZoomBuffer* single_photo_page_get_zoom_buffer (SinglePhotoPage* self);
VALA_EXTERN void page_switched_to (Page* self);
VALA_EXTERN void page_set_container (Page* self,
                         GtkWindow* container);
VALA_EXTERN void page_on_resize_finished (Page* self,
                              GdkRectangle* rect);
VALA_EXTERN void single_photo_page_new_surface (SinglePhotoPage* self,
                                    cairo_t* ctx,
                                    Dimensions* ctx_dim);
VALA_EXTERN void single_photo_page_updated_pixbuf (SinglePhotoPage* self,
                                       GdkPixbuf* pixbuf,
                                       SinglePhotoPageUpdateReason reason,
                                       Dimensions* old_dim);
VALA_EXTERN void single_photo_page_paint (SinglePhotoPage* self,
                              cairo_t* ctx,
                              Dimensions* ctx_dim);
VALA_EXTERN gboolean page_on_context_keypress (Page* self);
VALA_EXTERN void single_photo_page_on_previous_photo (SinglePhotoPage* self);
VALA_EXTERN void single_photo_page_on_next_photo (SinglePhotoPage* self);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
static void single_photo_page_on_colors_changed (SinglePhotoPage* self);
static void _single_photo_page_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender,
                                                                        gpointer self);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
VALA_EXTERN SinglePhotoPage* single_photo_page_construct (GType object_type,
                                              const gchar* page_name,
                                              gboolean scale_up_to_viewport);
VALA_EXTERN Page* page_construct (GType object_type,
                      const gchar* page_name);
VALA_EXTERN gpointer transition_effects_manager_ref (gpointer instance);
VALA_EXTERN void transition_effects_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_transition_effects_manager (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void value_set_transition_effects_manager (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void value_take_transition_effects_manager (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer value_get_transition_effects_manager (const GValue* value);
VALA_EXTERN GType transition_effects_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransitionEffectsManager, transition_effects_manager_unref)
VALA_EXTERN TransitionEffectsManager* transition_effects_manager_get_instance (void);
VALA_EXTERN TransitionClock* transition_effects_manager_create_null_transition_clock (TransitionEffectsManager* self);
static void single_photo_page_on_viewport_resize (SinglePhotoPage* self);
static void _single_photo_page_on_viewport_resize_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                     GtkAllocation* allocation,
                                                                     gpointer self);
static gboolean single_photo_page_on_canvas_exposed (SinglePhotoPage* self,
                                              cairo_t* exposed_ctx);
static gboolean _single_photo_page_on_canvas_exposed_gtk_widget_draw (GtkWidget* _sender,
                                                               cairo_t* cr,
                                                               gpointer self);
VALA_EXTERN void page_set_event_source (Page* self,
                            GtkWidget* event_source);
VALA_EXTERN gboolean single_photo_page_is_transition_in_progress (SinglePhotoPage* self);
VALA_EXTERN gboolean transition_clock_is_in_progress (TransitionClock* self);
VALA_EXTERN void single_photo_page_cancel_transition (SinglePhotoPage* self);
VALA_EXTERN void transition_clock_cancel (TransitionClock* self);
VALA_EXTERN void single_photo_page_set_transition (SinglePhotoPage* self,
                                       const gchar* effect_id,
                                       gint duration_msec);
VALA_EXTERN TransitionClock* transition_effects_manager_create_transition_clock (TransitionEffectsManager* self,
                                                                     const gchar* effect_id);
static void single_photo_page_render_zoomed_to_pixmap (SinglePhotoPage* self,
                                                ZoomState* zoom_state);
VALA_EXTERN void zoom_state_get_viewing_rectangle_wrt_content (ZoomState *self,
                                                   GdkRectangle* result);
VALA_EXTERN GdkPixbuf* zoom_buffer_get_zoomed_image (ZoomBuffer* self,
                                         ZoomState* zoom_state);
VALA_EXTERN GdkPixbuf* zoom_buffer_get_zoom_preview_image (ZoomBuffer* self,
                                               ZoomState* zoom_state);
VALA_EXTERN void zoom_state_get_viewing_rectangle_projection (ZoomState *self,
                                                  GdkPixbuf* for_pixbuf,
                                                  GdkRectangle* result);
VALA_EXTERN void paint_pixmap_with_background (cairo_t* ctx,
                                   GdkPixbuf* pixbuf,
                                   gint x,
                                   gint y);
VALA_EXTERN void single_photo_page_on_interactive_zoom (SinglePhotoPage* self,
                                            ZoomState* interactive_zoom_state);
VALA_EXTERN void set_source_color_from_string (cairo_t* ctx,
                                   const gchar* spec);
VALA_EXTERN void single_photo_page_on_interactive_pan (SinglePhotoPage* self,
                                           ZoomState* interactive_zoom_state);
static gboolean single_photo_page_real_is_zoom_supported (SinglePhotoPage* self);
static void single_photo_page_real_cancel_zoom (SinglePhotoPage* self);
static void single_photo_page_real_save_zoom_state (SinglePhotoPage* self);
static void single_photo_page_real_restore_zoom_state (SinglePhotoPage* self);
VALA_EXTERN GType direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void single_photo_page_repaint (SinglePhotoPage* self,
                                Direction* direction);
static ZoomBuffer* single_photo_page_real_get_zoom_buffer (SinglePhotoPage* self);
VALA_EXTERN void single_photo_page_get_saved_zoom_state (SinglePhotoPage* self,
                                             ZoomState* result);
VALA_EXTERN void single_photo_page_set_zoom_state (SinglePhotoPage* self,
                                       ZoomState* zoom_state);
VALA_EXTERN void single_photo_page_get_zoom_state (SinglePhotoPage* self,
                                       ZoomState* result);
static void single_photo_page_real_switched_to (Page* base);
static void single_photo_page_real_set_container (Page* base,
                                           GtkWindow* container);
VALA_EXTERN void single_photo_page_set_pixbuf (SinglePhotoPage* self,
                                   GdkPixbuf* unscaled,
                                   Dimensions* max_dim,
                                   Direction* direction);
VALA_EXTERN gdouble zoom_state_get_interpolation_factor (ZoomState *self);
VALA_EXTERN void zoom_state_get_viewport_center (ZoomState *self,
                                     GdkPoint* result);
VALA_EXTERN void zoom_state_init (ZoomState *self,
                      Dimensions* content_dimensions,
                      Dimensions* viewport_dimensions,
                      gdouble slider_val,
                      GdkPoint* viewport_center);
VALA_EXTERN void single_photo_page_blank_display (SinglePhotoPage* self);
VALA_EXTERN void single_photo_page_invalidate_all (SinglePhotoPage* self);
VALA_EXTERN cairo_surface_t* single_photo_page_get_surface (SinglePhotoPage* self);
VALA_EXTERN void single_photo_page_get_surface_dim (SinglePhotoPage* self,
                                        Dimensions* result);
VALA_EXTERN cairo_t* single_photo_page_get_cairo_context (SinglePhotoPage* self);
VALA_EXTERN void single_photo_page_paint_text (SinglePhotoPage* self,
                                   PangoLayout* pango_layout,
                                   gint x,
                                   gint y);
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN void single_photo_page_get_canvas_scaling (SinglePhotoPage* self,
                                           Scaling* result);
VALA_EXTERN GtkWindow* page_get_container (Page* self);
VALA_EXTERN void scaling_for_screen (GtkWindow* window,
                         gboolean scale_up,
                         Scaling* result);
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN AppWindow* app_window_get_instance (void);
VALA_EXTERN void scaling_for_widget (GtkWidget* widget,
                         gboolean scale_up,
                         Scaling* result);
VALA_EXTERN GdkPixbuf* single_photo_page_get_unscaled_pixbuf (SinglePhotoPage* self);
VALA_EXTERN GdkPixbuf* single_photo_page_get_scaled_pixbuf (SinglePhotoPage* self);
VALA_EXTERN void single_photo_page_get_scaled_pixbuf_position (SinglePhotoPage* self,
                                                   GdkRectangle* result);
VALA_EXTERN gboolean single_photo_page_is_inside_pixbuf (SinglePhotoPage* self,
                                             gint x,
                                             gint y);
VALA_EXTERN gboolean coord_in_rectangle (gint x,
                             gint y,
                             GdkRectangle* rect);
VALA_EXTERN gdouble application_get_scale (void);
VALA_EXTERN void single_photo_page_invalidate (SinglePhotoPage* self,
                                   GdkRectangle* rect);
static void single_photo_page_internal_repaint (SinglePhotoPage* self,
                                         gboolean fast,
                                         Direction* direction);
static void single_photo_page_real_on_resize_finished (Page* base,
                                                GdkRectangle* rect);
static void single_photo_page_real_new_surface (SinglePhotoPage* self,
                                         cairo_t* ctx,
                                         Dimensions* ctx_dim);
static void single_photo_page_real_updated_pixbuf (SinglePhotoPage* self,
                                            GdkPixbuf* pixbuf,
                                            SinglePhotoPageUpdateReason reason,
                                            Dimensions* old_dim);
static void single_photo_page_real_paint (SinglePhotoPage* self,
                                   cairo_t* ctx,
                                   Dimensions* ctx_dim);
VALA_EXTERN gboolean zoom_state_is_default (ZoomState *self);
VALA_EXTERN gboolean transition_clock_paint (TransitionClock* self,
                                 cairo_t* ctx,
                                 gint width,
                                 gint height);
static void single_photo_page_repaint_pixmap (SinglePhotoPage* self);
VALA_EXTERN gboolean page_is_in_view (Page* self);
VALA_EXTERN void dimensions_for_rectangle (GdkRectangle* rect,
                               Dimensions* result);
static void single_photo_page_init_pixmap (SinglePhotoPage* self,
                                    gint width,
                                    gint height);
VALA_EXTERN void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
VALA_EXTERN gboolean dimensions_has_area (Dimensions *self);
VALA_EXTERN void dimensions_get_scaled_proportional (Dimensions *self,
                                         Dimensions* viewport,
                                         Dimensions* result);
VALA_EXTERN GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
VALA_EXTERN void parse_color (const gchar* spec,
                  GdkRGBA* result);
VALA_EXTERN void transition_clock_start (TransitionClock* self,
                             SpitTransitionsVisuals* visuals,
                             SpitTransitionsDirection direction,
                             gint duration_msec,
                             TransitionClockRepaintCallback repaint,
                             gpointer repaint_target);
VALA_EXTERN SpitTransitionsDirection direction_to_transition_direction (Direction self);
static void _single_photo_page_repaint_pixmap_transition_clock_repaint_callback (gpointer self);
static gboolean single_photo_page_real_on_context_keypress (Page* base);
VALA_EXTERN gboolean page_popup_context_menu (Page* self,
                                  GtkMenu* context_menu,
                                  GdkEventButton* event);
VALA_EXTERN GtkMenu* page_get_page_context_menu (Page* self);
static void single_photo_page_real_on_previous_photo (SinglePhotoPage* self);
static void single_photo_page_real_on_next_photo (SinglePhotoPage* self);
static gboolean single_photo_page_real_key_press_event (GtkWidget* base,
                                                 GdkEventKey* event);
VALA_EXTERN void invalidate_transparent_background (void);
static void single_photo_page_finalize (GObject * obj);
static GType single_photo_page_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
single_photo_page_get_instance_private (SinglePhotoPage* self)
{
	return G_STRUCT_MEMBER_P (self, SinglePhotoPage_private_offset);
}

static void
_single_photo_page_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender,
                                                                   gpointer self)
{
	single_photo_page_on_colors_changed ((SinglePhotoPage*) self);
}

static GType
single_photo_page_update_reason_get_type_once (void)
{
	static const GEnumValue values[] = {{SINGLE_PHOTO_PAGE_UPDATE_REASON_NEW_PIXBUF, "SINGLE_PHOTO_PAGE_UPDATE_REASON_NEW_PIXBUF", "new-pixbuf"}, {SINGLE_PHOTO_PAGE_UPDATE_REASON_QUALITY_IMPROVEMENT, "SINGLE_PHOTO_PAGE_UPDATE_REASON_QUALITY_IMPROVEMENT", "quality-improvement"}, {SINGLE_PHOTO_PAGE_UPDATE_REASON_RESIZED_CANVAS, "SINGLE_PHOTO_PAGE_UPDATE_REASON_RESIZED_CANVAS", "resized-canvas"}, {0, NULL, NULL}};
	GType single_photo_page_update_reason_type_id;
	single_photo_page_update_reason_type_id = g_enum_register_static ("SinglePhotoPageUpdateReason", values);
	return single_photo_page_update_reason_type_id;
}

GType
single_photo_page_update_reason_get_type (void)
{
	static volatile gsize single_photo_page_update_reason_type_id__once = 0;
	if (g_once_init_enter (&single_photo_page_update_reason_type_id__once)) {
		GType single_photo_page_update_reason_type_id;
		single_photo_page_update_reason_type_id = single_photo_page_update_reason_get_type_once ();
		g_once_init_leave (&single_photo_page_update_reason_type_id__once, single_photo_page_update_reason_type_id);
	}
	return single_photo_page_update_reason_type_id__once;
}

static void
_single_photo_page_on_viewport_resize_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                GtkAllocation* allocation,
                                                                gpointer self)
{
	single_photo_page_on_viewport_resize ((SinglePhotoPage*) self);
}

static gboolean
_single_photo_page_on_canvas_exposed_gtk_widget_draw (GtkWidget* _sender,
                                                      cairo_t* cr,
                                                      gpointer self)
{
	gboolean result;
	result = single_photo_page_on_canvas_exposed ((SinglePhotoPage*) self, cr);
	return result;
}

SinglePhotoPage*
single_photo_page_construct (GType object_type,
                             const gchar* page_name,
                             gboolean scale_up_to_viewport)
{
	SinglePhotoPage * self = NULL;
	TransitionEffectsManager* _tmp0_;
	TransitionEffectsManager* _tmp1_;
	TransitionClock* _tmp2_;
	GtkViewport* _tmp3_;
	GtkViewport* _tmp4_;
	GtkViewport* _tmp5_;
	GtkDrawingArea* _tmp6_;
	GtkViewport* _tmp7_;
	GtkDrawingArea* _tmp8_;
	GtkViewport* _tmp9_;
	GtkDrawingArea* _tmp10_;
	GtkDrawingArea* _tmp11_;
	ConfigFacade* _tmp12_;
	ConfigFacade* _tmp13_;
	g_return_val_if_fail (page_name != NULL, NULL);
	self = (SinglePhotoPage*) page_construct (object_type, page_name);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page)->wheel_factor = 0.9999;
	self->priv->scale_up_to_viewport = scale_up_to_viewport;
	_tmp0_ = transition_effects_manager_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = transition_effects_manager_create_null_transition_clock (_tmp1_);
	_transition_clock_unref0 (self->priv->transition_clock);
	self->priv->transition_clock = _tmp2_;
	_transition_effects_manager_unref0 (_tmp1_);
	gtk_scrolled_window_set_policy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), (guint) 0);
	gtk_scrolled_window_set_shadow_type (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow), GTK_SHADOW_NONE);
	_tmp3_ = self->viewport;
	gtk_viewport_set_shadow_type (_tmp3_, GTK_SHADOW_NONE);
	_tmp4_ = self->viewport;
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer), (guint) 0);
	_tmp5_ = self->viewport;
	_tmp6_ = self->canvas;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = self->viewport;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->canvas;
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), (gint) ((GDK_EXPOSURE_MASK | GDK_STRUCTURE_MASK) | GDK_SUBSTRUCTURE_MASK));
	_tmp9_ = self->viewport;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), "size-allocate", (GCallback) _single_photo_page_on_viewport_resize_gtk_widget_size_allocate, self, 0);
	_tmp10_ = self->canvas;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), "draw", (GCallback) _single_photo_page_on_canvas_exposed_gtk_widget_draw, self, 0);
	_tmp11_ = self->canvas;
	page_set_event_source (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	_tmp12_ = config_facade_get_instance ();
	_tmp13_ = _tmp12_;
	g_signal_connect_object (_tmp13_, "colors-changed", (GCallback) _single_photo_page_on_colors_changed_config_facade_colors_changed, self, 0);
	_g_object_unref0 (_tmp13_);
	return self;
}

gboolean
single_photo_page_is_transition_in_progress (SinglePhotoPage* self)
{
	TransitionClock* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_SINGLE_PHOTO_PAGE (self), FALSE);
	_tmp0_ = self->priv->transition_clock;
	result = transition_clock_is_in_progress (_tmp0_);
	return result;
}

void
single_photo_page_cancel_transition (SinglePhotoPage* self)
{
	TransitionClock* _tmp0_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_tmp0_ = self->priv->transition_clock;
	if (transition_clock_is_in_progress (_tmp0_)) {
		TransitionClock* _tmp1_;
		_tmp1_ = self->priv->transition_clock;
		transition_clock_cancel (_tmp1_);
	}
}

void
single_photo_page_set_transition (SinglePhotoPage* self,
                                  const gchar* effect_id,
                                  gint duration_msec)
{
	TransitionEffectsManager* _tmp0_;
	TransitionEffectsManager* _tmp1_;
	TransitionClock* _tmp2_;
	TransitionClock* _tmp3_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	g_return_if_fail (effect_id != NULL);
	single_photo_page_cancel_transition (self);
	_tmp0_ = transition_effects_manager_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = transition_effects_manager_create_transition_clock (_tmp1_, effect_id);
	_transition_clock_unref0 (self->priv->transition_clock);
	self->priv->transition_clock = _tmp2_;
	_transition_effects_manager_unref0 (_tmp1_);
	_tmp3_ = self->priv->transition_clock;
	if (_tmp3_ == NULL) {
		TransitionEffectsManager* _tmp4_;
		TransitionEffectsManager* _tmp5_;
		TransitionClock* _tmp6_;
		_tmp4_ = transition_effects_manager_get_instance ();
		_tmp5_ = _tmp4_;
		_tmp6_ = transition_effects_manager_create_null_transition_clock (_tmp5_);
		_transition_clock_unref0 (self->priv->transition_clock);
		self->priv->transition_clock = _tmp6_;
		_transition_effects_manager_unref0 (_tmp5_);
	}
	self->priv->transition_duration_msec = duration_msec;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
single_photo_page_render_zoomed_to_pixmap (SinglePhotoPage* self,
                                           ZoomState* zoom_state)
{
	GdkRectangle view_rect = {0};
	GdkRectangle _tmp0_ = {0};
	GdkPixbuf* zoomed = NULL;
	ZoomBuffer* _tmp1_;
	ZoomBuffer* _tmp2_;
	gboolean _tmp3_;
	GdkPixbuf* _tmp26_;
	gint draw_x = 0;
	Dimensions _tmp27_;
	GdkRectangle _tmp28_;
	gint draw_y = 0;
	Dimensions _tmp29_;
	GdkRectangle _tmp30_;
	cairo_t* _tmp31_;
	GdkPixbuf* _tmp32_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	g_return_if_fail (zoom_state != NULL);
	_vala_assert (single_photo_page_is_zoom_supported (self), "is_zoom_supported()");
	zoom_state_get_viewing_rectangle_wrt_content (zoom_state, &_tmp0_);
	view_rect = _tmp0_;
	_tmp1_ = single_photo_page_get_zoom_buffer (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* _tmp13_;
		if (self->priv->zoom_high_quality) {
			ZoomBuffer* _tmp5_;
			ZoomBuffer* _tmp6_;
			ZoomState _tmp7_;
			GdkPixbuf* _tmp8_;
			_tmp5_ = single_photo_page_get_zoom_buffer (self);
			_tmp6_ = _tmp5_;
			_tmp7_ = *zoom_state;
			_tmp8_ = zoom_buffer_get_zoomed_image (_tmp6_, &_tmp7_);
			_g_object_unref0 (_tmp4_);
			_tmp4_ = _tmp8_;
			_g_object_unref0 (_tmp6_);
		} else {
			ZoomBuffer* _tmp9_;
			ZoomBuffer* _tmp10_;
			ZoomState _tmp11_;
			GdkPixbuf* _tmp12_;
			_tmp9_ = single_photo_page_get_zoom_buffer (self);
			_tmp10_ = _tmp9_;
			_tmp11_ = *zoom_state;
			_tmp12_ = zoom_buffer_get_zoom_preview_image (_tmp10_, &_tmp11_);
			_g_object_unref0 (_tmp4_);
			_tmp4_ = _tmp12_;
			_g_object_unref0 (_tmp10_);
		}
		_tmp13_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (zoomed);
		zoomed = _tmp13_;
		_g_object_unref0 (_tmp4_);
	} else {
		GdkRectangle view_rect_proj = {0};
		GdkPixbuf* _tmp14_;
		GdkRectangle _tmp15_ = {0};
		GdkPixbuf* proj_subpixbuf = NULL;
		GdkPixbuf* _tmp16_;
		GdkRectangle _tmp17_;
		GdkRectangle _tmp18_;
		GdkRectangle _tmp19_;
		GdkRectangle _tmp20_;
		GdkPixbuf* _tmp21_;
		GdkPixbuf* _tmp22_;
		GdkRectangle _tmp23_;
		GdkRectangle _tmp24_;
		GdkPixbuf* _tmp25_;
		_tmp14_ = self->priv->unscaled;
		zoom_state_get_viewing_rectangle_projection (zoom_state, _tmp14_, &_tmp15_);
		view_rect_proj = _tmp15_;
		_tmp16_ = self->priv->unscaled;
		_tmp17_ = view_rect_proj;
		_tmp18_ = view_rect_proj;
		_tmp19_ = view_rect_proj;
		_tmp20_ = view_rect_proj;
		_tmp21_ = gdk_pixbuf_new_subpixbuf (_tmp16_, _tmp17_.x, _tmp18_.y, _tmp19_.width, _tmp20_.height);
		proj_subpixbuf = _tmp21_;
		_tmp22_ = proj_subpixbuf;
		_tmp23_ = view_rect;
		_tmp24_ = view_rect;
		_tmp25_ = gdk_pixbuf_scale_simple (_tmp22_, _tmp23_.width, _tmp24_.height, GDK_INTERP_BILINEAR);
		_g_object_unref0 (zoomed);
		zoomed = _tmp25_;
		_g_object_unref0 (proj_subpixbuf);
	}
	_tmp26_ = zoomed;
	if (_tmp26_ == NULL) {
		_g_object_unref0 (zoomed);
		return;
	}
	_tmp27_ = self->priv->pixmap_dim;
	_tmp28_ = view_rect;
	draw_x = (_tmp27_.width - _tmp28_.width) / 2;
	draw_x = CLAMP (draw_x, 0, G_MAXINT);
	_tmp29_ = self->priv->pixmap_dim;
	_tmp30_ = view_rect;
	draw_y = (_tmp29_.height - _tmp30_.height) / 2;
	draw_y = CLAMP (draw_y, 0, G_MAXINT);
	_tmp31_ = self->priv->pixmap_ctx;
	_tmp32_ = zoomed;
	paint_pixmap_with_background (_tmp31_, _tmp32_, draw_x, draw_y);
	_g_object_unref0 (zoomed);
}

void
single_photo_page_on_interactive_zoom (SinglePhotoPage* self,
                                       ZoomState* interactive_zoom_state)
{
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gboolean old_quality_setting = FALSE;
	ZoomState _tmp2_;
	GtkDrawingArea* _tmp3_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	g_return_if_fail (interactive_zoom_state != NULL);
	_vala_assert (single_photo_page_is_zoom_supported (self), "is_zoom_supported()");
	_tmp0_ = self->priv->pixmap_ctx;
	set_source_color_from_string (_tmp0_, "#000");
	_tmp1_ = self->priv->pixmap_ctx;
	cairo_paint (_tmp1_);
	old_quality_setting = self->priv->zoom_high_quality;
	self->priv->zoom_high_quality = FALSE;
	_tmp2_ = *interactive_zoom_state;
	single_photo_page_render_zoomed_to_pixmap (self, &_tmp2_);
	self->priv->zoom_high_quality = old_quality_setting;
	_tmp3_ = self->canvas;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
}

void
single_photo_page_on_interactive_pan (SinglePhotoPage* self,
                                      ZoomState* interactive_zoom_state)
{
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gboolean old_quality_setting = FALSE;
	ZoomState _tmp2_;
	GtkDrawingArea* _tmp3_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	g_return_if_fail (interactive_zoom_state != NULL);
	_vala_assert (single_photo_page_is_zoom_supported (self), "is_zoom_supported()");
	_tmp0_ = self->priv->pixmap_ctx;
	set_source_color_from_string (_tmp0_, "#000");
	_tmp1_ = self->priv->pixmap_ctx;
	cairo_paint (_tmp1_);
	old_quality_setting = self->priv->zoom_high_quality;
	self->priv->zoom_high_quality = TRUE;
	_tmp2_ = *interactive_zoom_state;
	single_photo_page_render_zoomed_to_pixmap (self, &_tmp2_);
	self->priv->zoom_high_quality = old_quality_setting;
	_tmp3_ = self->canvas;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
}

static gboolean
single_photo_page_real_is_zoom_supported (SinglePhotoPage* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
single_photo_page_is_zoom_supported (SinglePhotoPage* self)
{
	SinglePhotoPageClass* _klass_;
	g_return_val_if_fail (IS_SINGLE_PHOTO_PAGE (self), FALSE);
	_klass_ = SINGLE_PHOTO_PAGE_GET_CLASS (self);
	if (_klass_->is_zoom_supported) {
		return _klass_->is_zoom_supported (self);
	}
	return FALSE;
}

static void
single_photo_page_real_cancel_zoom (SinglePhotoPage* self)
{
	cairo_surface_t* _tmp0_;
	_tmp0_ = self->priv->pixmap;
	if (_tmp0_ != NULL) {
		cairo_t* _tmp1_;
		cairo_t* _tmp2_;
		_tmp1_ = self->priv->pixmap_ctx;
		set_source_color_from_string (_tmp1_, "#000");
		_tmp2_ = self->priv->pixmap_ctx;
		cairo_paint (_tmp2_);
	}
}

void
single_photo_page_cancel_zoom (SinglePhotoPage* self)
{
	SinglePhotoPageClass* _klass_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_klass_ = SINGLE_PHOTO_PAGE_GET_CLASS (self);
	if (_klass_->cancel_zoom) {
		_klass_->cancel_zoom (self);
	}
}

static void
single_photo_page_real_save_zoom_state (SinglePhotoPage* self)
{
	ZoomState _tmp0_;
	_tmp0_ = self->priv->static_zoom_state;
	self->priv->saved_zoom_state = _tmp0_;
	self->priv->has_saved_zoom_state = TRUE;
}

void
single_photo_page_save_zoom_state (SinglePhotoPage* self)
{
	SinglePhotoPageClass* _klass_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_klass_ = SINGLE_PHOTO_PAGE_GET_CLASS (self);
	if (_klass_->save_zoom_state) {
		_klass_->save_zoom_state (self);
	}
}

static void
single_photo_page_real_restore_zoom_state (SinglePhotoPage* self)
{
	ZoomState _tmp0_;
	if (!self->priv->has_saved_zoom_state) {
		return;
	}
	_tmp0_ = self->priv->saved_zoom_state;
	self->priv->static_zoom_state = _tmp0_;
	single_photo_page_repaint (self, NULL);
	self->priv->has_saved_zoom_state = FALSE;
}

void
single_photo_page_restore_zoom_state (SinglePhotoPage* self)
{
	SinglePhotoPageClass* _klass_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_klass_ = SINGLE_PHOTO_PAGE_GET_CLASS (self);
	if (_klass_->restore_zoom_state) {
		_klass_->restore_zoom_state (self);
	}
}

static ZoomBuffer*
single_photo_page_real_get_zoom_buffer (SinglePhotoPage* self)
{
	ZoomBuffer* result;
	result = NULL;
	return result;
}

ZoomBuffer*
single_photo_page_get_zoom_buffer (SinglePhotoPage* self)
{
	SinglePhotoPageClass* _klass_;
	g_return_val_if_fail (IS_SINGLE_PHOTO_PAGE (self), NULL);
	_klass_ = SINGLE_PHOTO_PAGE_GET_CLASS (self);
	if (_klass_->get_zoom_buffer) {
		return _klass_->get_zoom_buffer (self);
	}
	return NULL;
}

void
single_photo_page_get_saved_zoom_state (SinglePhotoPage* self,
                                        ZoomState* result)
{
	ZoomState _tmp0_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_tmp0_ = self->priv->saved_zoom_state;
	*result = _tmp0_;
	return;
}

void
single_photo_page_set_zoom_state (SinglePhotoPage* self,
                                  ZoomState* zoom_state)
{
	ZoomState _tmp0_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	g_return_if_fail (zoom_state != NULL);
	_vala_assert (single_photo_page_is_zoom_supported (self), "is_zoom_supported()");
	_tmp0_ = *zoom_state;
	self->priv->static_zoom_state = _tmp0_;
}

void
single_photo_page_get_zoom_state (SinglePhotoPage* self,
                                  ZoomState* result)
{
	ZoomState _tmp0_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_vala_assert (single_photo_page_is_zoom_supported (self), "is_zoom_supported()");
	_tmp0_ = self->priv->static_zoom_state;
	*result = _tmp0_;
	return;
}

static void
single_photo_page_real_switched_to (Page* base)
{
	SinglePhotoPage * self;
	GdkPixbuf* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage);
	PAGE_CLASS (single_photo_page_parent_class)->switched_to (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page));
	_tmp0_ = self->priv->unscaled;
	if (_tmp0_ != NULL) {
		single_photo_page_repaint (self, NULL);
	}
}

static void
single_photo_page_real_set_container (Page* base,
                                      GtkWindow* container)
{
	SinglePhotoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (container, gtk_window_get_type ()));
	PAGE_CLASS (single_photo_page_parent_class)->set_container (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page), container);
	if (IS_FULLSCREEN_WINDOW (container)) {
		gtk_scrolled_window_set_policy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	}
}

void
single_photo_page_set_pixbuf (SinglePhotoPage* self,
                              GdkPixbuf* unscaled,
                              Dimensions* max_dim,
                              Direction* direction)
{
	Dimensions _tmp0_;
	Dimensions _tmp1_;
	GdkPoint _tmp2_ = {0};
	GdkPixbuf* _tmp3_;
	Dimensions _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GtkDrawingArea* _tmp7_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (unscaled, gdk_pixbuf_get_type ()));
	g_return_if_fail (max_dim != NULL);
	_tmp0_ = *max_dim;
	_tmp1_ = self->priv->pixmap_dim;
	zoom_state_get_viewport_center (&self->priv->static_zoom_state, &_tmp2_);
	zoom_state_init (&self->priv->static_zoom_state, &_tmp0_, &_tmp1_, zoom_state_get_interpolation_factor (&self->priv->static_zoom_state), &_tmp2_);
	single_photo_page_cancel_transition (self);
	_tmp3_ = _g_object_ref0 (unscaled);
	_g_object_unref0 (self->priv->unscaled);
	self->priv->unscaled = _tmp3_;
	_tmp4_ = *max_dim;
	self->priv->max_dim = _tmp4_;
	_tmp5_ = self->priv->scaled;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->old_scaled);
	self->priv->old_scaled = _tmp6_;
	_g_object_unref0 (self->priv->scaled);
	self->priv->scaled = NULL;
	_tmp7_ = self->canvas;
	gtk_widget_realize (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	single_photo_page_repaint (self, direction);
}

void
single_photo_page_blank_display (SinglePhotoPage* self)
{
	GtkDrawingArea* _tmp0_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_g_object_unref0 (self->priv->unscaled);
	self->priv->unscaled = NULL;
	dimensions_init (&self->priv->max_dim, 0, 0);
	_g_object_unref0 (self->priv->scaled);
	self->priv->scaled = NULL;
	_cairo_surface_destroy0 (self->priv->pixmap);
	self->priv->pixmap = NULL;
	_tmp0_ = self->canvas;
	gtk_widget_realize (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	single_photo_page_invalidate_all (self);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

cairo_surface_t*
single_photo_page_get_surface (SinglePhotoPage* self)
{
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* result;
	g_return_val_if_fail (IS_SINGLE_PHOTO_PAGE (self), NULL);
	_tmp0_ = self->priv->pixmap;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
single_photo_page_get_surface_dim (SinglePhotoPage* self,
                                   Dimensions* result)
{
	Dimensions _tmp0_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_tmp0_ = self->priv->pixmap_dim;
	*result = _tmp0_;
	return;
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

cairo_t*
single_photo_page_get_cairo_context (SinglePhotoPage* self)
{
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* result;
	g_return_val_if_fail (IS_SINGLE_PHOTO_PAGE (self), NULL);
	_tmp0_ = self->priv->pixmap_ctx;
	_tmp1_ = _cairo_reference0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
single_photo_page_paint_text (SinglePhotoPage* self,
                              PangoLayout* pango_layout,
                              gint x,
                              gint y)
{
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pango_layout, pango_layout_get_type ()));
	_tmp0_ = self->priv->text_ctx;
	cairo_move_to (_tmp0_, (gdouble) x, (gdouble) y);
	_tmp1_ = self->priv->text_ctx;
	pango_cairo_show_layout (_tmp1_, pango_layout);
}

void
single_photo_page_get_canvas_scaling (SinglePhotoPage* self,
                                      Scaling* result)
{
	Scaling _tmp0_ = {0};
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_tmp1_ = page_get_container (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page));
	_tmp2_ = _tmp1_;
	_tmp3_ = IS_FULLSCREEN_WINDOW (_tmp2_);
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		AppWindow* _tmp4_;
		AppWindow* _tmp5_;
		Scaling _tmp6_ = {0};
		_tmp4_ = app_window_get_instance ();
		_tmp5_ = _tmp4_;
		scaling_for_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow), self->priv->scale_up_to_viewport, &_tmp6_);
		_tmp0_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	} else {
		GtkViewport* _tmp7_;
		Scaling _tmp8_ = {0};
		_tmp7_ = self->viewport;
		scaling_for_widget (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), self->priv->scale_up_to_viewport, &_tmp8_);
		_tmp0_ = _tmp8_;
	}
	*result = _tmp0_;
	return;
}

GdkPixbuf*
single_photo_page_get_unscaled_pixbuf (SinglePhotoPage* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_SINGLE_PHOTO_PAGE (self), NULL);
	_tmp0_ = self->priv->unscaled;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GdkPixbuf*
single_photo_page_get_scaled_pixbuf (SinglePhotoPage* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_SINGLE_PHOTO_PAGE (self), NULL);
	_tmp0_ = self->priv->scaled;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
single_photo_page_get_scaled_pixbuf_position (SinglePhotoPage* self,
                                              GdkRectangle* result)
{
	GdkRectangle _tmp0_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_tmp0_ = self->priv->scaled_pos;
	*result = _tmp0_;
	return;
}

gboolean
single_photo_page_is_inside_pixbuf (SinglePhotoPage* self,
                                    gint x,
                                    gint y)
{
	GdkRectangle _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_SINGLE_PHOTO_PAGE (self), FALSE);
	_tmp0_ = self->priv->scaled_pos;
	result = coord_in_rectangle ((gint) lround (x * application_get_scale ()), (gint) lround (y * application_get_scale ()), &_tmp0_);
	return result;
}

void
single_photo_page_invalidate (SinglePhotoPage* self,
                              GdkRectangle* rect)
{
	GtkDrawingArea* _tmp0_;
	GdkWindow* _tmp1_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	g_return_if_fail (rect != NULL);
	_tmp0_ = self->canvas;
	_tmp1_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	if (_tmp1_ != NULL) {
		GtkDrawingArea* _tmp2_;
		GdkWindow* _tmp3_;
		GdkRectangle _tmp4_;
		_tmp2_ = self->canvas;
		_tmp3_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
		_tmp4_ = *rect;
		gdk_window_invalidate_rect (_tmp3_, &_tmp4_, FALSE);
	}
}

void
single_photo_page_invalidate_all (SinglePhotoPage* self)
{
	GtkDrawingArea* _tmp0_;
	GdkWindow* _tmp1_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_tmp0_ = self->canvas;
	_tmp1_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	if (_tmp1_ != NULL) {
		GtkDrawingArea* _tmp2_;
		GdkWindow* _tmp3_;
		_tmp2_ = self->canvas;
		_tmp3_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
		gdk_window_invalidate_rect (_tmp3_, NULL, FALSE);
	}
}

static void
single_photo_page_on_viewport_resize (SinglePhotoPage* self)
{
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	single_photo_page_internal_repaint (self, TRUE, NULL);
}

static void
single_photo_page_real_on_resize_finished (Page* base,
                                           GdkRectangle* rect)
{
	SinglePhotoPage * self;
	GdkRectangle _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage);
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	PAGE_CLASS (single_photo_page_parent_class)->on_resize_finished (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page), &_tmp0_);
	single_photo_page_repaint (self, NULL);
}

static gboolean
single_photo_page_on_canvas_exposed (SinglePhotoPage* self,
                                     cairo_t* exposed_ctx)
{
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp3_;
	gboolean result;
	g_return_val_if_fail (IS_SINGLE_PHOTO_PAGE (self), FALSE);
	g_return_val_if_fail (exposed_ctx != NULL, FALSE);
	_tmp0_ = self->priv->pixmap;
	if (_tmp0_ != NULL) {
		cairo_surface_t* _tmp1_;
		cairo_surface_t* _tmp2_;
		_tmp1_ = self->priv->pixmap;
		cairo_surface_set_device_scale (_tmp1_, application_get_scale (), application_get_scale ());
		_tmp2_ = self->priv->pixmap;
		cairo_set_source_surface (exposed_ctx, _tmp2_, (gdouble) 0, (gdouble) 0);
	} else {
		set_source_color_from_string (exposed_ctx, "#000");
	}
	cairo_rectangle (exposed_ctx, (gdouble) 0, (gdouble) 0, (gdouble) gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget)), (gdouble) gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget)));
	cairo_paint (exposed_ctx);
	_tmp3_ = self->priv->pixmap;
	if (_tmp3_ != NULL) {
		cairo_surface_t* _tmp4_;
		_tmp4_ = self->priv->pixmap;
		cairo_surface_set_device_scale (_tmp4_, 1.0, 1.0);
	}
	result = TRUE;
	return result;
}

static void
single_photo_page_real_new_surface (SinglePhotoPage* self,
                                    cairo_t* ctx,
                                    Dimensions* ctx_dim)
{
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (ctx_dim != NULL);
}

void
single_photo_page_new_surface (SinglePhotoPage* self,
                               cairo_t* ctx,
                               Dimensions* ctx_dim)
{
	SinglePhotoPageClass* _klass_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_klass_ = SINGLE_PHOTO_PAGE_GET_CLASS (self);
	if (_klass_->new_surface) {
		_klass_->new_surface (self, ctx, ctx_dim);
	}
}

static void
single_photo_page_real_updated_pixbuf (SinglePhotoPage* self,
                                       GdkPixbuf* pixbuf,
                                       SinglePhotoPageUpdateReason reason,
                                       Dimensions* old_dim)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()));
	g_return_if_fail (old_dim != NULL);
}

void
single_photo_page_updated_pixbuf (SinglePhotoPage* self,
                                  GdkPixbuf* pixbuf,
                                  SinglePhotoPageUpdateReason reason,
                                  Dimensions* old_dim)
{
	SinglePhotoPageClass* _klass_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_klass_ = SINGLE_PHOTO_PAGE_GET_CLASS (self);
	if (_klass_->updated_pixbuf) {
		_klass_->updated_pixbuf (self, pixbuf, reason, old_dim);
	}
}

static void
single_photo_page_real_paint (SinglePhotoPage* self,
                              cairo_t* ctx,
                              Dimensions* ctx_dim)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (ctx_dim != NULL);
	if (single_photo_page_is_zoom_supported (self)) {
		_tmp0_ = !zoom_state_is_default (&self->priv->static_zoom_state);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Dimensions _tmp1_;
		Dimensions _tmp2_;
		ZoomState _tmp3_;
		set_source_color_from_string (ctx, "#000");
		_tmp1_ = self->priv->pixmap_dim;
		_tmp2_ = self->priv->pixmap_dim;
		cairo_rectangle (ctx, (gdouble) 0, (gdouble) 0, (gdouble) _tmp1_.width, (gdouble) _tmp2_.height);
		cairo_fill (ctx);
		_tmp3_ = self->priv->static_zoom_state;
		single_photo_page_render_zoomed_to_pixmap (self, &_tmp3_);
	} else {
		TransitionClock* _tmp4_;
		Dimensions _tmp5_;
		Dimensions _tmp6_;
		_tmp4_ = self->priv->transition_clock;
		_tmp5_ = *ctx_dim;
		_tmp6_ = *ctx_dim;
		if (!transition_clock_paint (_tmp4_, ctx, _tmp5_.width, _tmp6_.height)) {
			Dimensions _tmp7_;
			Dimensions _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkRectangle _tmp10_;
			GdkRectangle _tmp11_;
			set_source_color_from_string (ctx, "#000");
			_tmp7_ = self->priv->pixmap_dim;
			_tmp8_ = self->priv->pixmap_dim;
			cairo_rectangle (ctx, (gdouble) 0, (gdouble) 0, (gdouble) _tmp7_.width, (gdouble) _tmp8_.height);
			cairo_fill (ctx);
			_tmp9_ = self->priv->scaled;
			_tmp10_ = self->priv->scaled_pos;
			_tmp11_ = self->priv->scaled_pos;
			paint_pixmap_with_background (ctx, _tmp9_, _tmp10_.x, _tmp11_.y);
		}
	}
}

void
single_photo_page_paint (SinglePhotoPage* self,
                         cairo_t* ctx,
                         Dimensions* ctx_dim)
{
	SinglePhotoPageClass* _klass_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_klass_ = SINGLE_PHOTO_PAGE_GET_CLASS (self);
	if (_klass_->paint) {
		_klass_->paint (self, ctx, ctx_dim);
	}
}

static void
single_photo_page_repaint_pixmap (SinglePhotoPage* self)
{
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	Dimensions _tmp2_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_tmp0_ = self->priv->pixmap_ctx;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->pixmap_ctx;
	_tmp2_ = self->priv->pixmap_dim;
	single_photo_page_paint (self, _tmp1_, &_tmp2_);
	single_photo_page_invalidate_all (self);
}

void
single_photo_page_repaint (SinglePhotoPage* self,
                           Direction* direction)
{
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	single_photo_page_internal_repaint (self, FALSE, direction);
}

static void
_single_photo_page_repaint_pixmap_transition_clock_repaint_callback (gpointer self)
{
	single_photo_page_repaint_pixmap ((SinglePhotoPage*) self);
}

static void
single_photo_page_internal_repaint (SinglePhotoPage* self,
                                    gboolean fast,
                                    Direction* direction)
{
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	GtkAllocation allocation = {0};
	GtkViewport* _tmp4_;
	GtkAllocation _tmp5_ = {0};
	gint width = 0;
	GtkAllocation _tmp6_;
	gint height = 0;
	GtkAllocation _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean new_pixbuf = FALSE;
	GdkPixbuf* _tmp9_;
	Dimensions old_scaled_dim = {0};
	GdkRectangle _tmp10_;
	Dimensions _tmp11_ = {0};
	GdkRectangle old_scaled_pos = {0};
	GdkRectangle _tmp12_;
	gboolean _tmp13_ = FALSE;
	Dimensions _tmp14_;
	gboolean new_pixmap = FALSE;
	cairo_surface_t* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GdkInterpType _tmp32_ = 0;
	GdkInterpType interp = 0;
	GdkPixbuf* _tmp33_;
	gboolean _tmp44_ = FALSE;
	TransitionClock* _tmp54_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	if (!page_is_in_view (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page))) {
		_cairo_surface_destroy0 (self->priv->pixmap);
		self->priv->pixmap = NULL;
		_g_object_unref0 (self->priv->scaled);
		self->priv->scaled = NULL;
		return;
	}
	_tmp1_ = self->priv->unscaled;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkDrawingArea* _tmp2_;
		GdkWindow* _tmp3_;
		_tmp2_ = self->canvas;
		_tmp3_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
		_tmp0_ = _tmp3_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->viewport;
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), &_tmp5_);
	allocation = _tmp5_;
	_tmp6_ = allocation;
	width = _tmp6_.width;
	_tmp7_ = allocation;
	height = _tmp7_.height;
	if (width <= 0) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = height <= 0;
	}
	if (_tmp8_) {
		return;
	}
	_tmp9_ = self->priv->scaled;
	new_pixbuf = _tmp9_ == NULL;
	_tmp10_ = self->priv->scaled_pos;
	dimensions_for_rectangle (&_tmp10_, &_tmp11_);
	old_scaled_dim = _tmp11_;
	_tmp12_ = self->priv->scaled_pos;
	old_scaled_pos = _tmp12_;
	_tmp14_ = self->priv->pixmap_dim;
	if (_tmp14_.width != width) {
		_tmp13_ = TRUE;
	} else {
		Dimensions _tmp15_;
		_tmp15_ = self->priv->pixmap_dim;
		_tmp13_ = _tmp15_.height != height;
	}
	if (_tmp13_) {
		_cairo_surface_destroy0 (self->priv->pixmap);
		self->priv->pixmap = NULL;
	}
	new_pixmap = FALSE;
	_tmp16_ = self->priv->pixmap;
	if (_tmp16_ == NULL) {
		single_photo_page_init_pixmap (self, (gint) lround (width * application_get_scale ()), (gint) lround (height * application_get_scale ()));
		new_pixmap = TRUE;
	}
	if (new_pixbuf) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = new_pixmap;
	}
	if (_tmp17_) {
		Dimensions unscaled_dim = {0};
		GdkPixbuf* _tmp18_;
		Dimensions _tmp19_ = {0};
		Dimensions scaled_dim = {0};
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		Dimensions _tmp28_;
		Dimensions _tmp29_;
		Dimensions _tmp30_;
		Dimensions _tmp31_;
		_tmp18_ = self->priv->unscaled;
		dimensions_for_pixbuf (_tmp18_, &_tmp19_);
		unscaled_dim = _tmp19_;
		dimensions_init (&scaled_dim, 0, 0);
		if (!self->priv->scale_up_to_viewport) {
			_tmp22_ = dimensions_has_area (&self->priv->max_dim);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			Dimensions _tmp23_;
			_tmp23_ = self->priv->max_dim;
			_tmp21_ = _tmp23_.width < width;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			Dimensions _tmp24_;
			_tmp24_ = self->priv->max_dim;
			_tmp20_ = _tmp24_.height < height;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			Dimensions _tmp25_;
			_tmp25_ = self->priv->max_dim;
			scaled_dim = _tmp25_;
		} else {
			Dimensions _tmp26_;
			Dimensions _tmp27_ = {0};
			_tmp26_ = self->priv->pixmap_dim;
			dimensions_get_scaled_proportional (&unscaled_dim, &_tmp26_, &_tmp27_);
			scaled_dim = _tmp27_;
		}
		_tmp28_ = scaled_dim;
		self->priv->scaled_pos.x = (gint) lround (((width * application_get_scale ()) - _tmp28_.width) / 2.0);
		_tmp29_ = scaled_dim;
		self->priv->scaled_pos.y = (gint) lround (((height * application_get_scale ()) - _tmp29_.height) / 2.0);
		_tmp30_ = scaled_dim;
		self->priv->scaled_pos.width = _tmp30_.width;
		_tmp31_ = scaled_dim;
		self->priv->scaled_pos.height = _tmp31_.height;
	}
	if (fast) {
		_tmp32_ = SINGLE_PHOTO_PAGE_FAST_INTERP;
	} else {
		_tmp32_ = SINGLE_PHOTO_PAGE_QUALITY_INTERP;
	}
	interp = _tmp32_;
	_tmp33_ = self->priv->scaled;
	if (_tmp33_ == NULL) {
		GdkPixbuf* _tmp34_;
		GdkRectangle _tmp35_;
		Dimensions _tmp36_ = {0};
		GdkPixbuf* _tmp37_;
		SinglePhotoPageUpdateReason reason = 0;
		Dimensions _tmp39_;
		Dimensions _tmp40_;
		GdkPoint _tmp41_ = {0};
		GdkPixbuf* _tmp42_;
		Dimensions _tmp43_;
		_tmp34_ = self->priv->unscaled;
		_tmp35_ = self->priv->scaled_pos;
		dimensions_for_rectangle (&_tmp35_, &_tmp36_);
		_tmp37_ = resize_pixbuf (_tmp34_, &_tmp36_, interp);
		_g_object_unref0 (self->priv->scaled);
		self->priv->scaled = _tmp37_;
		reason = SINGLE_PHOTO_PAGE_UPDATE_REASON_RESIZED_CANVAS;
		if (new_pixbuf) {
			reason = SINGLE_PHOTO_PAGE_UPDATE_REASON_NEW_PIXBUF;
		} else {
			gboolean _tmp38_ = FALSE;
			if (!new_pixmap) {
				_tmp38_ = interp == SINGLE_PHOTO_PAGE_QUALITY_INTERP;
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				reason = SINGLE_PHOTO_PAGE_UPDATE_REASON_QUALITY_IMPROVEMENT;
			}
		}
		_tmp39_ = self->priv->max_dim;
		_tmp40_ = self->priv->pixmap_dim;
		zoom_state_get_viewport_center (&self->priv->static_zoom_state, &_tmp41_);
		zoom_state_init (&self->priv->static_zoom_state, &_tmp39_, &_tmp40_, zoom_state_get_interpolation_factor (&self->priv->static_zoom_state), &_tmp41_);
		_tmp42_ = self->priv->scaled;
		_tmp43_ = old_scaled_dim;
		single_photo_page_updated_pixbuf (self, _tmp42_, reason, &_tmp43_);
	}
	self->priv->zoom_high_quality = !fast;
	if (direction != NULL) {
		TransitionClock* _tmp45_;
		_tmp45_ = self->priv->transition_clock;
		_tmp44_ = !transition_clock_is_in_progress (_tmp45_);
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		SpitTransitionsVisuals* visuals = NULL;
		GdkPixbuf* _tmp46_;
		GdkRectangle _tmp47_;
		GdkPixbuf* _tmp48_;
		GdkRectangle _tmp49_;
		GdkRGBA _tmp50_ = {0};
		SpitTransitionsVisuals* _tmp51_;
		TransitionClock* _tmp52_;
		SpitTransitionsVisuals* _tmp53_;
		_tmp46_ = self->priv->old_scaled;
		_tmp47_ = old_scaled_pos;
		_tmp48_ = self->priv->scaled;
		_tmp49_ = self->priv->scaled_pos;
		parse_color ("#000", &_tmp50_);
		_tmp51_ = spit_transitions_visuals_new (_tmp46_, &_tmp47_, _tmp48_, &_tmp49_, &_tmp50_);
		visuals = _tmp51_;
		_tmp52_ = self->priv->transition_clock;
		_tmp53_ = visuals;
		transition_clock_start (_tmp52_, _tmp53_, direction_to_transition_direction (*direction), self->priv->transition_duration_msec, _single_photo_page_repaint_pixmap_transition_clock_repaint_callback, self);
		_g_object_unref0 (visuals);
	}
	_tmp54_ = self->priv->transition_clock;
	if (!transition_clock_is_in_progress (_tmp54_)) {
		single_photo_page_repaint_pixmap (self);
	}
}

static void
single_photo_page_init_pixmap (SinglePhotoPage* self,
                               gint width,
                               gint height)
{
	GdkPixbuf* _tmp0_;
	GtkDrawingArea* _tmp1_;
	GdkWindow* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_surface_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	Dimensions _tmp10_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_tmp0_ = self->priv->unscaled;
	_vala_assert (_tmp0_ != NULL, "unscaled != null");
	_tmp1_ = self->canvas;
	_tmp2_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_vala_assert (_tmp2_ != NULL, "canvas.get_window() != null");
	_tmp3_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
	_cairo_surface_destroy0 (self->priv->pixmap);
	self->priv->pixmap = _tmp3_;
	dimensions_init (&self->priv->pixmap_dim, width, height);
	_tmp4_ = self->priv->pixmap;
	_tmp5_ = cairo_create (_tmp4_);
	_cairo_destroy0 (self->priv->pixmap_ctx);
	self->priv->pixmap_ctx = _tmp5_;
	_g_object_unref0 (self->priv->scaled);
	self->priv->scaled = NULL;
	_tmp6_ = self->priv->pixmap;
	_tmp7_ = cairo_create (_tmp6_);
	_cairo_destroy0 (self->priv->text_ctx);
	self->priv->text_ctx = _tmp7_;
	_tmp8_ = self->priv->text_ctx;
	set_source_color_from_string (_tmp8_, "#fff");
	_tmp9_ = self->priv->pixmap_ctx;
	_tmp10_ = self->priv->pixmap_dim;
	single_photo_page_new_surface (self, _tmp9_, &_tmp10_);
}

static gboolean
single_photo_page_real_on_context_keypress (Page* base)
{
	SinglePhotoPage * self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage);
	_tmp0_ = page_get_page_context_menu (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page));
	_tmp1_ = _tmp0_;
	_tmp2_ = page_popup_context_menu (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page), _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
single_photo_page_real_on_previous_photo (SinglePhotoPage* self)
{
}

void
single_photo_page_on_previous_photo (SinglePhotoPage* self)
{
	SinglePhotoPageClass* _klass_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_klass_ = SINGLE_PHOTO_PAGE_GET_CLASS (self);
	if (_klass_->on_previous_photo) {
		_klass_->on_previous_photo (self);
	}
}

static void
single_photo_page_real_on_next_photo (SinglePhotoPage* self)
{
}

void
single_photo_page_on_next_photo (SinglePhotoPage* self)
{
	SinglePhotoPageClass* _klass_;
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	_klass_ = SINGLE_PHOTO_PAGE_GET_CLASS (self);
	if (_klass_->on_next_photo) {
		_klass_->on_next_photo (self);
	}
}

static gboolean
single_photo_page_real_key_press_event (GtkWidget* base,
                                        GdkEventKey* event)
{
	SinglePhotoPage * self;
	gboolean nav_ok = FALSE;
	gboolean handled = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage);
	g_return_val_if_fail (event != NULL, FALSE);
	nav_ok = (event->time - self->priv->last_nav_key) > ((guint32) SINGLE_PHOTO_PAGE_KEY_REPEAT_INTERVAL_MSEC);
	handled = TRUE;
	_tmp0_ = gdk_keyval_name (event->keyval);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Left")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("KP_Left"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("BackSpace"))))) {
		switch (0) {
			default:
			{
				if (nav_ok) {
					single_photo_page_on_previous_photo (self);
					self->priv->last_nav_key = event->time;
				}
				break;
			}
		}
	} else if (((_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("Right")))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("KP_Right"))))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("space"))))) {
		switch (0) {
			default:
			{
				if (nav_ok) {
					single_photo_page_on_next_photo (self);
					self->priv->last_nav_key = event->time;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				handled = FALSE;
				break;
			}
		}
	}
	if (handled) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (single_photo_page_parent_class)->key_press_event != NULL) {
		_tmp4_ = GTK_WIDGET_CLASS (single_photo_page_parent_class)->key_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page), gtk_widget_get_type (), GtkWidget), event);
	} else {
		_tmp4_ = TRUE;
	}
	result = _tmp4_;
	return result;
}

static void
single_photo_page_on_colors_changed (SinglePhotoPage* self)
{
	g_return_if_fail (IS_SINGLE_PHOTO_PAGE (self));
	invalidate_transparent_background ();
	single_photo_page_repaint (self, NULL);
}

static void
single_photo_page_class_init (SinglePhotoPageClass * klass,
                              gpointer klass_data)
{
	single_photo_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SinglePhotoPage_private_offset);
	((SinglePhotoPageClass *) klass)->is_zoom_supported = (gboolean (*) (SinglePhotoPage*)) single_photo_page_real_is_zoom_supported;
	((SinglePhotoPageClass *) klass)->cancel_zoom = (void (*) (SinglePhotoPage*)) single_photo_page_real_cancel_zoom;
	((SinglePhotoPageClass *) klass)->save_zoom_state = (void (*) (SinglePhotoPage*)) single_photo_page_real_save_zoom_state;
	((SinglePhotoPageClass *) klass)->restore_zoom_state = (void (*) (SinglePhotoPage*)) single_photo_page_real_restore_zoom_state;
	((SinglePhotoPageClass *) klass)->get_zoom_buffer = (ZoomBuffer* (*) (SinglePhotoPage*)) single_photo_page_real_get_zoom_buffer;
	((PageClass *) klass)->switched_to = (void (*) (Page*)) single_photo_page_real_switched_to;
	((PageClass *) klass)->set_container = (void (*) (Page*, GtkWindow*)) single_photo_page_real_set_container;
	((PageClass *) klass)->on_resize_finished = (void (*) (Page*, GdkRectangle*)) single_photo_page_real_on_resize_finished;
	((SinglePhotoPageClass *) klass)->new_surface = (void (*) (SinglePhotoPage*, cairo_t*, Dimensions*)) single_photo_page_real_new_surface;
	((SinglePhotoPageClass *) klass)->updated_pixbuf = (void (*) (SinglePhotoPage*, GdkPixbuf*, SinglePhotoPageUpdateReason, Dimensions*)) single_photo_page_real_updated_pixbuf;
	((SinglePhotoPageClass *) klass)->paint = (void (*) (SinglePhotoPage*, cairo_t*, Dimensions*)) single_photo_page_real_paint;
	((PageClass *) klass)->on_context_keypress = (gboolean (*) (Page*)) single_photo_page_real_on_context_keypress;
	((SinglePhotoPageClass *) klass)->on_previous_photo = (void (*) (SinglePhotoPage*)) single_photo_page_real_on_previous_photo;
	((SinglePhotoPageClass *) klass)->on_next_photo = (void (*) (SinglePhotoPage*)) single_photo_page_real_on_next_photo;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) single_photo_page_real_key_press_event;
	G_OBJECT_CLASS (klass)->finalize = single_photo_page_finalize;
}

static void
single_photo_page_instance_init (SinglePhotoPage * self,
                                 gpointer klass)
{
	GtkDrawingArea* _tmp0_;
	GtkViewport* _tmp1_;
	self->priv = single_photo_page_get_instance_private (self);
	_tmp0_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp0_);
	self->canvas = _tmp0_;
	_tmp1_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
	g_object_ref_sink (_tmp1_);
	self->viewport = _tmp1_;
	self->priv->transition_duration_msec = 0;
	self->priv->pixmap = NULL;
	self->priv->pixmap_ctx = NULL;
	self->priv->text_ctx = NULL;
	dimensions_init (&self->priv->pixmap_dim, 0, 0);
	self->priv->unscaled = NULL;
	dimensions_init (&self->priv->max_dim, 0, 0);
	self->priv->scaled = NULL;
	self->priv->old_scaled = NULL;
	memset (&self->priv->scaled_pos, 0, sizeof (GdkRectangle));
	self->priv->zoom_high_quality = TRUE;
	self->priv->has_saved_zoom_state = FALSE;
	self->priv->last_nav_key = (guint32) 0;
}

static void
single_photo_page_finalize (GObject * obj)
{
	SinglePhotoPage * self;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	guint _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage);
	_tmp0_ = config_facade_get_instance ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("colors-changed", CONFIG_TYPE_FACADE, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _single_photo_page_on_colors_changed_config_facade_colors_changed, self);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (self->canvas);
	_g_object_unref0 (self->viewport);
	_transition_clock_unref0 (self->priv->transition_clock);
	_cairo_surface_destroy0 (self->priv->pixmap);
	_cairo_destroy0 (self->priv->pixmap_ctx);
	_cairo_destroy0 (self->priv->text_ctx);
	_g_object_unref0 (self->priv->unscaled);
	_g_object_unref0 (self->priv->scaled);
	_g_object_unref0 (self->priv->old_scaled);
	G_OBJECT_CLASS (single_photo_page_parent_class)->finalize (obj);
}

static GType
single_photo_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SinglePhotoPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) single_photo_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SinglePhotoPage), 0, (GInstanceInitFunc) single_photo_page_instance_init, NULL };
	GType single_photo_page_type_id;
	single_photo_page_type_id = g_type_register_static (TYPE_PAGE, "SinglePhotoPage", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SinglePhotoPage_private_offset = g_type_add_instance_private (single_photo_page_type_id, sizeof (SinglePhotoPagePrivate));
	return single_photo_page_type_id;
}

GType
single_photo_page_get_type (void)
{
	static volatile gsize single_photo_page_type_id__once = 0;
	if (g_once_init_enter (&single_photo_page_type_id__once)) {
		GType single_photo_page_type_id;
		single_photo_page_type_id = single_photo_page_get_type_once ();
		g_once_init_leave (&single_photo_page_type_id__once, single_photo_page_type_id);
	}
	return single_photo_page_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

