// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by hack/docgen tool. DO NOT EDIT.

package cri

import (
	"github.com/siderolabs/talos/pkg/machinery/config/encoder"
)

func (RegistryAuthConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "RegistryAuthConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "RegistryAuthConfig configures authentication for a registry endpoint." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "RegistryAuthConfig configures authentication for a registry endpoint.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Registry endpoint to apply the authentication configuration to.\n\nRegistry endpoint is the hostname part of the endpoint URL,\ne.g. 'my-mirror.local:5000' for 'https://my-mirror.local:5000/v2/'.\n\nThe authentication configuration will apply to all image pulls for this\nregistry endpoint, by Talos or any Kubernetes workloads.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Registry endpoint to apply the authentication configuration to." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "username",
				Type:        "string",
				Note:        "",
				Description: "Username/password authentication.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Username/password authentication." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "password",
				Type:        "string",
				Note:        "",
				Description: "Username/password authentication.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Username/password authentication." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "auth",
				Type:        "string",
				Note:        "",
				Description: "Raw authentication string.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Raw authentication string." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "identityToken",
				Type:        "string",
				Note:        "",
				Description: "Identity token authentication.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Identity token authentication." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleRegistryAuthConfigVAlpha1())

	return doc
}

func (RegistryMirrorConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "RegistryMirrorConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "RegistryMirrorConfig configures an image registry mirror." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "RegistryMirrorConfig configures an image registry mirror.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Registry name to apply the mirror configuration to.\n\nRegistry name is the first segment of image identifier, with 'docker.io'\nbeing default one.\n\nA special name '*' can be used to define mirror configuration\nthat applies to all registries.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Registry name to apply the mirror configuration to." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "endpoints",
				Type:        "[]RegistryEndpoint",
				Note:        "",
				Description: "List of mirror endpoints for the registry.\nMirrors will be used in the order they are specified,\nfalling back to the default registry is `skipFallback` is not set to true.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "List of mirror endpoints for the registry." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "skipFallback",
				Type:        "bool",
				Note:        "",
				Description: "Skip fallback to the original registry if none of the mirrors are available\nor contain the requested image.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Skip fallback to the original registry if none of the mirrors are available" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleRegistryMirrorConfigVAlpha1())

	return doc
}

func (RegistryEndpoint) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "RegistryEndpoint",
		Comments:    [3]string{"" /* encoder.HeadComment */, "RegistryEndpoint defines a registry mirror endpoint." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "RegistryEndpoint defines a registry mirror endpoint.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "RegistryMirrorConfigV1Alpha1",
				FieldName: "endpoints",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "url",
				Type:        "URL",
				Note:        "",
				Description: "The URL of the registry mirror endpoint.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The URL of the registry mirror endpoint." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "overridePath",
				Type:        "bool",
				Note:        "",
				Description: "Use endpoint path as supplied, without adding `/v2/` suffix.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Use endpoint path as supplied, without adding `/v2/` suffix." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", "https://my-registry-mirror.local:5000")

	return doc
}

func (RegistryTLSConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "RegistryTLSConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "RegistryTLSConfig configures TLS for a registry endpoint." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "RegistryTLSConfig configures TLS for a registry endpoint.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Registry endpoint to apply the TLS configuration to.\n\nRegistry endpoint is the hostname part of the endpoint URL,\ne.g. 'my-mirror.local:5000' for 'https://my-mirror.local:5000/v2/'.\n\nThe TLS configuration makes sense only for HTTPS endpoints.\nThe TLS configuration will apply to all image pulls for this\nregistry endpoint, by Talos or any Kubernetes workloads.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Registry endpoint to apply the TLS configuration to." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "clientIdentity",
				Type:        "CertificateAndKey",
				Note:        "",
				Description: "Enable mutual TLS authentication with the registry.\nClient certificate and key should be PEM-encoded.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable mutual TLS authentication with the registry." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "ca",
				Type:        "string",
				Note:        "",
				Description: "CA registry certificate to add the list of trusted certificates.\nCertificate should be PEM-encoded.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "CA registry certificate to add the list of trusted certificates." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "insecureSkipVerify",
				Type:        "bool",
				Note:        "",
				Description: "Skip TLS server certificate verification (not recommended).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Skip TLS server certificate verification (not recommended)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleRegistryTLSConfigVAlpha1())

	doc.Fields[2].AddExample("", exampleCertificateAndKey())

	return doc
}

// GetFileDoc returns documentation for the file cri_doc.go.
func GetFileDoc() *encoder.FileDoc {
	return &encoder.FileDoc{
		Name:        "cri",
		Description: "",
		Structs: []*encoder.Doc{
			RegistryAuthConfigV1Alpha1{}.Doc(),
			RegistryMirrorConfigV1Alpha1{}.Doc(),
			RegistryEndpoint{}.Doc(),
			RegistryTLSConfigV1Alpha1{}.Doc(),
		},
	}
}
