const char log_lua[] =
"-- log.lua\n"
"--\n"
"local ffi = require('ffi')\n"
"ffi.cdef[[\n"
"    typedef void (*sayfunc_t)(int level, const char *filename, int line,\n"
"               const char *error, const char *format, ...);\n"
"\n"
"    void\n"
"    say_set_log_level(int new_level);\n"
"\n"
"    void\n"
"    say_set_log_format(enum say_format format);\n"
"\n"
"    int\n"
"    say_check_cfg(const char *log,\n"
"                  int level,\n"
"                  int nonblock,\n"
"                  const char *format);\n"
"\n"
"    extern void\n"
"    say_logger_init(const char *init_str, int level, int nonblock,\n"
"                    const char *format);\n"
"\n"
"    extern bool\n"
"    say_logger_initialized(void);\n"
"\n"
"    extern void\n"
"    say_from_lua(int level, const char *module, const char *filename, int line,\n"
"                 const char *format, ...);\n"
"\n"
"    extern sayfunc_t _say;\n"
"    extern struct ev_loop;\n"
"    extern struct ev_signal;\n"
"\n"
"    extern void\n"
"    say_logrotate(struct ev_loop *, struct ev_signal *, int);\n"
"\n"
"    enum say_level {\n"
"        S_FATAL,\n"
"        S_SYSERROR,\n"
"        S_ERROR,\n"
"        S_CRIT,\n"
"        S_WARN,\n"
"        S_INFO,\n"
"        S_VERBOSE,\n"
"        S_DEBUG\n"
"    };\n"
"\n"
"    enum say_format {\n"
"        SF_PLAIN,\n"
"        SF_JSON\n"
"    };\n"
"    pid_t log_pid;\n"
"    extern int log_level;\n"
"    extern int log_format;\n"
"\n"
"    extern int log_level_flightrec;\n"
"    extern void\n"
"    log_write_flightrec_from_lua(int level, const char *filename, int line,\n"
"                                 ...);\n"
"]]\n"
"\n"
"local S_CRIT = ffi.C.S_CRIT\n"
"local S_WARN = ffi.C.S_WARN\n"
"local S_INFO = ffi.C.S_INFO\n"
"local S_VERBOSE = ffi.C.S_VERBOSE\n"
"local S_DEBUG = ffi.C.S_DEBUG\n"
"local S_ERROR = ffi.C.S_ERROR\n"
"\n"
"local json = require(\"json\").new()\n"
"json.cfg{\n"
"    encode_invalid_numbers = true,\n"
"    encode_load_metatables = true,\n"
"    encode_use_tostring    = true,\n"
"    encode_invalid_as_nil  = true,\n"
"}\n"
"\n"
"local special_fields = {\n"
"    \"file\",\n"
"    \"level\",\n"
"    \"pid\",\n"
"    \"line\",\n"
"    \"cord_name\",\n"
"    \"fiber_name\",\n"
"    \"fiber_id\",\n"
"    \"error_msg\"\n"
"}\n"
"\n"
"-- Map format number to string.\n"
"local fmt_num2str = {\n"
"    [ffi.C.SF_PLAIN]    = \"plain\",\n"
"    [ffi.C.SF_JSON]     = \"json\",\n"
"}\n"
"\n"
"-- Map format string to number.\n"
"local fmt_str2num = {\n"
"    [\"plain\"]           = ffi.C.SF_PLAIN,\n"
"    [\"json\"]            = ffi.C.SF_JSON,\n"
"}\n"
"\n"
"-- Logging levels symbolic representation.\n"
"local log_level_keys = {\n"
"    ['fatal']       = ffi.C.S_FATAL,\n"
"    ['syserror']    = ffi.C.S_SYSERROR,\n"
"    ['error']       = ffi.C.S_ERROR,\n"
"    ['crit']        = ffi.C.S_CRIT,\n"
"    ['warn']        = ffi.C.S_WARN,\n"
"    ['info']        = ffi.C.S_INFO,\n"
"    ['verbose']     = ffi.C.S_VERBOSE,\n"
"    ['debug']       = ffi.C.S_DEBUG,\n"
"}\n"
"\n"
"local function log_level_list()\n"
"    local keyset = {}\n"
"    for k in pairs(log_level_keys) do\n"
"        keyset[#keyset + 1] = k\n"
"    end\n"
"    return table.concat(keyset, ',')\n"
"end\n"
"\n"
"-- Default options. The keys are part of\n"
"-- user API, so change with caution.\n"
"local default_cfg = {\n"
"    log             = nil,\n"
"    nonblock        = nil,\n"
"    level           = S_INFO,\n"
"    modules         = nil,\n"
"    format          = fmt_num2str[ffi.C.SF_PLAIN],\n"
"}\n"
"\n"
"local log_cfg = table.copy(default_cfg)\n"
"\n"
"-- Name mapping from box to log module and\n"
"-- back. Make sure all required fields\n"
"-- are covered!\n"
"local log2box_keys = {\n"
"    ['log']             = 'log',\n"
"    ['nonblock']        = 'log_nonblock',\n"
"    ['level']           = 'log_level',\n"
"    ['modules']         = 'log_modules',\n"
"    ['format']          = 'log_format',\n"
"}\n"
"\n"
"-- Return level as a number, level must be valid.\n"
"local function log_normalize_level(level)\n"
"    if type(level) == 'string' then\n"
"        return log_level_keys[level]\n"
"    end\n"
"    return level\n"
"end\n"
"\n"
"local box2log_keys = {}\n"
"\n"
"for kl, kb in pairs(log2box_keys) do\n"
"    box2log_keys[kb] = kl\n"
"end\n"
"\n"
"-- Main routine which pass data to C logging code.\n"
"local function say(self, level, fmt, ...)\n"
"    local name = self and self.name\n"
"    local module_level = name and log_cfg.modules and log_cfg.modules[name] or\n"
"                         log_cfg.level\n"
"    if level > log_normalize_level(module_level) and\n"
"       level > ffi.C.log_level_flightrec then\n"
"        return\n"
"    end\n"
"    local type_fmt = type(fmt)\n"
"    local format = \"%s\"\n"
"    local msg\n"
"    if select('#', ...) ~= 0 then\n"
"        local stat\n"
"        stat, msg = pcall(string.format, fmt, ...)\n"
"        if not stat then\n"
"            error(msg, 3)\n"
"        end\n"
"    elseif type_fmt == 'table' then\n"
"        msg = table.copy(fmt)\n"
"        if ffi.C.log_format == ffi.C.SF_JSON then\n"
"            -- use serialization function from the metatable, if any\n"
"            local msg_mt = getmetatable(msg)\n"
"            if msg_mt and type(msg_mt.__serialize) == 'function' then\n"
"                msg = msg_mt.__serialize(msg)\n"
"                if type(msg) ~= 'table' then\n"
"                    msg = { message = tostring(msg) }\n"
"                end\n"
"            end\n"
"            -- ignore internal keys\n"
"            for _, field in ipairs(special_fields) do\n"
"                msg[field] = nil\n"
"            end\n"
"            -- return empty string for an empty table\n"
"            if next(msg) == nil then\n"
"                msg.message = ''\n"
"            end\n"
"            -- set 'message' field if it is absent\n"
"            if msg.message == nil then\n"
"                msg.message = msg[1]\n"
"                msg[1] = nil\n"
"            end\n"
"            -- always encode tables as maps\n"
"            setmetatable(msg, json.map_mt)\n"
"            -- indicate that message is already encoded in JSON\n"
"            format = fmt_num2str[ffi.C.SF_JSON]\n"
"        end\n"
"        msg = json.encode(msg)\n"
"    else\n"
"        msg = tostring(fmt)\n"
"    end\n"
"\n"
"    local debug = require('debug')\n"
"    local frame = debug.getinfo(3, \"Sl\")\n"
"    local line, file = 0, 'eval'\n"
"    if type(frame) == 'table' then\n"
"        line = frame.currentline or 0\n"
"        file = frame.short_src or frame.src or 'eval'\n"
"    end\n"
"\n"
"    if level <= ffi.C.log_level_flightrec then\n"
"        ffi.C.log_write_flightrec_from_lua(level, file, line, msg)\n"
"    end\n"
"    if level <= log_normalize_level(module_level) then\n"
"        ffi.C.say_from_lua(level, name, file, line, format, msg)\n"
"    end\n"
"end\n"
"\n"
"-- Just a syntactic sugar over say routine.\n"
"local function say_closure(self, lvl)\n"
"    return function (fmt, ...)\n"
"        say(self, lvl, fmt, ...)\n"
"    end\n"
"end\n"
"\n"
"local log_error = say_closure(nil, S_ERROR)\n"
"local log_warn = say_closure(nil, S_WARN)\n"
"local log_info = say_closure(nil, S_INFO)\n"
"local log_verbose = say_closure(nil, S_VERBOSE)\n"
"local log_debug = say_closure(nil, S_DEBUG)\n"
"\n"
"-- Rotate log (basically reopen the log file and\n"
"-- start writting into it).\n"
"local function log_rotate()\n"
"    ffi.C.say_logrotate(nil, nil, 0)\n"
"end\n"
"\n"
"-- Returns pid of a pipe process.\n"
"local function log_pid()\n"
"    return tonumber(ffi.C.log_pid)\n"
"end\n"
"\n"
"local ratelimit_enabled = true\n"
"\n"
"local function ratelimit_enable()\n"
"    ratelimit_enabled = true\n"
"end\n"
"\n"
"local function ratelimit_disable()\n"
"    ratelimit_enabled = false\n"
"end\n"
"\n"
"local Ratelimit = {\n"
"    interval = 60,\n"
"    burst = 10,\n"
"    emitted = 0,\n"
"    suppressed = 0,\n"
"    start = 0,\n"
"}\n"
"\n"
"local function ratelimit_new(object)\n"
"    return Ratelimit:new(object)\n"
"end\n"
"\n"
"function Ratelimit:new(object)\n"
"    object = object or {}\n"
"    setmetatable(object, self)\n"
"    self.__index = self\n"
"    return object\n"
"end\n"
"\n"
"function Ratelimit:check()\n"
"    if not ratelimit_enabled then\n"
"        return 0, true\n"
"    end\n"
"\n"
"    local clock = require('clock')\n"
"    local now = clock.monotonic()\n"
"    local saved_suppressed = 0\n"
"    if now > self.start + self.interval then\n"
"        saved_suppressed = self.suppressed\n"
"        self.suppressed = 0\n"
"        self.emitted = 0\n"
"        self.start = now\n"
"    end\n"
"\n"
"    if self.emitted < self.burst then\n"
"        self.emitted = self.emitted + 1\n"
"        return saved_suppressed, true\n"
"    end\n"
"    self.suppressed = self.suppressed + 1\n"
"    return saved_suppressed, false\n"
"end\n"
"\n"
"function Ratelimit:log_check(lvl)\n"
"    local suppressed, ok = self:check()\n"
"    if lvl >= S_WARN and suppressed > 0 then\n"
"        log_warn('%d messages suppressed due to rate limiting', suppressed)\n"
"    end\n"
"    return ok\n"
"end\n"
"\n"
"function Ratelimit:log(lvl, fmt, ...)\n"
"    if self:log_check(lvl) then\n"
"        say(nil, lvl, fmt, ...)\n"
"    end\n"
"end\n"
"\n"
"local function log_ratelimited_closure(lvl)\n"
"    return function(self, fmt, ...)\n"
"        self:log(lvl, fmt, ...)\n"
"    end\n"
"end\n"
"\n"
"Ratelimit.log_crit = log_ratelimited_closure(S_CRIT)\n"
"\n"
"local option_types = {\n"
"    log = 'string',\n"
"    nonblock = 'boolean',\n"
"    level = 'number, string',\n"
"    modules = 'table',\n"
"    format = 'string',\n"
"}\n"
"\n"
"local log_initialized = false\n"
"\n"
"-- Convert cfg options to types suitable for ffi say_ functions.\n"
"local function log_C_cfg(cfg)\n"
"    local cfg_C = table.copy(cfg)\n"
"    local level = cfg.modules and cfg.modules.tarantool or cfg.level\n"
"    cfg_C.level = log_normalize_level(level)\n"
"    local nonblock\n"
"    if cfg.nonblock ~= nil then\n"
"        nonblock = cfg.nonblock and 1 or 0\n"
"    else\n"
"        nonblock = -1\n"
"    end\n"
"    cfg_C.nonblock = nonblock\n"
"    return cfg_C\n"
"end\n"
"\n"
"local function box_to_log_cfg(box_cfg)\n"
"    local log_cfg = {}\n"
"    for kl, kb in pairs(log2box_keys) do\n"
"        log_cfg[kl] = box_cfg[kb]\n"
"    end\n"
"    return log_cfg\n"
"end\n"
"\n"
"-- Check that level is a number or a valid string.\n"
"local function log_check_level(level, option_name)\n"
"    if type(level) == 'string' and log_level_keys[level] == nil then\n"
"        local err = (\"expected %s\"):format(log_level_list())\n"
"        box.error(box.error.CFG, option_name, err)\n"
"    end\n"
"end\n"
"\n"
"-- Check that the 'modules' table contains valid log levels.\n"
"local function log_check_modules(modules)\n"
"    if modules == nil then\n"
"        return\n"
"    end\n"
"    for name, level in pairs(modules) do\n"
"        if type(name) ~= 'string' then\n"
"            box.error(box.error.CFG, 'module name', 'should be of type string')\n"
"        end\n"
"        local option_name = 'log_modules.' .. name\n"
"        box.internal.check_cfg_option_type(option_types.level, option_name,\n"
"                                           level)\n"
"        log_check_level(level, option_name)\n"
"    end\n"
"end\n"
"\n"
"-- Check cfg is valid and thus can be applied.\n"
"local function log_check_cfg(cfg)\n"
"    log_check_level(cfg.level, 'log_level')\n"
"    log_check_modules(cfg.modules)\n"
"\n"
"    if log_initialized then\n"
"        if log_cfg.log ~= cfg.log then\n"
"            box.error(box.error.RELOAD_CFG, 'log');\n"
"        end\n"
"        if log_cfg.nonblock ~= cfg.nonblock then\n"
"            box.error(box.error.RELOAD_CFG, 'log_nonblock');\n"
"        end\n"
"    end\n"
"\n"
"    local cfg_C = log_C_cfg(cfg)\n"
"    if ffi.C.say_check_cfg(cfg_C.log, cfg_C.level,\n"
"                           cfg_C.nonblock, cfg_C.format) ~= 0 then\n"
"        box.error()\n"
"    end\n"
"end\n"
"\n"
"-- Update box.internal.cfg on log config changes\n"
"local function box_cfg_update(key)\n"
"    if key == nil then\n"
"        for km, kb  in pairs(log2box_keys) do\n"
"            box.internal.update_cfg(kb, log_cfg[km])\n"
"        end\n"
"    else\n"
"        box.internal.update_cfg(log2box_keys[key], log_cfg[key])\n"
"    end\n"
"end\n"
"\n"
"local function set_log_level(level)\n"
"    box.internal.check_cfg_option_type(option_types.level, 'level', level)\n"
"    local cfg = table.copy(log_cfg)\n"
"    cfg.level = level\n"
"    log_check_cfg(cfg)\n"
"\n"
"    local cfg_C = log_C_cfg(cfg)\n"
"    ffi.C.say_set_log_level(cfg_C.level)\n"
"    log_cfg.level = level\n"
"\n"
"    box_cfg_update('level')\n"
"\n"
"    log_debug(\"log: level set to %s\", level)\n"
"end\n"
"\n"
"local function set_log_format(format)\n"
"    box.internal.check_cfg_option_type(option_types.format, 'format', format)\n"
"    local cfg = table.copy(log_cfg)\n"
"    cfg.format = format\n"
"    log_check_cfg(cfg)\n"
"\n"
"    ffi.C.say_set_log_format(fmt_str2num[format])\n"
"    log_cfg.format = format\n"
"\n"
"    box_cfg_update('format')\n"
"\n"
"    log_debug(\"log: format set to '%s'\", format)\n"
"end\n"
"\n"
"local function log_configure(self, cfg, box_api)\n"
"    if not box_api then\n"
"        if not log_initialized then\n"
"            local env_cfg = box.internal.env_cfg(box2log_keys)\n"
"            box.internal.apply_env_cfg(cfg, box_to_log_cfg(env_cfg))\n"
"        end\n"
"        cfg = box.internal.prepare_cfg(cfg, log_cfg, default_cfg, option_types)\n"
"    end\n"
"\n"
"    log_check_cfg(cfg)\n"
"    local cfg_C = log_C_cfg(cfg)\n"
"    ffi.C.say_logger_init(cfg_C.log, cfg_C.level,\n"
"                          cfg_C.nonblock, cfg_C.format)\n"
"    log_initialized = true\n"
"\n"
"    for o in pairs(option_types) do\n"
"        log_cfg[o] = cfg[o]\n"
"    end\n"
"\n"
"    box_cfg_update()\n"
"\n"
"    log_debug(\"log.cfg({log=%s, level=%s, nonblock=%s, format=%s})\",\n"
"              cfg.log, cfg.level, cfg.nonblock, cfg.format)\n"
"end\n"
"\n"
"local compat_warning_said = false\n"
"local compat_v16 = {\n"
"    logger_pid = function()\n"
"        if not compat_warning_said then\n"
"            compat_warning_said = true\n"
"            log_warn('logger_pid() is deprecated, please use pid() instead')\n"
"        end\n"
"        return log_pid()\n"
"    end;\n"
"}\n"
"\n"
"-- Log registry. It stores loggers, created by log_new, each of them having a\n"
"-- custom name. Allows to return same logger on consequent require('log') calls.\n"
"local log_registry = {}\n"
"-- Forward declaration.\n"
"local log_main\n"
"\n"
"-- Create a logger with a custom name.\n"
"local function log_new(name)\n"
"    if type(name) ~= 'string' then\n"
"        error('Illegal parameters, name should be a string')\n"
"    end\n"
"\n"
"    if log_registry[name] ~= nil then\n"
"        return log_registry[name]\n"
"    end\n"
"\n"
"    local log = table.copy(log_main)\n"
"    log.name = name\n"
"    log.error = say_closure(log, S_ERROR)\n"
"    log.warn = say_closure(log, S_WARN)\n"
"    log.info = say_closure(log, S_INFO)\n"
"    log.verbose = say_closure(log, S_VERBOSE)\n"
"    log.debug = say_closure(log, S_DEBUG)\n"
"    log_registry[name] = log\n"
"    return log\n"
"end\n"
"\n"
"-- Main logger, returned by the non-overloaded require('log')\n"
"log_main = {\n"
"    warn = log_warn,\n"
"    info = log_info,\n"
"    verbose = log_verbose,\n"
"    debug = log_debug,\n"
"    error = log_error,\n"
"    new = log_new,\n"
"    rotate = log_rotate,\n"
"    pid = log_pid,\n"
"    level = set_log_level,\n"
"    log_format = set_log_format,\n"
"    cfg = setmetatable(log_cfg, {\n"
"        __call = function(self, cfg) log_configure(self, cfg, false) end,\n"
"    }),\n"
"    box_api = {\n"
"        cfg = function()\n"
"            log_configure(log_cfg, box_to_log_cfg(box.cfg), true)\n"
"        end,\n"
"        cfg_check = function() log_check_cfg(box_to_log_cfg(box.cfg)) end,\n"
"    },\n"
"    internal = {\n"
"        ratelimit = {\n"
"            new = ratelimit_new,\n"
"            enable = ratelimit_enable,\n"
"            disable = ratelimit_disable,\n"
"        },\n"
"    }\n"
"}\n"
"\n"
"setmetatable(log_main, {\n"
"    __serialize = function(self)\n"
"        local res = table.copy(self)\n"
"        res.box_api = nil\n"
"        return setmetatable(res, {})\n"
"    end,\n"
"    __index = compat_v16;\n"
"})\n"
"\n"
"return log_main\n"
""
;
