// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomLocalstorageMetrics_h
#define mozilla_GleanDomLocalstorageMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace localstorage_database {
  /**
   * generated from localstorage.database.new_object_setup_time
   * Measures the time taken for the content process to fully set up a new database, including any time required for datastore preparation in the parent process. This duration can be significantly affected by datastore preloading, which is triggered when a page begins loading. If an error occurs, the time is not recorded.
   */
  constexpr impl::TimingDistributionMetric new_object_setup_time(3768);

  /**
   * generated from localstorage.database.request_allow_to_close_response_time
   * Time it took between sending PBackgroundLSDatabase::RequestAllowToClose and receiving PBackgroundLSDatabase::AllowToClose message. These messages are issued when QuotaManager is shutting down or is aborting operations for a particular origin or process.
   */
  constexpr impl::TimingDistributionMetric request_allow_to_close_response_time(3769);
}

namespace localstorage_request {
  /**
   * generated from localstorage.request.prepare_datastore_processing_time
   * Measures the time taken by the parent process to prepare a datastore. This duration can be significantly affected by datastore preloading, which is triggered when a page begins to load. When a datastore is already preloaded, preparation is usually fast since no additional I/O is required. If an error occurs, the time is not recorded. In the future, we may introduce separate metrics to distinguish between different types of datastore preparations (e.g., loading data from disk vs. using preloaded data).
   */
  constexpr impl::TimingDistributionMetric prepare_datastore_processing_time(3770);

  /**
   * generated from localstorage.request.recv_cancel_counter
   * Increments whenever a request cancellation message is successfully received. This includes cancellations for requests related to either databases or observers.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> recv_cancel_counter(3771);

  /**
   * generated from localstorage.request.send_cancel_counter
   * Increments whenever a request cancellation message is successfully sent. This includes cancellations for requests related to either databases or observers.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> send_cancel_counter(3772);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomLocalstorageMetrics_h
