/* THIS FILE IS AUTOGENERATED FROM CancelContentJSOptions.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "CancelContentJSOptionsBinding.h"
#include "MainThreadUtils.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



CancelContentJSOptions::CancelContentJSOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
CancelContentJSOptions::InitIds(JSContext* cx, CancelContentJSOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->uri_id.init(cx, "uri") ||
      !atomsCache->index_id.init(cx, "index") ||
      !atomsCache->epoch_id.init(cx, "epoch")) {
    return false;
  }
  return true;
}

bool
CancelContentJSOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  CancelContentJSOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<CancelContentJSOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->epoch_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'epoch' member of CancelContentJSOptions", &mEpoch)) {
      return false;
    }
  } else {
    mEpoch = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->index_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'index' member of CancelContentJSOptions", &mIndex)) {
      return false;
    }
  } else {
    mIndex = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->uri_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<nsIURI>::value, "We can only store refcounted classes.");
      RefPtr<nsIURI> holder;
      JS::Rooted<JSObject*> source(cx, &temp.ref().toObject());
      if (NS_FAILED(UnwrapArg<nsIURI>(cx, source, getter_AddRefs(holder)))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'uri' member of CancelContentJSOptions", "URI");
        return false;
      }
      MOZ_ASSERT(holder);
      mUri = holder;
    } else if (temp.ref().isNullOrUndefined()) {
      mUri = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'uri' member of CancelContentJSOptions");
      return false;
    }
  } else {
    mUri = nullptr;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
CancelContentJSOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
CancelContentJSOptions::TraceDictionary(JSTracer* trc)
{
}



CancelContentJSOptions&
CancelContentJSOptions::operator=(const CancelContentJSOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mEpoch = aOther.mEpoch;
  mIndex = aOther.mIndex;
  mUri = aOther.mUri;
  return *this;
}


} // namespace mozilla::dom
