/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
	applyconfigurationapisv1 "sigs.k8s.io/gateway-api/applyconfiguration/apis/v1"
	scheme "sigs.k8s.io/gateway-api/pkg/client/clientset/versioned/scheme"
)

// HTTPRoutesGetter has a method to return a HTTPRouteInterface.
// A group's client should implement this interface.
type HTTPRoutesGetter interface {
	HTTPRoutes(namespace string) HTTPRouteInterface
}

// HTTPRouteInterface has methods to work with HTTPRoute resources.
type HTTPRouteInterface interface {
	Create(ctx context.Context, hTTPRoute *apisv1.HTTPRoute, opts metav1.CreateOptions) (*apisv1.HTTPRoute, error)
	Update(ctx context.Context, hTTPRoute *apisv1.HTTPRoute, opts metav1.UpdateOptions) (*apisv1.HTTPRoute, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, hTTPRoute *apisv1.HTTPRoute, opts metav1.UpdateOptions) (*apisv1.HTTPRoute, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*apisv1.HTTPRoute, error)
	List(ctx context.Context, opts metav1.ListOptions) (*apisv1.HTTPRouteList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apisv1.HTTPRoute, err error)
	Apply(ctx context.Context, hTTPRoute *applyconfigurationapisv1.HTTPRouteApplyConfiguration, opts metav1.ApplyOptions) (result *apisv1.HTTPRoute, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, hTTPRoute *applyconfigurationapisv1.HTTPRouteApplyConfiguration, opts metav1.ApplyOptions) (result *apisv1.HTTPRoute, err error)
	HTTPRouteExpansion
}

// hTTPRoutes implements HTTPRouteInterface
type hTTPRoutes struct {
	*gentype.ClientWithListAndApply[*apisv1.HTTPRoute, *apisv1.HTTPRouteList, *applyconfigurationapisv1.HTTPRouteApplyConfiguration]
}

// newHTTPRoutes returns a HTTPRoutes
func newHTTPRoutes(c *GatewayV1Client, namespace string) *hTTPRoutes {
	return &hTTPRoutes{
		gentype.NewClientWithListAndApply[*apisv1.HTTPRoute, *apisv1.HTTPRouteList, *applyconfigurationapisv1.HTTPRouteApplyConfiguration](
			"httproutes",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *apisv1.HTTPRoute { return &apisv1.HTTPRoute{} },
			func() *apisv1.HTTPRouteList { return &apisv1.HTTPRouteList{} },
		),
	}
}
