package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetKeyPolicy invokes the kms.GetKeyPolicy API synchronously
func (client *Client) GetKeyPolicy(request *GetKeyPolicyRequest) (response *GetKeyPolicyResponse, err error) {
	response = CreateGetKeyPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// GetKeyPolicyWithChan invokes the kms.GetKeyPolicy API asynchronously
func (client *Client) GetKeyPolicyWithChan(request *GetKeyPolicyRequest) (<-chan *GetKeyPolicyResponse, <-chan error) {
	responseChan := make(chan *GetKeyPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetKeyPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetKeyPolicyWithCallback invokes the kms.GetKeyPolicy API asynchronously
func (client *Client) GetKeyPolicyWithCallback(request *GetKeyPolicyRequest, callback func(response *GetKeyPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetKeyPolicyResponse
		var err error
		defer close(result)
		response, err = client.GetKeyPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetKeyPolicyRequest is the request struct for api GetKeyPolicy
type GetKeyPolicyRequest struct {
	*requests.RpcRequest
	KeyId      string `position:"Query" name:"KeyId"`
	PolicyName string `position:"Query" name:"PolicyName"`
}

// GetKeyPolicyResponse is the response struct for api GetKeyPolicy
type GetKeyPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Policy    string `json:"Policy" xml:"Policy"`
}

// CreateGetKeyPolicyRequest creates a request to invoke GetKeyPolicy API
func CreateGetKeyPolicyRequest() (request *GetKeyPolicyRequest) {
	request = &GetKeyPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "GetKeyPolicy", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetKeyPolicyResponse creates a response to parse from GetKeyPolicy response
func CreateGetKeyPolicyResponse() (response *GetKeyPolicyResponse) {
	response = &GetKeyPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
