// python wrapper for vtkFidesReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkFidesReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkFidesReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkFidesReader_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkFidesReader_StepStatus_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOFides.vtkFidesReader.StepStatus", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkFidesReader_StepStatus_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkFidesReader_StepStatus_Type, static_cast<int>(val));
}


static PyObject *
PyvtkFidesReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkFidesReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkFidesReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkFidesReader *tempr = vtkFidesReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFidesReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkFidesReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkFidesReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkFidesReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_CanReadFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanReadFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->CanReadFile(temp0) :
      op->vtkFidesReader::CanReadFile(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkFidesReader::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_ParseDataModel_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ParseDataModel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->ParseDataModel(temp0);
    }
    else
    {
      op->vtkFidesReader::ParseDataModel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkFidesReader_ParseDataModel_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ParseDataModel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ParseDataModel();
    }
    else
    {
      op->vtkFidesReader::ParseDataModel();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkFidesReader_ParseDataModel(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkFidesReader_ParseDataModel_s1(self, args);
    case 0:
      return PyvtkFidesReader_ParseDataModel_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ParseDataModel");
  return nullptr;
}


static PyObject *
PyvtkFidesReader_SetDataSourcePath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataSourcePath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetFilePath(temp1))
  {
    if (ap.IsBound())
    {
      op->SetDataSourcePath(temp0, temp1);
    }
    else
    {
      op->vtkFidesReader::SetDataSourcePath(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_SetDataSourceEngine(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataSourceEngine");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetDataSourceEngine(temp0, temp1);
    }
    else
    {
      op->vtkFidesReader::SetDataSourceEngine(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_SetDataSourceIO(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataSourceIO");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetDataSourceIO(temp0, temp1);
    }
    else
    {
      op->vtkFidesReader::SetDataSourceIO(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_PrepareNextStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PrepareNextStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PrepareNextStep();
    }
    else
    {
      op->vtkFidesReader::PrepareNextStep();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetNextStepStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNextStepStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNextStepStatus() :
      op->vtkFidesReader::GetNextStepStatus());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetTimeOfCurrentStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeOfCurrentStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTimeOfCurrentStep() :
      op->vtkFidesReader::GetTimeOfCurrentStep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_ConvertToVTKOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ConvertToVTKOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ConvertToVTKOn();
    }
    else
    {
      op->vtkFidesReader::ConvertToVTKOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_ConvertToVTKOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ConvertToVTKOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ConvertToVTKOff();
    }
    else
    {
      op->vtkFidesReader::ConvertToVTKOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_SetConvertToVTK(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConvertToVTK");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConvertToVTK(temp0);
    }
    else
    {
      op->vtkFidesReader::SetConvertToVTK(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetConvertToVTK(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConvertToVTK");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetConvertToVTK() :
      op->vtkFidesReader::GetConvertToVTK());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_StreamStepsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StreamStepsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StreamStepsOn();
    }
    else
    {
      op->vtkFidesReader::StreamStepsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_StreamStepsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StreamStepsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StreamStepsOff();
    }
    else
    {
      op->vtkFidesReader::StreamStepsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_SetStreamSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStreamSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStreamSteps(temp0);
    }
    else
    {
      op->vtkFidesReader::SetStreamSteps(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetStreamSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStreamSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetStreamSteps() :
      op->vtkFidesReader::GetStreamSteps());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_CreateSharedPointsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateSharedPointsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CreateSharedPointsOn();
    }
    else
    {
      op->vtkFidesReader::CreateSharedPointsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_CreateSharedPointsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateSharedPointsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CreateSharedPointsOff();
    }
    else
    {
      op->vtkFidesReader::CreateSharedPointsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_SetCreateSharedPoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCreateSharedPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCreateSharedPoints(temp0);
    }
    else
    {
      op->vtkFidesReader::SetCreateSharedPoints(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetCreateSharedPoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCreateSharedPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCreateSharedPoints() :
      op->vtkFidesReader::GetCreateSharedPoints());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetPointDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetPointDataArraySelection() :
      op->vtkFidesReader::GetPointDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetCellDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetCellDataArraySelection() :
      op->vtkFidesReader::GetCellDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetFieldDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetFieldDataArraySelection() :
      op->vtkFidesReader::GetFieldDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetNumberOfPointArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfPointArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfPointArrays() :
      op->vtkFidesReader::GetNumberOfPointArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetNumberOfCellArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfCellArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfCellArrays() :
      op->vtkFidesReader::GetNumberOfCellArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetNumberOfFieldArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfFieldArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfFieldArrays() :
      op->vtkFidesReader::GetNumberOfFieldArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetPointArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetPointArrayName(temp0) :
      op->vtkFidesReader::GetPointArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetCellArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetCellArrayName(temp0) :
      op->vtkFidesReader::GetCellArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetFieldArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetFieldArrayName(temp0) :
      op->vtkFidesReader::GetFieldArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetPointArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPointArrayStatus(temp0) :
      op->vtkFidesReader::GetPointArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetCellArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCellArrayStatus(temp0) :
      op->vtkFidesReader::GetCellArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetFieldArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFieldArrayStatus(temp0) :
      op->vtkFidesReader::GetFieldArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_SetPointArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetPointArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkFidesReader::SetPointArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_SetCellArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetCellArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkFidesReader::SetCellArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_SetFieldArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFieldArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetFieldArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkFidesReader::SetFieldArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFidesReader_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFidesReader *op = static_cast<vtkFidesReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkFidesReader::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkFidesReader_Methods[] = {
  {"IsTypeOf", PyvtkFidesReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkFidesReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkFidesReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkFidesReader\nC++: static vtkFidesReader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkFidesReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkFidesReader\nC++: vtkFidesReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkFidesReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkFidesReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"CanReadFile", PyvtkFidesReader_CanReadFile, METH_VARARGS,
   "CanReadFile(self, name:str) -> int\nC++: int CanReadFile(const std::string &name)\n\nTest whether or not a given file should even be attempted for use\nwith this reader.\n"},
  {"SetFileName", PyvtkFidesReader_SetFileName, METH_VARARGS,
   "SetFileName(self, fname:str) -> None\nC++: void SetFileName(const std::string &fname)\n\nSet the filename to be read\n"},
  {"ParseDataModel", PyvtkFidesReader_ParseDataModel, METH_VARARGS,
   "ParseDataModel(self, fname:str) -> None\nC++: void ParseDataModel(const std::string &fname)\nParseDataModel(self) -> None\nC++: void ParseDataModel()\n\nGiven a json filename, parse and internally store a data model.\nHas to be called before any data input can take place. See the\nFides documentation for the description of the schema.\n"},
  {"SetDataSourcePath", PyvtkFidesReader_SetDataSourcePath, METH_VARARGS,
   "SetDataSourcePath(self, name:str, path:str) -> None\nC++: void SetDataSourcePath(const std::string &name,\n    const std::string &path)\n\nSet the path for a Fides data source. This can be a file, an SST\nstream or an inline data source. The name of the data source\ncorresponds to what is in the data model.\n"},
  {"SetDataSourceEngine", PyvtkFidesReader_SetDataSourceEngine, METH_VARARGS,
   "SetDataSourceEngine(self, name:str, engine:str) -> None\nC++: void SetDataSourceEngine(const std::string &name,\n    const std::string &engine)\n\nSet the engine for a Fides data source. Defaults to BP engine.\n"},
  {"SetDataSourceIO", PyvtkFidesReader_SetDataSourceIO, METH_VARARGS,
   "SetDataSourceIO(self, name:str, ioAddress:str) -> None\nC++: void SetDataSourceIO(const std::string &name,\n    const std::string &ioAddress)\n\nSet the ADIOS2::IO object to be used for setting up the Inline\nengine reader. This should not be used for any other engine type.\nioAddress is a string containing the address of the IO object,\nwhich Fides will cast to a IO pointer.\n"},
  {"PrepareNextStep", PyvtkFidesReader_PrepareNextStep, METH_VARARGS,
   "PrepareNextStep(self) -> None\nC++: void PrepareNextStep()\n\nThis method has to be called before each step when streaming. It\nwill move to the next step and initialize any meta-data\nnecessary. The loading of the next step is done in the update\npipeline pass. Note that this internally calls Modified() on the\nreader to force the next update to cause an execution.\n"},
  {"GetNextStepStatus", PyvtkFidesReader_GetNextStepStatus, METH_VARARGS,
   "GetNextStepStatus(self) -> int\nC++: int GetNextStepStatus()\n\nGet the StepStatus of the next step reported by Fides. See enum\nvtkFidesReader::StepStatus for potential return values. This is\nupdated in PrepareNextStep() and set back to NotReady after\nreading a step.\n"},
  {"GetTimeOfCurrentStep", PyvtkFidesReader_GetTimeOfCurrentStep, METH_VARARGS,
   "GetTimeOfCurrentStep(self) -> float\nC++: double GetTimeOfCurrentStep()\n\nGets the time (from the specified ADIOS variable) of the current\nstep. Should only be used in streaming mode.\n"},
  {"ConvertToVTKOn", PyvtkFidesReader_ConvertToVTKOn, METH_VARARGS,
   "ConvertToVTKOn(self) -> None\nC++: virtual void ConvertToVTKOn()\n\nMethods to determine whether to output a set of vtkmDataSets or\nnative VTK datasets. If the pipeline following the reader is\nmainly VTK filters (as opposed to Viskores accelerated VTK\nfilters), set this to on. False by default.\n"},
  {"ConvertToVTKOff", PyvtkFidesReader_ConvertToVTKOff, METH_VARARGS,
   "ConvertToVTKOff(self) -> None\nC++: virtual void ConvertToVTKOff()\n\n"},
  {"SetConvertToVTK", PyvtkFidesReader_SetConvertToVTK, METH_VARARGS,
   "SetConvertToVTK(self, _arg:bool) -> None\nC++: virtual void SetConvertToVTK(bool _arg)\n\n"},
  {"GetConvertToVTK", PyvtkFidesReader_GetConvertToVTK, METH_VARARGS,
   "GetConvertToVTK(self) -> bool\nC++: virtual bool GetConvertToVTK()\n\n"},
  {"StreamStepsOn", PyvtkFidesReader_StreamStepsOn, METH_VARARGS,
   "StreamStepsOn(self) -> None\nC++: virtual void StreamStepsOn()\n\nMethods to determine whether streaming mode is used. False by\ndefault.\n"},
  {"StreamStepsOff", PyvtkFidesReader_StreamStepsOff, METH_VARARGS,
   "StreamStepsOff(self) -> None\nC++: virtual void StreamStepsOff()\n\n"},
  {"SetStreamSteps", PyvtkFidesReader_SetStreamSteps, METH_VARARGS,
   "SetStreamSteps(self, _arg:bool) -> None\nC++: virtual void SetStreamSteps(bool _arg)\n\n"},
  {"GetStreamSteps", PyvtkFidesReader_GetStreamSteps, METH_VARARGS,
   "GetStreamSteps(self) -> bool\nC++: virtual bool GetStreamSteps()\n\n"},
  {"CreateSharedPointsOn", PyvtkFidesReader_CreateSharedPointsOn, METH_VARARGS,
   "CreateSharedPointsOn(self) -> None\nC++: virtual void CreateSharedPointsOn()\n\nDetermines whether to close gaps between blocks of structured\ngrids with the use of shared points.\n"},
  {"CreateSharedPointsOff", PyvtkFidesReader_CreateSharedPointsOff, METH_VARARGS,
   "CreateSharedPointsOff(self) -> None\nC++: virtual void CreateSharedPointsOff()\n\n"},
  {"SetCreateSharedPoints", PyvtkFidesReader_SetCreateSharedPoints, METH_VARARGS,
   "SetCreateSharedPoints(self, _arg:bool) -> None\nC++: virtual void SetCreateSharedPoints(bool _arg)\n\n"},
  {"GetCreateSharedPoints", PyvtkFidesReader_GetCreateSharedPoints, METH_VARARGS,
   "GetCreateSharedPoints(self) -> bool\nC++: virtual bool GetCreateSharedPoints()\n\n"},
  {"GetPointDataArraySelection", PyvtkFidesReader_GetPointDataArraySelection, METH_VARARGS,
   "GetPointDataArraySelection(self) -> vtkDataArraySelection\nC++: virtual vtkDataArraySelection *GetPointDataArraySelection()\n\nObject to perform point array selection before update.\n"},
  {"GetCellDataArraySelection", PyvtkFidesReader_GetCellDataArraySelection, METH_VARARGS,
   "GetCellDataArraySelection(self) -> vtkDataArraySelection\nC++: virtual vtkDataArraySelection *GetCellDataArraySelection()\n\nObject to perform cell array selection before update.\n"},
  {"GetFieldDataArraySelection", PyvtkFidesReader_GetFieldDataArraySelection, METH_VARARGS,
   "GetFieldDataArraySelection(self) -> vtkDataArraySelection\nC++: virtual vtkDataArraySelection *GetFieldDataArraySelection()\n\nObject to perform field array selection before update.\n"},
  {"GetNumberOfPointArrays", PyvtkFidesReader_GetNumberOfPointArrays, METH_VARARGS,
   "GetNumberOfPointArrays(self) -> int\nC++: int GetNumberOfPointArrays()\n\nGet the number of point or cell arrays available in the input.\n"},
  {"GetNumberOfCellArrays", PyvtkFidesReader_GetNumberOfCellArrays, METH_VARARGS,
   "GetNumberOfCellArrays(self) -> int\nC++: int GetNumberOfCellArrays()\n\n"},
  {"GetNumberOfFieldArrays", PyvtkFidesReader_GetNumberOfFieldArrays, METH_VARARGS,
   "GetNumberOfFieldArrays(self) -> int\nC++: int GetNumberOfFieldArrays()\n\n"},
  {"GetPointArrayName", PyvtkFidesReader_GetPointArrayName, METH_VARARGS,
   "GetPointArrayName(self, index:int) -> str\nC++: const char *GetPointArrayName(int index)\n\nGet the name of the point or cell array with the given index in\nthe input.\n"},
  {"GetCellArrayName", PyvtkFidesReader_GetCellArrayName, METH_VARARGS,
   "GetCellArrayName(self, index:int) -> str\nC++: const char *GetCellArrayName(int index)\n\n"},
  {"GetFieldArrayName", PyvtkFidesReader_GetFieldArrayName, METH_VARARGS,
   "GetFieldArrayName(self, index:int) -> str\nC++: const char *GetFieldArrayName(int index)\n\n"},
  {"GetPointArrayStatus", PyvtkFidesReader_GetPointArrayStatus, METH_VARARGS,
   "GetPointArrayStatus(self, name:str) -> int\nC++: int GetPointArrayStatus(const char *name)\n\nGet/Set whether the point or cell array with the given name is to\nbe read.\n"},
  {"GetCellArrayStatus", PyvtkFidesReader_GetCellArrayStatus, METH_VARARGS,
   "GetCellArrayStatus(self, name:str) -> int\nC++: int GetCellArrayStatus(const char *name)\n\n"},
  {"GetFieldArrayStatus", PyvtkFidesReader_GetFieldArrayStatus, METH_VARARGS,
   "GetFieldArrayStatus(self, name:str) -> int\nC++: int GetFieldArrayStatus(const char *name)\n\n"},
  {"SetPointArrayStatus", PyvtkFidesReader_SetPointArrayStatus, METH_VARARGS,
   "SetPointArrayStatus(self, name:str, status:int) -> None\nC++: void SetPointArrayStatus(const char *name, int status)\n\n"},
  {"SetCellArrayStatus", PyvtkFidesReader_SetCellArrayStatus, METH_VARARGS,
   "SetCellArrayStatus(self, name:str, status:int) -> None\nC++: void SetCellArrayStatus(const char *name, int status)\n\n"},
  {"SetFieldArrayStatus", PyvtkFidesReader_SetFieldArrayStatus, METH_VARARGS,
   "SetFieldArrayStatus(self, name:str, status:int) -> None\nC++: void SetFieldArrayStatus(const char *name, int status)\n\n"},
  {"GetMTime", PyvtkFidesReader_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nOverridden to take into account mtimes for vtkDataArraySelection\ninstances.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkFidesReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFidesReader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFidesReader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("convert_to_vtk"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetConvertToVTK(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFidesReader_SetConvertToVTK(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFidesReader_SetConvertToVTK(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConvertToVTK/SetConvertToVTK\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("stream_steps"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetStreamSteps(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFidesReader_SetStreamSteps(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFidesReader_SetStreamSteps(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStreamSteps/SetStreamSteps\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("create_shared_points"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetCreateSharedPoints(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFidesReader_SetCreateSharedPoints(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFidesReader_SetCreateSharedPoints(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCreateSharedPoints/SetCreateSharedPoints\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("next_step_status"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetNextStepStatus(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNextStepStatus\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_of_current_step"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetTimeOfCurrentStep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeOfCurrentStep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetPointDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPointDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetCellDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCellDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetFieldDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFieldDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_point_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetNumberOfPointArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfPointArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_cell_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetNumberOfCellArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfCellArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_field_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFidesReader_GetNumberOfFieldArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfFieldArrays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkFidesReader_Doc =
  "vtkFidesReader - Read ADIOS2 streams using Fides data model\n\n"
  "Superclass: vtkAlgorithm\n\n"
  "vtkFidesReader is a data source that reads ADIOS2 files or data\n"
  "streams (SST engine, inline engine etc.). The data model in these\n"
  "data streams is defined by the Fides library:\n"
  "(https://gitlab.kitware.com/vtk/fides/) See the Fides documentation\n"
  "for the details of the schema used to represent VTK/Viskores data\n"
  "models. The reader can create partitioned dataset collection\n"
  "containing native VTK dataset or  VTK Viskores datasets. Time and\n"
  "time streaming is supported. Note that the interface for time\n"
  "streaming is different. It requires calling PrepareNextStep() and\n"
  "Update() for each new step. Partitioned (in ADIOS2 terminology\n"
  "blocks) data is supported.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkFidesReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOFides.vtkFidesReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkFidesReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkFidesReader_StaticNew()
{
  return vtkFidesReader::New();
}

PyObject *PyvtkFidesReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkFidesReader_Type, PyvtkFidesReader_Methods,
    "vtkFidesReader",
 &PyvtkFidesReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkFidesReader_StepStatus_Type);
  PyVTKEnum_Add(&PyvtkFidesReader_StepStatus_Type, "vtkFidesReader.StepStatus");

  o = (PyObject *)&PyvtkFidesReader_StepStatus_Type;
  if (PyDict_SetItemString(d, "StepStatus", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 3; c++)
  {
    typedef vtkFidesReader::StepStatus cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[3] = {
        { "OK", vtkFidesReader::OK },
        { "NotReady", vtkFidesReader::NotReady },
        { "EndOfStream", vtkFidesReader::EndOfStream },
      };

    o = PyvtkFidesReader_StepStatus_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkFidesReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkFidesReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkFidesReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkFidesReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

