// python wrapper for vtkXdmf3ArrayKeeper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkXdmf3ArrayKeeper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkXdmf3ArrayKeeper(PyObject *dict); }

static PyObject *
PyvtkXdmf3ArrayKeeper_BumpGeneration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BumpGeneration");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3ArrayKeeper *op = static_cast<vtkXdmf3ArrayKeeper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    op->BumpGeneration();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3ArrayKeeper_Release(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Release");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3ArrayKeeper *op = static_cast<vtkXdmf3ArrayKeeper *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    op->Release(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkXdmf3ArrayKeeper_Methods[] = {
  {"BumpGeneration", PyvtkXdmf3ArrayKeeper_BumpGeneration, METH_VARARGS,
   "BumpGeneration(self) -> None\nC++: void BumpGeneration()\n\nCall to mark arrays that will be accessed with a new timestamp\n"},
  {"Release", PyvtkXdmf3ArrayKeeper_Release, METH_VARARGS,
   "Release(self, force:bool) -> None\nC++: void Release(bool force)\n\nCall to free all open arrays that are currently open but not in\nuse. Force argument frees all arrays.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkXdmf3ArrayKeeper_GetSets[] = {
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkXdmf3ArrayKeeper_vtkXdmf3ArrayKeeper(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkXdmf3ArrayKeeper");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkXdmf3ArrayKeeper *op = new vtkXdmf3ArrayKeeper();

    result = PyVTKSpecialObject_New("vtkXdmf3ArrayKeeper", op);
  }

  return result;
}

static PyMethodDef PyvtkXdmf3ArrayKeeper_vtkXdmf3ArrayKeeper_Methods[] = {
  {nullptr, nullptr, 0, nullptr}
};


static const char *PyvtkXdmf3ArrayKeeper_Doc =

  "vtkXdmf3ArrayKeeper() -> vtkXdmf3ArrayKeeper\nC++: vtkXdmf3ArrayKeeper()\n""\n"
  "vtkXdmf3ArrayKeeper - LRU cache of XDMF Arrays\n\n"
  "vtkXdmf3ArrayKeeper maintains the in memory cache of recently used\n"
  "XdmfArrays. Each array that is loaded from XDMF is put in the cache\n"
  "and/or marked with the current timestep. A release method frees\n"
  "arrays that have not been recently used.\n\n"
  "This file is a helper for the vtkXdmf3Reader and not intended to be\n"
  "part of VTK public API\n\n";

static PyObject *
PyvtkXdmf3ArrayKeeper_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkXdmf3ArrayKeeper_vtkXdmf3ArrayKeeper(nullptr, args);
}

static void PyvtkXdmf3ArrayKeeper_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkXdmf3ArrayKeeper *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkXdmf3ArrayKeeper_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkXdmf3ArrayKeeper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOXdmf3.vtkXdmf3ArrayKeeper", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkXdmf3ArrayKeeper_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkXdmf3ArrayKeeper_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkXdmf3ArrayKeeper_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkXdmf3ArrayKeeper_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

#ifndef DECLARED_PyvtkXdmf3ArrayKeeper_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkXdmf3ArrayKeeper_TypeNew(); }
#define DECLARED_PyvtkXdmf3ArrayKeeper_TypeNew
#endif

PyObject *PyvtkXdmf3ArrayKeeper_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkXdmf3ArrayKeeper_Type,
    PyvtkXdmf3ArrayKeeper_Methods,
    PyvtkXdmf3ArrayKeeper_GetSets,
    PyvtkXdmf3ArrayKeeper_vtkXdmf3ArrayKeeper_Methods,
    nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkXdmf3ArrayKeeper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkXdmf3ArrayKeeper_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkXdmf3ArrayKeeper", o) != 0)
  {
    Py_DECREF(o);
  }

}

