// java wrapper for vtkPlot object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPlot.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkContextItem_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPlot_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPlot",dType)) { return me; }
  if ((res= vtkContextItem_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlot_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlot_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_Update_14(JNIEnv* env, jobject obj)
{

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetLegendVisibility_15(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLegendVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPlot_GetLegendVisibility_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLegendVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_LegendVisibilityOn_17(JNIEnv* env, jobject obj)
{

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->LegendVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_LegendVisibilityOff_18(JNIEnv* env, jobject obj)
{

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->LegendVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetTooltipLabelFormat_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTooltipLabelFormat(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPlot_GetTooltipLabelFormat_110(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTooltipLabelFormat();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetTooltipNotation_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTooltipNotation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlot_GetTooltipNotation_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTooltipNotation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetTooltipPrecision_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTooltipPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlot_GetTooltipPrecision_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTooltipPrecision();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetColor_115(JNIEnv* env, jobject obj,jbyte id0,jbyte id1,jbyte id2,jbyte id3)
{
   unsigned char   temp0;
   unsigned char   temp1;
   unsigned char   temp2;
   unsigned char   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetColor_116(JNIEnv* env, jobject obj,jbyte id0,jbyte id1,jbyte id2)
{
   unsigned char   temp0;
   unsigned char   temp1;
   unsigned char   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetColorF_117(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorF(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetColorF_118(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorF(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_GetColorF_119(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetColorF(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetWidth_120(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWidth(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkPlot_GetWidth_121(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWidth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetPen_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPen * temp0;
  temp0 = static_cast<vtkPen*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPen(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetPen_123(JNIEnv* env, jobject obj)
{
  vtkPen * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPen();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetBrush_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkBrush * temp0;
  temp0 = static_cast<vtkBrush*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBrush(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetBrush_125(JNIEnv* env, jobject obj)
{
  vtkBrush * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBrush();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetSelectionPen_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPen * temp0;
  temp0 = static_cast<vtkPen*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionPen(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetSelectionPen_127(JNIEnv* env, jobject obj)
{
  vtkPen * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionPen();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetSelectionBrush_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkBrush * temp0;
  temp0 = static_cast<vtkBrush*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionBrush(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetSelectionBrush_129(JNIEnv* env, jobject obj)
{
  vtkBrush * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionBrush();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetLabel_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabel(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPlot_GetLabel_131(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabel();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetLabels_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkStringArray * temp0;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabels(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetLabels_133(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabels();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlot_GetNumberOfLabels_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabels();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPlot_GetLabel_135(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkStdString   temp20;
  temp0 = id0;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabel(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetIndexedLabels_136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkStringArray * temp0;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIndexedLabels(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetIndexedLabels_137(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIndexedLabels();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetData_138(JNIEnv* env, jobject obj)
{
  vtkContextMapper2D * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPlot_GetUseIndexForXSeries_139(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseIndexForXSeries();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetUseIndexForXSeries_140(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseIndexForXSeries(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetInputData_141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTable * temp0;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetInputData_142(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1, jbyteArray id2, jint len2)
{
  vtkTable * temp0;
  vtkStdString temp1;
  vtkStdString temp2;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  temp2 = vtkJavaUTF8ToString(env, id2, len2);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetInputData_143(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2)
{
  vtkTable * temp0;
  long long   temp1;
  long long   temp2;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetInputConnection_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputConnection(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetInput_145(JNIEnv* env, jobject obj)
{
  vtkTable * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetInputConnection_146(JNIEnv* env, jobject obj)
{
  vtkAlgorithmOutput * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputConnection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetInputArray_147(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  vtkStdString temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArray(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetXAxisInputArrayToProcess_148(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxisInputArrayToProcess(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPlot_GetXAxisInputArrayToProcess_149(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisInputArrayToProcess();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetYAxisInputArrayToProcess_150(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxisInputArrayToProcess(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPlot_GetYAxisInputArrayToProcess_151(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisInputArrayToProcess();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetSelectable_152(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectable(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPlot_GetSelectable_153(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectable();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SelectableOn_154(JNIEnv* env, jobject obj)
{

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SelectableOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SelectableOff_155(JNIEnv* env, jobject obj)
{

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SelectableOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetSelection_156(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdTypeArray * temp0;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelection(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetSelection_157(JNIEnv* env, jobject obj)
{
  vtkIdTypeArray * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetXAxis_158(JNIEnv* env, jobject obj)
{
  vtkAxis * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxis();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetXAxis_159(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAxis * temp0;
  temp0 = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxis(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot_GetYAxis_160(JNIEnv* env, jobject obj)
{
  vtkAxis * temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxis();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_SetYAxis_161(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAxis * temp0;
  temp0 = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxis(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_GetBounds_162(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_GetUnscaledInputBounds_163(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetUnscaledInputBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPlot_ClampPos_164(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[2];
  double temp1[4];
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ClampPos(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPlot_ClampPos_165(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ClampPos(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPlot_UpdateCache_166(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateCache();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot_FilterSelectedPoints_167(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  vtkIdTypeArray * temp2;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkPlot* op = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, obj));
  op->FilterSelectedPoints(temp0,temp1,temp2);

}
