// java wrapper for vtkPointSet object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPointSet.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataSet_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPointSet_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPointSet",dType)) { return me; }
  if ((res= vtkDataSet_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_ExtendedNew_10(JNIEnv* env, jobject obj)
{
  vtkPointSet * temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointSet_IsTypeOf_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointSet_IsA_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetNumberOfGenerationsFromBaseType_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetNumberOfGenerationsFromBase_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointSet_GetDataObjectType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_SetEditable_16(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEditable(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPointSet_GetEditable_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEditable();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_EditableOn_18(JNIEnv* env, jobject obj)
{

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->EditableOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_EditableOff_19(JNIEnv* env, jobject obj)
{

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->EditableOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_Initialize_110(JNIEnv* env, jobject obj)
{

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_CopyStructure_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetNumberOfPoints_112(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_GetPoint_113(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_FindPoint_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindPoint(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetNumberOfCells_115(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointSet_GetMaxCellSize_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetCell_117(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_GetCellPoints_118(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_GetPointCells_119(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_GetCell_120(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointSet_GetCellType_121(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetCellSize_122(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPointSet_GetPoint_123(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_NewCellIterator_124(JNIEnv* env, jobject obj)
{
  vtkCellIterator * temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewCellIterator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_BuildPointLocator_125(JNIEnv* env, jobject obj)
{

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildPointLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_BuildLocator_126(JNIEnv* env, jobject obj)
{

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_BuildCellLocator_127(JNIEnv* env, jobject obj)
{

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildCellLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_SetPointLocator_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractPointLocator * temp0;
  temp0 = static_cast<vtkAbstractPointLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointLocator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetPointLocator_129(JNIEnv* env, jobject obj)
{
  vtkAbstractPointLocator * temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointLocator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_SetCellLocator_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractCellLocator * temp0;
  temp0 = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellLocator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetCellLocator_131(JNIEnv* env, jobject obj)
{
  vtkAbstractCellLocator * temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellLocator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetMTime_132(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_ComputeBounds_133(JNIEnv* env, jobject obj)
{

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBounds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_Squeeze_134(JNIEnv* env, jobject obj)
{

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_SetPoints_135(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoints(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetPoints_136(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetActualMemorySize_137(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_ShallowCopy_138(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSet_DeepCopy_139(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPointSet_UsesGarbageCollector_140(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UsesGarbageCollector();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetData_141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkPointSet * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetData_142(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkPointSet * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSet_GetCell_143(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkCell * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPointSet* op = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPointSet_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPointSet::New());
}
