// java wrapper for vtkRectilinearGrid object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkRectilinearGrid.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataSet_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkRectilinearGrid_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkRectilinearGrid",dType)) { return me; }
  if ((res= vtkDataSet_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_ExtendedNew_10(JNIEnv* env, jobject obj)
{
  vtkRectilinearGrid * temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_IsTypeOf_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_IsA_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetNumberOfGenerationsFromBaseType_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetNumberOfGenerationsFromBase_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetDataObjectType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_CopyStructure_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_Initialize_17(JNIEnv* env, jobject obj)
{

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetNumberOfCells_18(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetNumberOfPoints_19(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetPoints_110(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRectilinearGrid_GetPoint_111(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_GetPoint_112(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetCell_113(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetCell_114(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkCell * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_GetCell_115(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_GetCellBounds_116(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_FindPoint_117(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindPoint(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetCellType_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetCellSize_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_GetCellPoints_120(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_GetPointCells_121(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_ComputeBounds_122(JNIEnv* env, jobject obj)
{

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBounds();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetMaxCellSize_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetMaxSpatialDimension_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetMinSpatialDimension_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_GetCellNeighbors_126(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellNeighbors(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetCells_127(JNIEnv* env, jobject obj)
{
  vtkStructuredCellArray * temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCells();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_BlankPoint_128(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlankPoint(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_UnBlankPoint_129(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBlankPoint(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_BlankPoint_130(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlankPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_UnBlankPoint_131(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBlankPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_BlankCell_132(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlankCell(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_UnBlankCell_133(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBlankCell(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_BlankCell_134(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlankCell(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_UnBlankCell_135(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBlankCell(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkRectilinearGrid_IsPointVisible_136(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned char   temp20;
  temp0 = id0;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPointVisible(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkRectilinearGrid_IsCellVisible_137(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned char   temp20;
  temp0 = id0;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsCellVisible(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRectilinearGrid_HasAnyBlankPoints_138(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyBlankPoints();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRectilinearGrid_HasAnyBlankCells_139(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyBlankCells();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetDataDescription_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDescription();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_GetCellDims_141(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellDims(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_SetDimensions_142(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_SetDimensions_143(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRectilinearGrid_GetDimensions_144(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetDataDimension_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_ComputeStructuredCoordinates_146(JNIEnv* env, jobject obj,jdoubleArray id0,jintArray id1,jdoubleArray id2)
{
  double temp0[3];
  int temp1[3];
  double temp2[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeStructuredCoordinates(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_ComputePointId_147(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputePointId(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_ComputeCellId_148(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeCellId(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_GetPoint_149(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jdoubleArray id3)
{
  int   temp0;
  int   temp1;
  int   temp2;
  double temp3[3];
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_SetXCoordinates_150(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXCoordinates(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetXCoordinates_151(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXCoordinates();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_SetYCoordinates_152(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYCoordinates(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetYCoordinates_153(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYCoordinates();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_SetZCoordinates_154(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZCoordinates(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetZCoordinates_155(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZCoordinates();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_SetExtent_156(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_SetExtent_157(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRectilinearGrid_GetExtent_158(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetActualMemorySize_159(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_ShallowCopy_160(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_DeepCopy_161(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetExtentType_162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtentType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetData_163(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkRectilinearGrid * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRectilinearGrid_GetData_164(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkRectilinearGrid * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_SetScalarType_165(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformation * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarType(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetScalarType_166(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRectilinearGrid_HasScalarType_167(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  bool   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasScalarType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetScalarType_168(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarType();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRectilinearGrid_GetScalarTypeAsString_169(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRectilinearGrid_SetNumberOfScalarComponents_170(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformation * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfScalarComponents(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetNumberOfScalarComponents_171(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfScalarComponents(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRectilinearGrid_HasNumberOfScalarComponents_172(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  bool   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasNumberOfScalarComponents(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRectilinearGrid_GetNumberOfScalarComponents_173(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRectilinearGrid* op = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfScalarComponents();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkRectilinearGrid_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkRectilinearGrid::New());
}
