// java wrapper for vtkBalloonWidget object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkBalloonWidget.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkHoverWidget_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkBalloonWidget_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkBalloonWidget",dType)) { return me; }
  if ((res= vtkHoverWidget_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBalloonWidget_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBalloonWidget_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonWidget_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonWidget_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonWidget_SetEnabled_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnabled(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonWidget_SetRepresentation_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkBalloonRepresentation * temp0;
  temp0 = static_cast<vtkBalloonRepresentation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRepresentation(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonWidget_GetBalloonRepresentation_16(JNIEnv* env, jobject obj)
{
  vtkBalloonRepresentation * temp20;

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBalloonRepresentation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonWidget_CreateDefaultRepresentation_17(JNIEnv* env, jobject obj)
{

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateDefaultRepresentation();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonWidget_AddBalloon_18(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1,jobject id2)
{
  vtkProp * temp0;
  char * temp1;
  vtkImageData * temp2;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id2));

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddBalloon(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonWidget_AddBalloon_19(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkProp * temp0;
  char * temp1;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddBalloon(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonWidget_RemoveBalloon_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBalloon(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkBalloonWidget_GetBalloonString_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  const char * temp20;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBalloonString(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonWidget_GetBalloonImage_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  vtkImageData * temp20;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBalloonImage(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonWidget_UpdateBalloonString_113(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkProp * temp0;
  char * temp1;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateBalloonString(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonWidget_UpdateBalloonImage_114(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkProp * temp0;
  vtkImageData * temp1;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateBalloonImage(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonWidget_GetCurrentProp_115(JNIEnv* env, jobject obj)
{
  vtkProp * temp20;

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentProp();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonWidget_SetPicker_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractPropPicker * temp0;
  temp0 = static_cast<vtkAbstractPropPicker*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPicker(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBalloonWidget_GetPicker_117(JNIEnv* env, jobject obj)
{
  vtkAbstractPropPicker * temp20;

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPicker();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBalloonWidget_RegisterPickers_118(JNIEnv* env, jobject obj)
{

  vtkBalloonWidget* op = static_cast<vtkBalloonWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->RegisterPickers();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkBalloonWidget_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkBalloonWidget::New());
}
