// java wrapper for vtkPolyDataMapper object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPolyDataMapper.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMapper_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPolyDataMapper_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPolyDataMapper",dType)) { return me; }
  if ((res= vtkMapper_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyDataMapper_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyDataMapper_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_RenderPiece_14(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkActor * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderPiece(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_Render_15(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkActor * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetInputData_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyDataMapper_GetInput_17(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_Update_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_Update_19(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper_Update_110(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformationVector * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Update(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper_Update_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Update(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetPiece_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPiece(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper_GetPiece_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPiece();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetNumberOfPieces_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPieces(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper_GetNumberOfPieces_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPieces();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetNumberOfSubPieces_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfSubPieces(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper_GetNumberOfSubPieces_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSubPieces();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetGhostLevel_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGhostLevel(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper_GetGhostLevel_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGhostLevel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetSeamlessU_120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSeamlessU(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyDataMapper_GetSeamlessU_121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSeamlessU();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SeamlessUOn_122(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SeamlessUOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SeamlessUOff_123(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SeamlessUOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetSeamlessV_124(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSeamlessV(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyDataMapper_GetSeamlessV_125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSeamlessV();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SeamlessVOn_126(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SeamlessVOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SeamlessVOff_127(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SeamlessVOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetPointIdArrayName_128(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointIdArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPolyDataMapper_GetPointIdArrayName_129(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetCellIdArrayName_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellIdArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPolyDataMapper_GetCellIdArrayName_131(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetCompositeIdArrayName_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCompositeIdArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPolyDataMapper_GetCompositeIdArrayName_133(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompositeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetProcessIdArrayName_134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProcessIdArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPolyDataMapper_GetProcessIdArrayName_135(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPolyDataMapper_GetBounds_136(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_GetBounds_137(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_ShallowCopy_138(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractMapper * temp0;
  temp0 = static_cast<vtkAbstractMapper*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_MapDataArrayToVertexAttribute_139(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1,jint id2,jint id3)
{
  char * temp0;
  char * temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;
  temp3 = id3;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->MapDataArrayToVertexAttribute(temp0,temp1,temp2,temp3);
  delete[] temp0;
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_MapDataArrayToMultiTextureAttribute_140(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1,jint id2,jint id3)
{
  char * temp0;
  char * temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;
  temp3 = id3;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->MapDataArrayToMultiTextureAttribute(temp0,temp1,temp2,temp3);
  delete[] temp0;
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_RemoveVertexAttributeMapping_141(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveVertexAttributeMapping(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_RemoveAllVertexAttributeMappings_142(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllVertexAttributeMappings();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetVBOShiftScaleMethod_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVBOShiftScaleMethod(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyDataMapper_GetVBOShiftScaleMethod_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVBOShiftScaleMethod();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_SetPauseShiftScale_145(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPauseShiftScale(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyDataMapper_GetPauseShiftScale_146(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPauseShiftScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_PauseShiftScaleOn_147(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->PauseShiftScaleOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyDataMapper_PauseShiftScaleOff_148(JNIEnv* env, jobject obj)
{

  vtkPolyDataMapper* op = static_cast<vtkPolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->PauseShiftScaleOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPolyDataMapper_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPolyDataMapper::New());
}
