// java wrapper for vtkUnstructuredGridLinearRayIntegrator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkUnstructuredGridLinearRayIntegrator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkUnstructuredGridVolumeRayIntegrator_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkUnstructuredGridLinearRayIntegrator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkUnstructuredGridLinearRayIntegrator",dType)) { return me; }
  if ((res= vtkUnstructuredGridVolumeRayIntegrator_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGridLinearRayIntegrator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGridLinearRayIntegrator* op = static_cast<vtkUnstructuredGridLinearRayIntegrator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGridLinearRayIntegrator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGridLinearRayIntegrator* op = static_cast<vtkUnstructuredGridLinearRayIntegrator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGridLinearRayIntegrator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGridLinearRayIntegrator* op = static_cast<vtkUnstructuredGridLinearRayIntegrator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGridLinearRayIntegrator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGridLinearRayIntegrator* op = static_cast<vtkUnstructuredGridLinearRayIntegrator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridLinearRayIntegrator_Initialize_14(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkVolume * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUnstructuredGridLinearRayIntegrator* op = static_cast<vtkUnstructuredGridLinearRayIntegrator*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridLinearRayIntegrator_Integrate_15(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jfloatArray id3)
{
  vtkDoubleArray * temp0;
  vtkDataArray * temp1;
  vtkDataArray * temp2;
  float temp3[4];
  temp0 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id2));
  env->GetFloatArrayRegion(id3, 0, 4, &temp3[0]);

  vtkUnstructuredGridLinearRayIntegrator* op = static_cast<vtkUnstructuredGridLinearRayIntegrator*>(vtkJavaGetPointerFromObject(env, obj));
  op->Integrate(temp0,temp1,temp2,temp3);
  env->SetFloatArrayRegion(id3, 0, 4, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridLinearRayIntegrator_IntegrateRay_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jfloatArray id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  float temp5[4];
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  env->GetFloatArrayRegion(id5, 0, 4, &temp5[0]);

  vtkUnstructuredGridLinearRayIntegrator* op = static_cast<vtkUnstructuredGridLinearRayIntegrator*>(vtkJavaGetPointerFromObject(env, obj));
  op->IntegrateRay(temp0,temp1,temp2,temp3,temp4,temp5);
  env->SetFloatArrayRegion(id5, 0, 4, &temp5[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGridLinearRayIntegrator_IntegrateRay_17(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1,jdouble id2,jdoubleArray id3,jdouble id4,jfloatArray id5)
{
  double   temp0;
  double temp1[3];
  double   temp2;
  double temp3[3];
  double   temp4;
  float temp5[4];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = id2;
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  temp4 = id4;
  env->GetFloatArrayRegion(id5, 0, 4, &temp5[0]);

  vtkUnstructuredGridLinearRayIntegrator* op = static_cast<vtkUnstructuredGridLinearRayIntegrator*>(vtkJavaGetPointerFromObject(env, obj));
  op->IntegrateRay(temp0,temp1,temp2,temp3,temp4,temp5);
  env->SetFloatArrayRegion(id5, 0, 4, &temp5[0]);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkUnstructuredGridLinearRayIntegrator_Psi_18(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2)
{
  float   temp0;
  float   temp1;
  float   temp2;
  float   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkUnstructuredGridLinearRayIntegrator* op = static_cast<vtkUnstructuredGridLinearRayIntegrator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Psi(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkUnstructuredGridLinearRayIntegrator_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkUnstructuredGridLinearRayIntegrator::New());
}
