/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAnalyserOptions.h"

#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> ConversionResult<IDLDictionary<AnalyserOptions>> convertDictionary<AnalyserOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    AnalyserOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelCountValue.isUndefined()) {
        auto channelCountConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        if (channelCountConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.channelCount = channelCountConversionResult.releaseReturnValue();
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelCountModeValue.isUndefined()) {
        auto channelCountModeConversionResult = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        if (channelCountModeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.channelCountMode = channelCountModeConversionResult.releaseReturnValue();
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        auto channelInterpretationConversionResult = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        if (channelInterpretationConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.channelInterpretation = channelInterpretationConversionResult.releaseReturnValue();
    }
    JSValue fftSizeValue;
    if (isNullOrUndefined)
        fftSizeValue = jsUndefined();
    else {
        fftSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fftSize"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto fftSizeConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, fftSizeValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 2048 }; });
    if (fftSizeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.fftSize = fftSizeConversionResult.releaseReturnValue();
    JSValue maxDecibelsValue;
    if (isNullOrUndefined)
        maxDecibelsValue = jsUndefined();
    else {
        maxDecibelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxDecibels"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto maxDecibelsConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, maxDecibelsValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { -30 }; });
    if (maxDecibelsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.maxDecibels = maxDecibelsConversionResult.releaseReturnValue();
    JSValue minDecibelsValue;
    if (isNullOrUndefined)
        minDecibelsValue = jsUndefined();
    else {
        minDecibelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "minDecibels"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto minDecibelsConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, minDecibelsValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { -100 }; });
    if (minDecibelsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.minDecibels = minDecibelsConversionResult.releaseReturnValue();
    JSValue smoothingTimeConstantValue;
    if (isNullOrUndefined)
        smoothingTimeConstantValue = jsUndefined();
    else {
        smoothingTimeConstantValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "smoothingTimeConstant"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto smoothingTimeConstantConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, smoothingTimeConstantValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.8 }; });
    if (smoothingTimeConstantConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.smoothingTimeConstant = smoothingTimeConstantConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(WEB_AUDIO)
