/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSContactsManager.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSContactInfo.h"
#include "JSContactProperty.h"
#include "JSContactsSelectOptions.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "Navigator.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include "WorkerNavigator.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsContactsManagerPrototypeFunction_getProperties);
static JSC_DECLARE_HOST_FUNCTION(jsContactsManagerPrototypeFunction_select);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsContactsManagerConstructor);

class JSContactsManagerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSContactsManagerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSContactsManagerPrototype* ptr = new (NotNull, JSC::allocateCell<JSContactsManagerPrototype>(vm)) JSContactsManagerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSContactsManagerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSContactsManagerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSContactsManagerPrototype, JSContactsManagerPrototype::Base);

using JSContactsManagerDOMConstructor = JSDOMConstructorNotConstructable<JSContactsManager>;

template<> const ClassInfo JSContactsManagerDOMConstructor::s_info = { "ContactsManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSContactsManagerDOMConstructor) };

template<> JSValue JSContactsManagerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSContactsManagerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ContactsManager"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSContactsManager::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSContactsManagerPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsContactsManagerConstructor, 0 } },
    HashTableValue { "getProperties"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsContactsManagerPrototypeFunction_getProperties, 0 } },
    HashTableValue { "select"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsContactsManagerPrototypeFunction_select, 1 } },
};

const ClassInfo JSContactsManagerPrototype::s_info = { "ContactsManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSContactsManagerPrototype) };

void JSContactsManagerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSContactsManager::info(), JSContactsManagerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSContactsManager::s_info = { "ContactsManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSContactsManager) };

JSContactsManager::JSContactsManager(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ContactsManager>&& impl)
    : JSDOMWrapper<ContactsManager>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, ContactsManager>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSContactsManager::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSContactsManagerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSContactsManagerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSContactsManager::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSContactsManager>(vm, globalObject);
}

JSValue JSContactsManager::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSContactsManagerDOMConstructor, DOMConstructorID::ContactsManager>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSContactsManager::destroy(JSC::JSCell* cell)
{
    JSContactsManager* thisObject = static_cast<JSContactsManager*>(cell);
    thisObject->JSContactsManager::~JSContactsManager();
}

JSC_DEFINE_CUSTOM_GETTER(jsContactsManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSContactsManagerPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSContactsManager::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsContactsManagerPrototypeFunction_getPropertiesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSContactsManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLSequence<IDLEnumeration<ContactProperty>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getProperties(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsContactsManagerPrototypeFunction_getProperties, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSContactsManager>::call<jsContactsManagerPrototypeFunction_getPropertiesBody>(*lexicalGlobalObject, *callFrame, "getProperties");
}

static inline JSC::EncodedJSValue jsContactsManagerPrototypeFunction_selectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSContactsManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto propertiesConversionResult = convert<IDLSequence<IDLEnumeration<ContactProperty>>>(*lexicalGlobalObject, argument0.value());
    if (propertiesConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<ContactsSelectOptions>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLSequence<IDLDictionary<ContactInfo>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.select(propertiesConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsContactsManagerPrototypeFunction_select, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSContactsManager>::call<jsContactsManagerPrototypeFunction_selectBody>(*lexicalGlobalObject, *callFrame, "select");
}

JSC::GCClient::IsoSubspace* JSContactsManager::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSContactsManager, UseCustomHeapCellType::No>(vm, "JSContactsManager"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForContactsManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForContactsManager = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForContactsManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForContactsManager = std::forward<decltype(space)>(space); }
    );
}

void JSContactsManager::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSContactsManager*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSContactsManagerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsContactsManager = jsCast<JSContactsManager*>(handle.slot()->asCell());
    NavigatorBase* owner = WTF::getPtr(jsContactsManager->wrapped().navigator());
    if (!owner)
        return false;
    if (reason) [[unlikely]]
        *reason = "Reachable from Navigator"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSContactsManagerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsContactsManager = static_cast<JSContactsManager*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsContactsManager->protectedWrapped().ptr(), jsContactsManager);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ContactsManager@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15ContactsManagerE[]; }
#endif
template<std::same_as<ContactsManager> T>
static inline void verifyVTable(ContactsManager* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ContactsManager@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15ContactsManagerE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ContactsManager has subclasses. If ContactsManager has subclasses that get passed
        // to toJS() we currently require ContactsManager you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ContactsManager>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ContactsManager>(impl.ptr());
#endif
    return createWrapper<ContactsManager>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ContactsManager& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ContactsManager* JSContactsManager::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSContactsManager*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
