/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUShaderModuleCompilationHint.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUAutoLayoutMode.h"
#include "JSGPUPipelineLayout.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUShaderModuleCompilationHint>> convertDictionary<GPUShaderModuleCompilationHint>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUShaderModuleCompilationHint result;
    JSValue layoutValue;
    if (isNullOrUndefined)
        layoutValue = jsUndefined();
    else {
        layoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "layout"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (layoutValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "layout"_s, "GPUShaderModuleCompilationHint"_s, "(GPUPipelineLayout or GPUAutoLayoutMode)"_s);
        return ConversionResultException { };
    }
    auto layoutConversionResult = convert<IDLUnion<IDLInterface<GPUPipelineLayout>, IDLEnumeration<GPUAutoLayoutMode>>>(lexicalGlobalObject, layoutValue);
    if (layoutConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.layout = layoutConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

