/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLImageElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "DOMPromiseProxy.h"
#include "DeprecatedGlobalSettings.h"
#include "Document.h"
#include "DocumentInlines.h"
#include "ElementInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "HTMLNames.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMLegacyFactoryFunction.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(HTMLImageElement::LoadingValues enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("lazy"),
        MAKE_STATIC_STRING_IMPL("eager"),
    };
    static_assert(static_cast<size_t>(HTMLImageElement::LoadingValues::Lazy) == 0, "HTMLImageElement::LoadingValues::Lazy is not 0 as expected");
    static_assert(static_cast<size_t>(HTMLImageElement::LoadingValues::Eager) == 1, "HTMLImageElement::LoadingValues::Eager is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, HTMLImageElement::LoadingValues enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<HTMLImageElement::LoadingValues> parseEnumerationFromString<HTMLImageElement::LoadingValues>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, HTMLImageElement::LoadingValues>, 2> mappings {
        std::pair<ComparableASCIILiteral, HTMLImageElement::LoadingValues> { "eager"_s, HTMLImageElement::LoadingValues::Eager },
        std::pair<ComparableASCIILiteral, HTMLImageElement::LoadingValues> { "lazy"_s, HTMLImageElement::LoadingValues::Lazy },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<HTMLImageElement::LoadingValues> parseEnumeration<HTMLImageElement::LoadingValues>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<HTMLImageElement::LoadingValues>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<HTMLImageElement::LoadingValues>()
{
    return "\"lazy\", \"eager\""_s;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsHTMLImageElementPrototypeFunction_decode);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_alt);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_alt);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_src);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_src);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_srcset);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_srcset);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_sizes);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_sizes);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_crossOrigin);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_crossOrigin);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_useMap);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_useMap);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_isMap);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_isMap);
#if ENABLE(SPATIAL_IMAGE_CONTROLS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_controls);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_controls);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_width);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_width);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_height);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_height);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_naturalHeight);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_naturalWidth);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_complete);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_currentSrc);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_referrerPolicy);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_referrerPolicy);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_decoding);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_decoding);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_loading);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_loading);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_name);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_name);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_lowsrc);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_lowsrc);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_align);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_align);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_hspace);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_hspace);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_vspace);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_vspace);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_longDesc);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_longDesc);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_border);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_border);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_fetchPriority);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_fetchPriority);
#if ENABLE(ATTACHMENT_ELEMENT)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_attachmentIdentifier);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_x);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_y);

class JSHTMLImageElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLImageElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLImageElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLImageElementPrototype>(vm)) JSHTMLImageElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLImageElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLImageElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLImageElementPrototype, JSHTMLImageElementPrototype::Base);

using JSHTMLImageElementDOMConstructor = JSDOMConstructorNotConstructable<JSHTMLImageElement>;
using JSHTMLImageElementLegacyFactoryFunction = JSDOMLegacyFactoryFunction<JSHTMLImageElement>;

template<> const ClassInfo JSHTMLImageElementDOMConstructor::s_info = { "HTMLImageElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLImageElementDOMConstructor) };

template<> JSValue JSHTMLImageElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLImageElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "HTMLImageElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLImageElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSHTMLImageElementLegacyFactoryFunction::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSHTMLImageElementLegacyFactoryFunction*>(callFrame->jsCallee());
    ASSERT(castedThis);
    RefPtr context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "HTMLImageElement"_s);
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto widthConversionResult = convert<IDLOptional<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (widthConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto heightConversionResult = convert<IDLOptional<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value());
    if (heightConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = HTMLImageElement::createForLegacyFactoryFunction(document.get(), widthConversionResult.releaseReturnValue(), heightConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<HTMLImageElement>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSHTMLImageElementLegacyFactoryFunctionConstruct, JSHTMLImageElementLegacyFactoryFunction::construct);

template<> const ClassInfo JSHTMLImageElementLegacyFactoryFunction::s_info = { "Image"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLImageElementLegacyFactoryFunction) };

template<> JSValue JSHTMLImageElementLegacyFactoryFunction::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSHTMLImageElementLegacyFactoryFunction::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Image"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLImageElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 30> JSHTMLImageElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElementConstructor, 0 } },
    HashTableValue { "alt"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_alt, setJSHTMLImageElement_alt } },
    HashTableValue { "src"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_src, setJSHTMLImageElement_src } },
    HashTableValue { "srcset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_srcset, setJSHTMLImageElement_srcset } },
    HashTableValue { "sizes"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_sizes, setJSHTMLImageElement_sizes } },
    HashTableValue { "crossOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_crossOrigin, setJSHTMLImageElement_crossOrigin } },
    HashTableValue { "useMap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_useMap, setJSHTMLImageElement_useMap } },
    HashTableValue { "isMap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_isMap, setJSHTMLImageElement_isMap } },
#if ENABLE(SPATIAL_IMAGE_CONTROLS)
    HashTableValue { "controls"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_controls, setJSHTMLImageElement_controls } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_width, setJSHTMLImageElement_width } },
    HashTableValue { "height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_height, setJSHTMLImageElement_height } },
    HashTableValue { "naturalHeight"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_naturalHeight, 0 } },
    HashTableValue { "naturalWidth"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_naturalWidth, 0 } },
    HashTableValue { "complete"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_complete, 0 } },
    HashTableValue { "currentSrc"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_currentSrc, 0 } },
    HashTableValue { "referrerPolicy"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_referrerPolicy, setJSHTMLImageElement_referrerPolicy } },
    HashTableValue { "decoding"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_decoding, setJSHTMLImageElement_decoding } },
    HashTableValue { "loading"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_loading, setJSHTMLImageElement_loading } },
    HashTableValue { "name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_name, setJSHTMLImageElement_name } },
    HashTableValue { "lowsrc"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_lowsrc, setJSHTMLImageElement_lowsrc } },
    HashTableValue { "align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_align, setJSHTMLImageElement_align } },
    HashTableValue { "hspace"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_hspace, setJSHTMLImageElement_hspace } },
    HashTableValue { "vspace"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_vspace, setJSHTMLImageElement_vspace } },
    HashTableValue { "longDesc"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_longDesc, setJSHTMLImageElement_longDesc } },
    HashTableValue { "border"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_border, setJSHTMLImageElement_border } },
    HashTableValue { "fetchPriority"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_fetchPriority, setJSHTMLImageElement_fetchPriority } },
#if ENABLE(ATTACHMENT_ELEMENT)
    HashTableValue { "attachmentIdentifier"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_attachmentIdentifier, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "x"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_x, 0 } },
    HashTableValue { "y"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_y, 0 } },
    HashTableValue { "decode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLImageElementPrototypeFunction_decode, 0 } },
};

const ClassInfo JSHTMLImageElementPrototype::s_info = { "HTMLImageElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLImageElementPrototype) };

void JSHTMLImageElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLImageElement::info(), JSHTMLImageElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(SPATIAL_IMAGE_CONTROLS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().spatialImageControlsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "controls"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().lazyImageLoadingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "loading"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(ATTACHMENT_ELEMENT)
    if (!DeprecatedGlobalSettings::attachmentElementEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "attachmentIdentifier"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSHTMLImageElement::s_info = { "HTMLImageElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLImageElement) };

JSHTMLImageElement::JSHTMLImageElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLImageElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

Ref<HTMLImageElement> JSHTMLImageElement::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, HTMLImageElement>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSHTMLImageElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSHTMLImageElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSHTMLImageElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSHTMLImageElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLImageElement>(vm, globalObject);
}

JSValue JSHTMLImageElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLImageElementDOMConstructor, DOMConstructorID::HTMLImageElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSValue JSHTMLImageElement::getLegacyFactoryFunction(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLImageElementLegacyFactoryFunction, DOMConstructorID::HTMLImageElementLegacyFactory>(vm, *jsCast<JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLImageElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLImageElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsHTMLImageElement_altGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::altAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_alt, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_altGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_altSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::altAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_alt, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_altSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_srcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.getURLAttributeForBindings(WebCore::HTMLNames::srcAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_src, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_srcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_srcSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_src, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_srcSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_srcsetGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.srcsetForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_srcset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_srcsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_srcsetSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcsetAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_srcset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_srcsetSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_sizesGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::sizesAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_sizes, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_sizesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_sizesSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::sizesAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_sizes, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_sizesSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_crossOriginGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(lexicalGlobalObject, throwScope, impl.crossOrigin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_crossOrigin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_crossOriginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_crossOriginSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::crossoriginAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_crossOrigin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_crossOriginSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_useMapGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::usemapAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_useMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_useMapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_useMapSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::usemapAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_useMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_useMapSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_isMapGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::ismapAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_isMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_isMapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_isMapSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::ismapAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_isMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_isMapSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(SPATIAL_IMAGE_CONTROLS)
static inline JSValue jsHTMLImageElement_controlsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::controlsAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_controls, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_controlsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(SPATIAL_IMAGE_CONTROLS)
static inline bool setJSHTMLImageElement_controlsSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::controlsAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_controls, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_controlsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSValue jsHTMLImageElement_widthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_widthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::widthAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_widthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_heightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_heightSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::heightAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_heightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_naturalHeightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.naturalHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_naturalHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_naturalHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLImageElement_naturalWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.naturalWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_naturalWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_naturalWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLImageElement_completeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.complete())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_complete, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_completeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLImageElement_currentSrcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.currentSrc())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_currentSrc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_currentSrcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLImageElement_referrerPolicyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.referrerPolicyForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_referrerPolicy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_referrerPolicyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_referrerPolicySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::referrerpolicyAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_referrerPolicy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_referrerPolicySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_decodingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.decoding())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_decoding, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_decodingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_decodingSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::decodingAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_decoding, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_decodingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_loadingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    const AtomString& contentAttributeValue = impl.attributeWithoutSynchronization(WebCore::HTMLNames::loadingAttr);
    AtomString result;
    if (contentAttributeValue.isNull())
        result = AtomString("eager"_s);
    else if (auto value = parseEnumerationFromString<HTMLImageElement::LoadingValues>(contentAttributeValue.convertToASCIILowercase()); value) [[likely]]
        result = AtomString(convertEnumerationToString(*value));
    else
        result = AtomString("eager"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, result)));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_loading, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_loadingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_loadingSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::loadingAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_loading, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_loadingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_nameGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.getNameAttribute())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_nameSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_nameSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_lowsrcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.getURLAttributeForBindings(WebCore::HTMLNames::lowsrcAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_lowsrc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_lowsrcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_lowsrcSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::lowsrcAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_lowsrc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_lowsrcSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_alignGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::alignAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_align, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_alignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_alignSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::alignAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_align, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_alignSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_hspaceGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.integralAttribute(WebCore::HTMLNames::hspaceAttr)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_hspace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_hspaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_hspaceSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::hspaceAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_hspace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_hspaceSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_vspaceGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.integralAttribute(WebCore::HTMLNames::vspaceAttr)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_vspace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_vspaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_vspaceSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::vspaceAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_vspace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_vspaceSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_longDescGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.getURLAttributeForBindings(WebCore::HTMLNames::longdescAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_longDesc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_longDescGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_longDescSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::longdescAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_longDesc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_longDescSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_borderGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::borderAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_border, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_borderGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_borderSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::borderAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_border, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_borderSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_fetchPriorityGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.fetchPriorityForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_fetchPriority, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_fetchPriorityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_fetchPrioritySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::fetchpriorityAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_fetchPriority, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_fetchPrioritySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(ATTACHMENT_ELEMENT)
static inline JSValue jsHTMLImageElement_attachmentIdentifierGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attachmentIdentifier())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_attachmentIdentifier, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_attachmentIdentifierGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsHTMLImageElement_xGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.x())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLImageElement_yGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.y())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsHTMLImageElementPrototypeFunction_decodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLImageElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.decode(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLImageElementPrototypeFunction_decode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSHTMLImageElement>::call<jsHTMLImageElementPrototypeFunction_decodeBody>(*lexicalGlobalObject, *callFrame, "decode");
}

JSC::GCClient::IsoSubspace* JSHTMLImageElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSHTMLImageElement, UseCustomHeapCellType::No>(vm, "JSHTMLImageElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForHTMLImageElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForHTMLImageElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForHTMLImageElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForHTMLImageElement = std::forward<decltype(space)>(space); }
    );
}

void JSHTMLImageElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLImageElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSHTMLImageElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsHTMLImageElement = jsCast<JSHTMLImageElement*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsHTMLImageElement->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor, reason))
        return true;
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSHTMLImageElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLImageElement = static_cast<JSHTMLImageElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsHTMLImageElement->protectedWrapped().ptr(), jsHTMLImageElement);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7HTMLImageElement@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16HTMLImageElementE[]; }
#endif
template<std::same_as<HTMLImageElement> T>
static inline void verifyVTable(HTMLImageElement* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7HTMLImageElement@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16HTMLImageElementE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // HTMLImageElement has subclasses. If HTMLImageElement has subclasses that get passed
        // to toJS() we currently require HTMLImageElement you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<HTMLImageElement>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<HTMLImageElement>(impl.ptr());
#endif
    return createWrapper<HTMLImageElement>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, HTMLImageElement& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

HTMLImageElement* JSHTMLImageElement::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLImageElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
