/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSShadowRealmGlobalScope.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "EventTargetInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSAbortController.h"
#include "JSAbortSignal.h"
#include "JSByteLengthQueuingStrategy.h"
#include "JSCompressionStream.h"
#include "JSCompressionStreamEncoder.h"
#include "JSCountQueuingStrategy.h"
#include "JSCustomEvent.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMURL.h"
#include "JSDOMWrapperCache.h"
#include "JSDecompressionStream.h"
#include "JSDecompressionStreamDecoder.h"
#include "JSErrorEvent.h"
#include "JSEvent.h"
#include "JSEventTarget.h"
#include "JSPerformance.h"
#include "JSPerformanceEntry.h"
#include "JSPerformanceMark.h"
#include "JSPerformanceMeasure.h"
#include "JSPerformanceObserver.h"
#include "JSPerformanceObserverEntryList.h"
#include "JSPerformanceResourceTiming.h"
#include "JSPerformanceServerTiming.h"
#include "JSPromiseRejectionEvent.h"
#include "JSReadableByteStreamController.h"
#include "JSReadableStream.h"
#include "JSReadableStreamBYOBReader.h"
#include "JSReadableStreamBYOBRequest.h"
#include "JSReadableStreamDefaultController.h"
#include "JSReadableStreamDefaultReader.h"
#include "JSShadowRealmGlobalScope.h"
#include "JSTextDecoder.h"
#include "JSTextDecoderStream.h"
#include "JSTextEncoder.h"
#include "JSTextEncoderStream.h"
#include "JSTransformStream.h"
#include "JSTransformStreamDefaultController.h"
#include "JSURLSearchParams.h"
#include "JSWritableStream.h"
#include "JSWritableStreamDefaultController.h"
#include "JSWritableStreamDefaultWriter.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "ShadowRealmGlobalScope.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_self);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_CompressionStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_CompressionStreamEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_DecompressionStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_DecompressionStreamDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ByteLengthQueuingStrategyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_CountQueuingStrategyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableByteStreamControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableStreamBYOBReaderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableStreamBYOBRequestConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableStreamDefaultReaderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TransformStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TransformStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_WritableStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_WritableStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_WritableStreamDefaultWriterConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_AbortControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_AbortSignalConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_CustomEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ErrorEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_EventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_EventTargetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PromiseRejectionEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TextDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TextDecoderStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TextEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TextEncoderStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_URLConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_URLSearchParamsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceEntryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceMarkConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceMeasureConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceObserverConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceObserverEntryListConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceResourceTimingConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceServerTimingConstructor);

/* Hash table */

static const struct CompactHashIndex JSShadowRealmGlobalScopeTableIndex[16] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 0, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
};


static const std::array<HashTableValue, 1> JSShadowRealmGlobalScopeTableValues {
    HashTableValue { "self"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsShadowRealmGlobalScope_self, 0 } },
};

static const HashTable JSShadowRealmGlobalScopeTable = { 1, 15, static_cast<uint8_t>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::ReadOnly), JSShadowRealmGlobalScope::info(), JSShadowRealmGlobalScopeTableValues.data(), JSShadowRealmGlobalScopeTableIndex };
const ClassInfo JSShadowRealmGlobalScope::s_info = { "ShadowRealmGlobalScope"_s, &Base::s_info, &JSShadowRealmGlobalScopeTable, nullptr, CREATE_METHOD_TABLE(JSShadowRealmGlobalScope) };

JSShadowRealmGlobalScope::JSShadowRealmGlobalScope(VM& vm, Structure* structure, Ref<ShadowRealmGlobalScope>&& impl)
    : JSShadowRealmGlobalScopeBase(vm, structure, WTFMove(impl))
{
}

Ref<ShadowRealmGlobalScope> JSShadowRealmGlobalScope::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, ShadowRealmGlobalScope>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

void JSShadowRealmGlobalScope::finishCreation(VM& vm, JSGlobalProxy* proxy)
{
    Base::finishCreation(vm, proxy);

    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CompressionStreamPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_CompressionStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).CompressionStreamEncoderPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_CompressionStreamEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).DecompressionStreamPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_DecompressionStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).DecompressionStreamDecoderPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_DecompressionStreamDecoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).ByteLengthQueuingStrategyPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_ByteLengthQueuingStrategyConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CountQueuingStrategyPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_CountQueuingStrategyConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).ReadableByteStreamControllerPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_ReadableByteStreamControllerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_ReadableStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_ReadableStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamBYOBReaderPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_ReadableStreamBYOBReaderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamBYOBRequestPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_ReadableStreamBYOBRequestConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultControllerPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_ReadableStreamDefaultControllerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_ReadableStreamDefaultControllerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultReaderPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_ReadableStreamDefaultReaderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultReaderPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_ReadableStreamDefaultReaderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_TransformStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_TransformStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamDefaultControllerPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_TransformStreamDefaultControllerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_TransformStreamDefaultControllerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_WritableStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_WritableStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultControllerPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_WritableStreamDefaultControllerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_WritableStreamDefaultControllerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultWriterPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_WritableStreamDefaultWriterConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultWriterPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_WritableStreamDefaultWriterConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).AbortControllerPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_AbortControllerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).AbortSignalPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_AbortSignalConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).AbortSignalPrivateName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_AbortSignalConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CustomEventPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_CustomEventConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).ErrorEventPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_ErrorEventConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).EventPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_EventConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).EventTargetPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_EventTargetConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PromiseRejectionEventPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_PromiseRejectionEventConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).TextDecoderPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_TextDecoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).TextDecoderStreamPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_TextDecoderStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).TextEncoderPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_TextEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).TextEncoderStreamPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_TextEncoderStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).URLPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_URLConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).URLSearchParamsPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_URLSearchParamsConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PerformancePublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_PerformanceConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PerformanceEntryPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_PerformanceEntryConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PerformanceMarkPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_PerformanceMarkConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PerformanceMeasurePublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_PerformanceMeasureConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PerformanceObserverPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_PerformanceObserverConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PerformanceObserverEntryListPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_PerformanceObserverEntryListConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PerformanceResourceTimingPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_PerformanceResourceTimingConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webAPIsInShadowRealmEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PerformanceServerTimingPublicName(), CustomGetterSetter::create(vm, jsShadowRealmGlobalScope_PerformanceServerTimingConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
}

static inline JSValue jsShadowRealmGlobalScope_selfGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<ShadowRealmGlobalScope>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.self())));
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_self, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_selfGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_CompressionStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCompressionStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_CompressionStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_CompressionStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_CompressionStreamEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCompressionStreamEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_CompressionStreamEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_CompressionStreamEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_DecompressionStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDecompressionStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_DecompressionStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_DecompressionStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_DecompressionStreamDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDecompressionStreamDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_DecompressionStreamDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_DecompressionStreamDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_ByteLengthQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSByteLengthQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ByteLengthQueuingStrategyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_ByteLengthQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_CountQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCountQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_CountQueuingStrategyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_CountQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_ReadableByteStreamControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableByteStreamController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableByteStreamControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_ReadableByteStreamControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_ReadableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_ReadableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_ReadableStreamBYOBReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamBYOBReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableStreamBYOBReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_ReadableStreamBYOBReaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_ReadableStreamBYOBRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamBYOBRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableStreamBYOBRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_ReadableStreamBYOBRequestConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_ReadableStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_ReadableStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_ReadableStreamDefaultReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamDefaultReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ReadableStreamDefaultReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_ReadableStreamDefaultReaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_TransformStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTransformStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TransformStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_TransformStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_TransformStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTransformStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TransformStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_TransformStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_WritableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_WritableStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_WritableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_WritableStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_WritableStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_WritableStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_WritableStreamDefaultWriterConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStreamDefaultWriter::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_WritableStreamDefaultWriterConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_WritableStreamDefaultWriterConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_AbortControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSAbortController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_AbortControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_AbortControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_AbortSignalConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSAbortSignal::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_AbortSignalConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_AbortSignalConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_CustomEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCustomEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_CustomEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_CustomEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_ErrorEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSErrorEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_ErrorEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_ErrorEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_EventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_EventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_EventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_EventTargetConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSEventTarget::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_EventTargetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_EventTargetConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_PromiseRejectionEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPromiseRejectionEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PromiseRejectionEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_PromiseRejectionEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_TextDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TextDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_TextDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_TextDecoderStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDecoderStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TextDecoderStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_TextDecoderStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_TextEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TextEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_TextEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_TextEncoderStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextEncoderStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_TextEncoderStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_TextEncoderStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_URLConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMURL::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_URLConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_URLConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_URLSearchParamsConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSURLSearchParams::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_URLSearchParamsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_URLSearchParamsConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_PerformanceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformance::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_PerformanceConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_PerformanceEntryConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceEntry::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceEntryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_PerformanceEntryConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_PerformanceMarkConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceMark::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceMarkConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_PerformanceMarkConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_PerformanceMeasureConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceMeasure::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceMeasureConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_PerformanceMeasureConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_PerformanceObserverConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceObserver::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceObserverConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_PerformanceObserverConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_PerformanceObserverEntryListConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceObserverEntryList::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceObserverEntryListConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_PerformanceObserverEntryListConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_PerformanceResourceTimingConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceResourceTiming::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceResourceTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_PerformanceResourceTimingConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsShadowRealmGlobalScope_PerformanceServerTimingConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSShadowRealmGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceServerTiming::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsShadowRealmGlobalScope_PerformanceServerTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSShadowRealmGlobalScope>::get<jsShadowRealmGlobalScope_PerformanceServerTimingConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSShadowRealmGlobalScope::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSShadowRealmGlobalScope, UseCustomHeapCellType::Yes>(vm, "JSShadowRealmGlobalScope"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForShadowRealmGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForShadowRealmGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForShadowRealmGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForShadowRealmGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& server) -> JSC::HeapCellType& { return server.m_heapCellTypeForJSShadowRealmGlobalScope; }
    );
}

void JSShadowRealmGlobalScope::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSShadowRealmGlobalScope*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
