/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioWorkletProcessor.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSMessagePort.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAudioWorkletProcessorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioWorkletProcessor_port);

class JSAudioWorkletProcessorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioWorkletProcessorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioWorkletProcessorPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioWorkletProcessorPrototype>(vm)) JSAudioWorkletProcessorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioWorkletProcessorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioWorkletProcessorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioWorkletProcessorPrototype, JSAudioWorkletProcessorPrototype::Base);

using JSAudioWorkletProcessorDOMConstructor = JSDOMConstructor<JSAudioWorkletProcessor>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSAudioWorkletProcessorDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSAudioWorkletProcessorDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "AudioWorkletProcessor"_s);
    auto object = AudioWorkletProcessor::create(*context);
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<AudioWorkletProcessor>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<AudioWorkletProcessor>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSAudioWorkletProcessorDOMConstructorConstruct, JSAudioWorkletProcessorDOMConstructor::construct);

template<> const ClassInfo JSAudioWorkletProcessorDOMConstructor::s_info = { "AudioWorkletProcessor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioWorkletProcessorDOMConstructor) };

template<> JSValue JSAudioWorkletProcessorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAudioWorkletProcessorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioWorkletProcessor"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAudioWorkletProcessor::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSAudioWorkletProcessorPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioWorkletProcessorConstructor, 0 } },
    HashTableValue { "port"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioWorkletProcessor_port, 0 } },
};

const ClassInfo JSAudioWorkletProcessorPrototype::s_info = { "AudioWorkletProcessor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioWorkletProcessorPrototype) };

void JSAudioWorkletProcessorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioWorkletProcessor::info(), JSAudioWorkletProcessorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAudioWorkletProcessor::s_info = { "AudioWorkletProcessor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioWorkletProcessor) };

JSAudioWorkletProcessor::JSAudioWorkletProcessor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioWorkletProcessor>&& impl)
    : JSDOMWrapper<AudioWorkletProcessor>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, AudioWorkletProcessor>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSAudioWorkletProcessor::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAudioWorkletProcessorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSAudioWorkletProcessorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSAudioWorkletProcessor::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioWorkletProcessor>(vm, globalObject);
}

JSValue JSAudioWorkletProcessor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioWorkletProcessorDOMConstructor, DOMConstructorID::AudioWorkletProcessor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAudioWorkletProcessor::destroy(JSC::JSCell* cell)
{
    JSAudioWorkletProcessor* thisObject = static_cast<JSAudioWorkletProcessor*>(cell);
    thisObject->JSAudioWorkletProcessor::~JSAudioWorkletProcessor();
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioWorkletProcessorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioWorkletProcessorPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioWorkletProcessor::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsAudioWorkletProcessor_portGetter(JSGlobalObject& lexicalGlobalObject, JSAudioWorkletProcessor& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MessagePort>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.port())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioWorkletProcessor_port, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioWorkletProcessor>::get<jsAudioWorkletProcessor_portGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSAudioWorkletProcessor::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAudioWorkletProcessor, UseCustomHeapCellType::No>(vm, "JSAudioWorkletProcessor"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAudioWorkletProcessor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAudioWorkletProcessor = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAudioWorkletProcessor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAudioWorkletProcessor = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSAudioWorkletProcessor::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSAudioWorkletProcessor*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSAudioWorkletProcessor);

template<typename Visitor>
void JSAudioWorkletProcessor::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSAudioWorkletProcessor*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSAudioWorkletProcessor::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSAudioWorkletProcessor::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSAudioWorkletProcessor::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioWorkletProcessor*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioWorkletProcessorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsAudioWorkletProcessor = jsCast<JSAudioWorkletProcessor*>(handle.slot()->asCell());
    AudioWorkletProcessor* owner = &jsAudioWorkletProcessor->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from AudioWorkletProcessor"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSAudioWorkletProcessorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioWorkletProcessor = static_cast<JSAudioWorkletProcessor*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAudioWorkletProcessor->protectedWrapped().ptr(), jsAudioWorkletProcessor);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioWorkletProcessor@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21AudioWorkletProcessorE[]; }
#endif
template<std::same_as<AudioWorkletProcessor> T>
static inline void verifyVTable(AudioWorkletProcessor* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7AudioWorkletProcessor@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21AudioWorkletProcessorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // AudioWorkletProcessor has subclasses. If AudioWorkletProcessor has subclasses that get passed
        // to toJS() we currently require AudioWorkletProcessor you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioWorkletProcessor>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<AudioWorkletProcessor>(impl.ptr());
#endif
    return createWrapper<AudioWorkletProcessor>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioWorkletProcessor& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

AudioWorkletProcessor* JSAudioWorkletProcessor::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioWorkletProcessor*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
