/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSNestedDeclarations.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSStyleProperties.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSNestedDeclarationsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSNestedDeclarations_style);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSNestedDeclarations_style);

class JSCSSNestedDeclarationsPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSNestedDeclarationsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSNestedDeclarationsPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSNestedDeclarationsPrototype>(vm)) JSCSSNestedDeclarationsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSNestedDeclarationsPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSNestedDeclarationsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSNestedDeclarationsPrototype, JSCSSNestedDeclarationsPrototype::Base);

using JSCSSNestedDeclarationsDOMConstructor = JSDOMConstructorNotConstructable<JSCSSNestedDeclarations>;

template<> const ClassInfo JSCSSNestedDeclarationsDOMConstructor::s_info = { "CSSNestedDeclarations"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSNestedDeclarationsDOMConstructor) };

template<> JSValue JSCSSNestedDeclarationsDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSRule::getConstructor(vm, &globalObject);
}

template<> void JSCSSNestedDeclarationsDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSNestedDeclarations"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSNestedDeclarations::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSCSSNestedDeclarationsPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSNestedDeclarationsConstructor, 0 } },
    HashTableValue { "style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSNestedDeclarations_style, setJSCSSNestedDeclarations_style } },
};

const ClassInfo JSCSSNestedDeclarationsPrototype::s_info = { "CSSNestedDeclarations"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSNestedDeclarationsPrototype) };

void JSCSSNestedDeclarationsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSNestedDeclarations::info(), JSCSSNestedDeclarationsPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSNestedDeclarations::s_info = { "CSSNestedDeclarations"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSNestedDeclarations) };

JSCSSNestedDeclarations::JSCSSNestedDeclarations(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSNestedDeclarations>&& impl)
    : JSCSSRule(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSNestedDeclarations> JSCSSNestedDeclarations::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSNestedDeclarations>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSNestedDeclarations::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSNestedDeclarationsPrototype::createStructure(vm, &globalObject, JSCSSRule::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSNestedDeclarationsPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSNestedDeclarations::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSNestedDeclarations>(vm, globalObject);
}

JSValue JSCSSNestedDeclarations::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSNestedDeclarationsDOMConstructor, DOMConstructorID::CSSNestedDeclarations>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSNestedDeclarationsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSNestedDeclarationsPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSNestedDeclarations::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSNestedDeclarations_styleGetter(JSGlobalObject& lexicalGlobalObject, JSCSSNestedDeclarations& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSStyleProperties>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.style())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSNestedDeclarations_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSNestedDeclarations>::get<jsCSSNestedDeclarations_styleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSNestedDeclarations_styleSetter(JSGlobalObject& lexicalGlobalObject, JSCSSNestedDeclarations& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto id = Identifier::fromString(vm, "style"_s);
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!valueToForwardTo.isObject()) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, "cssText"_s);
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable()->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSNestedDeclarations_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSNestedDeclarations>::set<setJSCSSNestedDeclarations_styleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSNestedDeclarations::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSNestedDeclarations, UseCustomHeapCellType::No>(vm, "JSCSSNestedDeclarations"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSNestedDeclarations.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSNestedDeclarations = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSNestedDeclarations.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSNestedDeclarations = std::forward<decltype(space)>(space); }
    );
}

void JSCSSNestedDeclarations::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSNestedDeclarations*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
