/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDeprecatedCSSOMRect.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSDeprecatedCSSOMPrimitiveValue.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMRectConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMRect_top);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMRect_right);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMRect_bottom);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMRect_left);

class JSDeprecatedCSSOMRectPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeprecatedCSSOMRectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeprecatedCSSOMRectPrototype* ptr = new (NotNull, JSC::allocateCell<JSDeprecatedCSSOMRectPrototype>(vm)) JSDeprecatedCSSOMRectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMRectPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeprecatedCSSOMRectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMRectPrototype, JSDeprecatedCSSOMRectPrototype::Base);

using JSDeprecatedCSSOMRectDOMConstructor = JSDOMConstructorNotConstructable<JSDeprecatedCSSOMRect>;

template<> const ClassInfo JSDeprecatedCSSOMRectDOMConstructor::s_info = { "Rect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRectDOMConstructor) };

template<> JSValue JSDeprecatedCSSOMRectDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDeprecatedCSSOMRectDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Rect"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDeprecatedCSSOMRect::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSDeprecatedCSSOMRectPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMRectConstructor, 0 } },
    HashTableValue { "top"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMRect_top, 0 } },
    HashTableValue { "right"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMRect_right, 0 } },
    HashTableValue { "bottom"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMRect_bottom, 0 } },
    HashTableValue { "left"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMRect_left, 0 } },
};

const ClassInfo JSDeprecatedCSSOMRectPrototype::s_info = { "Rect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRectPrototype) };

void JSDeprecatedCSSOMRectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeprecatedCSSOMRect::info(), JSDeprecatedCSSOMRectPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDeprecatedCSSOMRect::s_info = { "Rect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRect) };

JSDeprecatedCSSOMRect::JSDeprecatedCSSOMRect(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeprecatedCSSOMRect>&& impl)
    : JSDOMWrapper<DeprecatedCSSOMRect>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DeprecatedCSSOMRect>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDeprecatedCSSOMRect::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDeprecatedCSSOMRectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDeprecatedCSSOMRectPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDeprecatedCSSOMRect::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeprecatedCSSOMRect>(vm, globalObject);
}

JSValue JSDeprecatedCSSOMRect::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeprecatedCSSOMRectDOMConstructor, DOMConstructorID::DeprecatedCSSOMRect>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDeprecatedCSSOMRect::destroy(JSC::JSCell* cell)
{
    JSDeprecatedCSSOMRect* thisObject = static_cast<JSDeprecatedCSSOMRect*>(cell);
    thisObject->JSDeprecatedCSSOMRect::~JSDeprecatedCSSOMRect();
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMRectConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMRectPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeprecatedCSSOMRect::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDeprecatedCSSOMRect_topGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRect& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.top())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMRect_top, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMRect>::get<jsDeprecatedCSSOMRect_topGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDeprecatedCSSOMRect_rightGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRect& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.right())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMRect_right, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMRect>::get<jsDeprecatedCSSOMRect_rightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDeprecatedCSSOMRect_bottomGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRect& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bottom())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMRect_bottom, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMRect>::get<jsDeprecatedCSSOMRect_bottomGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDeprecatedCSSOMRect_leftGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRect& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.left())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMRect_left, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMRect>::get<jsDeprecatedCSSOMRect_leftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSDeprecatedCSSOMRect::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDeprecatedCSSOMRect, UseCustomHeapCellType::No>(vm, "JSDeprecatedCSSOMRect"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDeprecatedCSSOMRect.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDeprecatedCSSOMRect = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDeprecatedCSSOMRect.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDeprecatedCSSOMRect = std::forward<decltype(space)>(space); }
    );
}

void JSDeprecatedCSSOMRect::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMRect*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSDeprecatedCSSOMRectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDeprecatedCSSOMRectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDeprecatedCSSOMRect = static_cast<JSDeprecatedCSSOMRect*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDeprecatedCSSOMRect->protectedWrapped().ptr(), jsDeprecatedCSSOMRect);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DeprecatedCSSOMRect@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19DeprecatedCSSOMRectE[]; }
#endif
template<std::same_as<DeprecatedCSSOMRect> T>
static inline void verifyVTable(DeprecatedCSSOMRect* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DeprecatedCSSOMRect@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19DeprecatedCSSOMRectE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DeprecatedCSSOMRect has subclasses. If DeprecatedCSSOMRect has subclasses that get passed
        // to toJS() we currently require DeprecatedCSSOMRect you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DeprecatedCSSOMRect>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<DeprecatedCSSOMRect>(impl.ptr());
#endif
    return createWrapper<DeprecatedCSSOMRect>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DeprecatedCSSOMRect& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DeprecatedCSSOMRect* JSDeprecatedCSSOMRect::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDeprecatedCSSOMRect*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
