/* Generated by wayland-scanner 1.24.0 */

#ifndef XDG_TOPLEVEL_ICON_V1_SERVER_PROTOCOL_H
#define XDG_TOPLEVEL_ICON_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_xdg_toplevel_icon_v1 The xdg_toplevel_icon_v1 protocol
 * protocol to assign icons to toplevels
 *
 * @section page_desc_xdg_toplevel_icon_v1 Description
 *
 * This protocol allows clients to set icons for their toplevel surfaces
 * either via the XDG icon stock (using an icon name), or from pixel data.
 *
 * A toplevel icon represents the individual toplevel (unlike the application
 * or launcher icon, which represents the application as a whole), and may be
 * shown in window switchers, window overviews and taskbars that list
 * individual windows.
 *
 * This document adheres to RFC 2119 when using words like "must",
 * "should", "may", etc.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 *
 * @section page_ifaces_xdg_toplevel_icon_v1 Interfaces
 * - @subpage page_iface_xdg_toplevel_icon_manager_v1 - interface to manage toplevel icons
 * - @subpage page_iface_xdg_toplevel_icon_v1 - a toplevel window icon
 * @section page_copyright_xdg_toplevel_icon_v1 Copyright
 * <pre>
 *
 * Copyright © 2023-2024 Matthias Klumpp
 * Copyright ©      2024 David Edmundson
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_buffer;
struct xdg_toplevel;
struct xdg_toplevel_icon_manager_v1;
struct xdg_toplevel_icon_v1;

#ifndef XDG_TOPLEVEL_ICON_MANAGER_V1_INTERFACE
#define XDG_TOPLEVEL_ICON_MANAGER_V1_INTERFACE
/**
 * @page page_iface_xdg_toplevel_icon_manager_v1 xdg_toplevel_icon_manager_v1
 * @section page_iface_xdg_toplevel_icon_manager_v1_desc Description
 *
 * This interface allows clients to create toplevel window icons and set
 * them on toplevel windows to be displayed to the user.
 * @section page_iface_xdg_toplevel_icon_manager_v1_api API
 * See @ref iface_xdg_toplevel_icon_manager_v1.
 */
/**
 * @defgroup iface_xdg_toplevel_icon_manager_v1 The xdg_toplevel_icon_manager_v1 interface
 *
 * This interface allows clients to create toplevel window icons and set
 * them on toplevel windows to be displayed to the user.
 */
extern const struct wl_interface xdg_toplevel_icon_manager_v1_interface;
#endif
#ifndef XDG_TOPLEVEL_ICON_V1_INTERFACE
#define XDG_TOPLEVEL_ICON_V1_INTERFACE
/**
 * @page page_iface_xdg_toplevel_icon_v1 xdg_toplevel_icon_v1
 * @section page_iface_xdg_toplevel_icon_v1_desc Description
 *
 * This interface defines a toplevel icon.
 * An icon can have a name, and multiple buffers.
 * In order to be applied, the icon must have either a name, or at least
 * one buffer assigned. Applying an empty icon (with no buffer or name) to
 * a toplevel should reset its icon to the default icon.
 *
 * It is up to compositor policy whether to prefer using a buffer or loading
 * an icon via its name. See 'set_name' and 'add_buffer' for details.
 * @section page_iface_xdg_toplevel_icon_v1_api API
 * See @ref iface_xdg_toplevel_icon_v1.
 */
/**
 * @defgroup iface_xdg_toplevel_icon_v1 The xdg_toplevel_icon_v1 interface
 *
 * This interface defines a toplevel icon.
 * An icon can have a name, and multiple buffers.
 * In order to be applied, the icon must have either a name, or at least
 * one buffer assigned. Applying an empty icon (with no buffer or name) to
 * a toplevel should reset its icon to the default icon.
 *
 * It is up to compositor policy whether to prefer using a buffer or loading
 * an icon via its name. See 'set_name' and 'add_buffer' for details.
 */
extern const struct wl_interface xdg_toplevel_icon_v1_interface;
#endif

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 * @struct xdg_toplevel_icon_manager_v1_interface
 */
struct xdg_toplevel_icon_manager_v1_interface {
	/**
	 * destroy the toplevel icon manager
	 *
	 * Destroy the toplevel icon manager. This does not destroy
	 * objects created with the manager.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a new icon instance
	 *
	 * Creates a new icon object. This icon can then be attached to a
	 * xdg_toplevel via the 'set_icon' request.
	 */
	void (*create_icon)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t id);
	/**
	 * set an icon on a toplevel window
	 *
	 * This request assigns the icon 'icon' to 'toplevel', or clears
	 * the toplevel icon if 'icon' was null. This state is
	 * double-buffered and is applied on the next wl_surface.commit of
	 * the toplevel.
	 *
	 * After making this call, the xdg_toplevel_icon_v1 provided as
	 * 'icon' can be destroyed by the client without 'toplevel' losing
	 * its icon. The xdg_toplevel_icon_v1 is immutable from this point,
	 * and any future attempts to change it must raise the
	 * 'xdg_toplevel_icon_v1.immutable' protocol error.
	 *
	 * The compositor must set the toplevel icon from either the pixel
	 * data the icon provides, or by loading a stock icon using the
	 * icon name. See the description of 'xdg_toplevel_icon_v1' for
	 * details.
	 *
	 * If 'icon' is set to null, the icon of the respective toplevel is
	 * reset to its default icon (usually the icon of the application,
	 * derived from its desktop-entry file, or a placeholder icon). If
	 * this request is passed an icon with no pixel buffers or icon
	 * name assigned, the icon must be reset just like if 'icon' was
	 * null.
	 * @param toplevel the toplevel to act on
	 */
	void (*set_icon)(struct wl_client *client,
			 struct wl_resource *resource,
			 struct wl_resource *toplevel,
			 struct wl_resource *icon);
};

#define XDG_TOPLEVEL_ICON_MANAGER_V1_ICON_SIZE 0
#define XDG_TOPLEVEL_ICON_MANAGER_V1_DONE 1

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 */
#define XDG_TOPLEVEL_ICON_MANAGER_V1_ICON_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 */
#define XDG_TOPLEVEL_ICON_MANAGER_V1_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 */
#define XDG_TOPLEVEL_ICON_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 */
#define XDG_TOPLEVEL_ICON_MANAGER_V1_CREATE_ICON_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 */
#define XDG_TOPLEVEL_ICON_MANAGER_V1_SET_ICON_SINCE_VERSION 1

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 * Sends an icon_size event to the client owning the resource.
 * @param resource_ The client's resource
 * @param size the edge size of the square icon in surface-local coordinates, e.g. 64
 */
static inline void
xdg_toplevel_icon_manager_v1_send_icon_size(struct wl_resource *resource_, int32_t size)
{
	wl_resource_post_event(resource_, XDG_TOPLEVEL_ICON_MANAGER_V1_ICON_SIZE, size);
}

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xdg_toplevel_icon_manager_v1_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, XDG_TOPLEVEL_ICON_MANAGER_V1_DONE);
}

#ifndef XDG_TOPLEVEL_ICON_V1_ERROR_ENUM
#define XDG_TOPLEVEL_ICON_V1_ERROR_ENUM
enum xdg_toplevel_icon_v1_error {
	/**
	 * the provided buffer does not satisfy requirements
	 */
	XDG_TOPLEVEL_ICON_V1_ERROR_INVALID_BUFFER = 1,
	/**
	 * the icon has already been assigned to a toplevel and must not be changed
	 */
	XDG_TOPLEVEL_ICON_V1_ERROR_IMMUTABLE = 2,
	/**
	 * the provided buffer has been destroyed before the toplevel icon
	 */
	XDG_TOPLEVEL_ICON_V1_ERROR_NO_BUFFER = 3,
};
#endif /* XDG_TOPLEVEL_ICON_V1_ERROR_ENUM */

#ifndef XDG_TOPLEVEL_ICON_V1_ERROR_ENUM_IS_VALID
#define XDG_TOPLEVEL_ICON_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_xdg_toplevel_icon_v1
 * Validate a xdg_toplevel_icon_v1 error value.
 *
 * @return true on success, false on error.
 * @ref xdg_toplevel_icon_v1_error
 */
static inline bool
xdg_toplevel_icon_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XDG_TOPLEVEL_ICON_V1_ERROR_INVALID_BUFFER:
		return version >= 1;
	case XDG_TOPLEVEL_ICON_V1_ERROR_IMMUTABLE:
		return version >= 1;
	case XDG_TOPLEVEL_ICON_V1_ERROR_NO_BUFFER:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XDG_TOPLEVEL_ICON_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_xdg_toplevel_icon_v1
 * @struct xdg_toplevel_icon_v1_interface
 */
struct xdg_toplevel_icon_v1_interface {
	/**
	 * destroy the icon object
	 *
	 * Destroys the 'xdg_toplevel_icon_v1' object. The icon must
	 * still remain set on every toplevel it was assigned to, until the
	 * toplevel icon is reset explicitly.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set an icon name
	 *
	 * This request assigns an icon name to this icon. Any previously
	 * set name is overridden.
	 *
	 * The compositor must resolve 'icon_name' according to the lookup
	 * rules described in the XDG icon theme specification[1] using the
	 * environment's current icon theme.
	 *
	 * If the compositor does not support icon names or cannot resolve
	 * 'icon_name' according to the XDG icon theme specification it
	 * must fall back to using pixel buffer data instead.
	 *
	 * If this request is made after the icon has been assigned to a
	 * toplevel via 'set_icon', a 'immutable' error must be raised.
	 *
	 * [1]:
	 * https://specifications.freedesktop.org/icon-theme-spec/icon-theme-spec-latest.html
	 */
	void (*set_name)(struct wl_client *client,
			 struct wl_resource *resource,
			 const char *icon_name);
	/**
	 * add icon data from a pixel buffer
	 *
	 * This request adds pixel data supplied as wl_buffer to the
	 * icon.
	 *
	 * The client should add pixel data for all icon sizes and scales
	 * that it can provide, or which are explicitly requested by the
	 * compositor via 'icon_size' events on
	 * xdg_toplevel_icon_manager_v1.
	 *
	 * The wl_buffer supplying pixel data as 'buffer' must be backed by
	 * wl_shm and must be a square (width and height being equal). If
	 * any of these buffer requirements are not fulfilled, a
	 * 'invalid_buffer' error must be raised.
	 *
	 * If this icon instance already has a buffer of the same size and
	 * scale from a previous 'add_buffer' request, data from the last
	 * request overrides the preexisting pixel data.
	 *
	 * The wl_buffer must be kept alive for as long as the
	 * xdg_toplevel_icon it is associated with is not destroyed,
	 * otherwise a 'no_buffer' error is raised. The buffer contents
	 * must not be modified after it was assigned to the icon. As a
	 * result, the region of the wl_shm_pool's backing storage used for
	 * the wl_buffer must not be modified after this request is sent.
	 * The wl_buffer.release event is unused.
	 *
	 * If this request is made after the icon has been assigned to a
	 * toplevel via 'set_icon', a 'immutable' error must be raised.
	 * @param scale the scaling factor of the icon, e.g. 1
	 */
	void (*add_buffer)(struct wl_client *client,
			   struct wl_resource *resource,
			   struct wl_resource *buffer,
			   int32_t scale);
};


/**
 * @ingroup iface_xdg_toplevel_icon_v1
 */
#define XDG_TOPLEVEL_ICON_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_icon_v1
 */
#define XDG_TOPLEVEL_ICON_V1_SET_NAME_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_icon_v1
 */
#define XDG_TOPLEVEL_ICON_V1_ADD_BUFFER_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
