/******************************************************
Copyright (c) 2013 Percona LLC and/or its affiliates.

Version numbers definitions.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

*******************************************************/

#ifndef XB_VERSION_H
#define XB_VERSION_H
#include <string>

#define XTRABACKUP_VERSION		"8.4.0-4"
#define XTRABACKUP_REVISION		"c584cb20"
#define XTRABACKUP_SUFFIX_DEF           ""

#ifdef XTRABACKUP_SUFFIX
#define XTRABACKUP_SUFFIX_STR STRINGIFY_ARG(XTRABACKUP_SUFFIX)
#else
#define XTRABACKUP_SUFFIX_STR XTRABACKUP_SUFFIX_DEF
#endif

inline std::string get_suffix_str() {
  std::string str(XTRABACKUP_SUFFIX_STR);

#ifdef UNIV_DEBUG
  str.append("-debug");
#endif

#ifdef HAVE_VALGRIND
  str.append("-valgrind");
#endif

#ifdef HAVE_ASAN
  str.append("-asan");
#endif

#ifdef HAVE_LSAN
  str.append("-lsan");
#endif

#ifdef HAVE_UBSAN
  str.append("-ubsan");
#endif

#ifdef HAVE_TSAN
  str.append("-tsan");
#endif
  return str;
}

#endif /* XB_VERSION_H */
