﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/SchemaStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>An object that contains minimal details for a schema.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SchemaListItem">AWS
 * API Reference</a></p>
 */
class SchemaListItem {
 public:
  AWS_GLUE_API SchemaListItem() = default;
  AWS_GLUE_API SchemaListItem(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API SchemaListItem& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>the name of the registry where the schema resides.</p>
   */
  inline const Aws::String& GetRegistryName() const { return m_registryName; }
  inline bool RegistryNameHasBeenSet() const { return m_registryNameHasBeenSet; }
  template <typename RegistryNameT = Aws::String>
  void SetRegistryName(RegistryNameT&& value) {
    m_registryNameHasBeenSet = true;
    m_registryName = std::forward<RegistryNameT>(value);
  }
  template <typename RegistryNameT = Aws::String>
  SchemaListItem& WithRegistryName(RegistryNameT&& value) {
    SetRegistryName(std::forward<RegistryNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the schema.</p>
   */
  inline const Aws::String& GetSchemaName() const { return m_schemaName; }
  inline bool SchemaNameHasBeenSet() const { return m_schemaNameHasBeenSet; }
  template <typename SchemaNameT = Aws::String>
  void SetSchemaName(SchemaNameT&& value) {
    m_schemaNameHasBeenSet = true;
    m_schemaName = std::forward<SchemaNameT>(value);
  }
  template <typename SchemaNameT = Aws::String>
  SchemaListItem& WithSchemaName(SchemaNameT&& value) {
    SetSchemaName(std::forward<SchemaNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) for the schema.</p>
   */
  inline const Aws::String& GetSchemaArn() const { return m_schemaArn; }
  inline bool SchemaArnHasBeenSet() const { return m_schemaArnHasBeenSet; }
  template <typename SchemaArnT = Aws::String>
  void SetSchemaArn(SchemaArnT&& value) {
    m_schemaArnHasBeenSet = true;
    m_schemaArn = std::forward<SchemaArnT>(value);
  }
  template <typename SchemaArnT = Aws::String>
  SchemaListItem& WithSchemaArn(SchemaArnT&& value) {
    SetSchemaArn(std::forward<SchemaArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description for the schema.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  SchemaListItem& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the schema.</p>
   */
  inline SchemaStatus GetSchemaStatus() const { return m_schemaStatus; }
  inline bool SchemaStatusHasBeenSet() const { return m_schemaStatusHasBeenSet; }
  inline void SetSchemaStatus(SchemaStatus value) {
    m_schemaStatusHasBeenSet = true;
    m_schemaStatus = value;
  }
  inline SchemaListItem& WithSchemaStatus(SchemaStatus value) {
    SetSchemaStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that a schema was created.</p>
   */
  inline const Aws::String& GetCreatedTime() const { return m_createdTime; }
  inline bool CreatedTimeHasBeenSet() const { return m_createdTimeHasBeenSet; }
  template <typename CreatedTimeT = Aws::String>
  void SetCreatedTime(CreatedTimeT&& value) {
    m_createdTimeHasBeenSet = true;
    m_createdTime = std::forward<CreatedTimeT>(value);
  }
  template <typename CreatedTimeT = Aws::String>
  SchemaListItem& WithCreatedTime(CreatedTimeT&& value) {
    SetCreatedTime(std::forward<CreatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that a schema was updated.</p>
   */
  inline const Aws::String& GetUpdatedTime() const { return m_updatedTime; }
  inline bool UpdatedTimeHasBeenSet() const { return m_updatedTimeHasBeenSet; }
  template <typename UpdatedTimeT = Aws::String>
  void SetUpdatedTime(UpdatedTimeT&& value) {
    m_updatedTimeHasBeenSet = true;
    m_updatedTime = std::forward<UpdatedTimeT>(value);
  }
  template <typename UpdatedTimeT = Aws::String>
  SchemaListItem& WithUpdatedTime(UpdatedTimeT&& value) {
    SetUpdatedTime(std::forward<UpdatedTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_registryName;
  bool m_registryNameHasBeenSet = false;

  Aws::String m_schemaName;
  bool m_schemaNameHasBeenSet = false;

  Aws::String m_schemaArn;
  bool m_schemaArnHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  SchemaStatus m_schemaStatus{SchemaStatus::NOT_SET};
  bool m_schemaStatusHasBeenSet = false;

  Aws::String m_createdTime;
  bool m_createdTimeHasBeenSet = false;

  Aws::String m_updatedTime;
  bool m_updatedTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
