/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class Point
implements Cloneable,
Serializable,
Translatable {
    private static final long serialVersionUID = 1L;
    public static final Point SINGLETON = new Point();
    public int x;
    public int y;

    public static Point max(Point p1, Point p2) {
        return new Rectangle(p1, p2).getBottomRight().translate(-1, -1);
    }

    public static Point min(Point p1, Point p2) {
        return new Rectangle(p1, p2).getTopLeft();
    }

    public Point() {
    }

    @Deprecated(since="3.7", forRemoval=true)
    public Point(double x, double y) {
        this.x = (int)x;
        this.y = (int)y;
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(org.eclipse.swt.graphics.Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Point(Point p) {
        this.x = p.x();
        this.y = p.y();
    }

    public Point(Dimension copy) {
        this.x = copy.width;
        this.y = copy.height;
    }

    public boolean equals(int x, int y) {
        return this.x == x && this.y == y;
    }

    public boolean equals(Object o) {
        if (o instanceof Point) {
            Point p = (Point)o;
            return p.x() == this.x && p.y() == this.y;
        }
        return false;
    }

    public Point getCopy() {
        return new Point(this);
    }

    public Dimension getDifference(Point p) {
        return new Dimension(this.x - p.x(), this.y - p.y());
    }

    public double getDistance(Point p) {
        double i = p.preciseX() - this.preciseX();
        double j = p.preciseY() - this.preciseY();
        return Math.sqrt(i * i + j * j);
    }

    @Deprecated(since="3.7", forRemoval=true)
    public int getDistance2(Point p) {
        return this.getDistanceSquared(p);
    }

    public int getDistanceSquared(Point p) {
        long j;
        long i = p.x() - this.x;
        long result = i * i + (j = (long)(p.y() - this.y)) * j;
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)result;
    }

    public int getDistanceOrthogonal(Point p) {
        return Math.abs(this.y - p.y()) + Math.abs(this.x - p.x());
    }

    public Point getNegated() {
        return this.getCopy().negate();
    }

    public int getPosition(Point p) {
        int dx = p.x() - this.x;
        int dy = p.y() - this.y;
        if (Math.abs(dx) > Math.abs(dy)) {
            if (dx < 0) {
                return 8;
            }
            return 16;
        }
        if (dy < 0) {
            return 1;
        }
        return 4;
    }

    public Point getScaled(double factor) {
        return this.getCopy().scale(factor);
    }

    public Point getScaled(double xFactor, double yFactor) {
        return this.getCopy().scale(xFactor, yFactor);
    }

    public org.eclipse.swt.graphics.Point getSWTPoint() {
        return new org.eclipse.swt.graphics.Point(this.x, this.y);
    }

    public Point getTranslated(Dimension d) {
        return this.getCopy().translate(d);
    }

    public Point getTranslated(double x, double y) {
        return this.getCopy().translate(x, y);
    }

    public Point getTranslated(int x, int y) {
        return this.getCopy().translate(x, y);
    }

    public Point getTranslated(Point p) {
        return this.getCopy().translate(p);
    }

    public Point getTransposed() {
        return this.getCopy().transpose();
    }

    public int hashCode() {
        return this.x * this.y ^ this.x + this.y;
    }

    public Point negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    @Override
    public void performScale(double factor) {
        this.scale(factor);
    }

    @Override
    public void performTranslate(int dx, int dy) {
        this.translate(dx, dy);
    }

    public double preciseX() {
        return this.x;
    }

    public double preciseY() {
        return this.y;
    }

    public Point scale(double factor) {
        return this.scale(factor, factor);
    }

    public Point scale(double xFactor, double yFactor) {
        this.x = (int)Math.floor((double)this.x * xFactor);
        this.y = (int)Math.floor((double)this.y * yFactor);
        return this;
    }

    public Point setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Point setLocation(Point p) {
        this.x = p.x();
        this.y = p.y();
        return this;
    }

    public Point setX(int x) {
        this.x = x;
        return this;
    }

    public Point setY(int y) {
        this.y = y;
        return this;
    }

    public String toString() {
        return "Point(" + this.preciseX() + ", " + this.preciseY() + ")";
    }

    public Point translate(Dimension d) {
        return this.translate(d.width(), d.height());
    }

    public Point translate(double x, double y) {
        return this.translate((int)x, (int)y);
    }

    public Point translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public Point translate(Point p) {
        return this.translate(p.x(), p.y());
    }

    public Point transpose() {
        int temp = this.x;
        this.x = this.y;
        this.y = temp;
        return this;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }
}

