/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.Pair;

public class SQLQueryRowsTableDataModel
extends SQLQueryRowsSourceModel
implements SQLQuerySymbolDefinition,
SQLQueryNodeModel.NodeSubtreeTraverseControl<SQLQueryRowsSourceModel, SQLQueryRowsDataContext> {
    private static final Log log = Log.getLog(SQLQueryRowsTableDataModel.class);
    @Nullable
    private final SQLQueryComplexName name;
    @Nullable
    private DBSEntity table = null;
    @Nullable
    private DBSObject immediateTargetObject = null;
    private final boolean forDdl;
    @Nullable
    protected SQLQueryRowsSourceModel referencedSource = null;

    public SQLQueryRowsTableDataModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryComplexName name, boolean forDdl) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.name = name;
        this.forDdl = forDdl;
    }

    @Override
    @Nullable
    public SQLQuerySymbolClass getAssociatedSymbolClass() {
        return SQLQuerySemanticUtils.getIdentifierSymbolClass(this.name);
    }

    @Nullable
    public SQLQueryComplexName getName() {
        return this.name;
    }

    @Nullable
    public DBSEntity getTable() {
        return this.table;
    }

    @Nullable
    public DBSObject getImmediateTargetObject() {
        return this.immediateTargetObject;
    }

    @Nullable
    public SQLQueryRowsSourceModel getReferencedSource() {
        return this.referencedSource;
    }

    @Override
    @NotNull
    public SQLQuerySymbolClass getSymbolClass() {
        return this.table != null ? SQLQuerySymbolClass.TABLE : SQLQuerySymbolClass.ERROR;
    }

    @NotNull
    protected Pair<List<SQLQueryResultColumn>, List<SQLQueryResultPseudoColumn>> prepareResultColumnsList(@NotNull STMTreeNode cause, @NotNull SQLDialect dialect, @NotNull SQLQueryRecognitionContext statistics, @NotNull List<? extends DBSEntityAttribute> attributes) {
        return SQLQuerySemanticUtils.prepareResultColumnsList(cause, this, this.table, dialect, statistics, attributes);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext originalContext, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.name == null) {
            statistics.appendError(this.getSyntaxNode(), "Invalid table reference");
            return originalContext.resetAsUnresolved();
        }
        if (this.name.invalidPartsCount > 0) {
            nameContext = originalContext.resetAsUnresolved();
            SQLQuerySemanticUtils.performPartialResolution(nameContext, statistics, this.name, new SQLQuerySymbolOrigin.RowsSourceRef(nameContext), SQLQuerySymbolOrigin.DbObjectFilterMode.ROWSET, SQLQuerySymbolClass.ERROR);
            statistics.appendError(this.getSyntaxNode(), "Invalid table reference");
            return nameContext;
        }
        if (this.name.parts.size() == 1) {
            if (this.name.stringParts.getLast().equalsIgnoreCase(originalContext.getDialect().getDualTableName())) {
                this.name.parts.getLast().getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE);
                return originalContext.reset();
            }
            dynamicSource = originalContext.findDynamicRowsSource(this.name.parts.getFirst());
            if (dynamicSource != null) {
                this.referencedSource = dynamicSource.source;
                referenceName = dynamicSource.referenceName;
                nameContext = originalContext.reset();
                if (referenceName != null) {
                    this.name.parts.getFirst().setDefinition(referenceName.parts.getLast());
                    this.name.parts.getFirst().setOrigin(new SQLQuerySymbolOrigin.RowsSourceRef(nameContext));
                }
                return nameContext.appendSource(this, this.name, null);
            }
        }
        refTarget = (candidates = originalContext.getConnectionInfo().findRealObjects(statistics.getMonitor(), RelationalObjectType.TYPE_UNKNOWN, this.name.stringParts)).size() == 1 ? candidates.getFirst() : null;
        v0 = obj = this.forDdl != false ? refTarget : SQLQueryConnectionContext.expandAliases(statistics.getMonitor(), refTarget);
        if (!(obj instanceof DBSEntity)) ** GOTO lbl-1000
        e = (DBSEntity)obj;
        if (obj instanceof DBSTable || obj instanceof DBSView) {
            v1 = e;
        } else lbl-1000:
        // 2 sources

        {
            v1 = this.table = null;
        }
        if (this.table != null) {
            this.immediateTargetObject = refTarget;
            nameContext = originalContext.reset();
            SQLQuerySemanticUtils.setNamePartsDefinition(nameContext, this.name, refTarget, SQLQuerySymbolClass.TABLE, (SQLQuerySymbolOrigin)new SQLQuerySymbolOrigin.RowsSourceRef(nameContext), SQLQuerySymbolOrigin.DbObjectFilterMode.ROWSET);
            resultContext = nameContext.appendSource(this, this.name, this.table);
        } else {
            nameContext = originalContext.resetAsUnresolved();
            tableSymbolClass = statistics.isTreatErrorsAsWarnings() != false ? SQLQuerySymbolClass.TABLE : SQLQuerySymbolClass.ERROR;
            SQLQuerySemanticUtils.performPartialResolution(nameContext, statistics, this.name, new SQLQuerySymbolOrigin.RowsSourceRef(nameContext), SQLQuerySymbolOrigin.DbObjectFilterMode.ROWSET, tableSymbolClass);
            resultContext = nameContext;
            if (candidates.isEmpty() || candidates.size() == 1) {
                statistics.appendError(this.name.syntaxNode, "Table " + this.name.getNameString() + " not found");
            }
        }
        return resultContext;
    }

    @Override
    @Nullable
    public List<SQLQueryNodeModel> getChildren() {
        return this.referencedSource == null ? null : List.of(this.referencedSource);
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryRowsDataContext result;
        block11: {
            if (this.table != null && this.name != null) {
                try {
                    List attributes = this.table.getAttributes(statistics.getMonitor());
                    if (attributes != null) {
                        List<Object> list;
                        Pair<List<SQLQueryResultColumn>, List<SQLQueryResultPseudoColumn>> columns = this.prepareResultColumnsList(this.name.syntaxNode, this.getRowsSources().getDialect(), statistics, attributes);
                        DBSEntity dBSEntity = this.table;
                        if (dBSEntity instanceof DBDPseudoAttributeContainer) {
                            DBDPseudoAttributeContainer pac = (DBDPseudoAttributeContainer)dBSEntity;
                            list = SQLQuerySemanticUtils.prepareResultPseudoColumnsList(this.getRowsSources().getDialect(), this, this.table, Stream.of(pac.getAllPseudoAttributes(statistics.getMonitor())).filter(a -> a.getPropagationPolicy().providedByTable));
                        } else {
                            list = Collections.emptyList();
                        }
                        List inferredPseudoColumns = list;
                        List<SQLQueryResultPseudoColumn> pseudoColumns = Stream.of((List)columns.getSecond(), inferredPseudoColumns).flatMap(Collection::stream).collect(Collectors.toList());
                        result = this.getRowsSources().makeTuple(this, (List)columns.getFirst(), pseudoColumns);
                        break block11;
                    }
                    result = this.getRowsSources().makeEmptyTuple();
                }
                catch (DBException ex) {
                    result = this.getRowsSources().makeEmptyTuple();
                    statistics.appendError(this.name.syntaxNode, "Failed to resolve columns of the table " + this.name.getNameString(), ex);
                }
            } else if (this.referencedSource != null) {
                if (this.referencedSource.isResolved()) {
                    SQLQueryRowsDataContext referencedData = this.referencedSource.getRowsDataContext();
                    List<SQLQueryResultColumn> resultColumns = referencedData.getColumnsList().stream().map(c -> c.withNewSource(this)).toList();
                    result = this.getRowsSources().makeTuple(this, resultColumns, Collections.emptyList());
                } else {
                    statistics.appendError(this.name.syntaxNode, "Circular dependency detected at " + this.name.getNameString());
                    result = this.getRowsSources().makeTuple(this, Collections.emptyList(), Collections.emptyList());
                }
            } else {
                result = this.getRowsSources().makeEmptyTuple();
            }
        }
        return result;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsTableData(this, arg);
    }
}

