/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.components.JComboBoxFactory;

public abstract class EditableComboProperty<T>
extends PropertyBean {
    private final JComboBox mComboBox;
    private T selected;

    public EditableComboProperty(String name, List<? extends T> values) {
        super(name);
        this.mComboBox = this.createFormatChooser(values);
        this.mComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                EditableComboProperty.this.firePropertyChangeEvent();
            }
        });
    }

    private JComboBox createFormatChooser(List<? extends T> list) {
        JComboBox<T> formatChooser = JComboBoxFactory.create(new Vector<T>(list));
        formatChooser.setEditable(true);
        formatChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object valueObject = EditableComboProperty.this.toValueObject(e.getItem());
                if (valueObject != null) {
                    EditableComboProperty.this.selected = valueObject;
                }
            }
        });
        return formatChooser;
    }

    @Override
    public String getValue() {
        return this.selected == null ? null : this.selected.toString();
    }

    @Override
    public JComponent getValueComponent() {
        return this.mComboBox;
    }

    public T getSelected() {
        return this.selected;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        this.appendToForm(builder, this.mComboBox);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mComboBox.setEnabled(pEnabled);
        super.setEnabled(pEnabled);
    }

    @Override
    public void setValue(String value) {
        this.mComboBox.setSelectedItem(value == null ? null : this.toValueObject(value));
    }

    public void setToolTipText(String text) {
        this.mComboBox.setToolTipText(text);
    }

    public abstract T toValueObject(Object var1);
}

