/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.KeywordValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;

abstract class BaseGridShorthandSetter
extends ShorthandSetter {
    BaseGridShorthandSetter(BaseCSSStyleDeclaration style, String shorthandName) {
        super(style, shorthandName);
    }

    @Override
    public void init(LexicalUnit shorthandValue, boolean important) {
        this.currentValue = shorthandValue;
        this.setPriority(important);
        this.initValueString();
    }

    boolean isNoneDeclaration() {
        return this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(this.currentValue.getStringValue()) && this.currentValue.getNextLexicalUnit() == null;
    }

    boolean isTemplateAreasSyntax() {
        LexicalUnit lu = this.currentValue;
        do {
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.STRING) continue;
            return true;
        } while ((lu = lu.getNextLexicalUnit()) != null);
        return false;
    }

    boolean templateSyntax(boolean setTemplateAreas) {
        StyleValue value;
        LexicalUnit fullValue = this.currentValue;
        ValueList gridTemplateRows = ValueList.createWSValueList();
        ValueList gridTemplateAreas = ValueList.createWSValueList();
        ValueList lineNames = null;
        boolean missSlash = !setTemplateAreas;
        LexicalUnit.LexicalType lasttype = LexicalUnit.LexicalType.UNKNOWN;
        block5: do {
            LexicalUnit.LexicalType type = this.currentValue.getLexicalUnitType();
            switch (type) {
                case LEFT_BRACKET: {
                    LexicalUnit nlu;
                    ValueFactory.ListValueItem item;
                    if (lasttype == LexicalUnit.LexicalType.STRING) {
                        gridTemplateRows.add(BaseGridShorthandSetter.createAutoValue());
                    }
                    if ((item = this.valueFactory.parseBracketList(nlu = this.currentValue.getNextLexicalUnit(), this.styleDeclaration, true)) != null) {
                        ValueList newLineNames = item.getCSSValue();
                        if (lineNames == null) {
                            lineNames = newLineNames;
                            gridTemplateRows.add(lineNames);
                        } else {
                            lineNames.addAll(newLineNames);
                        }
                        this.appendValueItemString(newLineNames);
                        this.currentValue = item.getNextLexicalUnit();
                        lasttype = type;
                        break;
                    }
                    this.currentValue = nlu.getNextLexicalUnit();
                    break;
                }
                case STRING: {
                    if (lasttype == LexicalUnit.LexicalType.STRING) {
                        gridTemplateRows.add(BaseGridShorthandSetter.createAutoValue());
                    }
                    lineNames = null;
                    value = this.createCSSValue();
                    gridTemplateAreas.add(value);
                    this.appendValueItemString(value);
                    lasttype = type;
                    break;
                }
                case OPERATOR_SLASH: {
                    if (lasttype != LexicalUnit.LexicalType.UNKNOWN) {
                        if (lasttype == LexicalUnit.LexicalType.STRING) {
                            gridTemplateRows.add(BaseGridShorthandSetter.createAutoValue());
                        }
                        this.currentValue = this.currentValue.getNextLexicalUnit();
                        if (this.currentValue != null) {
                            value = this.valueFactory.createCSSValue(this.currentValue, this.styleDeclaration);
                            value = this.subpropertyValue(value);
                            this.setSubpropertyValue("grid-template-columns", value);
                            this.getValueItemBuffer().append(" /");
                            this.getValueItemBufferMini().append('/');
                            this.appendValueItemString(value);
                            missSlash = false;
                            break block5;
                        }
                        this.syntaxError("Unexpected end of declaration after slash '/' in " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                    } else {
                        this.syntaxError("Slash '/' was the first token in " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                    }
                    return false;
                }
                default: {
                    if (setTemplateAreas && type == LexicalUnit.LexicalType.FUNCTION && "repeat".equalsIgnoreCase(this.currentValue.getFunctionName())) {
                        this.syntaxError("This syntax does not allow repeat(): " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                        return false;
                    }
                    lineNames = null;
                    value = this.createCSSValue();
                    gridTemplateRows.add(value);
                    this.appendValueItemString(value);
                    lasttype = type;
                }
            }
        } while (this.currentValue != null);
        if (missSlash) {
            String message = "Not a correct rows / columns syntax: " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue);
            this.syntaxError(message);
            return false;
        }
        if (gridTemplateRows.getLength() != 0) {
            value = gridTemplateRows.getLength() != 1 ? gridTemplateRows : gridTemplateRows.item(0);
            this.setSubpropertyValue("grid-template-rows", value);
        } else if (setTemplateAreas) {
            IdentifierValue auto = new IdentifierValue("auto");
            auto.setSubproperty(true);
            this.setSubpropertyValue("grid-template-rows", auto);
        }
        if (gridTemplateAreas.getLength() != 0) {
            value = gridTemplateAreas.getLength() != 1 ? gridTemplateAreas : gridTemplateAreas.item(0);
            this.setSubpropertyValue("grid-template-areas", value);
        }
        return true;
    }

    StyleValue subpropertyValue(StyleValue value) {
        switch (value.getCssValueType()) {
            case TYPED: 
            case PROXY: {
                ((PrimitiveValue)value).setSubproperty(true);
                break;
            }
            case LIST: {
                ((ValueList)value).setSubproperty(true);
                break;
            }
            case KEYWORD: {
                value = ((KeywordValue)value).asSubproperty();
            }
        }
        return value;
    }

    void syntaxError(String message) {
        BaseCSSDeclarationRule rule = this.styleDeclaration.getParentRule();
        if (rule != null) {
            rule.getStyleDeclarationErrorHandler().shorthandSyntaxError(this.getShorthandName(), message);
        }
    }

    @Override
    protected boolean isDelimiterChar(char c, String cssText) {
        return c == ',' || c == '/' || c == ']' && cssText.charAt(0) == '[';
    }

    static boolean isAutoOnly(ValueList list) {
        for (StyleValue value : list) {
            if ("auto".equalsIgnoreCase(value.getCssText())) continue;
            return false;
        }
        return true;
    }

    static IdentifierValue createAutoValue() {
        IdentifierValue ident = new IdentifierValue("auto");
        ident.setSubproperty(true);
        return ident;
    }
}

