/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.io.Serializable;

class PositionalConditionImpl
implements PositionalCondition,
Serializable {
    private static final long serialVersionUID = 1L;
    int offset = 1;
    int slope = 0;
    boolean forwardCondition = true;
    boolean oftype = false;
    private final boolean hasArgument;
    boolean hasKeyword = false;
    SelectorList ofList = null;

    PositionalConditionImpl(boolean needsArgument) {
        this.hasArgument = needsArgument;
    }

    @Override
    public Condition.ConditionType getConditionType() {
        return Condition.ConditionType.POSITIONAL;
    }

    @Override
    public boolean isForwardCondition() {
        return this.forwardCondition;
    }

    @Override
    public boolean isOfType() {
        return this.oftype;
    }

    @Override
    public int getFactor() {
        return this.slope;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public boolean hasArgument() {
        return this.hasArgument;
    }

    @Override
    public boolean hasKeyword() {
        return this.hasKeyword;
    }

    @Override
    public SelectorList getOfList() {
        return this.ofList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.forwardCondition ? 1231 : 1237);
        result = 31 * result + (this.hasArgument ? 1231 : 1237);
        result = 31 * result + (this.hasKeyword ? 1231 : 1237);
        result = 31 * result + (this.ofList == null ? 0 : this.ofList.hashCode());
        result = 31 * result + this.offset;
        result = 31 * result + (this.oftype ? 1231 : 1237);
        result = 31 * result + this.slope;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PositionalConditionImpl other = (PositionalConditionImpl)obj;
        if (this.forwardCondition != other.forwardCondition) {
            return false;
        }
        if (this.hasArgument != other.hasArgument) {
            return false;
        }
        if (this.hasKeyword != other.hasKeyword) {
            return false;
        }
        if (this.ofList == null ? other.ofList != null : !ParseHelper.equalSelectorList(this.ofList, other.ofList)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.oftype != other.oftype) {
            return false;
        }
        return this.slope == other.slope;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(':');
        if (this.oftype) {
            this.ofTypeSerialization(buf);
        } else {
            this.normalSerialization(buf);
        }
        return buf.toString();
    }

    private void normalSerialization(StringBuilder buf) {
        if (this.slope == 0) {
            if (this.offset == 1 && this.ofList == null && !this.hasArgument) {
                if (this.forwardCondition) {
                    buf.append("first-child");
                } else {
                    buf.append("last-child");
                }
            } else {
                if (this.forwardCondition) {
                    buf.append("nth-child(");
                } else {
                    buf.append("nth-last-child(");
                }
                buf.append(this.offset);
                if (!this.isUniversalOfList()) {
                    buf.append(" of ").append(this.ofList.toString());
                }
                buf.append(')');
            }
        } else {
            if (this.forwardCondition) {
                buf.append("nth-child(");
            } else {
                buf.append("nth-last-child(");
            }
            this.appendAnB(buf);
            if (!this.isUniversalOfList()) {
                buf.append(" of ").append(this.ofList.toString());
            }
            buf.append(')');
        }
    }

    private void ofTypeSerialization(StringBuilder buf) {
        if (this.slope == 0) {
            if (this.offset == 1 && this.ofList == null && !this.hasArgument) {
                if (this.forwardCondition) {
                    buf.append("first-of-type");
                } else {
                    buf.append("last-of-type");
                }
            } else {
                if (this.forwardCondition) {
                    buf.append("nth-of-type(");
                } else {
                    buf.append("nth-last-of-type(");
                }
                buf.append(this.offset).append(')');
            }
        } else {
            if (this.forwardCondition) {
                buf.append("nth-of-type(");
            } else {
                buf.append("nth-last-of-type(");
            }
            this.appendAnB(buf);
            buf.append(')');
        }
    }

    private void appendAnB(StringBuilder buf) {
        if (this.hasKeyword && this.slope == 2) {
            if (this.offset == 0) {
                buf.append("even");
            } else {
                buf.append("odd");
            }
            return;
        }
        if (this.slope == -1) {
            buf.append('-');
        } else if (this.slope != 1) {
            buf.append(this.slope);
        }
        buf.append('n');
        if (this.offset > 0) {
            buf.append('+');
            buf.append(this.offset);
        } else if (this.offset != 0) {
            buf.append(this.offset);
        }
    }

    private boolean isUniversalOfList() {
        if (this.ofList == null) {
            return true;
        }
        for (int i = 0; i < this.ofList.getLength(); ++i) {
            Selector sel = this.ofList.item(i);
            if (sel.getSelectorType() != Selector.SelectorType.UNIVERSAL || ((ElementSelector)sel).getNamespaceURI() != null) continue;
            return true;
        }
        return false;
    }
}

