/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HSLColorValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import org.w3c.dom.DOMException;

public class RGBColorValue
extends ColorValue {
    private static final long serialVersionUID = 1L;
    private final RGBColor color;

    RGBColorValue() {
        this.color = new ColorValue.CSSRGBColor();
    }

    RGBColorValue(RGBColor rgbColor) {
        this.color = rgbColor;
    }

    protected RGBColorValue(RGBColorValue copied) {
        super(copied);
        this.color = copied.color.clone();
    }

    @Override
    void set(StyleValue value) {
        super.set(value);
        BaseColor setfrom = (BaseColor)((ColorValue)value).getColor();
        this.color.set(setfrom);
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.RGB;
    }

    @Override
    public RGBAColor getColor() {
        return this.color;
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        if (this.color.getRed() == null || this.color.getGreen() == null || this.color.getBlue() == null) {
            throw new DOMException(11, "Color not set");
        }
        return this.color;
    }

    @Override
    public LABColorValue toLABColorValue() throws DOMException {
        LABColorValue lab = new LABColorValue();
        this.color.toLABColor(lab.getLABColorImpl());
        return lab;
    }

    @Override
    public HSLColorValue toHSLColorValue() throws DOMException {
        if (!this.color.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        HSLColorValue hsl = new HSLColorValue();
        this.color.toHSLColor(hsl.getHSLColorImpl());
        return hsl;
    }

    @Override
    public PrimitiveValue getComponent(int index) {
        return this.color.item(index);
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        this.color.setComponent(index, (PrimitiveValue)component);
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.color.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue color) {
        LABColor lab2;
        LABColor lab1;
        if (!this.color.hasConvertibleComponents() || !((ColorValue)color).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (color.getColorModel()) {
            case LCH: 
            case LAB: {
                return color.deltaE2000(this);
            }
            case RGB: {
                lab1 = this.toLABColorValue().getColor();
                RGBColor rgb = (RGBColor)color.getColor();
                LABColorImpl labColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                rgb.toLABColor(labColor);
                lab2 = labColor;
                break;
            }
            case XYZ: {
                lab1 = this.toLABColorValue().getColor();
                XYZColorImpl xyz = (XYZColorImpl)color.getColor();
                LABColorImpl labColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                xyz.toLABColor(labColor);
                lab2 = labColor;
                break;
            }
            default: {
                RGBAColor rgba = color.toRGBColor(false);
                RGBColorValue rgbValue = new RGBColorValue();
                rgbValue.setComponent(0, (StyleValue)((Object)rgba.getAlpha()));
                rgbValue.setComponent(1, (StyleValue)((Object)rgba.getRed()));
                rgbValue.setComponent(2, (StyleValue)((Object)rgba.getGreen()));
                rgbValue.setComponent(3, (StyleValue)((Object)rgba.getBlue()));
                lab2 = rgbValue.toLABColorValue().getColor();
                lab1 = this.toLABColorValue().getColor();
            }
        }
        return ColorUtil.deltaE2000Lab(((CSSTypedValue)lab1.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lab1.getA()).getFloatValue((short)0), ((CSSTypedValue)lab1.getB()).getFloatValue((short)0), ((CSSTypedValue)lab2.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lab2.getA()).getFloatValue((short)0), ((CSSTypedValue)lab2.getB()).getFloatValue((short)0));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RGBColorValue other = (RGBColorValue)obj;
        return this.color.equals(other.color);
    }

    @Override
    public RGBColorValue clone() {
        return new RGBColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            try {
                if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.RGBCOLOR) {
                    throw new DOMException(13, "No rgb() value: " + lunit.toString());
                }
                this.setLexicalRGB(lunit);
            }
            catch (DOMException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new DOMException(12, "Bad value: " + lunit.toString());
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void setLexicalRGB(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            ValueFactory factory = new ValueFactory();
            PrimitiveValue basiccolor = factory.createCSSPrimitiveValue(lu, true);
            RGBColorValue.this.color.setRed(basiccolor);
            lu = lu.getNextLexicalUnit();
            RGBColorValue.this.commaSyntax = lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA;
            if (RGBColorValue.this.commaSyntax) {
                lu = lu.getNextLexicalUnit();
            }
            basiccolor = factory.createCSSPrimitiveValue(lu, true);
            RGBColorValue.this.color.setGreen(basiccolor);
            if (RGBColorValue.this.commaSyntax) {
                lu = lu.getNextLexicalUnit();
            }
            lu = lu.getNextLexicalUnit();
            basiccolor = factory.createCSSPrimitiveValue(lu, true);
            RGBColorValue.this.color.setBlue(basiccolor);
            lu = lu.getNextLexicalUnit();
            if (lu != null) {
                lu = lu.getNextLexicalUnit();
                PrimitiveValue alpha = factory.createCSSPrimitiveValue(lu, true);
                if (!RGBColorValue.this.commaSyntax && alpha.getUnitType() == 0 && basiccolor.getUnitType() == 0) {
                    ((NumberValue)alpha).setAbsolutizedUnit();
                }
                RGBColorValue.this.color.setAlpha(alpha);
                lu = lu.getNextLexicalUnit();
                if (lu != null) {
                    throw new DOMException(12, "Bad value: " + lunit.toString());
                }
            }
        }
    }
}

