---
stage: Plan
group: Product Planning
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLabのエピックボードで、グループエピックを管理、可視化します。ラベルとウェイトを使用して、進捗状況を作成、整理、フィルタリング、追跡します。
title: エピックボード
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- リストの最上部に合計ウェイトを表示します。[introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/364503) GitLab 15.11。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

エピックボードは既存の[エピック追跡機能](_index.md)と[ラベル](../../project/labels.md)を基に構築されています。割り当てられたラベルで整理されたエピックは、垂直リストのカードとして表示されます。

各リストの上部には、リスト内のエピックの数({{< icon name="epic" >}})と、すべてのエピックの合計ウェイト({{< icon name="weight" >}})が表示されます。

<div class="video-fallback">
  参照用動画: <a href="https://www.youtube.com/watch?v=eQUnHwbKEkY">エピックとイシューボード - プロジェクト管理</a>。
</div>
<figure class="video-container">
  <iframe src="https://www.youtube-nocookie.com/embed/eQUnHwbKEkY" frameborder="0" allowfullscreen> </iframe>
</figure>

エピックボードを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **エピックボード**を選択します。

![GitLabエピックボード - プレミアム](img/epic_board_v15_10.png)

## エピックボードを作成 {#create-an-epic-board}

前提要件: 

- グループのプランナー以上のロールが必要です。

新しいエピックボードを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **エピックボード**を選択します。
1. 左上隅で、現在のボード名が記載されたドロップダウンリストを選択します。
1. **新しいボードを作成する**を選択します。
1. 新しいボードのタイトルを入力します。
1. オプション。[オープン]または[クローズ済み]リストを非表示にするには、**オープンリストを表示する**と**クローズドリストを表示する**チェックボックスをオフにします。
1. オプション。ボードのスコープを設定します:
   1. **スコープ**の横にある**全て展開**を選択します。
   1. **ラベル**の横にある**編集**を選択し、ボードのスコープとして使用するラベルを選択します。
1. **ボードを作成する**を選択します。

これで、[リストを追加](#create-a-new-list)できます。これらのオプションを後で変更するには、[ボードを編集](#edit-the-scope-of-an-epic-board)します。

## エピックボードを削除 {#delete-an-epic-board}

前提要件: 

- グループのプランナー以上のロールが必要です。
- グループに2つ以上のボードが存在する必要があります。

アクティブなエピックボードを削除するには:

1. エピックボードページの左上隅で、ドロップダウンリストを選択します。
1. **ボードを削除する**を選択します。
1. **削除**を選択します。

## エピックボードで実行できるアクション {#actions-you-can-take-on-an-epic-board}

- [新しいリスト](#create-a-new-list)を作成。
- [既存のリスト](#remove-a-list)を削除。
- [エピックをフィルタリング](#filter-epics)。
- [イシューボード](../../../tutorials/plan_and_track.md)を使用する際のように、ワークフローを作成します。
- [エピックとリストを移動](#move-epics-and-lists)。
- エピックのラベルを変更します(エピックをリスト間でドラッグすることによって)。
- エピックを**クローズ**リストにドラッグして、エピックをクローズします。
- [ボードのスコープを編集](#edit-the-scope-of-an-epic-board)。

### 新しいリストを作成 {#create-a-new-list}

{{< history >}}

- 既存のリスト間にリストを作成することは、GitLab 17.5[で導入](https://gitlab.com/gitlab-org/gitlab/-/issues/462515)されました。

{{< /history >}}

前提要件: 

- グループのプランナー以上のロールが必要です。

新しいリストを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**Plan** > **エピックボード**を選択します。
1. 右上隅で、**新しいリスト**を選択します。
1. 2つのリストの間で、カーソルを合わせるか、キーボードのフォーカスを移動します。
1. **新しいリスト**を選択します。新しいリストパネルが開きます。

   ![イシューボードの2つのリスト間に新しいリストを作成する](img/issue_board_add_list_between_lists_v17_6.png)
1. **新しいリスト**列で、**ラベルを選択**ドロップダウンリストを展開し、リストのスコープとして使用するラベルを選択します。
1. **ボードに追加**を選択します。

新しいリストは、新しいリストパネルと同じ位置にボードに挿入されます。

リストを移動して並べ替えるには、それらをドラッグして移動します。

または、**新しいリスト**の右端にある新しいリストを選択することもできます。新しいリストは、リストの右端の**クローズ**の前に挿入されます。

### リストを削除 {#remove-a-list}

リストを削除しても、エピックとラベルには影響しません。削除されるのはリストビューのみです。必要に応じて、いつでも後で再作成できます。

前提要件: 

- グループのプランナー以上のロールが必要です。

エピックボードからリストを削除するには:

1. 削除するリストの上部にある**リスト設定**アイコン（{{< icon name="settings" >}}）を選択します。リスト設定サイドバーが右側に開きます。
1. **リストを削除**を削除を選択します。
1. 確認ダイアログで、**OK**を選択します。

### エピックボードからエピックを作成 {#create-an-epic-from-an-epic-board}

前提要件: 

- グループのプランナー以上のロールが必要です。
- 最初に[リストを作成](#create-a-new-list)する必要があります。

エピックボードのリストからエピックを作成するには:

1. リストの上部にある**新しいエピック** ({{< icon name="plus" >}})アイコンを選択します。
1. 新しいエピックのタイトルを入力します。
1. **エピックを作成**を選択します。

![エピックボードからGitLabエピックを作成](img/epic_board_epic_create_v15_10.png)

### エピックを編集する {#edit-an-epic}

エピックボードからエピックカードを選択すると、[エピックがドロワーで開きます](manage_epics.md#open-epics-in-a-drawer)。そこでは、説明、コメント、関連アイテムなど、すべてのフィールドを編集できます。

### エピックをフィルタリング {#filter-epics}

エピックボードの上部にあるフィルターを使用して、必要な結果のみを表示できます。エピックとラベルのメタデータがエピックボードで再利用されるため、エピックリストで使用されるフィルタリングと同様です。

以下でフィルタリングできます:

- 作成者
- ラベル

### エピックのイシュー数、ウェイト、および進捗状況を表示 {#view-count-of-issues-weight-and-progress-of-an-epic}

エピックボード上のエピックには、イシュー、ウェイト、および進捗状況の概要が表示されます。オープンおよびクローズされたイシューの数と、完了および未完了のウェイトを表示するには、イシューアイコン{{< icon name="issues" >}}、ウェイトアイコン{{< icon name="weight" >}}、または進捗状況アイコン{{< icon name="progress" >}}にカーソルを合わせるます。

### エピックとリストを移動 {#move-epics-and-lists}

エピックとリストは、ドラッグして移動できます。

前提要件: 

- グループのプランナー以上のロールが必要です。

エピックを移動するには、エピックカードを選択し、現在のリスト内の別の位置または別のリストにドラッグします。[リスト間でのエピックのドラッグ](#dragging-epics-between-lists)で起こりうる影響について説明します。

リストを移動するには、上部のバーを選択し、水平方向にドラッグします。**オープン**と**クローズ**のリストは移動できませんが、エピックボードの編集中に非表示にできます。

#### リストの先頭にエピックを移動 {#move-an-epic-to-the-start-of-the-list}

{{< history >}}

- GitLab 15.4で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/367473)されました。

{{< /history >}}

エピックが多数ある場合、ボードリストの下部から上部までエピックを手動でドラッグするのは不便です。メニューショートカットを使用して、エピックをリストの一番上に移動できます。

別のエピックがフィルターで非表示になっている場合でも、エピックはリストの一番上に移動されます。

前提要件: 

- グループのプランナー以上のロールが必要です。

リストの先頭にエピックを移動するには:

1. エピックボードで、移動するエピックのカードにカーソルを合わせるます。
1. **カードオプション** ({{< icon name="ellipsis_v" >}}) を選択し、次に**リストの先頭に移動**の先頭に移動を選択します。

#### リストの最後にエピックを移動 {#move-an-epic-to-the-end-of-the-list}

{{< history >}}

- GitLab 15.4で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/367473)されました。

{{< /history >}}

エピックが多数ある場合、ボードリストの上部から下部までエピックを手動でドラッグするのは不便です。メニューショートカットを使用して、エピックをリストの一番下に移動できます。

別のエピックがフィルターで非表示になっている場合でも、エピックはリストの一番下に移動されます。

前提要件: 

- グループのプランナー以上のロールが必要です。

リストの最後にエピックを移動するには:

1. エピックボードで、移動するエピックのカードにカーソルを合わせるます。
1. **カードオプション** ({{< icon name="ellipsis_v" >}}) を選択し、次に**リストの最後に移動**を選択します。

#### リスト間でエピックをドラッグ {#dragging-epics-between-lists}

リスト間でエピックをドラッグすると、その結果はソースリストとターゲットリストによって異なります。

|                       | オープンへ        | 完了へ  | ラベルBリストへ                |
| --------------------- | -------------- | ---------- | ------------------------------ |
| **From Open**（オープンから）         | -              | エピックをクローズ | ラベルBを追加                    |
| **From Closed**（完了から）       | エピックを再度開く    | -          | エピックを再度開き、ラベルBを追加    |
| **From label A list**（ラベルAリストから） | ラベルAを削除 | エピックをクローズ | ラベルAを削除してラベルBを追加 |

### エピックボードのスコープを編集 {#edit-the-scope-of-an-epic-board}

前提要件: 

- グループのプランナー以上のロールが必要です。

エピックボードのスコープを編集するには:

1. 右上隅で、**ボードを設定する** ({{< icon name="settings" >}}) を選択します。
1. （オプション）:
   - ボードのタイトルを編集します。
   - [オープン]列と[クローズ済み]列を表示または非表示にします。
   - ボードのスコープとして、他のラベルを選択します。
1. **変更を保存**を選択します。
