/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class HintableFeature {
    static final int FORM = 1;
    static final int LEMMA = 2;
    static final int HEAD_RELATION = 4;
    static final int CHILD_RELATION = 8;
    private static final ConcurrentHashMap<HintableFeature, HintableFeature> interner = new ConcurrentHashMap();
    final int kind;
    @NotNull
    private final String value;
    private final int hash;

    private HintableFeature(int kind, @NotNull String value) {
        this.kind = kind;
        this.value = value;
        this.hash = kind * 31 + value.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HintableFeature)) {
            return false;
        }
        HintableFeature feature = (HintableFeature)o;
        return this.kind == feature.kind && this.hash == feature.hash && this.value.equals(feature.value);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "HintableFeature[kind=" + this.kind + ", value=" + this.value + "]";
    }

    static HintableFeature create(int kind, @NotNull String value) {
        HintableFeature feature = new HintableFeature(kind, value);
        if (kind == 4 || kind == 8) {
            return interner.computeIfAbsent(feature, Function.identity());
        }
        return feature;
    }
}

