/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.gestures.snapping.LazyGridSnapLayoutInfoProviderKt;
import androidx.compose.foundation.lazy.grid.LazyGridItemInfo;
import androidx.compose.foundation.lazy.grid.LazyGridItemInfoKt;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfo;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfoKt;
import androidx.compose.foundation.lazy.grid.LazyGridMeasureResult;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchResultScope;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchScope;
import androidx.compose.foundation.lazy.layout.CacheWindowScope;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020\u00112\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020,0+H\u0016J\u0010\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0016J\u0010\u00101\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0016J\u0010\u00105\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011H\u0016J\b\u00106\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0014\u0010\u001c\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013R\u0014\u0010\u001e\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0013R\u0014\u0010 \u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013R\u0016\u0010\"\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010-\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0013R\u0015\u0010)\u001a\u00020\u0011*\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00067"}, d2={"Landroidx/compose/foundation/lazy/grid/LazyGridCacheWindowScope;", "Landroidx/compose/foundation/lazy/layout/CacheWindowScope;", "<init>", "()V", "layoutInfo", "Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;", "getLayoutInfo", "()Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;", "setLayoutInfo", "(Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;)V", "prefetchScope", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchScope;", "getPrefetchScope", "()Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchScope;", "setPrefetchScope", "(Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchScope;)V", "totalItemsCount", "", "getTotalItemsCount", "()I", "hasVisibleItems", "", "getHasVisibleItems", "()Z", "mainAxisExtraSpaceStart", "getMainAxisExtraSpaceStart", "mainAxisExtraSpaceEnd", "getMainAxisExtraSpaceEnd", "firstVisibleLineIndex", "getFirstVisibleLineIndex", "lastVisibleLineIndex", "getLastVisibleLineIndex", "mainAxisViewportSize", "getMainAxisViewportSize", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "schedulePrefetch", "", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "lineIndex", "onItemPrefetched", "Lkotlin/Function2;", "", "visibleLineCount", "getVisibleLineCount", "getVisibleItemSize", "indexInVisibleLines", "getVisibleItemLine", "Landroidx/compose/foundation/lazy/grid/LazyGridItemInfo;", "getLineIndex", "(Landroidx/compose/foundation/lazy/grid/LazyGridItemInfo;)I", "getLastIndexInLine", "getLastLineIndex", "foundation"})
@ExperimentalFoundationApi
@SourceDebugExtension(value={"SMAP\nLazyGridCacheWindowStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridCacheWindowStrategy.kt\nandroidx/compose/foundation/lazy/grid/LazyGridCacheWindowScope\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n231#2,2:165\n35#2,5:167\n233#2:172\n35#2,5:173\n1#3:178\n*S KotlinDebug\n*F\n+ 1 LazyGridCacheWindowStrategy.kt\nandroidx/compose/foundation/lazy/grid/LazyGridCacheWindowScope\n*L\n131#1:165,2\n131#1:167,5\n131#1:172\n132#1:173,5\n*E\n"})
final class LazyGridCacheWindowScope
implements CacheWindowScope {
    public LazyGridLayoutInfo layoutInfo;
    public LazyGridPrefetchScope prefetchScope;

    @NotNull
    public final LazyGridLayoutInfo getLayoutInfo() {
        LazyGridLayoutInfo lazyGridLayoutInfo = this.layoutInfo;
        if (lazyGridLayoutInfo != null) {
            return lazyGridLayoutInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"layoutInfo");
        return null;
    }

    public final void setLayoutInfo(@NotNull LazyGridLayoutInfo lazyGridLayoutInfo) {
        Intrinsics.checkNotNullParameter((Object)lazyGridLayoutInfo, (String)"<set-?>");
        this.layoutInfo = lazyGridLayoutInfo;
    }

    @NotNull
    public final LazyGridPrefetchScope getPrefetchScope() {
        LazyGridPrefetchScope lazyGridPrefetchScope = this.prefetchScope;
        if (lazyGridPrefetchScope != null) {
            return lazyGridPrefetchScope;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"prefetchScope");
        return null;
    }

    public final void setPrefetchScope(@NotNull LazyGridPrefetchScope lazyGridPrefetchScope) {
        Intrinsics.checkNotNullParameter((Object)lazyGridPrefetchScope, (String)"<set-?>");
        this.prefetchScope = lazyGridPrefetchScope;
    }

    @Override
    public int getTotalItemsCount() {
        return this.getLayoutInfo().getTotalItemsCount();
    }

    @Override
    public boolean getHasVisibleItems() {
        return !((Collection)this.getLayoutInfo().getVisibleItemsInfo()).isEmpty();
    }

    @Override
    public int getMainAxisExtraSpaceStart() {
        LazyGridItemInfo firstVisibleItem = (LazyGridItemInfo)CollectionsKt.first(this.getLayoutInfo().getVisibleItemsInfo());
        int firstItemOverflowOffset = RangesKt.coerceAtMost((int)(LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(firstVisibleItem, this.getLayoutInfo().getOrientation()) + this.getLayoutInfo().getBeforeContentPadding()), (int)0);
        return Math.abs(firstItemOverflowOffset);
    }

    @Override
    public int getMainAxisExtraSpaceEnd() {
        LazyGridItemInfo lastVisibleItem = (LazyGridItemInfo)CollectionsKt.last(this.getLayoutInfo().getVisibleItemsInfo());
        int lastItemOverflowOffset = LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(lastVisibleItem, this.getLayoutInfo().getOrientation()) + LazyGridSnapLayoutInfoProviderKt.sizeOnMainAxis(lastVisibleItem, this.getLayoutInfo().getOrientation()) + this.getLayoutInfo().getMainAxisItemSpacing();
        return Math.abs(lastItemOverflowOffset - this.getLayoutInfo().getViewportEndOffset());
    }

    @Override
    public int getFirstVisibleLineIndex() {
        return this.getLineIndex((LazyGridItemInfo)CollectionsKt.first(this.getLayoutInfo().getVisibleItemsInfo()));
    }

    @Override
    public int getLastVisibleLineIndex() {
        return this.getLineIndex((LazyGridItemInfo)CollectionsKt.last(this.getLayoutInfo().getVisibleItemsInfo()));
    }

    @Override
    public int getMainAxisViewportSize() {
        return LazyGridLayoutInfoKt.getSingleAxisViewportSize(this.getLayoutInfo());
    }

    @Override
    @Nullable
    public Density getDensity() {
        LazyGridLayoutInfo lazyGridLayoutInfo = this.getLayoutInfo();
        LazyGridMeasureResult lazyGridMeasureResult = lazyGridLayoutInfo instanceof LazyGridMeasureResult ? (LazyGridMeasureResult)lazyGridLayoutInfo : null;
        return lazyGridMeasureResult != null ? lazyGridMeasureResult.getDensity() : null;
    }

    @Override
    @NotNull
    public List<LazyLayoutPrefetchState.PrefetchHandle> schedulePrefetch(int lineIndex, @NotNull Function2<? super Integer, ? super Integer, Unit> onItemPrefetched) {
        Intrinsics.checkNotNullParameter(onItemPrefetched, (String)"onItemPrefetched");
        return this.getPrefetchScope().scheduleLinePrefetch(lineIndex, (Function1<? super LazyGridPrefetchResultScope, Unit>)((Function1)arg_0 -> LazyGridCacheWindowScope.schedulePrefetch$lambda$0(onItemPrefetched, lineIndex, arg_0)));
    }

    @Override
    public int getVisibleLineCount() {
        return this.getLastVisibleLineIndex() - this.getFirstVisibleLineIndex() + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getVisibleItemSize(int indexInVisibleLines) {
        void $this$fastForEach$iv;
        List $this$fastFilter$iv;
        int laneIndex = indexInVisibleLines + this.getFirstVisibleLineIndex();
        int tallestItemSize = 0;
        List<LazyGridItemInfo> list = this.getLayoutInfo().getVisibleItemsInfo();
        boolean $i$f$fastFilter = false;
        ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
        void $this$fastForEach$iv$iv = $this$fastFilter$iv;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv$iv).size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            Object item$iv$iv;
            Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            boolean bl = false;
            LazyGridItemInfo it = (LazyGridItemInfo)it$iv;
            boolean bl2 = false;
            if (!(this.getLineIndex(it) == laneIndex)) continue;
            ((Collection)target$iv).add(it$iv);
        }
        $this$fastFilter$iv = target$iv;
        boolean $i$f$fastForEach2 = false;
        int n2 = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n2; ++index$iv) {
            Object item$iv = $this$fastForEach$iv.get(index$iv);
            LazyGridItemInfo it = (LazyGridItemInfo)item$iv;
            boolean bl = false;
            tallestItemSize = Math.max(LazyGridSnapLayoutInfoProviderKt.sizeOnMainAxis(it, this.getLayoutInfo().getOrientation()), tallestItemSize);
        }
        return tallestItemSize;
    }

    @Override
    public int getVisibleItemLine(int indexInVisibleLines) {
        return this.getFirstVisibleLineIndex() + indexInVisibleLines;
    }

    public final int getLineIndex(@NotNull LazyGridItemInfo $this$lineIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$lineIndex, (String)"<this>");
        return LazyGridItemInfoKt.lineIndex($this$lineIndex, this.getLayoutInfo().getOrientation());
    }

    @Override
    public int getLastIndexInLine(int lineIndex) {
        LazyGridLayoutInfo lazyGridLayoutInfo = this.getLayoutInfo();
        LazyGridMeasureResult lazyGridMeasureResult = lazyGridLayoutInfo instanceof LazyGridMeasureResult ? (LazyGridMeasureResult)lazyGridLayoutInfo : null;
        if (lazyGridMeasureResult == null) {
            return -1;
        }
        LazyGridMeasureResult measureResult = lazyGridMeasureResult;
        List itemsInLine = (List)measureResult.getPrefetchInfoRetriever().invoke((Object)lineIndex);
        return itemsInLine.isEmpty() ? -1 : ((Number)((Pair)CollectionsKt.first((List)itemsInLine)).getFirst()).intValue() + itemsInLine.size() - 1;
    }

    @Override
    public int getLastLineIndex() {
        LazyGridLayoutInfo lazyGridLayoutInfo = this.getLayoutInfo();
        LazyGridMeasureResult lazyGridMeasureResult = lazyGridLayoutInfo instanceof LazyGridMeasureResult ? (LazyGridMeasureResult)lazyGridLayoutInfo : null;
        if (lazyGridMeasureResult == null) {
            return -1;
        }
        LazyGridMeasureResult measureResult = lazyGridMeasureResult;
        if (this.getTotalItemsCount() == 0) {
            return -1;
        }
        return ((Number)measureResult.getLineIndexProvider().invoke((Object)(this.getTotalItemsCount() - 1))).intValue();
    }

    private static final Unit schedulePrefetch$lambda$0(Function2 $onItemPrefetched, int $lineIndex, LazyGridPrefetchResultScope $this$scheduleLinePrefetch) {
        Intrinsics.checkNotNullParameter((Object)$this$scheduleLinePrefetch, (String)"$this$scheduleLinePrefetch");
        int tallestElement = 0;
        tallestElement = Integer.MIN_VALUE;
        int n = $this$scheduleLinePrefetch.getLineItemCount();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            tallestElement = ComparisonsKt.maxOf((int)$this$scheduleLinePrefetch.getMainAxisSize(it), (int[])new int[0]);
        }
        if (tallestElement != Integer.MIN_VALUE) {
            $onItemPrefetched.invoke((Object)$lineIndex, (Object)tallestElement);
        }
        return Unit.INSTANCE;
    }
}

