/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineComponentFactory;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRConnectedProjectViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineViewModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineFileEditor;", "Lcom/intellij/diff/util/FileEditorBase;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "projectVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRConnectedProjectViewModel;", "file", "Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRConnectedProjectViewModel;Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile;)V", "cs", "timelineVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineViewModel;", "getName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "content", "Ljavax/swing/JComponent;", "getContent", "()Ljavax/swing/JComponent;", "content$delegate", "Lkotlin/Lazy;", "getComponent", "getPreferredFocusedComponent", "selectNotify", "", "getFile", "intellij.vcs.github"})
public final class GHPRTimelineFileEditor
extends FileEditorBase {
    @NotNull
    private final GHPRConnectedProjectViewModel projectVm;
    @NotNull
    private final GHPRTimelineVirtualFile file;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final GHPRTimelineViewModel timelineVm;
    @NotNull
    private final Lazy content$delegate;

    public GHPRTimelineFileEditor(@NotNull CoroutineScope parentCs, @NotNull GHPRConnectedProjectViewModel projectVm, @NotNull GHPRTimelineVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        Intrinsics.checkNotNullParameter((Object)projectVm, (String)"projectVm");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.projectVm = projectVm;
        this.file = file;
        this.cs = CoroutineUtilKt.cancelledWith((CoroutineScope)CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, (String)"GitHub Pull Request Timeline UI", (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (boolean)false, (int)4, null), (Disposable)((Disposable)this));
        this.timelineVm = this.projectVm.acquireTimelineViewModel(this.file.getPullRequest(), this.cs);
        this.content$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> GHPRTimelineFileEditor.content_delegate$lambda$0(this));
    }

    @NotNull
    public String getName() {
        String string = GithubBundle.message("pull.request.editor.timeline", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final JComponent getContent() {
        Lazy lazy = this.content$delegate;
        return (JComponent)lazy.getValue();
    }

    @NotNull
    public JComponent getComponent() {
        return this.getContent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public void selectNotify() {
        this.timelineVm.update();
    }

    @NotNull
    public GHPRTimelineVirtualFile getFile() {
        return this.file;
    }

    private static final JComponent content_delegate$lambda$0(GHPRTimelineFileEditor this$0) {
        return GHPRTimelineComponentFactory.INSTANCE.create(this$0.file.getProject(), this$0.cs, this$0.projectVm, this$0.timelineVm, this$0.file.getPullRequest());
    }
}

