/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.SmartList;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceableDisposable {
    private final Throwable CREATE_TRACE;
    private Throwable KILL_TRACE;

    public TraceableDisposable(boolean debug) {
        this.CREATE_TRACE = debug ? ThrowableInterner.intern(new Throwable()) : null;
    }

    public void kill(@NonNls @Nullable String msg) {
        if (this.CREATE_TRACE != null) {
            this.killExceptionally(ThrowableInterner.intern(new Throwable(msg)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killExceptionally(@NotNull Throwable throwable) {
        if (throwable == null) {
            TraceableDisposable.$$$reportNull$$$0(0);
        }
        if (this.CREATE_TRACE != null) {
            TraceableDisposable traceableDisposable = this;
            synchronized (traceableDisposable) {
                if (this.KILL_TRACE == null) {
                    this.KILL_TRACE = throwable;
                }
            }
        }
    }

    @Contract(value="_->fail")
    public void throwDisposalError(@NotNull @NonNls String msg) throws RuntimeException {
        if (msg == null) {
            TraceableDisposable.$$$reportNull$$$0(1);
        }
        throw new DisposalException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getStackTrace() {
        StringWriter s = new StringWriter();
        @NonNls PrintWriter out = new PrintWriter(s);
        if (this.CREATE_TRACE != null) {
            out.println("--------------Creation trace: ");
            this.CREATE_TRACE.printStackTrace(out);
        }
        TraceableDisposable traceableDisposable = this;
        synchronized (traceableDisposable) {
            if (this.KILL_TRACE != null) {
                out.println("--------------Kill trace: ");
                this.KILL_TRACE.printStackTrace(out);
            }
        }
        out.println("-------------Own trace:");
        new DisposalException(String.valueOf(System.identityHashCode(this))).printStackTrace(out);
        out.flush();
        String string = s.toString();
        if (string == null) {
            TraceableDisposable.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/TraceableDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/TraceableDisposable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "killExceptionally";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "throwDisposalError";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class DisposalException
    extends RuntimeException
    implements ExceptionWithAttachments {
        private DisposalException(String message) {
            if (message == null) {
                DisposalException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Attachment @NotNull [] getAttachments() {
            SmartList<Attachment> answer = new SmartList<Attachment>();
            if (TraceableDisposable.this.CREATE_TRACE != null) {
                answer.add(new Attachment("creation", TraceableDisposable.this.CREATE_TRACE));
            }
            DisposalException disposalException = this;
            synchronized (disposalException) {
                if (TraceableDisposable.this.KILL_TRACE != null) {
                    answer.add(new Attachment("kill", TraceableDisposable.this.KILL_TRACE));
                }
            }
            Attachment[] attachmentArray = answer.toArray(Attachment.EMPTY_ARRAY);
            if (attachmentArray == null) {
                DisposalException.$$$reportNull$$$0(1);
            }
            return attachmentArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/TraceableDisposable$DisposalException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/TraceableDisposable$DisposalException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttachments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

