/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Warps an image using an input displacement field.


WarpImageFilter warps an existing image with respect to a given displacement field.

A displacement field is represented as a image whose pixel type is
some vector type with at least N elements, where N is the dimension of
the input image. The vector type must support element access via
operator [].

The output image is produced by inverse mapping: the output pixels are
mapped back onto the input image. This scheme avoids the creation of
any holes and overlaps in the output image.

Each vector in the displacement field represent the distance between a
geometric point in the input space and a point in the output space
such that:

\\[ p_{in} = p_{out} + d \\]

Typically the mapped position does not correspond to an integer pixel
position in the input image. Interpolation via an image function is
used to compute values at non-integer positions. The default
interpolation typed used is the LinearInterpolateImageFunction . The user can specify a particular interpolation function via SetInterpolator() . Note that the input interpolator must derive from base class InterpolateImageFunction .

Position mapped to outside of the input image buffer are assigned a
edge padding value.

The LargestPossibleRegion for the output is inherited from the input
displacement field. The output image spacing, origin and orientation
may be set via SetOutputSpacing, SetOutputOrigin and
SetOutputDirection. The default are respectively a vector of 1's, a
vector of 0's and an identity matrix.

This class is templated over the type of the input image, the type of
the output image and the type of the displacement field.

The input image is set via SetInput. The input displacement field is
set via SetDisplacementField.

This filter is implemented as a multithreaded filter.


WARNING:
This filter assumes that the input type, output type and displacement
field type all have the same number of dimensions.

See:
 itk::simple::Warp for the procedural interface

 itk::WarpImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkWarpImageFilter.h
*/
public class WarpImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected WarpImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.WarpImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(WarpImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(WarpImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::WarpImageFilter::~WarpImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_WarpImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::WarpImageFilter::WarpImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  WarpImageFilter() {
    this(SimpleITKJNI.new_WarpImageFilter(), true);
  }

  /**
Self&amp; itk::simple::WarpImageFilter::SetInterpolator(InterpolatorEnum Interpolator)

Get/Set the interpolator function.

*/
public  void setInterpolator(InterpolatorEnum Interpolator) {
    SimpleITKJNI.WarpImageFilter_setInterpolator(swigCPtr, this, Interpolator.swigValue());
  }

  /**
InterpolatorEnum itk::simple::WarpImageFilter::GetInterpolator() const

Get/Set the interpolator function.

*/
public  InterpolatorEnum getInterpolator() {
    return InterpolatorEnum.swigToEnum(SimpleITKJNI.WarpImageFilter_getInterpolator(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::WarpImageFilter::SetOutputSize(std::vector&lt; uint32_t &gt; OutputSize)

Set the size of the output image.

*/
public  void setOutputSize(VectorUInt32 OutputSize) {
    SimpleITKJNI.WarpImageFilter_setOutputSize(swigCPtr, this, VectorUInt32.getCPtr(OutputSize), OutputSize);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::WarpImageFilter::GetOutputSize() const

Get the size of the output image.

*/
public  VectorUInt32 getOutputSize() {
    return new VectorUInt32(SimpleITKJNI.WarpImageFilter_getOutputSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::WarpImageFilter::SetOutputOrigin(std::vector&lt; double &gt; OutputOrigin)

Set the output image origin.

*/
public  void setOutputOrigin(VectorDouble OutputOrigin) {
    SimpleITKJNI.WarpImageFilter_setOutputOrigin(swigCPtr, this, VectorDouble.getCPtr(OutputOrigin), OutputOrigin);
  }

  /**
std::vector&lt;double&gt; itk::simple::WarpImageFilter::GetOutputOrigin() const

Get the output image origin.

*/
public  VectorDouble getOutputOrigin() {
    return new VectorDouble(SimpleITKJNI.WarpImageFilter_getOutputOrigin(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::WarpImageFilter::SetOutputSpacing(std::vector&lt; double &gt; OutputSpacing)

Set the output image spacing.

*/
public  void setOutputSpacing(VectorDouble OutputSpacing) {
    SimpleITKJNI.WarpImageFilter_setOutputSpacing(swigCPtr, this, VectorDouble.getCPtr(OutputSpacing), OutputSpacing);
  }

  /**
std::vector&lt;double&gt; itk::simple::WarpImageFilter::GetOutputSpacing() const

Get the output image spacing.

*/
public  VectorDouble getOutputSpacing() {
    return new VectorDouble(SimpleITKJNI.WarpImageFilter_getOutputSpacing(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::WarpImageFilter::SetOutputDirection(std::vector&lt; double &gt; OutputDirection)

Set/Get the direction (orientation) of the output image

*/
public  void setOutputDirection(VectorDouble OutputDirection) {
    SimpleITKJNI.WarpImageFilter_setOutputDirection(swigCPtr, this, VectorDouble.getCPtr(OutputDirection), OutputDirection);
  }

  /**
std::vector&lt;double&gt; itk::simple::WarpImageFilter::GetOutputDirection() const

Set/Get the direction (orientation) of the output image

*/
public  VectorDouble getOutputDirection() {
    return new VectorDouble(SimpleITKJNI.WarpImageFilter_getOutputDirection(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::WarpImageFilter::SetEdgePaddingValue(double EdgePaddingValue)

Set the edge padding value

*/
public  void setEdgePaddingValue(double EdgePaddingValue) {
    SimpleITKJNI.WarpImageFilter_setEdgePaddingValue(swigCPtr, this, EdgePaddingValue);
  }

  /**
double itk::simple::WarpImageFilter::GetEdgePaddingValue() const

Get the edge padding value

*/
public  double getEdgePaddingValue() {
    return SimpleITKJNI.WarpImageFilter_getEdgePaddingValue(swigCPtr, this);
  }

  /**
std::string itk::simple::WarpImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.WarpImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::WarpImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.WarpImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::WarpImageFilter::Execute(const Image &amp;image, const Image &amp;displacementField)

Execute the filter on the input image

*/
public  Image execute(Image image, Image displacementField) {
    return new Image(SimpleITKJNI.WarpImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(displacementField), displacementField), true);
  }

  /**
void itk::simple::WarpImageFilter::SetOutputParameteresFromImage(const Image &amp;refImage)

This methods sets the output size, origin, spacing and direction to
that of the provided image

*/
public  void setOutputParameteresFromImage(Image refImage) {
    SimpleITKJNI.WarpImageFilter_setOutputParameteresFromImage(swigCPtr, this, Image.getCPtr(refImage), refImage);
  }

}
