/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Locale;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Appendable;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertDouble;
import org.jruby.util.Numeric;
import org.jruby.util.Sprintf;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Float"}, parent="Numeric")
public class RubyFloat
extends RubyNumeric
implements Appendable {
    public static final int ROUNDS = 1;
    public static final int RADIX = 2;
    public static final int MANT_DIG = 53;
    public static final int DIG = 15;
    public static final int MIN_EXP = -1021;
    public static final int MAX_EXP = 1024;
    public static final int MAX_10_EXP = 308;
    public static final int MIN_10_EXP = -307;
    public static final double EPSILON = 2.220446049250313E-16;
    public static final double INFINITY = Double.POSITIVE_INFINITY;
    public static final double NAN = Double.NaN;
    public static final int FLOAT_DIG = 17;
    final double value;
    public static final ByteList POSITIVE_INFINITY_TO_S_BYTELIST = new ByteList(ByteList.plain("Infinity"), USASCIIEncoding.INSTANCE, false);
    public static final ByteList NEGATIVE_INFINITY_TO_S_BYTELIST = new ByteList(ByteList.plain("-Infinity"), USASCIIEncoding.INSTANCE, false);
    public static final ByteList NAN_TO_S_BYTELIST = new ByteList(ByteList.plain("NaN"), USASCIIEncoding.INSTANCE, false);
    static final int DBL_MANT_DIG = 53;
    private static final ByteList NAN_BYTELIST = new ByteList("nan".getBytes());
    private static final ByteList NEGATIVE_INFINITY_BYTELIST = new ByteList("-inf".getBytes());
    private static final ByteList INFINITY_BYTELIST = new ByteList("inf".getBytes());

    public static RubyClass createFloatClass(ThreadContext context, RubyClass Numeric2) {
        RubyClass Float2 = (RubyClass)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "Float", Numeric2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR).reifiedClass(RubyFloat.class)).kindOf(new RubyModule.JavaClassKindOf(RubyFloat.class))).classIndex(ClassIndex.FLOAT)).defineMethods(context, RubyFloat.class).tap(c -> c.singletonClass(context).undefMethods(context, "new")).defineConstant(context, "ROUNDS", Convert.asFixnum(context, 1))).defineConstant(context, "RADIX", Convert.asFixnum(context, 2))).defineConstant(context, "MANT_DIG", Convert.asFixnum(context, 53))).defineConstant(context, "DIG", Convert.asFixnum(context, 15))).defineConstant(context, "MIN_EXP", Convert.asFixnum(context, -1021))).defineConstant(context, "MAX_EXP", Convert.asFixnum(context, 1024))).defineConstant(context, "MIN_10_EXP", Convert.asFixnum(context, -307))).defineConstant(context, "MAX_10_EXP", Convert.asFixnum(context, 308));
        ((RubyModule)((RubyModule)((RubyModule)((RubyModule)Float2.defineConstant(context, "MIN", new RubyFloat(Float2, Double.MIN_NORMAL))).defineConstant(context, "MAX", new RubyFloat(Float2, Double.MAX_VALUE))).defineConstant(context, "EPSILON", new RubyFloat(Float2, 2.220446049250313E-16))).defineConstant(context, "INFINITY", new RubyFloat(Float2, Double.POSITIVE_INFINITY))).defineConstant(context, "NAN", new RubyFloat(Float2, Double.NaN));
        return Float2;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.FLOAT;
    }

    public RubyFloat(Ruby runtime2) {
        this(runtime2, 0.0);
    }

    public RubyFloat(Ruby runtime2, double value2) {
        super(runtime2.getFloat());
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    private RubyFloat(RubyClass klass, double value2) {
        super(klass);
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    @Override
    public RubyClass singletonClass(ThreadContext context) {
        throw Error.typeError(context, "can't define singleton");
    }

    @Override
    public Class<?> getJavaClass() {
        return Double.TYPE;
    }

    @JRubyAPI
    public double getValue() {
        return this.value;
    }

    @Override
    @JRubyAPI
    public BigInteger asBigInteger(ThreadContext context) {
        return RubyBignum.toBigInteger(this.value);
    }

    @Override
    @JRubyAPI
    public double asDouble(ThreadContext context) {
        return this.value;
    }

    @Override
    @JRubyAPI
    public int asInt(ThreadContext context) {
        return (int)this.value;
    }

    @Override
    @JRubyAPI
    public long asLong(ThreadContext context) {
        return (long)this.value;
    }

    @Override
    public RubyFloat convertToFloat() {
        return this;
    }

    @Override
    public RubyInteger convertToInteger() {
        return this.toInteger(this.metaClass.runtime.getCurrentContext());
    }

    private RubyInteger toInteger(ThreadContext context) {
        return Convert.asInteger(context, this.value > 0.0 ? Math.floor(this.value) : Math.ceil(this.value));
    }

    @Deprecated(since="10.0.0.0")
    public int signum() {
        return this.signum(this.getCurrentContext());
    }

    @JRubyAPI
    public int signum(ThreadContext context) {
        return (int)Math.signum(this.value);
    }

    @Override
    @JRubyMethod(name={"negative?"})
    public IRubyObject isNegative(ThreadContext context) {
        return Convert.asBoolean(context, this.isNegativeNumber(context));
    }

    @Override
    @JRubyMethod(name={"positive?"})
    public IRubyObject isPositive(ThreadContext context) {
        return Convert.asBoolean(context, this.isPositiveNumber(context));
    }

    @Override
    public boolean isNegativeNumber(ThreadContext context) {
        return this.signum(context) < 0;
    }

    @Override
    public boolean isPositiveNumber(ThreadContext context) {
        return this.signum(context) > 0;
    }

    public static RubyFloat newFloat(Ruby runtime2, double value2) {
        return new RubyFloat(runtime2, value2);
    }

    @Deprecated(since="9.0.0.0")
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject number) {
        if (number instanceof RubyFixnum || number instanceof RubyBignum || number instanceof RubyRational) {
            return number.callMethod(context, "to_f");
        }
        if (!(number instanceof RubyFloat)) {
            throw Error.typeError(context, "failed to convert ", number, " into Float");
        }
        return number;
    }

    @Override
    @JRubyMethod(name={"to_s", "inspect"})
    public IRubyObject to_s(ThreadContext context) {
        ByteList buf = new ByteList(24);
        RubyFloat.formatFloat(this, buf);
        return Create.newString(context, buf);
    }

    @Override
    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(ThreadContext context, IRubyObject other) {
        return Create.newArray(context, (IRubyObject)RubyKernel.new_float(context, other), (IRubyObject)this);
    }

    @Override
    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus(ThreadContext context) {
        return Convert.asFloat(context, -this.value);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject op_uminus() {
        return this.op_uminus(this.getCurrentContext());
    }

    @Override
    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        return switch (other.getMetaClass().getClassIndex()) {
            case ClassIndex.INTEGER, ClassIndex.FLOAT -> Convert.asFloat(context, this.value + ((RubyNumeric)other).asDouble(context));
            default -> this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_plus, other);
        };
    }

    public IRubyObject op_plus(ThreadContext context, double other) {
        return Convert.asFloat(context, this.value + other);
    }

    @Override
    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        return switch (other.getMetaClass().getClassIndex()) {
            case ClassIndex.INTEGER, ClassIndex.FLOAT -> Convert.asFloat(context, this.value - ((RubyNumeric)other).asDouble(context));
            default -> this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_minus, other);
        };
    }

    public IRubyObject op_minus(ThreadContext context, double other) {
        return Convert.asFloat(context, this.value - other);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        return switch (other.getMetaClass().getClassIndex()) {
            case ClassIndex.INTEGER, ClassIndex.FLOAT -> Convert.asFloat(context, this.value * ((RubyNumeric)other).asDouble(context));
            default -> this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_times, other);
        };
    }

    public IRubyObject op_mul(ThreadContext context, double other) {
        return Convert.asFloat(context, this.value * other);
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        switch (RubyFloat.getMetaClass(other).getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                try {
                    return Convert.asFloat(context, this.value / ((RubyNumeric)other).asDouble(context));
                }
                catch (NumberFormatException nfe) {
                    throw context.runtime.newFloatDomainError(other.toString());
                }
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_quo, other);
    }

    public IRubyObject op_div(ThreadContext context, double other) {
        return Convert.asFloat(context, this.value / other);
    }

    @Override
    @JRubyMethod(name={"quo", "fdiv"})
    public IRubyObject quo(ThreadContext context, IRubyObject other) {
        return RubyFloat.numFuncall(context, this, RubyFloat.sites((ThreadContext)context).op_quo, other);
    }

    @JRubyMethod(name={"%", "modulo"})
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        switch (RubyFloat.getMetaClass(other).getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                return this.op_mod(context, ((RubyNumeric)other).asDouble(context));
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_mod, other);
    }

    public IRubyObject op_mod(ThreadContext context, double other) {
        if (other == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        double x = this.value;
        double mod = Math.IEEEremainder(x, other);
        if (other * mod < 0.0) {
            mod += other;
        }
        return Convert.asFloat(context, mod);
    }

    @Override
    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        switch (RubyFloat.getMetaClass(other).getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double y = ((RubyNumeric)other).asDouble(context);
                if (y == 0.0) {
                    throw context.runtime.newZeroDivisionError();
                }
                double x = this.value;
                double mod = Math.IEEEremainder(x, y);
                if (Double.isNaN(mod)) {
                    throw context.runtime.newFloatDomainError("NaN");
                }
                double div2 = Math.floor(x / y);
                if (y * mod < 0.0) {
                    mod += y;
                }
                return Create.newArray(context, (IRubyObject)Convert.asInteger(context, div2), (IRubyObject)Convert.asFloat(context, mod));
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).divmod, other);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double d_other = ((RubyNumeric)other).asDouble(context);
                if (this.value < 0.0 && d_other != (double)Math.round(d_other)) {
                    RubyComplex complex = RubyComplex.newComplexRaw(context.runtime, this);
                    return RubyFloat.sites((ThreadContext)context).op_exp.call(context, (IRubyObject)complex, (IRubyObject)complex, other);
                }
                return Convert.asFloat(context, Math.pow(this.value, d_other));
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_exp, other);
    }

    public IRubyObject op_pow(ThreadContext context, double other) {
        return Convert.asFloat(context, Math.pow(this.value, other));
    }

    @Override
    @JRubyMethod(name={"==", "==="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return context.fals;
        }
        return switch (other.getMetaClass().getClassIndex()) {
            case ClassIndex.INTEGER, ClassIndex.FLOAT -> Convert.asBoolean(context, this.value == ((RubyNumeric)other).asDouble(context));
            default -> super.op_num_equal(context, other);
        };
    }

    public IRubyObject op_equal(ThreadContext context, double other) {
        return Double.isNaN(this.value) ? context.fals : Convert.asBoolean(context, this.value == other);
    }

    public IRubyObject op_not_equal(ThreadContext context, double other) {
        return Double.isNaN(this.value) ? context.tru : Convert.asBoolean(context, this.value != other);
    }

    public boolean fastEqual(RubyFloat other) {
        return !Double.isNaN(this.value) && this.value == other.value;
    }

    @Override
    public final int compareTo(IRubyObject other) {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        return switch (other.getMetaClass().getClassIndex()) {
            case ClassIndex.INTEGER, ClassIndex.FLOAT -> Double.compare(this.value, ((RubyNumeric)other).asDouble(context));
            default -> (int)Convert.toLong(context, this.coerceCmp(context, RubyFloat.sites((ThreadContext)context).op_cmp, other));
        };
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: {
                if (Double.isInfinite(this.value)) {
                    return Convert.asFixnum(context, this.value > 0.0 ? 1 : -1);
                }
            }
            case FLOAT: {
                double b2 = ((RubyNumeric)other).asDouble(context);
                return RubyFloat.dbl_cmp(context.runtime, this.value, b2);
            }
        }
        JavaSites.FloatSites sites = RubyFloat.sites(context);
        if (Double.isInfinite(this.value) && sites.respond_to_infinite.respondsTo(context, other, other, true)) {
            IRubyObject infinite = sites.infinite.call(context, other, other);
            if (infinite.isTrue()) {
                int sign2 = RubyComparable.cmpint(context, infinite, this, other);
                return sign2 > 0 ? Convert.asFixnum(context, this.value > 0.0 ? 0 : -1) : Convert.asFixnum(context, this.value < 0.0 ? 0 : 1);
            }
            return Convert.asFixnum(context, this.value > 0.0 ? 1 : -1);
        }
        return this.coerceCmp(context, sites.op_cmp, other);
    }

    public IRubyObject op_cmp(ThreadContext context, double other) {
        return RubyFloat.dbl_cmp(context.runtime, this.value, other);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).asDouble(context);
                return Convert.asBoolean(context, !Double.isNaN(b2) && this.value > b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_gt, other);
    }

    public IRubyObject op_gt(ThreadContext context, double other) {
        return Convert.asBoolean(context, !Double.isNaN(other) && this.value > other);
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).asDouble(context);
                return Convert.asBoolean(context, !Double.isNaN(b2) && this.value >= b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_ge, other);
    }

    public IRubyObject op_ge(ThreadContext context, double other) {
        return Convert.asBoolean(context, !Double.isNaN(other) && this.value >= other);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).asDouble(context);
                return Convert.asBoolean(context, !Double.isNaN(b2) && this.value < b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_lt, other);
    }

    public IRubyObject op_lt(ThreadContext context, double other) {
        return Convert.asBoolean(context, !Double.isNaN(other) && this.value < other);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).asDouble(context);
                return Convert.asBoolean(context, !Double.isNaN(b2) && this.value <= b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_le, other);
    }

    public IRubyObject op_le(ThreadContext context, double other) {
        return Convert.asBoolean(context, !Double.isNaN(other) && this.value <= other);
    }

    @Override
    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        return this.equals(other) ? context.tru : context.fals;
    }

    @Override
    public final boolean eql(IRubyObject other) {
        return this.equals(other);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof RubyFloat && this.equals((RubyFloat)other);
    }

    private boolean equals(RubyFloat that) {
        if (Double.isNaN(this.value) || Double.isNaN(that.value)) {
            return false;
        }
        double val1 = this.value == -0.0 ? 0.0 : this.value;
        double val2 = that.value == -0.0 ? 0.0 : that.value;
        return Double.doubleToLongBits(val1) == Double.doubleToLongBits(val2);
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, RubyFloat.floatHash(context.runtime, this.value));
    }

    @Override
    public final int hashCode() {
        return (int)RubyFloat.floatHash(this.getRuntime(), this.value);
    }

    private static long floatHash(Ruby runtime2, double value2) {
        double val = value2 == 0.0 ? -0.0 : value2;
        long hashLong = Double.doubleToLongBits(val);
        return Helpers.multAndMix(runtime2.getHashSeedK0(), hashLong);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject to_f() {
        return this.to_f(this.getCurrentContext());
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext context) {
        return this;
    }

    @Override
    @JRubyMethod(name={"abs"})
    public IRubyObject abs(ThreadContext context) {
        return Double.doubleToLongBits(this.value) < 0L ? Convert.asFloat(context, Math.abs(this.value)) : this;
    }

    @Override
    @JRubyMethod(name={"magnitude"})
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @Override
    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p(ThreadContext context) {
        return Convert.asBoolean(context, this.value == 0.0);
    }

    @Override
    public final boolean isZero(ThreadContext context) {
        return this.value == 0.0;
    }

    @Override
    public IRubyObject nonzero_p(ThreadContext context) {
        return this.isZero(context) ? context.nil : this;
    }

    @Override
    @JRubyMethod(name={"truncate", "to_i", "to_int"})
    public IRubyObject truncate(ThreadContext context) {
        return this.toInteger(context);
    }

    @JRubyMethod(name={"truncate", "to_i", "to_int"})
    public IRubyObject truncate(ThreadContext context, IRubyObject n) {
        if (this.value > 0.0) {
            return this.floor(context, n);
        }
        return this.ceil(context, n);
    }

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this;
        }
        return super.numerator(context);
    }

    @Override
    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext context) {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return RubyFixnum.one(context.runtime);
        }
        return super.denominator(context);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        long[] exp2 = new long[1];
        RubyInteger rf = Convert.asInteger(context, Numeric.ldexp(Numeric.frexp(this.value, exp2), 53L));
        RubyFixnum rn = Convert.asFixnum(context, exp2[0] - 53L);
        return Numeric.f_mul(context, (IRubyObject)rf, Numeric.f_expt(context, Convert.asFixnum(context, 2), rn));
    }

    @JRubyMethod(name={"rationalize"}, optional=1, checkArity=false)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject b2;
        IRubyObject a;
        Arity.checkArgumentCount(context, args2, 0, 1);
        if (Numeric.f_negative_p(context, this)) {
            return Numeric.f_negate(context, Numeric.f_abs(context, this).rationalize(context, args2));
        }
        Ruby runtime2 = context.runtime;
        if (args2.length != 0) {
            IRubyObject eps = Numeric.f_abs(context, args2[0]);
            a = Numeric.f_sub(context, this, eps);
            b2 = Numeric.f_add(context, this, eps);
        } else {
            long[] exp2 = new long[1];
            double f = Numeric.frexp(this.value, exp2);
            f = Numeric.ldexp(f, 53L);
            long n = exp2[0] - 53L;
            RubyInteger rf = RubyBignum.newBignorm(runtime2, f);
            RubyFixnum rn = Convert.asFixnum(context, n);
            if (rf.isZero(context) || Convert.toInt(context, rn) >= 0) {
                return RubyRational.newRationalRaw(runtime2, rf.op_lshift(context, rn));
            }
            RubyFixnum one = Convert.asFixnum(context, 1);
            RubyInteger two_times_f = (RubyInteger)rf.op_mul(context, 2L);
            RubyInteger den = (RubyInteger)one.op_lshift(context, one.op_minus(context, n));
            a = RubyRational.newRationalRaw(runtime2, two_times_f.op_minus(context, 1L), den);
            b2 = RubyRational.newRationalRaw(runtime2, two_times_f.op_plus(context, 1L), den);
        }
        if (RubyFloat.sites((ThreadContext)context).op_equal.call(context, a, a, b2).isTrue()) {
            return Numeric.f_to_r(context, this);
        }
        IRubyObject[] ans = Numeric.nurat_rationalize_internal(context, a, b2);
        return RubyRational.newRationalRaw(runtime2, ans[0], ans[1]);
    }

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor(ThreadContext context) {
        return Convert.asInteger(context, Math.floor(this.value));
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject floor(ThreadContext context, IRubyObject digits2) {
        int ndigits = Convert.toInt(context, digits2);
        double number = this.value;
        if (number == 0.0) {
            return ndigits > 0 ? this : Convert.asFixnum(context, 0);
        }
        if (ndigits > 0) {
            RubyNumeric[] num = new RubyNumeric[]{this};
            long[] binexp = new long[]{0L};
            Numeric.frexp(number, binexp);
            if (RubyFloat.floatRoundOverflow(ndigits, binexp)) {
                return num[0];
            }
            if (number > 0.0 && RubyFloat.floatRoundUnderflow(ndigits, binexp)) {
                return Convert.asFloat(context, 0.0);
            }
            double f = Math.pow(10.0, ndigits);
            double mul = Math.floor(number * f);
            double res = (mul + 1.0) / f;
            if (res > number) {
                res = mul / f;
            }
            return Convert.asFloat(context, res);
        }
        RubyInteger num = Convert.asInteger(context, Math.floor(number));
        if (ndigits < 0) {
            num = (RubyInteger)num.floor(context, digits2);
        }
        return num;
    }

    private static boolean floatRoundOverflow(int ndigits, long[] binexp) {
        return (long)ndigits >= 17L - (binexp[0] > 0L ? binexp[0] / 4L : binexp[0] / 3L - 1L);
    }

    private static boolean floatRoundUnderflow(int ndigits, long[] binexp) {
        return (long)ndigits < -(binexp[0] > 0L ? binexp[0] / 3L + 1L : binexp[0] / 4L);
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil(ThreadContext context) {
        return Convert.asInteger(context, Math.ceil(this.value));
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil(ThreadContext context, IRubyObject digits2) {
        int ndigits = Convert.toInt(context, digits2);
        double number = this.value;
        if (number == 0.0) {
            return ndigits > 0 ? this : Convert.asFixnum(context, 0);
        }
        if (ndigits > 0) {
            long[] binexp = new long[]{0L};
            Numeric.frexp(number, binexp);
            if (RubyFloat.floatRoundOverflow(ndigits, binexp)) {
                return this;
            }
            if (number < 0.0 && RubyFloat.floatRoundUnderflow(ndigits, binexp)) {
                return Convert.asFloat(context, 0.0);
            }
            double f = Math.pow(10.0, ndigits);
            f = Math.ceil(number * f) / f;
            return Convert.asFloat(context, f);
        }
        IRubyObject num = Convert.asInteger(context, Math.ceil(number));
        if (ndigits < 0) {
            num = num.ceil(context, digits2);
        }
        return num;
    }

    @Override
    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context) {
        return this.roundShared(context, 0, RoundingMode.HALF_UP);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject arg0) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context, arg0);
        int digits2 = opts.isNil() ? Convert.toInt(context, arg0) : 0;
        return this.roundShared(context, digits2, RubyFloat.getRoundingMode(context, opts));
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject _digits, IRubyObject _opts) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context, _opts);
        int digits2 = Convert.toInt(context, _digits);
        return this.roundShared(context, digits2, RubyFloat.getRoundingMode(context, opts));
    }

    public IRubyObject roundShared(ThreadContext context, int ndigits, RoundingMode mode2) {
        double number = this.value;
        if (number == 0.0) {
            return ndigits > 0 ? this : Convert.asFixnum(context, 0);
        }
        if (ndigits < 0) {
            return ((RubyInteger)this.to_int(context)).roundShared(context, ndigits, mode2);
        }
        if (ndigits == 0) {
            return Convert.asInteger(context, RubyFloat.doRound(context, mode2, number, 1.0));
        }
        if (Double.isFinite(this.value)) {
            long[] binexp = new long[]{0L};
            Numeric.frexp(number, binexp);
            if (RubyFloat.floatRoundOverflow(ndigits, binexp)) {
                return this;
            }
            if (RubyFloat.floatRoundUnderflow(ndigits, binexp)) {
                return Convert.asFloat(context, 0L);
            }
            if (ndigits > 14) {
                return this.floatRoundByRational(context, Convert.asFixnum(context, ndigits), mode2);
            }
            double f = Math.pow(10.0, ndigits);
            double x = RubyFloat.doRound(context, mode2, number, f);
            return Convert.asFloat(context, x / f);
        }
        return this;
    }

    private static double doRound(ThreadContext context, RoundingMode roundingMode, double number, double scale2) {
        switch (roundingMode) {
            case HALF_UP: {
                return RubyFloat.roundHalfUp(number, scale2);
            }
            case HALF_DOWN: {
                return RubyFloat.roundHalfDown(number, scale2);
            }
            case HALF_EVEN: {
                return RubyFloat.roundHalfEven(number, scale2);
            }
        }
        throw Error.argumentError(context, "invalid rounding mode: " + String.valueOf((Object)roundingMode));
    }

    private static double roundHalfUp(double x, double s2) {
        double xs = x * s2;
        int signum = x >= 0.0 ? 1 : -1;
        double f = RubyFloat.roundHalfUp(xs *= (double)signum);
        f *= (double)signum;
        if (s2 == 1.0) {
            return f;
        }
        if (x > 0.0) {
            if ((f + 0.5) / s2 <= x) {
                f += 1.0;
            }
            x = f;
        } else {
            if ((f - 0.5) / s2 >= x) {
                f -= 1.0;
            }
            x = f;
        }
        return x;
    }

    private static double roundHalfDown(double x, double s2) {
        double xs = x * s2;
        int signum = x >= 0.0 ? 1 : -1;
        double f = RubyFloat.roundHalfUp(xs *= (double)signum);
        f *= (double)signum;
        if (x > 0.0) {
            if ((f - 0.5) / s2 >= x) {
                f -= 1.0;
            }
            x = f;
        } else {
            if ((f + 0.5) / s2 <= x) {
                f += 1.0;
            }
            x = f;
        }
        return x;
    }

    private static double roundHalfUp(double n) {
        double f = n;
        if (f >= 0.0) {
            if (n - (f = Math.floor(f)) >= 0.5) {
                f += 1.0;
            }
        } else if ((f = Math.ceil(f)) - n >= 0.5) {
            f -= 1.0;
        }
        return f;
    }

    private static double roundHalfEven(double x, double s2) {
        double us = 0.0;
        if (x > 0.0) {
            double u = Math.floor(x);
            double v = x - u;
            us = u * s2;
            double vs = v * s2;
            double f = Math.floor(vs);
            double uf = us + f;
            double d = vs - f;
            d = d > 0.5 ? 1.0 : (d == 0.5 || (uf + 0.5) / s2 <= x ? uf % 2.0 : 0.0);
            x = f + d;
        } else if (x < 0.0) {
            double u = Math.ceil(x);
            double v = x - u;
            us = u * s2;
            double vs = v * s2;
            double f = Math.ceil(vs);
            double uf = us + f;
            double d = f - vs;
            d = d > 0.5 ? 1.0 : (d == 0.5 || (uf - 0.5) / s2 >= x ? -uf % 2.0 : 0.0);
            x = f - d;
        }
        return us + x;
    }

    private IRubyObject floatRoundByRational(ThreadContext context, IRubyObject ndigits, RoundingMode mode2) {
        IRubyObject v = ((RubyRational)this.to_r(context)).roundCommon(context, ndigits, mode2);
        return ((RubyRational)v).to_f(context);
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isNaN());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject nan_p() {
        return this.nan_p(this.getCurrentContext());
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject infinite_p() {
        return this.infinite_p(this.getCurrentContext());
    }

    @Override
    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p(ThreadContext context) {
        return Double.isInfinite(this.value) ? Convert.asFixnum(context, this.value < 0.0 ? -1 : 1) : context.nil;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject finite_p() {
        return this.finite_p(this.getCurrentContext());
    }

    @Override
    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p(ThreadContext context) {
        return Double.isInfinite(this.value) || Double.isNaN(this.value) ? context.fals : context.tru;
    }

    private ByteList marshalDump(ThreadContext context) {
        if (Double.isInfinite(this.value)) {
            return this.value < 0.0 ? NEGATIVE_INFINITY_BYTELIST : INFINITY_BYTELIST;
        }
        if (Double.isNaN(this.value)) {
            return NAN_BYTELIST;
        }
        ByteList byteList = new ByteList();
        Sprintf.sprintf(byteList, Locale.US, (CharSequence)"%.17g", Create.newArray(context, (IRubyObject)this));
        return byteList;
    }

    public static ByteList formatFloat(RubyFloat self2, ByteList buf) {
        ASCIIEncoding ascii;
        buf.setRealSize(0);
        double value2 = self2.value;
        if (Double.isInfinite(value2)) {
            buf.append(value2 < 0.0 ? NEGATIVE_INFINITY_TO_S_BYTELIST : POSITIVE_INFINITY_TO_S_BYTELIST);
            buf.setEncoding(USASCIIEncoding.INSTANCE);
            return buf;
        }
        if (Double.isNaN(value2)) {
            buf.append(NAN_TO_S_BYTELIST);
            buf.setEncoding(USASCIIEncoding.INSTANCE);
            return buf;
        }
        Sprintf.sprintf(buf, Locale.US, (CharSequence)"%#.20g", self2);
        int e = buf.indexOf(101);
        if (e == -1) {
            e = buf.getRealSize();
        }
        if (!(ascii = ASCIIEncoding.INSTANCE).isDigit(buf.get(e - 1))) {
            buf.setRealSize(0);
            Sprintf.sprintf(buf, Locale.US, (CharSequence)"%#.14e", self2);
            e = buf.indexOf(101);
            if (e == -1) {
                e = buf.getRealSize();
            }
        }
        int p2 = e;
        while (buf.get(p2 - 1) == 48 && ascii.isDigit(buf.get(p2 - 2))) {
            --p2;
        }
        System.arraycopy(buf.getUnsafeBytes(), e, buf.getUnsafeBytes(), p2, buf.getRealSize() - e);
        buf.setRealSize(p2 + buf.getRealSize() - e);
        buf.setEncoding(USASCIIEncoding.INSTANCE);
        return buf;
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static void marshalTo(RubyFloat aFloat, MarshalStream output) throws IOException {
        ThreadContext context = aFloat.getRuntime().getCurrentContext();
        output.registerLinkTarget(context, aFloat);
        output.writeString(aFloat.marshalDump(context));
    }

    public static void marshalTo(ThreadContext context, RubyOutputStream out, RubyFloat aFloat, MarshalDumper output) {
        output.registerLinkTarget(aFloat);
        output.writeString(out, aFloat.marshalDump(context));
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static RubyFloat unmarshalFrom(UnmarshalStream input) throws IOException {
        ByteList value2 = input.unmarshalString();
        if (value2.equals(NAN_BYTELIST)) {
            return RubyFloat.newFloat(input.getRuntime(), Double.NaN);
        }
        if (value2.equals(NEGATIVE_INFINITY_BYTELIST)) {
            return RubyFloat.newFloat(input.getRuntime(), Double.NEGATIVE_INFINITY);
        }
        if (value2.equals(INFINITY_BYTELIST)) {
            return RubyFloat.newFloat(input.getRuntime(), Double.POSITIVE_INFINITY);
        }
        return RubyFloat.newFloat(input.getRuntime(), ConvertDouble.byteListToDouble(value2, false));
    }

    public static RubyFloat unmarshalFrom(ThreadContext context, RubyInputStream in, MarshalLoader input) {
        ByteList value2 = input.unmarshalString(context, in);
        if (value2.equals(NAN_BYTELIST)) {
            return RubyFloat.newFloat(context.runtime, Double.NaN);
        }
        if (value2.equals(NEGATIVE_INFINITY_BYTELIST)) {
            return RubyFloat.newFloat(context.runtime, Double.NEGATIVE_INFINITY);
        }
        if (value2.equals(INFINITY_BYTELIST)) {
            return RubyFloat.newFloat(context.runtime, Double.POSITIVE_INFINITY);
        }
        return RubyFloat.newFloat(context.runtime, ConvertDouble.byteListToDouble(value2, false));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject next_float() {
        return this.next_float(this.getCurrentContext());
    }

    @JRubyMethod(name={"next_float"})
    public IRubyObject next_float(ThreadContext context) {
        return Convert.asFloat(context, Math.nextAfter(this.value, Double.POSITIVE_INFINITY));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject prev_float() {
        return this.prev_float(this.getCurrentContext());
    }

    @JRubyMethod(name={"prev_float"})
    public IRubyObject prev_float(ThreadContext context) {
        return Convert.asFloat(context, Math.nextAfter(this.value, Double.NEGATIVE_INFINITY));
    }

    @Override
    @Deprecated(since="10.0.3.0")
    public IRubyObject id() {
        long flonum;
        long longBits = Double.doubleToLongBits(this.value);
        if (RubyFloat.flonumRange(longBits)) {
            flonum = Numeric.rotl(longBits, 3) & 0xFFFFFFFFFFFFFFFEL | 2L;
        } else if (RubyFloat.positiveZero(longBits)) {
            flonum = -9223372036854775806L;
        } else {
            return super.id();
        }
        return RubyFixnum.newFixnum(this.metaClass.runtime, flonum);
    }

    @Override
    public RubyInteger __id__(ThreadContext context) {
        long flonum;
        long longBits = Double.doubleToLongBits(this.value);
        if (RubyFloat.flonumRange(longBits)) {
            flonum = Numeric.rotl(longBits, 3) & 0xFFFFFFFFFFFFFFFEL | 2L;
        } else if (RubyFloat.positiveZero(longBits)) {
            flonum = -9223372036854775806L;
        } else {
            return super.__id__(context);
        }
        return Convert.asFixnum(context, flonum);
    }

    @Override
    public IRubyObject equal_p(ThreadContext context, IRubyObject obj) {
        if (RubyFloat.flonumable(this.value)) {
            return Convert.asBoolean(context, this == obj || this.eql(obj));
        }
        return super.equal_p(context, obj);
    }

    private static boolean flonumable(double value2) {
        long longBits = Double.doubleToLongBits(value2);
        return RubyFloat.flonumRange(longBits) || RubyFloat.positiveZero(longBits);
    }

    private static boolean flonumRange(long longBits) {
        int bits = (int)(longBits >>> 60 & 7L);
        return longBits != 0x3000000000000000L && (bits - 3 & 0xFFFFFFFE) == 0;
    }

    private static boolean positiveZero(long longBits) {
        return longBits == 0L;
    }

    @Override
    public void appendIntoString(RubyString target2) {
        target2.catWithCodeRange((RubyString)this.to_s(this.getRuntime().getCurrentContext()));
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject zero_p() {
        return this.zero_p(this.getCurrentContext());
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject floor(ThreadContext context, IRubyObject[] args2) {
        return switch (args2.length) {
            case 0 -> this.floor(context);
            case 1 -> this.floor(context, args2[0]);
            default -> throw Error.argumentError(context, args2.length, 1);
        };
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject round(ThreadContext context, IRubyObject[] args2) {
        return switch (args2.length) {
            case 0 -> this.round(context);
            case 1 -> this.round(context, args2[0]);
            case 2 -> this.round(context, args2[0], args2[1]);
            default -> throw Error.argumentError(context, args2.length, 2);
        };
    }

    private static JavaSites.FloatSites sites(ThreadContext context) {
        return context.sites.Float;
    }
}

