/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.DefaultKeyProviders;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo3_4_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("3.4.0");

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::migrateRealm);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(realm);
    }

    protected void migrateRealm(RealmModel r) {
        DefaultKeyProviders.createAesProvider((RealmModel)r);
        Map securityHeaders = r.getBrowserSecurityHeaders();
        if (securityHeaders != null) {
            HashMap<String, String> browserSecurityHeaders = new HashMap<String, String>(securityHeaders);
            browserSecurityHeaders.put("strictTransportSecurity", "max-age=31536000; includeSubDomains");
            r.setBrowserSecurityHeaders(Collections.unmodifiableMap(browserSecurityHeaders));
        }
    }

    public ModelVersion getVersion() {
        return VERSION;
    }
}

